/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.data.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppBpmService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppRegionService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.dao.SysDataPullMapper;
import com.jxdinfo.hussar.formdesign.application.data.dao.SysDataPullRecordMapper;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullConfigDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.SysDataPullTaskDto;
import com.jxdinfo.hussar.formdesign.application.data.dto.TestUrlDto;
import com.jxdinfo.hussar.formdesign.application.data.middle.SysDataPullRepeatRule;
import com.jxdinfo.hussar.formdesign.application.data.model.HttpDoPostResponse;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullFieldMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullRecord;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullTask;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullSysIdConvertsService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.util.DataPullUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.util.TimeFormatUtil;
import com.jxdinfo.hussar.formdesign.storage.common.utils.HttpUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStatusCheckDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.data.service.impl.PullDataServiceImpl")
public class PullDataServiceImpl
extends HussarServiceImpl<SysDataPullMapper, SysDataPullConfig>
implements SysDataPullService {
    private static Logger logger = LoggerFactory.getLogger(PullDataServiceImpl.class);
    private final SysDataPullRecordMapper pullDataRecordMapper;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IHussarBaseUserBoService sysUsersService;
    @Resource
    private IHussarAppRegionService hussarAppRegionService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private StandardInstanceEngineApiService standardInstanceEngineApiService;
    @Autowired
    private IHussarAppBpmService hussarAppBpmService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysDataPullMapper sysDataPullMapper;
    @Resource
    private IHussarBaseOrganizationBoService organizationBoService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static final Long SECURITY_LEVEL_TYPE_ID = 1450742089372590091L;
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    @Resource
    private SysDataPullSysIdConvertsService pullSysIdConvertsService;

    @Autowired
    public PullDataServiceImpl(SysDataPullRecordMapper pullDataRecordMapper) {
        this.pullDataRecordMapper = pullDataRecordMapper;
    }

    @HussarTransactional
    public ApiResponse<Void> saveConfig(SysDataPullConfigDto sysDataPullConfigDto) {
        this.saveOrUpdate((BaseEntity)sysDataPullConfigDto);
        if (StringUtil.isNotEmpty((String)sysDataPullConfigDto.getTriggerAction()) && sysDataPullConfigDto.getTriggerAction().equals("0")) {
            this.sysDataPullTaskService.removeByConfigId(sysDataPullConfigDto.getId());
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig((SysDataPullConfig)sysDataPullConfigDto));
        }
        return ApiResponse.success();
    }

    public ApiResponse<Void> copyConfig(String id) {
        SysDataPullConfig dataPullConfig = (SysDataPullConfig)this.getById((Serializable)((Object)id));
        dataPullConfig.setId(null);
        LocalDateTime now = LocalDateTime.now();
        dataPullConfig.setLastTime(null);
        dataPullConfig.setCreateTime(null);
        this.save((BaseEntity)dataPullConfig);
        if (StringUtil.isNotEmpty((String)dataPullConfig.getTriggerAction()) && dataPullConfig.getTriggerAction().equals("0")) {
            this.sysDataPullTaskService.removeByConfigId(dataPullConfig.getId());
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig(dataPullConfig));
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysDataPullConfig>> getConfigList(String formId, String delFlag) {
        List<SysDataPullConfig> configListByFormId = this.sysDataPullMapper.getConfigListByFormId(formId);
        return ApiResponse.success(configListByFormId);
    }

    public ApiResponse<SysDataPullConfig> getConfigById(Long id) {
        return ApiResponse.success((Object)this.getById(id));
    }

    @HussarTransactional
    public ApiResponse<Void> editConfig(SysDataPullConfigDto sysDataPullConfigDto) {
        LambdaQueryWrapper queryWrapper;
        List list;
        String triggerAction;
        Long configId = sysDataPullConfigDto.getId();
        String triggerActionNew = sysDataPullConfigDto.getTriggerAction();
        SysDataPullConfig sysDataPullConfig = (SysDataPullConfig)this.getById(configId);
        if (HussarUtils.isNotEmpty((Object)sysDataPullConfig) && "1".equals(triggerAction = sysDataPullConfig.getTriggerAction()) && !triggerAction.equals(triggerActionNew) && !(list = this.sysCustomButtonService.list((Wrapper)(queryWrapper = new LambdaQueryWrapper()).eq(SysCustomButton::getDataPullId, (Object)configId))).isEmpty()) {
            for (SysCustomButton customButton : list) {
                Long customButtonId = customButton.getId();
                this.sysCustomButtonService.deleteSysCustomButtonById(customButtonId);
            }
        }
        super.updateById((BaseEntity)sysDataPullConfigDto);
        String delFlag = "0";
        if (sysDataPullConfigDto.getDelFlag() != null) {
            delFlag = sysDataPullConfigDto.getDelFlag();
        }
        if (StringUtil.isNotEmpty((String)sysDataPullConfigDto.getTriggerAction()) && sysDataPullConfigDto.getTriggerAction().equals("0")) {
            this.sysDataPullTaskService.removeByConfigId(sysDataPullConfigDto.getId());
            if (delFlag.equals("0")) {
                HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig((SysDataPullConfig)sysDataPullConfigDto));
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<Void> deleteConfig(Long id) {
        SysDataPullConfig sysDataPullConfig = (SysDataPullConfig)this.getById(id);
        String triggerAction = sysDataPullConfig.getTriggerAction();
        Long configId = sysDataPullConfig.getId();
        switch (triggerAction) {
            case "1": {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                List list = this.sysCustomButtonService.list((Wrapper)queryWrapper.eq(SysCustomButton::getDataPullId, (Object)configId));
                if (list.isEmpty()) break;
                for (SysCustomButton customButton : list) {
                    Long customButtonId = customButton.getId();
                    this.sysCustomButtonService.deleteSysCustomButtonById(customButtonId);
                }
                break;
            }
            case "0": {
                this.sysDataPullTaskService.removeByConfigId(configId);
            }
        }
        this.removeById(sysDataPullConfig.getId());
        return ApiResponse.success();
    }

    public ApiResponse<Void> removeByFormId(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getFormId, (Object)formId);
        this.remove((Wrapper)queryWrapper);
        return ApiResponse.success();
    }

    public ApiResponse<Void> status(SysDataPullConfigDto sysDataPullConfigDto) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysDataPullConfig::getId, (Object)sysDataPullConfigDto.getId())).set(SysDataPullConfig::getStatus, (Object)sysDataPullConfigDto.getStatus());
        this.update((Wrapper)updateWrapper);
        String status = sysDataPullConfigDto.getStatus();
        if ("0".equals(status)) {
            this.sysDataPullTaskService.removeByConfigId(sysDataPullConfigDto.getId());
        }
        if ("1".equals(status) && StringUtil.isNotEmpty((String)sysDataPullConfigDto.getTriggerAction()) && sysDataPullConfigDto.getTriggerAction().equals("0")) {
            this.sysDataPullTaskService.removeByConfigId(sysDataPullConfigDto.getId());
            HussarNoCodeThreadUtil.executeUserTask(() -> this.sysDataPullTaskService.asyncGenerateTaskBySaveConfig((SysDataPullConfig)sysDataPullConfigDto));
        }
        return ApiResponse.success();
    }

    public ApiResponse<HttpDoPostResponse> connection(TestUrlDto testUrlDto) throws IOException {
        return ApiResponse.success((Object)this.httpDoPost(testUrlDto.getUrl(), null));
    }

    public ApiResponse<List<Map<String, Object>>> getApiKeys(String url, String param) throws IOException {
        ApiResponse<List<Map<String, Object>>> listApiResponse;
        try {
            HashMap<String, Object> parasMap = this.buildParam(JSONObject.parseArray((String)param, JSONObject.class));
            listApiResponse = this.httpPostRequest(url, parasMap);
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u6570\u636e\u62c9\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u5668\u5730\u5740\u548c\u5165\u53c2\u914d\u7f6e");
        }
        return listApiResponse;
    }

    public List<SysDataPullConfig> listByFormIdAndTriggerType(Long formId, String reminderType) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getFormId, (Object)formId)).eq(SysDataPullConfig::getTriggerAction, (Object)reminderType)).eq(SysDataPullConfig::getStatus, (Object)"1");
        return this.list((Wrapper)queryWrapper);
    }

    public List<SysDataPullConfig> listByCondition(SysDataPullConfigDto sysDataPullConfigDto) {
        SysDataPullConfig sysDataPullConfig = new SysDataPullConfig();
        BeanUtils.copyProperties((Object)sysDataPullConfigDto, (Object)sysDataPullConfig);
        List<SysDataPullConfig> sysDataPullConfigList = this.sysDataPullMapper.listByCondition(sysDataPullConfig);
        return sysDataPullConfigList;
    }

    @OperateLogTypeCache(mode=6)
    public ApiResponse<Object> asyncPullData(Long formId, Long id, String positive) {
        String key;
        FormCanvasSchema formCanvasSchema;
        Map map;
        SecurityUser securityUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        SysDataPullRecord sysDataPullRecord = new SysDataPullRecord();
        sysDataPullRecord.setFormId(formId);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getId, (Object)id)).eq(HussarDelflagEntity::getDelFlag, (Object)0);
        SysDataPullConfig config = (SysDataPullConfig)this.getOne((Wrapper)queryWrapper);
        sysDataPullRecord.setPullId(config.getId());
        sysDataPullRecord.setPullName(config.getName());
        sysDataPullRecord.setUrl(config.getUrl());
        sysDataPullRecord.setSuccess("1");
        String params = config.getParams();
        HashMap<String, Object> parasMap = this.buildParam(JSONObject.parseArray((String)params, JSONObject.class));
        ApiResponse<List<Map<String, Object>>> response = null;
        try {
            response = this.httpPostRequest(config.getUrl(), parasMap);
        }
        catch (IOException e) {
            logger.error("\u8c03\u7528\u6570\u636e\u62c9\u53d6\u63a5\u53e3\u5931\u8d25\u5730\u5740\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{config.getUrl(), parasMap, e});
            return ApiResponse.fail((String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        if (10000 != response.getCode()) {
            sysDataPullRecord.setSuccess("0");
            sysDataPullRecord.setHttpStatus(String.valueOf(500));
            String errMsg = "";
            if (HussarUtils.isNotEmpty((Object)response.getMsg())) {
                sysDataPullRecord.setResult(response.getMsg());
                errMsg = response.getMsg();
            } else {
                sysDataPullRecord.setResult("\u63a5\u53e3\u8fd4\u56de\u9519\u8bef");
                errMsg = "\u63a5\u53e3\u8fd4\u56de\u9519\u8bef";
            }
            this.pullDataRecordMapper.insert(sysDataPullRecord);
            return ApiResponse.fail((String)errMsg);
        }
        sysDataPullRecord.setHttpStatus(String.valueOf(200));
        sysDataPullRecord.setParams(JSON.toJSONString(parasMap));
        sysDataPullRecord.setResult(JsonUtil.toJson((Object)response.getData()));
        if (positive != null && positive.equals("1") && (config.getTriggerAction() == null || config.getTriggerAction().equals("0"))) {
            sysDataPullRecord.setHttpStatus("600");
            sysDataPullRecord.setResult("\u4efb\u52a1\u6267\u884c\u7684\u529f\u80fd\u4e0d\u80fd\u591f\u88ab\u4e3b\u52a8\u89e6\u53d1");
        }
        if (sysDataPullRecord.getHttpStatus().equals("600")) {
            sysDataPullRecord.setSuccess("0");
            sysDataPullRecord.setResult("\u4e3b\u52a8\u89e6\u53d1\u4e0d\u80fd\u4f7f\u7528\u4efb\u52a1\u914d\u7f6e");
            this.pullDataRecordMapper.insert(sysDataPullRecord);
            return ApiResponse.fail((String)"\u4e3b\u52a8\u89e6\u53d1\u4e0d\u80fd\u4f7f\u7528\u4efb\u52a1\u914d\u7f6e");
        }
        this.pullDataRecordMapper.insert(sysDataPullRecord);
        if (HussarUtils.isEmpty((Object)response.getData())) {
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setCode(10000);
            apiResponse.setSuccess(false);
            apiResponse.setMsg("\u62c9\u53d6\u6570\u636e\u4e3a\u7a7a\u6216\u6570\u636e\u62c9\u53d6\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458");
            return apiResponse;
        }
        List thirdDataList = new ArrayList();
        thirdDataList = (List)response.getData();
        if (thirdDataList.size() == 1 && HussarUtils.isEmpty((Object)(map = (Map)thirdDataList.get(0)))) {
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setCode(10000);
            apiResponse.setSuccess(false);
            apiResponse.setMsg("\u62c9\u53d6\u6570\u636e\u4e3a\u7a7a\u6216\u6570\u636e\u62c9\u53d6\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458");
            return apiResponse;
        }
        String fieldMaps = config.getFieldMaps();
        List fieldMapList = JSON.parseArray((String)fieldMaps, SysDataPullFieldMap.class);
        if (HussarUtils.isEmpty((Object)fieldMapList)) {
            return ApiResponse.fail((String)"");
        }
        ArrayList<JSONObject> importList = new ArrayList<JSONObject>();
        for (Map map2 : thirdDataList) {
            JSONObject resMap = this.buildMapAliasValue(fieldMapList, map2, String.valueOf(formId));
            PullDataServiceImpl.deleteEntriesWithEmptyValues((Map)resMap);
            importList.add(resMap);
        }
        HashMap<String, ArrayList<JSONObject>> paramMap = new HashMap<String, ArrayList<JSONObject>>();
        paramMap.put("importList", importList);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)securityUser);
        SysForm sysForm = (SysForm)this.sysFormService.getDetailById(formId).getData();
        List dataList = (List)paramMap.get("importList");
        for (Object object : dataList) {
            Map objectMap = (Map)object;
            if (!HussarUtils.isNotEmpty((Object)sysForm) || !FormCreateTypeEnum.FORM_TO_FORM.getType().equals(sysForm.getCreateSource())) continue;
            objectMap.put("FORM_ID", formId);
        }
        if (StringUtil.isEmpty((String)config.getPullMode()) || "0".equals(config.getPullMode())) {
            this.deleteOldData(sysForm);
            if (sysForm.getFormType().equals("1")) {
                formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
                key = formCanvasSchema.getIdentity();
                for (Object object : dataList) {
                    String json = JsonUtil.toJson(object);
                    JSONObject jsonObject = JSONObject.parseObject((String)json);
                    String createUserId = jsonObject.getString("createUser_user");
                    if (HussarUtils.isEmpty((Object)createUserId)) {
                        createUserId = DataPullUtil.getExternalUserId().toString();
                    }
                    HashMap<String, Object> resMap1 = new HashMap<String, Object>();
                    resMap1.put("formData", object);
                    resMap1.put("processDefinitionKey", key);
                    resMap1.put("userId", createUserId);
                    this.appFormService.flowFormSubmit(String.valueOf(formId), resMap1);
                }
            } else {
                this.formOperateExposedService.tableSave(String.valueOf(config.getAppId()), String.valueOf(formId), paramMap);
            }
        } else if (sysForm.getFormType().equals("1")) {
            formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            key = formCanvasSchema.getIdentity();
            for (Object object : dataList) {
                String json = JsonUtil.toJson(object);
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String createUserId = jsonObject.getString("createUser_user");
                HashMap<String, Object> resMap1 = new HashMap<String, Object>();
                resMap1.put("formData", object);
                resMap1.put("processDefinitionKey", key);
                resMap1.put("userId", createUserId);
                this.appFormService.flowFormSubmit(String.valueOf(formId), resMap1);
            }
        } else {
            this.formOperateExposedService.tableSave(String.valueOf(config.getAppId()), String.valueOf(formId), paramMap);
        }
        return ApiResponse.success();
    }

    private boolean deleteOldData(SysForm sysForm) {
        String appId = sysForm.getAppId().toString();
        String formType = sysForm.getFormType();
        String formId = String.valueOf(sysForm.getId());
        SecurityUser securityUser = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        ArrayList filters = new ArrayList();
        HashMap newParam = new HashMap();
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("rule", "_ne");
        filter.put("val", "");
        filter.put("field", "RECORD_ID");
        filter.put("match", "AND");
        filters.add(filter);
        newParam.put("superQueryConditionDto", filters);
        ResponseEntity responseEntity = this.appFormService.tableQueryByCondition(formId, null, newParam, appId);
        PageVo data = (PageVo)((ApiResponse)responseEntity.getBody()).getData();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)securityUser);
        if (data != null && data.getData() != null) {
            List<Object> list = this.getBelongToForm(formId, data, sysForm);
            if ("1".equals(formType)) {
                if (CollectionUtils.isEmpty(list)) {
                    return true;
                }
                for (Object object : list) {
                    String json = JsonUtil.toJson((Object)object);
                    JSONObject jsonObject = JSONObject.parseObject((String)json);
                    String processInsId = jsonObject.getString("PROCESS_INST_ID");
                    String id = jsonObject.getString("RECORD_ID");
                    if (HussarUtils.isNotEmpty((Object)processInsId)) {
                        ProcessStatusCheckDto processStatusCheckDto = new ProcessStatusCheckDto();
                        processStatusCheckDto.setProcessInsId(processInsId.toString());
                        BpmResponseResult checkedProcessStatus = this.standardInstanceEngineApiService.checkProcessStatus(processStatusCheckDto);
                        JSONArray result = checkedProcessStatus.getResult();
                        String ProcessStatus = (String)result.get(0);
                        if (!"3".equals(ProcessStatus)) {
                            ProcessDto processDto = new ProcessDto();
                            processDto.setProcessInsId(processInsId);
                            BpmResponseResult bpmResponseResult = this.standardInstanceEngineApiService.queryProcessInstance(processDto);
                            JSONArray array = bpmResponseResult.getResult();
                            Map resultMap = (Map)array.get(0);
                            String businessId = resultMap.get("businessId").toString();
                            SecurityUser user = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
                            this.hussarAppBpmService.endProcessByBusinessId(businessId, String.valueOf(user.getUserId()), "\u6570\u636e\u62c9\u53d6\u6267\u884c\u5168\u91cf\u62c9\u53d6", Collections.emptyMap());
                        }
                    }
                    this.appFormService.deleteBatch(formId, id, appId);
                }
            } else {
                String ids = list.stream().map(dataOne -> (String)BeanUtil.beanToMap((Object)dataOne).get("RECORD_ID")).collect(Collectors.joining(","));
                if (HussarUtils.isNotEmpty((Object)ids)) {
                    this.appFormService.deleteBatch(formId, ids, appId);
                }
            }
        }
        return true;
    }

    private List<Object> getBelongToForm(String formId, PageVo data, SysForm form) {
        List datalist = data.getData();
        ArrayList list = Lists.newArrayListWithCapacity((int)5);
        for (Object object : datalist) {
            String json = JsonUtil.toJson(object);
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            if (FormCreateTypeEnum.FORM_TO_FORM.getType().equals(form.getCreateSource())) {
                if (!jsonObject.getString("FORM_ID").equals(formId)) continue;
                list.add(object);
                continue;
            }
            if (!jsonObject.containsKey((Object)"FORM_ID")) {
                list.add(object);
                continue;
            }
            if (HussarUtils.isEmpty((Object)jsonObject.get((Object)"FORM_ID"))) {
                list.add(object);
                continue;
            }
            if (!jsonObject.getString("FORM_ID").equals(formId)) continue;
            list.add(object);
        }
        return list;
    }

    private void fillResMap(Map resMap) {
        HashMap extendMap = new HashMap();
        resMap.forEach((k, v) -> {
            boolean isNum = Pattern.matches("\\d+", String.valueOf(v));
            boolean isNumArr = Pattern.matches("^\\d+(,\\d+)*$", String.valueOf(v));
            if (HussarUtils.isNotEmpty((Object)v) && (isNum || isNumArr)) {
                String fieldName;
                String userName;
                HashMap<String, String> userMap;
                ArrayList userList;
                String fieldName2;
                String userId;
                SysUsers user;
                String name = String.valueOf(k);
                if (name.equals("createUser_user") && HussarUtils.isNotEmpty((Object)(user = this.sysUsersService.getUser(Long.valueOf(userId = String.valueOf(v)))))) {
                    String userName2 = user.getUserName();
                    extendMap.put("createUserName", userName2);
                }
                if (name.contains("usermul") && name.split("_")[1].equals("id")) {
                    fieldName2 = name.split("_")[0];
                    String userId2 = String.valueOf(v);
                    String[] userIds = userId2.split(",");
                    ArrayList<String> userNames = new ArrayList<String>();
                    userList = new ArrayList();
                    for (int i = 0; i < userIds.length; ++i) {
                        SysUsers user2 = this.sysUsersService.getUser(Long.valueOf(userIds[i]));
                        if (HussarUtils.isEmpty((Object)user2)) continue;
                        String userName3 = user2.getUserName();
                        userNames.add(userName3);
                        userMap = new HashMap<String, String>();
                        userMap.put("id", userIds[i]);
                        userMap.put("label", userName3);
                        userList.add(userMap);
                    }
                    userName = String.join((CharSequence)",", userNames);
                    extendMap.put(fieldName2 + "_label", userName);
                    extendMap.put(fieldName2, JSONObject.toJSONString((Object)userList));
                } else if (name.contains("user") && name.split("_")[1].equals("id")) {
                    userId = String.valueOf(v);
                    fieldName = name.split("_")[0];
                    boolean isUserId = Pattern.matches("\\d+", userId);
                    SysUsers user3 = null;
                    if (isUserId) {
                        user3 = this.sysUsersService.getUser(Long.valueOf(userId));
                    }
                    if (HussarUtils.isNotEmpty(user3)) {
                        String userName4 = user3.getUserName();
                        extendMap.put(fieldName + "_label", userName4);
                        ArrayList userList2 = new ArrayList();
                        HashMap<String, String> userMap2 = new HashMap<String, String>();
                        userMap2.put("id", userId);
                        userMap2.put("label", userName4);
                        userList2.add(userMap2);
                        extendMap.put(fieldName, JSONObject.toJSONString(userList2));
                    }
                }
                if (name.contains("orgmul") && name.split("_")[1].equals("id")) {
                    fieldName2 = name.split("_")[0];
                    String orgId = String.valueOf(v);
                    String[] orgIds = orgId.split(",");
                    ArrayList<String> orgNames = new ArrayList<String>();
                    userList = new ArrayList();
                    for (int i = 0; i < orgIds.length; ++i) {
                        String orgName = "";
                        List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(Long.valueOf(orgIds[i])));
                        if (HussarUtils.isNotEmpty((Object)organsByStruIds)) {
                            orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                        } else {
                            OrganizationBo organ = this.organizationBoService.findOrganizationById(Long.valueOf(orgIds[i]));
                            if (!HussarUtils.isNotEmpty((Object)organ)) continue;
                            orgName = organ.getOrganName();
                        }
                        orgNames.add(orgName);
                        userMap = new HashMap();
                        userMap.put("id", orgIds[i]);
                        userMap.put("label", orgName);
                        userList.add(userMap);
                    }
                    userName = String.join((CharSequence)",", orgNames);
                    extendMap.put(fieldName2 + "_label", userName);
                    extendMap.put(fieldName2, JSONObject.toJSONString((Object)userList));
                } else if (name.contains("org") && name.split("_")[1].equals("id")) {
                    String orgId = String.valueOf(v);
                    fieldName = name.split("_")[0];
                    String orgName = "";
                    List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(Long.valueOf(orgId)));
                    if (HussarUtils.isNotEmpty((Object)organsByStruIds)) {
                        orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                    } else {
                        OrganizationBo organ = this.organizationBoService.findOrganizationById(Long.valueOf(orgId));
                        if (HussarUtils.isNotEmpty((Object)organ)) {
                            orgName = organ.getOrganName();
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)orgName)) {
                        extendMap.put(fieldName + "_label", orgName);
                        userList = new ArrayList();
                        HashMap<String, String> userMap3 = new HashMap<String, String>();
                        userMap3.put("id", orgId);
                        userMap3.put("label", orgName);
                        userList.add(userMap3);
                        extendMap.put(fieldName, JSONObject.toJSONString(userList));
                    }
                }
                if (name.contains("address") && name.split("_")[1].equals("code")) {
                    fieldName2 = name.split("_")[0];
                    String code = String.valueOf(v);
                    List fullPathRegionInfoByIds = this.hussarAppRegionService.getFullPathRegionInfoByIds(Collections.singletonList(Long.parseLong(code)));
                    if (HussarUtils.isNotEmpty((Object)fullPathRegionInfoByIds)) {
                        ArrayList<String> regionNames = new ArrayList<String>();
                        for (RegionVo region : fullPathRegionInfoByIds) {
                            String regionName = region.getName();
                            regionNames.add(regionName);
                        }
                        String regionNameFull = String.join((CharSequence)" / ", regionNames);
                        extendMap.put(fieldName2 + "_label", regionNameFull);
                    }
                }
            }
        });
        resMap.putAll(extendMap);
    }

    private static void deleteEntriesWithEmptyValues(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((String)entry.getKey()).startsWith("table")) {
                for (Object object : (ArrayList)entry.getValue()) {
                    PullDataServiceImpl.deleteEntriesWithEmptyValues((Map)object);
                }
            }
            if (entry.getValue() == null || HussarUtils.isEmpty(entry.getValue())) {
                iterator.remove();
                continue;
            }
            boolean isNum = Pattern.matches("\\d+", String.valueOf(entry.getValue()));
            boolean isNumArr = Pattern.matches("^\\d+(,\\d+)*$", String.valueOf(entry.getValue()));
            if ((((String)entry.getKey()).startsWith("number") || ((String)entry.getKey()).startsWith("switch") || ((String)entry.getKey()).startsWith("agg")) && !isNum) {
                iterator.remove();
            }
            if (((String)entry.getKey()).startsWith("usermul") && ((String)entry.getKey()).contains("_id")) {
                if (!isNumArr) {
                    iterator.remove();
                }
            } else if (((String)entry.getKey()).startsWith("user") && ((String)entry.getKey()).contains("_id") && !isNum) {
                iterator.remove();
            }
            if (((String)entry.getKey()).startsWith("orgmul") && ((String)entry.getKey()).contains("_id")) {
                if (!isNumArr) {
                    iterator.remove();
                }
            } else if (((String)entry.getKey()).startsWith("org") && ((String)entry.getKey()).contains("_id") && !isNum) {
                iterator.remove();
            }
            if (((String)entry.getKey()).contains("_code") || ((String)entry.getKey()).equals("createUser_user")) {
                if (isNum || isNumArr) continue;
                iterator.remove();
                continue;
            }
            if (!((String)entry.getKey()).contains("jxdndate")) continue;
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("yyyy");
            DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyy-MM");
            DateTimeFormatter formatter3 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            DateTimeFormatter formatter4 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            DateTimeFormatter formatter5 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            try {
                LocalDateTime.parse(String.valueOf(entry.getValue()), formatter1);
            }
            catch (DateTimeParseException e1) {
                try {
                    LocalDateTime.parse(String.valueOf(entry.getValue()), formatter2);
                }
                catch (DateTimeParseException e2) {
                    try {
                        LocalDateTime.parse(String.valueOf(entry.getValue()), formatter3);
                    }
                    catch (DateTimeParseException e3) {
                        try {
                            LocalDateTime.parse(String.valueOf(entry.getValue()), formatter4);
                        }
                        catch (DateTimeParseException e4) {
                            try {
                                LocalDateTime.parse(String.valueOf(entry.getValue()), formatter5);
                            }
                            catch (DateTimeParseException e5) {
                                iterator.remove();
                            }
                        }
                    }
                }
            }
        }
    }

    private HttpDoPostResponse httpDoPost(String urlString, HashMap paramMap) throws IOException {
        HttpDoPostResponse result = new HttpDoPostResponse();
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
        URL url = new URL(urlString);
        String ipAddress = url.getHost();
        int port = url.getPort();
        if (port != 80) {
            ipAddress = ipAddress + ":" + port;
        }
        String path = url.getPath();
        result.setTestTime(new Date());
        HttpResponse response = HttpUtil.doPost((String)ipAddress, (String)path, (Header[])headers, (HashMap)paramMap, null);
        if (response == null) {
            result.setStatus(500);
            return result;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        result.setStatus(statusCode);
        if (statusCode == 200) {
            result.setResult("\u6210\u529f\uff01");
        } else {
            result.setResult("\u5931\u8d25\uff01");
        }
        HttpEntity entity = response.getEntity();
        String responseBody = EntityUtils.toString((HttpEntity)entity);
        result.setMsg(responseBody);
        return result;
    }

    private ApiResponse<List<Map<String, Object>>> httpPostRequest(String urlString, HashMap paramMap) throws IOException {
        HttpResponse response;
        ApiResponse result = new ApiResponse();
        Header[] headers = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
        URL url = new URL(urlString);
        String ipAddress = url.getHost();
        int port = url.getPort();
        if (port != 80) {
            ipAddress = ipAddress + ":" + port;
        }
        String path = url.getPath();
        try {
            response = HttpUtil.request((String)"POST", (String)ipAddress, (String)path, null, (Header[])headers, (Object)paramMap);
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setCode(500);
            result.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
            return result;
        }
        if (response == null) {
            result.setSuccess(false);
            result.setCode(500);
            result.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
            return result;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            HttpEntity entity = response.getEntity();
            if (HussarUtils.isNotEmpty((Object)entity)) {
                String responseBody = EntityUtils.toString((HttpEntity)entity);
                try {
                    result = (ApiResponse)JsonUtil.parse((String)responseBody, ApiResponse.class);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setCode(500);
                    result.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
                    return result;
                }
            }
        } else {
            result.setSuccess(false);
            result.setCode(500);
            result.setMsg("\u63a5\u53e3\u65e0\u54cd\u5e94");
        }
        if (10000 != result.getCode()) {
            String errMsg = "";
            errMsg = HussarUtils.isNotEmpty((Object)result.getMsg()) ? "\u6570\u636e\u62c9\u53d6\u5f02\u5e38\uff0c\u7b2c\u4e09\u65b9\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + result.getMsg() : "\u6570\u636e\u62c9\u53d6\u5f02\u5e38";
            result.setCode(500);
            result.setMsg(errMsg);
        }
        return result;
    }

    public static boolean isJSON(String str) {
        String pattern = "^\\{.*\\}$";
        return str.matches(pattern);
    }

    private HashMap<String, Object> buildParam(List<JSONObject> list) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        list.stream().forEach(fieldMap -> {
            String name = fieldMap.getString("name");
            Object value = fieldMap.get((Object)"value");
            Object children = fieldMap.get((Object)"children");
            paramMap.put(name, value);
            if (HussarUtils.isNotEmpty((Object)children)) {
                String json = JsonUtil.toJson((Object)children);
                List jsonObjects = JsonUtil.parseArray((String)json, JSONObject.class);
                paramMap.put(name, this.buildParam(jsonObjects));
            }
        });
        return paramMap;
    }

    private JSONObject buildMapAliasValue(List<SysDataPullFieldMap> fieldMapList, Map aliasmMap, String formId) {
        JSONObject paramMap = new JSONObject();
        fieldMapList.stream().forEach(fieldMap -> {
            String name = fieldMap.getName();
            String alias = fieldMap.getAlias();
            String mapType = fieldMap.getMapType();
            String fieldType = fieldMap.getType();
            Map bodyMap = aliasmMap;
            List children = fieldMap.getChildren();
            List subForm = fieldMap.getSubForm();
            if (subForm != null && subForm.size() > 0) {
                ArrayList<JSONObject> subFormList = new ArrayList<JSONObject>();
                List subBodyMaps = new ArrayList();
                Object aliasObject = bodyMap.get(alias);
                if (HussarUtils.isNotEmpty(aliasObject)) {
                    String json = JsonUtil.toJson(aliasObject);
                    subBodyMaps = JsonUtil.parseArray((String)json, Object.class);
                }
                if (HussarUtils.isNotEmpty(subBodyMaps)) {
                    for (Object subBodyMap : subBodyMaps) {
                        Map subBodyWithMain = (Map)subBodyMap;
                        subBodyWithMain.putAll(aliasmMap);
                        for (SysDataPullFieldMap sysDataPullFieldMap : subForm) {
                            String[] aliasName = sysDataPullFieldMap.getAlias().split("\\.");
                            sysDataPullFieldMap.setAlias(aliasName[aliasName.length - 1]);
                        }
                        JSONObject subFormResMap = this.buildMapAliasValue(subForm, (Map)subBodyMap, formId);
                        subFormList.add(subFormResMap);
                    }
                }
                paramMap.put(name, subFormList);
            }
            if (children != null && children.size() > 0) {
                paramMap.put(name, (Object)this.buildMapAliasValue(children, bodyMap, formId));
            } else if (StringUtils.isNotEmpty((CharSequence)mapType)) {
                switch (mapType) {
                    case "0": {
                        try {
                            Object thirdValue = this.gatDataByAlias(alias, bodyMap);
                            if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                            this.formatNewData(name, fieldType, thirdValue, paramMap, formId);
                        }
                        catch (Exception e) {
                            logger.error("\u6570\u636e\u62c9\u53d6\u5904\u7406\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
                        }
                        break;
                    }
                    case "1": {
                        if (!HussarUtils.isNotEmpty((Object)fieldMap.getValue())) break;
                        this.formatNewData(name, fieldType, fieldMap.getValue(), paramMap, formId);
                        break;
                    }
                    case "2": {
                        if ("JXDNSwitch".equals(fieldType)) {
                            paramMap.put(name, (Object)0);
                            break;
                        }
                        paramMap.put(name, (Object)"");
                        break;
                    }
                    case "4": {
                        if (!"createUser_user".equals(name)) break;
                        paramMap.put(name, (Object)DataPullUtil.getExternalUserId());
                        paramMap.put("createUserName", (Object)DataPullUtil.getUserName());
                        break;
                    }
                    case "31": {
                        Map<String, Object> dataMap = this.convertID((SysDataPullFieldMap)fieldMap, bodyMap, "31");
                        paramMap.putAll(dataMap);
                        break;
                    }
                    case "32": {
                        Map<String, Object> dataMapCRM = this.convertID((SysDataPullFieldMap)fieldMap, bodyMap, "32");
                        paramMap.putAll(dataMapCRM);
                    }
                }
            }
        });
        return paramMap;
    }

    private void formatNewData(String field, String fieldType, Object thirdValue, JSONObject newData, String formId) {
        switch (fieldType) {
            case "JXDNDate": {
                String data = String.valueOf(thirdValue);
                String dateFormat = TimeFormatUtil.completeDateFormat((String)data);
                if (!HussarUtils.isNotEmpty((Object)dateFormat)) break;
                newData.put(field, (Object)dateFormat);
                break;
            }
            case "JXDNAddress": {
                if (field.endsWith("_code") && HussarUtils.isNotEmpty((Object)thirdValue)) {
                    List fullPathRegionInfoByIds;
                    String addressCode = "";
                    String fieldName = field.split("_")[0];
                    addressCode = String.valueOf(thirdValue);
                    boolean isAddressCode = Pattern.matches("\\d+", addressCode);
                    if (!isAddressCode || !HussarUtils.isNotEmpty((Object)(fullPathRegionInfoByIds = this.hussarAppRegionService.getFullPathRegionInfoByIds(Collections.singletonList(Long.parseLong(addressCode)))))) break;
                    ArrayList<String> regionNames = new ArrayList<String>();
                    for (RegionVo region : fullPathRegionInfoByIds) {
                        String regionName = region.getName();
                        regionNames.add(regionName);
                    }
                    String regionNameFull = String.join((CharSequence)" / ", regionNames);
                    JSONObject jsonObject = this.formatAddress(formId, regionNameFull, addressCode, fieldName);
                    if (!HussarUtils.isNotEmpty((Object)jsonObject)) break;
                    newData.put(field, (Object)jsonObject.getString("code"));
                    newData.put(fieldName + "_label", (Object)jsonObject.getString("label"));
                    break;
                }
                newData.put(field, thirdValue);
                break;
            }
            case "JXDNUser": {
                if (field.endsWith("_user")) {
                    List organizationBos;
                    SysUsers user;
                    String fieldLabel = field.replace("_user", "Name");
                    String createUserId = "";
                    String createUserName = "";
                    if (!HussarUtils.isNotEmpty((Object)thirdValue) || !HussarUtils.isNotEmpty((Object)(user = this.sysUsersService.getUser(Long.valueOf(createUserId = String.valueOf(thirdValue)))))) break;
                    createUserName = user.getUserName();
                    newData.put(field, (Object)createUserId);
                    newData.put(fieldLabel, (Object)createUserName);
                    if (!HussarUtils.isNotEmpty((Object)createUserId) || (organizationBos = this.organizationBoService.searchOrganizationByUserId(Long.valueOf(createUserId))).isEmpty()) break;
                    String organName = ((OrganizationBo)organizationBos.get(0)).getOrganName();
                    newData.put("dataOrganName", (Object)organName);
                    break;
                }
                if (!field.endsWith("_id")) break;
                String fieldLabel = field.replace("_id", "_label");
                String fieldName = field.split("_")[0];
                String userId = "";
                String userLabel = "";
                ArrayList mapList = new ArrayList();
                if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                userId = String.valueOf(thirdValue);
                boolean isUserId = Pattern.matches("\\d+", userId);
                SysUsers user = null;
                if (isUserId) {
                    user = this.sysUsersService.getUser(Long.valueOf(userId));
                }
                if (!HussarUtils.isNotEmpty(user)) break;
                userLabel = user.getUserName();
                HashMap<String, Object> userMap = new HashMap<String, Object>();
                userMap.put("id", user.getId());
                userMap.put("label", user.getUserName());
                mapList.add(userMap);
                newData.put(field, (Object)userId);
                newData.put(fieldLabel, (Object)userLabel);
                newData.put(fieldName, (Object)JsonUtil.toJson(mapList));
                break;
            }
            case "JXDNUserMulti": {
                if (!field.endsWith("_id")) break;
                String fieldLabel = field.replace("_id", "_label");
                String fieldKey = field.split("_")[0];
                ArrayList mapList = new ArrayList();
                if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                String userIdStr = String.valueOf(thirdValue);
                String[] userIds = userIdStr.split(",");
                ArrayList<String> userNames = new ArrayList<String>();
                ArrayList<String> userIdList = new ArrayList<String>();
                for (int i = 0; i < userIds.length; ++i) {
                    SysUsers user = this.sysUsersService.getUser(Long.valueOf(userIds[i]));
                    if (HussarUtils.isEmpty((Object)user)) continue;
                    String userName = user.getUserName();
                    userNames.add(userName);
                    userIdList.add(String.valueOf(user.getId()));
                    HashMap<String, Object> userMap = new HashMap<String, Object>();
                    userMap.put("id", user.getId());
                    userMap.put("label", user.getUserName());
                    mapList.add(userMap);
                }
                if (userNames.size() <= 0 || userIdList.size() <= 0) break;
                String userName = String.join((CharSequence)",", userNames);
                String userId = String.join((CharSequence)",", userIdList);
                newData.put(field, (Object)userId);
                newData.put(fieldLabel, (Object)userName);
                newData.put(fieldKey, (Object)JsonUtil.toJson(mapList));
                break;
            }
            case "JXDNOrg": {
                if (!field.endsWith("_id")) break;
                String fieldLabel = field.replace("_id", "_label");
                String fieldName = field.split("_")[0];
                String orgName = "";
                String orgId = "";
                ArrayList dataMapList = new ArrayList();
                if (HussarUtils.isNotEmpty((Object)thirdValue)) {
                    orgId = String.valueOf(thirdValue);
                    List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(Long.valueOf(orgId)));
                    if (HussarUtils.isNotEmpty((Object)organsByStruIds)) {
                        orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                    }
                    HashMap<String, String> dataMap = new HashMap<String, String>();
                    dataMap.put("id", orgId);
                    dataMap.put("label", orgName);
                    dataMapList.add(dataMap);
                }
                newData.put(field, (Object)orgId);
                newData.put(fieldLabel, (Object)orgName);
                newData.put(fieldName, (Object)JsonUtil.toJson(dataMapList));
                break;
            }
            case "JXDNOrgMulti": {
                if (!field.endsWith("_id")) break;
                String fieldName = field.split("_")[0];
                String fieldLabel = field.replace("_id", "_label");
                CharSequence[] orgIds = new String[]{};
                ArrayList<String> orgNames = new ArrayList<String>();
                ArrayList dataMapList = new ArrayList();
                if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                String orgId = String.valueOf(thirdValue);
                orgIds = orgId.split(",");
                for (int i = 0; i < orgIds.length; ++i) {
                    String orgName = "";
                    List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(Long.valueOf(orgIds[i])));
                    if (!HussarUtils.isNotEmpty((Object)organsByStruIds)) continue;
                    orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                    orgNames.add(orgName);
                    HashMap<String, CharSequence> fieldDataMap = new HashMap<String, CharSequence>();
                    fieldDataMap.put("id", orgIds[i]);
                    fieldDataMap.put("label", orgName);
                    dataMapList.add(fieldDataMap);
                }
                String orgName = String.join((CharSequence)",", orgNames);
                String organId = String.join((CharSequence)",", orgIds);
                newData.put(field, (Object)organId);
                newData.put(fieldLabel, (Object)orgName);
                newData.put(fieldName, (Object)JsonUtil.toJson(dataMapList));
                break;
            }
            case "JXDNSecurityLevel": {
                Optional<DicLevelTreeVo> any;
                if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                String valueString = thirdValue.toString();
                Integer value = Integer.valueOf(valueString);
                String label = valueString;
                List dicListByType = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
                if (HussarUtils.isNotEmpty((Object)dicListByType) && (any = dicListByType.stream().filter(d -> HussarUtils.equals((Object)valueString, (Object)d.getValue())).findAny()).isPresent()) {
                    label = any.get().getLabel();
                }
                String fieldLabel = field + "_label";
                newData.put(field, (Object)value);
                newData.put(fieldLabel, (Object)label);
                break;
            }
            default: {
                if (!HussarUtils.isNotEmpty((Object)thirdValue)) break;
                newData.put(field, thirdValue);
            }
        }
    }

    private JSONObject formatAddress(String formId, String address, String code, String fieldName) {
        JSONObject jsonObject = new JSONObject();
        int level = (Integer)this.getFieldProperty(formId, fieldName, "addressLevel");
        String replace = address.replace(" ", "");
        String[] parts = replace.split("/");
        int maxLevel = Math.min(level, parts.length);
        StringBuilder labelAddress = new StringBuilder();
        for (int i = 0; i < maxLevel; ++i) {
            labelAddress.append(parts[i]);
            if (i >= maxLevel - 1) continue;
            labelAddress.append(" / ");
        }
        String labelAddressString = labelAddress.toString();
        String newCode = null;
        switch (maxLevel) {
            case 1: {
                newCode = code.substring(0, 2);
                break;
            }
            case 2: {
                newCode = code.substring(0, 4);
                break;
            }
            case 3: {
                newCode = code.substring(0, 6);
                break;
            }
            default: {
                newCode = code;
            }
        }
        jsonObject.put("label", (Object)labelAddressString);
        jsonObject.put("code", (Object)newCode);
        return jsonObject;
    }

    private JSONObject formatAddressCode(String formId, String code, String fieldName) {
        JSONObject jsonObject = new JSONObject();
        int level = (Integer)this.getFieldProperty(formId, fieldName, "addressLevel");
        int maxLevel = Math.min(level, code.length());
        String newCode = null;
        switch (maxLevel) {
            case 1: {
                newCode = code.substring(0, 2);
                break;
            }
            case 2: {
                newCode = code.substring(0, 4);
                break;
            }
            case 3: {
                newCode = code.substring(0, 6);
                break;
            }
            default: {
                newCode = code;
            }
        }
        jsonObject.put("code", (Object)newCode);
        return jsonObject;
    }

    private String processDateField(String field, String formId, String thirdValue) {
        String formatter = (String)this.getFieldProperty(formId, field, "format");
        String result = null;
        if (HussarUtils.isNotEmpty((Object)formatter)) {
            switch (formatter) {
                case "yyyy": {
                    result = thirdValue + "-01-01 00:00:00";
                    break;
                }
                case "yyyy-MM": {
                    result = thirdValue + "-01 00:00:00";
                    break;
                }
                case "yyyy-MM-dd": {
                    result = thirdValue + " 00:00:00";
                    break;
                }
                case "yyyy-MM-dd HH:mm": {
                    result = thirdValue + ":00";
                    break;
                }
                default: {
                    result = thirdValue;
                }
            }
        }
        return result;
    }

    private void processDependDate(JSONObject newData, LocalDateTime dependTime, String formId, String targetField) {
        String formatter = (String)this.getFieldProperty(formId, targetField, "format");
        if (HussarUtils.isEmpty((Object)formatter)) {
            formatter = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String result = null;
        switch (formatter) {
            case "yyyy": {
                int year = dependTime.getYear();
                result = year + "-1-1 00:00:00";
                break;
            }
            case "yyyy-MM": {
                result = dependTime.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).format(dtf);
                break;
            }
            case "yyyy-MM-dd": {
                result = dependTime.with(LocalTime.MIN).format(dtf);
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                result = dependTime.withSecond(0).format(dtf);
                break;
            }
            default: {
                result = dependTime.format(dtf);
            }
        }
        newData.put(targetField, (Object)result);
    }

    private Object getFieldProperty(String formId, String fieldName, String propertyName) {
        if ("CREATETIME_DATE".equals(fieldName.toUpperCase()) || "UPDATETIME_DATE".equals(fieldName.toUpperCase())) {
            return "yyyy-MM-dd HH:mm:ss";
        }
        FormCanvasSchema formCanvasSchema = null;
        try {
            formCanvasSchema = (FormCanvasSchema)this.canvasService.get(formId).getData();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u83b7\u53d6\u65b0\u6570\u636e\u65b9\u6cd5\u4e2d,\u67e5\u8be2\u753b\u5e03\u5931\u8d25,id:{}", (Object)formId);
            throw new BaseException("\u7ec4\u88c5\u6570\u636e\u65f6,\u67e5\u8be2\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
        }
        List widgets = formCanvasSchema.getWidgets();
        List fieldList = widgets.stream().filter(widget -> {
            if ("JXDNChildrenTable".equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) {
                List children = widget.getChildren();
                return children.stream().anyMatch(child -> Objects.equals(child.getName(), fieldName));
            }
            if ("JXDNGroups".equals(widget.getType())) {
                List groupChildList = widget.getChildren();
                return groupChildList.stream().anyMatch(groupChild -> {
                    if ("JXDNChildrenTable".equals(groupChild.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(groupChild.getType())) {
                        List children = groupChild.getChildren();
                        return children.stream().anyMatch(child -> Objects.equals(child.getName(), fieldName));
                    }
                    return Objects.equals(groupChild.getName(), fieldName);
                });
            }
            return Objects.equals(widget.getName(), fieldName);
        }).collect(Collectors.toList());
        Object result = null;
        if (!fieldList.isEmpty()) {
            Widget widget2 = (Widget)fieldList.get(0);
            if ("JXDNChildrenTable".equals(widget2.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget2.getType())) {
                List childWidgets = widget2.getChildren();
                List childFieldList = childWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                result = ((Widget)childFieldList.get(0)).getProps().get((Object)propertyName);
            } else if ("JXDNGroups".equals(widget2.getType())) {
                List groupWidgets = widget2.getChildren();
                List childFieldList = groupWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                if (!childFieldList.isEmpty()) {
                    result = ((Widget)childFieldList.get(0)).getProps().get((Object)propertyName);
                } else {
                    for (Widget groupWidget : groupWidgets) {
                        List groupChildWidgets;
                        List groupChildFieldList;
                        if (!"JXDNChildrenTable".equals(groupWidget.getType()) && !WidgetType.JXDNChildrenTableAgg.getType().equals(groupWidget.getType()) || (groupChildFieldList = (groupChildWidgets = groupWidget.getChildren()).stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList())).isEmpty()) continue;
                        result = ((Widget)groupChildFieldList.get(0)).getProps().get((Object)propertyName);
                        break;
                    }
                }
            } else {
                result = widget2.getProps().get((Object)propertyName);
            }
        }
        return result;
    }

    private Map<String, Object> convertID(SysDataPullFieldMap fieldMap, Map<String, Object> thirdMap, String coverType) {
        String type = fieldMap.getType();
        String name = fieldMap.getName();
        String alias = fieldMap.getAlias();
        String mapType = fieldMap.getMapType();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        switch (type) {
            case "JXDNUser": {
                Long employeeId;
                SysUsers sysUsersRes;
                String id;
                if (name.contains("_code") || name.contains("_id")) {
                    id = this.gatDataByAlias(alias, thirdMap).toString();
                    sysUsersRes = null;
                    employeeId = null;
                    if (StringUtils.isNotEmpty((CharSequence)id)) {
                        if ("32".equals(coverType)) {
                            employeeId = this.pullSysIdConvertsService.getPlatformUserId(null, Long.valueOf(id));
                        } else if ("31".equals(coverType)) {
                            employeeId = this.pullSysIdConvertsService.getPlatformUserId(id, null);
                        }
                    }
                    if (employeeId != null) {
                        sysUsersRes = this.getUserIdByEmployeeId(employeeId);
                    }
                    if (sysUsersRes != null) {
                        dataMap.putAll(this.getUserMap(sysUsersRes, name));
                    }
                }
                if (!name.endsWith("_user")) break;
                id = this.gatDataByAlias(alias, thirdMap).toString();
                sysUsersRes = null;
                employeeId = null;
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    if ("32".equals(coverType)) {
                        employeeId = this.pullSysIdConvertsService.getPlatformUserId(null, Long.valueOf(id));
                    } else if ("31".equals(coverType)) {
                        employeeId = this.pullSysIdConvertsService.getPlatformUserId(id, null);
                    }
                }
                if (employeeId != null) {
                    sysUsersRes = this.getUserIdByEmployeeId(employeeId);
                }
                if (sysUsersRes != null) {
                    List organizationBos;
                    dataMap.put(name, sysUsersRes.getId());
                    dataMap.put("createUserName", sysUsersRes.getUserName());
                    if (!HussarUtils.isNotEmpty((Object)sysUsersRes.getId()) || (organizationBos = this.organizationBoService.searchOrganizationByUserId(sysUsersRes.getId())).isEmpty()) break;
                    String organName = ((OrganizationBo)organizationBos.get(0)).getOrganName();
                    dataMap.put("dataOrganName", organName);
                    break;
                }
                Long externalUserId = DataPullUtil.getExternalUserId();
                String userName = DataPullUtil.getUserName();
                String fieldLabel = name.replace("_id", "_label");
                dataMap.put(name, externalUserId);
                dataMap.put("createUserName", userName);
                break;
            }
            case "JXDNUserMulti": {
                if (!name.contains("_code") && !name.contains("_id")) break;
                String id = this.gatDataByAlias(alias, thirdMap).toString();
                String[] ids = id.split(",");
                String fieldLabel = name.replace("_id", "_label");
                String fieldName = name.split("_")[0];
                ArrayList mapList = new ArrayList();
                List<Object> idList = new ArrayList();
                if (ids != null && ids.length > 0 && HussarUtils.isNotEmpty((Object)id)) {
                    idList = Arrays.asList(ids);
                }
                ArrayList employeeIds = new ArrayList();
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    idList.stream().forEach(idOne -> {
                        Long employeeId = null;
                        if ("32".equals(coverType)) {
                            employeeId = this.pullSysIdConvertsService.getPlatformUserId(null, Long.valueOf(idOne));
                        } else if ("31".equals(coverType)) {
                            employeeId = this.pullSysIdConvertsService.getPlatformUserId(idOne, null);
                        }
                        if (HussarUtils.isNotEmpty(employeeId)) {
                            employeeIds.add(employeeId);
                        }
                    });
                }
                ArrayList<String> userNames = new ArrayList<String>();
                ArrayList<String> userIdList = new ArrayList<String>();
                if (employeeIds.size() <= 0) break;
                for (int i = 0; i < employeeIds.size(); ++i) {
                    SysUsers userIdByEmployeeId = this.getUserIdByEmployeeId((Long)employeeIds.get(i));
                    if (HussarUtils.isEmpty((Object)userIdByEmployeeId)) continue;
                    String userName = userIdByEmployeeId.getUserName();
                    userNames.add(userName);
                    userIdList.add(String.valueOf(userIdByEmployeeId.getId()));
                    HashMap<String, Object> userMap = new HashMap<String, Object>();
                    userMap.put("id", userIdByEmployeeId.getId());
                    userMap.put("label", userIdByEmployeeId.getUserName());
                    mapList.add(userMap);
                }
                if (userNames.size() <= 0 || userIdList.size() <= 0) break;
                String userName = String.join((CharSequence)",", userNames);
                String userId = String.join((CharSequence)",", userIdList);
                dataMap.put(name, userId);
                dataMap.put(fieldLabel, userName);
                dataMap.put(fieldName, JsonUtil.toJson(mapList));
                break;
            }
            case "JXDNOrg": {
                if (!name.contains("_code") && !name.contains("_id")) break;
                String fieldLabel = name.replace("_id", "_label");
                String fieldName = name.split("_")[0];
                String id = this.gatDataByAlias(alias, thirdMap).toString();
                Long struId = null;
                String orgName = "";
                ArrayList mapList = new ArrayList();
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    if ("32".equals(coverType)) {
                        struId = this.pullSysIdConvertsService.getPlatformUserId(null, Long.valueOf(id));
                    } else if ("31".equals(coverType)) {
                        struId = this.pullSysIdConvertsService.getPlatformUserId(id, null);
                    }
                }
                if (struId == null) break;
                List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(struId));
                if (HussarUtils.isNotEmpty((Object)organsByStruIds)) {
                    orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                }
                HashMap<String, Object> fieldDataMap = new HashMap<String, Object>();
                fieldDataMap.put("id", struId);
                fieldDataMap.put("label", orgName);
                mapList.add(fieldDataMap);
                dataMap.put(name, struId);
                dataMap.put(fieldLabel, orgName);
                dataMap.put(fieldName, JsonUtil.toJson(mapList));
                break;
            }
            case "JXDNOrgMulti": {
                if (!name.contains("_code") && !name.contains("_id")) break;
                String fieldLabel = name.replace("_id", "_label");
                String fieldName = name.split("_")[0];
                String id = this.gatDataByAlias(alias, thirdMap).toString();
                String[] ids = id.split(",");
                ArrayList mapList = new ArrayList();
                List<Object> idList = new ArrayList();
                if (ids != null && ids.length > 0 && HussarUtils.isNotEmpty((Object)id)) {
                    idList = Arrays.asList(ids);
                }
                ArrayList employeeIds = new ArrayList();
                ArrayList orgNames = new ArrayList();
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    idList.stream().forEach(idOne -> {
                        Long struId = null;
                        if ("32".equals(coverType)) {
                            struId = this.pullSysIdConvertsService.getPlatformUserId(null, Long.valueOf(idOne));
                        } else if ("31".equals(coverType)) {
                            struId = this.pullSysIdConvertsService.getPlatformUserId(idOne, null);
                        }
                        if (HussarUtils.isNotEmpty(struId)) {
                            employeeIds.add(String.valueOf(struId));
                        }
                    });
                }
                if (employeeIds.size() <= 0) break;
                employeeIds.stream().forEach(employeeIdOne -> {
                    List organsByStruIds = this.organizationBoService.getOrgansByStruIds(Collections.singletonList(Long.valueOf(employeeIdOne)));
                    if (HussarUtils.isNotEmpty((Object)organsByStruIds)) {
                        String orgName = ((SearchOrganVo)organsByStruIds.get(0)).getLabel();
                        orgNames.add(orgName);
                        HashMap<String, String> fieldDataMap = new HashMap<String, String>();
                        fieldDataMap.put("id", (String)employeeIdOne);
                        fieldDataMap.put("label", orgName);
                        mapList.add(fieldDataMap);
                    }
                });
                String orgName = String.join((CharSequence)",", orgNames);
                String organId = String.join((CharSequence)",", employeeIds);
                dataMap.put(name, organId);
                dataMap.put(fieldLabel, orgName);
                dataMap.put(fieldName, JsonUtil.toJson(mapList));
            }
        }
        return dataMap;
    }

    private Object gatDataByAlias(String alias, Map<String, Object> bodyMap) {
        if (HussarUtils.isNotEmpty((Object)alias)) {
            String[] aliasArr = alias.split("\\.");
            if (aliasArr.length == 0) {
                return bodyMap.get(alias);
            }
            for (String aliasOne : Arrays.stream(aliasArr).limit(aliasArr.length - 1).collect(Collectors.toList())) {
                bodyMap = (Map)bodyMap.get(aliasOne);
            }
            Object dataVal = bodyMap.get(Arrays.stream(aliasArr).skip(aliasArr.length - 1).findFirst().get());
            if (HussarUtils.isNotEmpty(dataVal)) {
                return dataVal;
            }
        }
        return null;
    }

    private SysUsers getUserIdByEmployeeId(Long employeeId) {
        return this.sysUsersService.getOneByEmployeeId(employeeId);
    }

    private List<SysUsers> getUserIdByEmployeeIds(List employeeIds) {
        ArrayList<SysUsers> sysUsers = new ArrayList<SysUsers>();
        employeeIds.stream().forEach(employeeId -> sysUsers.add(this.getUserIdByEmployeeId((Long)employeeId)));
        return sysUsers;
    }

    private Map getUserMap(SysUsers sysUsers, String name) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> userMapList = new ArrayList<HashMap<String, Object>>();
        HashMap labelMap = new HashMap();
        resMap.put(name, sysUsers.getId());
        if (name.contains("_id")) {
            name = name.replace("_id", "");
        }
        if (name.contains("_code")) {
            name = name.replace("_code", "");
        }
        userMap.put("id", sysUsers.getId());
        userMap.put("label", sysUsers.getUserName());
        userMapList.add(userMap);
        resMap.put(name, JSON.toJSONString(userMapList));
        name = name + "_label";
        resMap.put(name, sysUsers.getUserName());
        return resMap;
    }

    private Map getUserMap(List<SysUsers> sysUsersList, String name) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        List userMapList = null;
        HashMap labelMap = new HashMap();
        List ids = sysUsersList.stream().map(SysUsers::getId).collect(Collectors.toList());
        List names = sysUsersList.stream().map(SysUsers::getUserName).collect(Collectors.toList());
        resMap.put(name, ids);
        if (name.contains("_id")) {
            name = name.replace("_id", "");
        }
        if (name.contains("_code")) {
            name = name.replace("_code", "");
        }
        userMapList = sysUsersList.stream().map(sysUsers -> {
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("id", sysUsers.getId());
            userMap.put("label", sysUsers.getUserName());
            return userMap;
        }).collect(Collectors.toList());
        resMap.put(name, JSON.toJSONString(userMapList));
        name = name + "_label";
        resMap.put(name, name);
        return resMap;
    }

    public void dealPullData(String dataSourceKey, String tenantCode) {
        String dataSourceKeyLocal = DataModelUtil.currentDsName();
        HussarTenantDefinition hussarTenant = HussarContextHolder.getHussarTenant();
        LocalDateTime now = LocalDateTime.now();
        List sysDataPullTasks = this.sysDataPullTaskService.queryDataPullTasks(now);
        if (HussarUtils.isNotEmpty(sysDataPullTasks = sysDataPullTasks.stream().filter(sysDataPullTask -> {
            boolean validTask = this.validTask((SysDataPullTask)sysDataPullTask, now);
            return validTask;
        }).collect(Collectors.toList()))) {
            logger.info("\u6570\u636e\u62c9\u53d6 => \u5f53\u524d\u5f85\u62c9\u53d6\u4efb\u52a1\u5217\u8868\uff1a{},\u6570\u636e\u6e90\uff1a{},hussarTenant:{}", new Object[]{sysDataPullTasks.stream().map(SysDataPullTask::getId).collect(Collectors.toList()), dataSourceKeyLocal, JsonUtil.toJson((Object)hussarTenant)});
            ArrayList<SysDataPullTask> updatedTasks = new ArrayList<SysDataPullTask>();
            ArrayList<SysDataPullTaskDto> newTasks = new ArrayList<SysDataPullTaskDto>();
            for (SysDataPullTask sysDataPullTask2 : sysDataPullTasks) {
                try {
                    SecurityUser sysUser = new SecurityUser();
                    sysUser.setUserId(DataPullUtil.getExternalUserId());
                    sysUser.setUserName(DataPullUtil.getUserName());
                    TransmittableThreadLocalHolder.set((String)"loginUser", (Object)sysUser);
                    this.asyncPullData(sysDataPullTask2.getFormId(), sysDataPullTask2.getConfigId(), null);
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u62c9\u53d6 => \u8c03\u7528\u6570\u636e\u62c9\u53d6\u540c\u6b65\u5931\u8d25 => \u6570\u636e\u6e90:{}", (Object)dataSourceKey, (Object)e);
                }
                sysDataPullTask2.setStatus("1");
                sysDataPullTask2.setExecuteTime(now);
                updatedTasks.add(sysDataPullTask2);
                SysDataPullRepeatRule repeatRule = (SysDataPullRepeatRule)JSON.parseObject((String)sysDataPullTask2.getRepeatRule(), SysDataPullRepeatRule.class);
                if ("only_once".equals(repeatRule.getType())) continue;
                LocalDateTime nextExecuteTime = repeatRule.calculateNextReminderTime(sysDataPullTask2.getFirstExecuteTime(), now);
                String endExecuteTimeSet = sysDataPullTask2.getEndExecuteTimeSet();
                if (endExecuteTimeSet != null && !endExecuteTimeSet.equals("0") && nextExecuteTime.isAfter(sysDataPullTask2.getEndExecuteTime())) continue;
                SysDataPullTaskDto newTask = new SysDataPullTaskDto();
                BeanUtils.copyProperties((Object)sysDataPullTask2, (Object)newTask);
                newTask.setId(null);
                newTask.setNextExecuteTime(nextExecuteTime);
                newTask.setStatus("0");
                newTask.setExecuteTime(null);
                newTasks.add(newTask);
            }
            this.sysDataPullTaskService.updateBatchById(updatedTasks);
            this.sysDataPullTaskService.saveBatch(newTasks);
        }
    }

    private boolean validTask(SysDataPullTask sysDataPullTask, LocalDateTime dataPullExecuteTime) {
        if (com.jxdinfo.hussar.platform.core.utils.StringUtil.isNotEmpty((Object)sysDataPullTask.getEndExecuteTimeSet()) && sysDataPullTask.getEndExecuteTimeSet().equals("1")) {
            if (dataPullExecuteTime.isAfter(sysDataPullTask.getEndExecuteTime())) {
                return false;
            }
            if (sysDataPullTask.getStatus().equals("1")) {
                return false;
            }
        }
        return true;
    }
}

