/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserRelationDto;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.relational.dto.RoleOrganRelationDto;
import com.jxdinfo.hussar.authorization.relational.dto.RolePostRelationDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppRoleService;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SaveRoleMembersDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.appRoleServiceImpl")
public class AppRoleServiceImpl
implements IAppRoleService {
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthorizeRolesService;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysUpAppVisitRoleFieldService roleFieldService;
    @Resource
    private ISysAppVisitDataLogicService dataLogicService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService organDataAuthorityService;
    @Resource
    private ISysAppVisitDataLogicFilterService dataLogicFilterService;

    @HussarTransactional
    public Boolean delAppRole(Long roleId) {
        Boolean flag = this.sysRolesExternalService.delAppRole(roleId);
        this.delAppRoleNoCode(roleId);
        return flag;
    }

    @HussarTransactional
    public Long copyAppRole(Long roleId) {
        Long newRoleId = this.sysRolesExternalService.copyAppRole(roleId);
        this.copyAppRoleNoCode(roleId, newRoleId);
        return newRoleId;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveAppRoleMembers(SaveRoleMembersDto saveRoleMembersDto) {
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getStruIds())) {
            RoleOrganRelationDto roleOrganRelationDto = new RoleOrganRelationDto();
            roleOrganRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            roleOrganRelationDto.setStruIds(saveRoleMembersDto.getStruIds());
            this.sysRolesExternalService.saveAppOrganRole(roleOrganRelationDto);
        }
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getUserIds())) {
            RoleUserRelationDto roleUserRelationDto = new RoleUserRelationDto();
            roleUserRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            roleUserRelationDto.setUserIds(saveRoleMembersDto.getUserIds());
            this.sysRolesExternalService.saveAppUserRole(roleUserRelationDto);
        }
        if (HussarUtils.isNotEmpty((Object)saveRoleMembersDto.getPostIds())) {
            RolePostRelationDto rolePostRelationDto = new RolePostRelationDto();
            rolePostRelationDto.setRoleId(saveRoleMembersDto.getRoleId());
            rolePostRelationDto.setPostIds(saveRoleMembersDto.getPostIds());
            this.sysRolesExternalService.saveAppPostRole(rolePostRelationDto);
        }
        return Boolean.TRUE;
    }

    private void delAppRoleNoCode(Long roleId) {
        this.formAuthorizeRolesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)roleId));
        this.roleButtonService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getRoleId, (Object)roleId));
        this.roleFieldService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getRoleId, (Object)roleId));
        this.organDataAuthorityService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)roleId));
        List dataLogicList = this.dataLogicService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)dataLogicList)) {
            List dataLogicIds = dataLogicList.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicFilterService.remove((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, dataLogicIds));
            this.dataLogicService.removeByIds((Collection)dataLogicList);
        }
    }

    private void copyAppRoleNoCode(Long sourceRoleId, Long targetRoleId) {
        this.copyFormAuthorizeRoles(sourceRoleId, targetRoleId);
        this.copyButton(sourceRoleId, targetRoleId);
        this.copyField(sourceRoleId, targetRoleId);
        this.copyOrganData(sourceRoleId, targetRoleId);
        this.copyDataLogic(sourceRoleId, targetRoleId);
    }

    private void copyFormAuthorizeRoles(Long sourceRoleId, Long targetRoleId) {
        List formAuthorizeRoleList = this.formAuthorizeRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)sourceRoleId));
        formAuthorizeRoleList.forEach(role -> {
            role.setId(null);
            role.setRoleId(targetRoleId);
        });
        this.formAuthorizeRolesService.saveBatch((Collection)formAuthorizeRoleList);
    }

    private void copyButton(Long sourceRoleId, Long targetRoleId) {
        List roleButtonList = this.roleButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getRoleId, (Object)sourceRoleId));
        roleButtonList.forEach(button -> {
            button.setId(null);
            button.setRoleId(targetRoleId);
        });
        this.roleButtonService.saveBatch((Collection)roleButtonList);
    }

    private void copyField(Long sourceRoleId, Long targetRoleId) {
        List roleFieldList = this.roleFieldService.list((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getRoleId, (Object)sourceRoleId));
        roleFieldList.forEach(field -> {
            field.setId(null);
            field.setRoleId(targetRoleId);
        });
        this.roleFieldService.saveBatch((Collection)roleFieldList);
    }

    private void copyOrganData(Long sourceRoleId, Long targetRoleId) {
        List organDataAuthorityList = this.organDataAuthorityService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getRoleId, (Object)sourceRoleId));
        organDataAuthorityList.forEach(organ -> {
            organ.setId(null);
            organ.setRoleId(targetRoleId);
        });
        this.organDataAuthorityService.saveBatch((Collection)organDataAuthorityList);
    }

    private void copyDataLogic(Long sourceRoleId, Long targetRoleId) {
        List dataLogicList = this.dataLogicService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getRoleId, (Object)sourceRoleId));
        if (HussarUtils.isNotEmpty((Object)dataLogicList)) {
            List dataLogicIds = dataLogicList.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            List dataLogicFilterList = this.dataLogicFilterService.list((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, dataLogicIds));
            HashMap dataLogicIdMapping = new HashMap();
            dataLogicList.forEach(dataLogic -> {
                Long newLogicDataId = IdWorker.getId((Object)dataLogic);
                dataLogicIdMapping.put(dataLogic.getId(), newLogicDataId);
                dataLogic.setId(newLogicDataId);
                dataLogic.setRoleId(targetRoleId);
            });
            this.dataLogicService.saveBatch((Collection)dataLogicList);
            dataLogicFilterList.forEach(filter -> {
                filter.setId(null);
                filter.setRoleDataLogicId((Long)dataLogicIdMapping.get(filter.getRoleDataLogicId()));
            });
            this.dataLogicFilterService.saveBatch((Collection)dataLogicFilterList);
        }
    }
}

