/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.service.impl;

import com.alibaba.excel.util.FileUtils;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFileInfoVo;
import com.jxdinfo.hussar.formdesign.application.print.dao.SysFileInfoDashboardMapper;
import com.jxdinfo.hussar.formdesign.application.print.model.SysFileInfoDashboard;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class SysFileInfoDashboardServiceImpl
extends HussarServiceImpl<SysFileInfoDashboardMapper, SysFileInfoDashboard>
implements ISysFileInfoDashboardService {
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private OssService ossService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysFileInfoDashboardServiceImpl.class);

    public void exportFileInfoDashboard(List<SysFileInfoVo> sysFileInfoDashboards, String FileInfoPath) {
        if (HussarUtils.isNotEmpty(sysFileInfoDashboards)) {
            for (AttachmentManagerModelVo attachmentManagerModelVo : sysFileInfoDashboards) {
                Long fileId = Long.valueOf(String.valueOf(attachmentManagerModelVo.getId()));
                AttachmentManagerModelVo sourceAttachment = this.attachmentManagerService.getByFileId(fileId);
                Path inputFilePath = Paths.get(sourceAttachment.getPath(), new String[0]);
                String filePath = FileUtil.posixPath((String[])new String[]{FileInfoPath, String.valueOf(attachmentManagerModelVo.getId())});
                File file = new File(filePath);
                if (!file.exists() && !file.mkdirs()) {
                    throw new HussarException("\u5bfc\u51fa\u56fe\u7247\u6587\u4ef6\u65f6\uff0c\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25!");
                }
                Path outputFilePath = Paths.get(filePath, sourceAttachment.getAttachmentName());
                try {
                    InputStream inputStream = Files.newInputStream(inputFilePath, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        OutputStream outputStream = Files.newOutputStream(outputFilePath, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            outputStream.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u56fe\u7247\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01{}", (Object)e.getMessage());
                }
            }
        }
    }

    public void importDashboardImage(ImportMappingDto importMappingDto, List<SysFileInfoDashboard> printDashboardImages, String templateFilePath) {
        if (HussarUtils.isNotEmpty(printDashboardImages)) {
            for (SysFileInfoDashboard fileInfoDashboard : printDashboardImages) {
                try {
                    File file;
                    if (!HussarUtils.isNotEmpty((Object)fileInfoDashboard) || !(file = new File(templateFilePath + "/" + fileInfoDashboard.getId())).exists()) continue;
                    Object[] files = file.listFiles();
                    AssertUtil.isNotEmpty((Object[])files, (String)"\u56fe\u7247\u6587\u4ef6\u4e0d\u5b58\u5728!");
                    String fileName = ((File)files[0]).getName();
                    String filePath = FileUtil.posixPath((String[])new String[]{templateFilePath, String.valueOf(fileInfoDashboard.getId()), fileName});
                    Long id = this.fileUpload(filePath);
                    importMappingDto.getDashboardImageIdMap().put(fileInfoDashboard.getId(), id);
                }
                catch (Exception e) {
                    LOGGER.error("\u56fe\u7247\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u56fe\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException iOException) {
            throw new BaseException("\u56fe\u7247\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }
}

