/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lefttree.aspect;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.lefttree.annotation.CheckPermission;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeService;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.NavLeftTreeOption;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.WidgetItem;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.utils.ConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class NavLeftTreeAspect {
    @Resource
    private INavLeftTreeService navLeftTreeService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationBoService applicationBoService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private SysUpAppVisitRoleFieldMapper sysUpAppVisitRoleFieldMapper;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final Logger LOGGER = LoggerFactory.getLogger(NavLeftTreeAspect.class);

    @Before(value="@annotation(annotation)", argNames="joinPoint,annotation")
    public void before(JoinPoint joinPoint, CheckPermission annotation) {
        Object[] args = joinPoint.getArgs();
        if (args.length < 2) {
            throw new HussarException("\u672a\u77e5\u9519\u8bef");
        }
        Long formId = (Long)ConvertUtil.convert((Object)args[0], Long.class);
        String viewId = (String)ConvertUtil.convert((Object)args[1], String.class);
        DataView dataView = this.navLeftTreeService.getDataView(formId, viewId);
        int viewType = dataView.getViewType();
        NavLeftTreeOption leftTreeOption = dataView.getNavLeftTreeOption();
        this.checkLeftTreeProps(formId, viewType, leftTreeOption);
        this.checkLeftTreePermission(formId, viewType, leftTreeOption);
    }

    private void checkLeftTreeProps(Long formId, int viewType, NavLeftTreeOption leftTreeOption) {
        WidgetItem linkWidget = leftTreeOption.getLinkWidget();
        Long linkFormId = linkWidget.getFormId();
        WidgetItem supWidget = leftTreeOption.getSupWidget();
        switch (viewType) {
            case 1: {
                WidgetItem filterWidget = leftTreeOption.getFilterWidget();
                this.checkWidgetExist(formId, filterWidget.getName());
                this.checkWidgetExist(linkFormId, linkWidget.getName(), supWidget.getName());
                break;
            }
            case 2: {
                WidgetItem titleWidget = leftTreeOption.getTitleWidget();
                this.checkWidgetExist(formId, titleWidget.getName(), linkWidget.getName(), supWidget.getName());
                break;
            }
        }
    }

    private void checkLeftTreePermission(Long formId, int viewType, NavLeftTreeOption leftTreeOption) {
        if (this.isAdmin(formId)) {
            return;
        }
        WidgetItem linkWidget = leftTreeOption.getLinkWidget();
        Long linkFormId = linkWidget.getFormId();
        WidgetItem supWidget = leftTreeOption.getSupWidget();
        switch (viewType) {
            case 1: {
                this.checkFormPermission(linkFormId);
                this.checkWidgetPermission(linkFormId, linkWidget.getName(), supWidget.getName());
                break;
            }
            case 2: {
                WidgetItem titleWidget = leftTreeOption.getTitleWidget();
                this.checkWidgetPermission(formId, titleWidget.getName());
                break;
            }
        }
    }

    private FormCanvasSchema getCanvasSchema(Long formId) {
        return Optional.ofNullable(this.canvasSchemaService.get(String.valueOf(formId))).map(FormDesignResponse::getData).orElseThrow(() -> new HussarException("\u8868\u5355\u753b\u5e03\u67e5\u8be2\u5931\u8d25"));
    }

    private void checkFormPermission(Long formId) {
        boolean flag = this.sysAppVisitFormAuthorizeRolesService.checkFormAuthority(String.valueOf(formId));
        if (!flag) {
            LOGGER.error("\u65e0\u8868\u5355\u6743\u9650! \u8868\u5355id:{}", (Object)formId);
            throw new HussarException("\u5de6\u4fa7\u6811\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u8bbe\u8ba1\u6216\u6743\u9650\u914d\u7f6e");
        }
    }

    private void checkWidgetPermission(Long formId, String ... widgetNameList) {
        SecurityUser user = NoCodeSecurityUtil.getUser();
        List<FieldAuthorityVo> fieldAuthorityVoList = this.sysUpAppVisitRoleFieldMapper.selectByFormId(formId, user.getRolesList());
        for (String widgetName : widgetNameList) {
            for (FieldAuthorityVo fieldAuth : fieldAuthorityVoList) {
                if (!widgetName.equals(fieldAuth.getFieldId()) || !Whether.NO.getValue().equals(fieldAuth.getCanRead())) continue;
                LOGGER.error("\u65e0\u5b57\u6bb5\u6743\u9650! \u8868\u5355id:{}, \u5b57\u6bb5\u6807\u8bc6:{}", (Object)formId, (Object)widgetName);
                throw new HussarException("\u5de6\u4fa7\u6811\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u8bbe\u8ba1\u6216\u6743\u9650\u914d\u7f6e");
            }
        }
    }

    private void checkWidgetExist(Long formId, String ... widgetNameList) {
        FormCanvasSchema canvasSchema = this.getCanvasSchema(formId);
        List widgets = canvasSchema.widgets();
        for (String widgetName : widgetNameList) {
            boolean flag;
            boolean bl = flag = widgets.stream().anyMatch(widget -> widgetName.equals(widget.getName())) || widgetName.equals("title");
            if (flag) continue;
            LOGGER.error("\u5de6\u4fa7\u6811\u914d\u7f6e\u7684\u7ec4\u4ef6\u4e0d\u5b58\u5728! \u8868\u5355id:{}, \u7ec4\u4ef6\u6807\u8bc6:{}", (Object)formId, (Object)widgetName);
            throw new HussarException("\u5de6\u4fa7\u6811\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u8bbe\u8ba1\u6216\u6743\u9650\u914d\u7f6e");
        }
    }

    private boolean isAdmin(Long formId) {
        SecurityUser user = NoCodeSecurityUtil.getUser();
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        if (user.isSuperAdmin() || isTenantAdmin) {
            return true;
        }
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        Long appId = sysForm.getAppId();
        SysApplication sysApplication = this.applicationBoService.selectById(appId);
        Long developRoleId = sysApplication.getDevelopRoleId();
        List rolesList = user.getRolesList();
        return rolesList.contains(developRoleId);
    }
}

