/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.model.FormMap;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormUpgradeTypEnum;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.UpgradeFormMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormCheckConfig;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.dao.SysFormLinkOpenMapper;
import com.jxdinfo.hussar.formdesign.application.formLink.model.SysFormLink;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleStatusService;
import com.jxdinfo.hussar.formdesign.application.lefttree.model.NavLeftTreeOrder;
import com.jxdinfo.hussar.formdesign.application.lefttree.service.INavLeftTreeOrderService;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.print.dto.SysPrintTemplateDto;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysFileInfoDashboardService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethod;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptMethodRelated;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptParam;
import com.jxdinfo.hussar.formdesign.application.property.model.ScriptRecord;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptMethodService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptParamService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRecordService;
import com.jxdinfo.hussar.formdesign.application.property.service.ScriptRelatedService;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptMethodConstruct;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.tool.CollUtil;
import com.jxdinfo.hussar.formdesign.application.tool.SnowflakeID;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.FormUpgradeProgressCache;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.FormMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.EngineOperationType;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormUpgradeInfoServiceImpl")
public class FormUpgradeInfoServiceImpl
implements IFormUpgradeInfoService {
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFileInfoDashboardService sysFileInfoDashboardService;
    @Resource
    private IFormImportInfoService formImportInfoService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SnowflakeID snowflakeID;
    @Resource
    private OssService ossService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private ViewService viewService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private SysMsgPushConfigService sysMsgPushConfigService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private ISysFormLinkSingleStatusService sysFormLinkSingleStatusService;
    @Resource
    private SysFormLinkOpenMapper sysFormLinkOpenMapper;
    @Resource
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Resource
    private ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Resource
    private ISysFormLinkSingleService sysFormLinkSingleService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private INavLeftTreeOrderService navLeftTreeOrderService;
    @Resource
    private ISysRuleInfoService sysRuleInfoService;

    @FormUpgradeProgressCache(status=1, msg="\u6b63\u5728\u5347\u7ea7\u8868\u5355\u6570\u636e")
    @ImportProgressCache(status=1, msg="\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")
    public void upgradeFormData(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        Long userId = BaseSecurityUtil.getUser().getUserId();
        SysForm upgradeForm = upgradeFormMappingDto.getFormDataInit().getForm();
        SysForm currentForm = null;
        if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            currentForm = (SysForm)JSONObject.parseObject((String)JSONObject.toJSONString((Object)upgradeForm), SysForm.class);
            currentForm.setAppId(formUpgradeDto.getAppId());
            currentForm.setFormGroupId(formUpgradeDto.getFormGroupId());
            this.sysFormService.save((Object)currentForm);
        } else if (FormUpgradeTypEnum.MERGE.getCode().equals(formUpgradeDto.getUpgradeType()) || FormUpgradeTypEnum.HALF_COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            currentForm = (SysForm)this.sysFormService.getById((Serializable)formUpgradeDto.getId());
            if (!upgradeForm.getTableName().equals(currentForm.getTableName())) {
                throw new HussarException("\u8868\u5355\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u6821\u9a8c\u5931\u8d25");
            }
            currentForm.setFormName(upgradeForm.getFormName());
            currentForm.setFormIconType(upgradeForm.getFormIconType());
            currentForm.setFormIcon(upgradeForm.getFormIcon());
            currentForm.setFormIconColor(upgradeForm.getFormIconColor());
            currentForm.setLastEditor(userId);
            currentForm.setHidden(upgradeForm.getHidden());
            this.sysFormService.updateById((Object)currentForm);
        } else {
            throw new HussarException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
        }
        upgradeFormMappingDto.setUpgradeForm(upgradeForm);
        upgradeFormMappingDto.setCurrentForm(currentForm);
        upgradeFormMappingDto.setOldAppId(upgradeForm.getAppId());
        upgradeFormMappingDto.setNewAppId(currentForm.getAppId());
        upgradeFormMappingDto.getAppIdMap().put(upgradeForm.getAppId(), currentForm.getAppId());
        upgradeFormMappingDto.getFormGroupMap().put(upgradeForm.getFormGroupId(), currentForm.getFormGroupId());
        upgradeFormMappingDto.getFormIdMap().put(upgradeForm.getId(), currentForm.getId());
        formUpgradeDto.setFormType(currentForm.getFormType());
    }

    @FormUpgradeProgressCache(status=2, msg="\u6b63\u5728\u5347\u7ea7\u4eea\u8868\u76d8\u6570\u636e")
    @ImportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u5165\u4eea\u8868\u76d8\u6570\u636e")
    public void upgradeDashboardData(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        JSONArray dashEntryArray = upgradeFormMappingDto.getFormDataInit().getDashEntry();
        if (HussarUtils.isEmpty((Object)dashEntryArray)) {
            return;
        }
        dashEntryArray = FormMigrateUtil.updateObj(dashEntryArray, this.getReplaceMapAppIdAndGroupId((com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto), JSONArray.class);
        List<DashEntry> upgrades = FormMigrateUtil.parseJsonArrayToList(dashEntryArray, DashEntry.class);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(DashEntry::getParentId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        this.importDashboardImage(formUpgradeDto, upgradeFormMappingDto);
        if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.dashEntryService.removeById((Serializable)upgradeFormMappingDto.getCurrentForm().getId());
            this.dashEntryService.remove((Wrapper)new LambdaQueryWrapper().eq(DashEntry::getParentId, (Object)upgradeFormMappingDto.getCurrentForm().getId()));
            this.importDashboardData(upgrades, formUpgradeDto, upgradeFormMappingDto);
            return;
        }
        List olds = this.dashEntryService.list((Wrapper)wrapper);
        DashEntry parent = (DashEntry)this.dashEntryService.getById((Serializable)upgradeFormMappingDto.getCurrentForm().getId());
        olds.add(parent);
        Map<Long, DashEntry> oldMap = olds.stream().collect(Collectors.toMap(DashEntry::getEntryId, e -> e));
        Map<Long, DashEntry> upgradeMap = upgrades.stream().collect(Collectors.toMap(DashEntry::getEntryId, e -> e));
        Set<Long> ups = CollUtil.intersectionDistinct(oldMap.keySet(), upgradeMap.keySet());
        this.dashEntryService.removeByIds(ups);
        this.dashEntryService.remove((Wrapper)new LambdaQueryWrapper().in(DashEntry::getParentId, ups));
        this.importDashboardData(upgrades, formUpgradeDto, upgradeFormMappingDto);
    }

    @FormUpgradeProgressCache(status=3, msg="\u6b63\u5728\u5347\u7ea7\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    @ImportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u5165\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6")
    public void upgradeMidFile(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws Exception {
        FormSchema formSchemaOld = null;
        FormViewSchema oldView = null;
        if (FormUpgradeTypEnum.MERGE.getCode().equals(formUpgradeDto.getUpgradeType()) || FormUpgradeTypEnum.HALF_COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            formSchemaOld = (FormSchema)this.formOperateService.get(String.valueOf(upgradeFormMappingDto.getCurrentForm().getId())).getData();
            oldView = formSchemaOld.getView();
        }
        this.upgradeFormCanvasSchema(null, upgradeFormMappingDto, formUpgradeDto, formSchemaOld);
        if (!FormUpgradeTypEnum.MERGE.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.upgradeFormSettingSchema(null, upgradeFormMappingDto);
        }
        this.upgradeFormViewSchema(null, formUpgradeDto.getUpgradeType(), oldView, upgradeFormMappingDto);
        if (FormUpgradeTypEnum.HALF_COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.canvasService.updateTableAndSync(EngineOperationType.UPDATE.getOperationType(), (FormSchema)this.formOperateService.get(String.valueOf(upgradeFormMappingDto.getCurrentForm().getId())).getData(), formSchemaOld);
        } else if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.canvasService.updateTableAndSync(EngineOperationType.ADD.getOperationType(), (FormSchema)this.formOperateService.get(String.valueOf(upgradeFormMappingDto.getCurrentForm().getId())).getData(), null);
        }
    }

    @FormUpgradeProgressCache(status=4, msg="\u6b63\u5728\u5347\u7ea7\u9ad8\u7ea7\u529f\u80fd")
    public void upgradeExtension(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws IOException {
        this.upgradeCustomButton(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeScript(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeMsgPush(formUpgradeDto, upgradeFormMappingDto);
        this.upgradePrintTemplate(formUpgradeDto, upgradeFormMappingDto);
        if (formUpgradeDto.isUpgradeFormLink()) {
            this.upgradeFormLink(formUpgradeDto, upgradeFormMappingDto);
        }
        this.upgradeDataPull(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeDataPush(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeDataPushMap(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeDataPublicView(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeDataLeftTree(formUpgradeDto, upgradeFormMappingDto);
        this.upgradeBusinessRule(formUpgradeDto, upgradeFormMappingDto);
    }

    private void upgradeBusinessRule(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws IOException {
        List upgrades = upgradeFormMappingDto.getFormDataInit().getRules();
        this.formImportInfoService.importBusinessRule(upgrades, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeDataLeftTree(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(NavLeftTreeOrder::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        this.navLeftTreeOrderService.remove((Wrapper)wrapper);
        this.formImportInfoService.importLeftTreeData((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeDataPublicView(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomView::getAppId, (Object)upgradeFormMappingDto.getNewAppId())).eq(CustomView::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.customViewService.remove((Wrapper)wrapper);
            this.formImportInfoService.importPublicView((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        this.mergeData(this.customViewService.list((Wrapper)wrapper), upgradeFormMappingDto.getFormDataInit().getDataViews(), (Function)e -> e.getName(), (Function)e -> e.getName(), (BiFunction)(u, o) -> {
            CustomView obj = FormUpgradeTypEnum.MERGE.getCode().equals(formUpgradeDto.getUpgradeType()) && HussarUtils.isNotEmpty((Object)o) ? this.customViewService.convertToCustomView(this.mergeDataView((DataView)u, this.customViewService.convertToDataView(o))) : this.customViewService.convertToCustomView(u);
            return obj;
        }, (HussarService)this.customViewService);
    }

    private void upgradeDataPushMap(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FormMap::getAppId, (Object)upgradeFormMappingDto.getNewAppId())).eq(FormMap::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType())) {
            this.formMapService.remove((Wrapper)wrapper);
            this.formImportInfoService.importDataPushMap((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        FormMap map = upgradeFormMappingDto.getFormDataInit().getMap();
        if (HussarUtils.isEmpty((Object)map)) {
            return;
        }
        FormMap old = (FormMap)this.formMapService.getOne((Wrapper)wrapper);
        if (old != null) {
            BeanUtil.copyProperties((Object)map, (Object)old);
            this.formMapService.updateById((Object)old);
            return;
        }
        this.formMapService.save((Object)map);
    }

    private void upgradeDataPush(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getAppId, (Object)upgradeFormMappingDto.getNewAppId())).eq(SysDataPushConfig::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType())) {
            List olds = this.pushDataService.list((Wrapper)wrapper);
            olds.forEach(e -> this.pushDataService.deleteConfig(e.getId()));
            this.formImportInfoService.importDataPush((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        List upgrades = upgradeFormMappingDto.getFormDataInit().getPushConfigs();
        if (CollectionUtil.isEmpty((Collection)upgrades)) {
            return;
        }
        List olds = this.pushDataService.list((Wrapper)wrapper);
        Map<Long, SysDataPushConfig> oldMap = olds.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Map<Long, SysDataPushConfig> upgradeMap = upgrades.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Set<Long> ups = CollUtil.intersectionDistinct(oldMap.keySet(), upgradeMap.keySet());
        ups.forEach(e -> this.pushDataService.deleteConfig(e));
        List adds = CollectionUtil.newArrayList((Iterable)upgrades);
        if (CollectionUtil.isEmpty((Collection)adds)) {
            return;
        }
        this.formImportInfoService.importDataPush(adds, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeDataPull(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getAppId, (Object)upgradeFormMappingDto.getNewAppId())).eq(SysDataPullConfig::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType())) {
            List olds = this.sysDataPullService.list((Wrapper)wrapper);
            olds.forEach(e -> this.sysDataPullService.deleteConfig(e.getId()));
            this.sysDataPullService.remove((Wrapper)wrapper);
            this.formImportInfoService.importDataPull((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        List upgrades = upgradeFormMappingDto.getFormDataInit().getPullConfigs();
        if (CollectionUtil.isEmpty((Collection)upgrades)) {
            return;
        }
        this.formImportInfoService.importDataPull(upgrades, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeFormLink(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        JSONArray formLinkJsonArray;
        List<SysFormLink> formLinks;
        boolean isCover = false;
        if (ToolUtil.isNotEmpty((Object)upgradeFormMappingDto.getFormDataInit().getFormLinkObject()) && HussarUtils.isNotEmpty(formLinks = AppMigrateUtil.parseJsonArrayToList(formLinkJsonArray = (JSONArray)upgradeFormMappingDto.getFormDataInit().getFormLinkObject().getObject("formLink", JSONArray.class), SysFormLink.class))) {
            isCover = true;
        }
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType()) || isCover) {
            this.sysFormLinkService.deleteAllForm(upgradeFormMappingDto.getCurrentForm().getId());
        }
        JSONObject jsonObject = upgradeFormMappingDto.getFormDataInit().getFormLinkObject();
        this.sysFormLinkService.saveBatchImportData(jsonObject, (ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradePrintTemplate(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPrintTemplate::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType())) {
            List olds = this.sysPrintTemplateService.list((Wrapper)wrapper);
            olds.forEach(e -> {
                SysPrintTemplateDto dto = new SysPrintTemplateDto();
                dto.setId(e.getId());
                this.sysPrintTemplateService.deleteByPrintId(dto);
            });
            this.formImportInfoService.importPrintTemplate((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        List upgrades = upgradeFormMappingDto.getFormDataInit().getPrintTemplates();
        if (CollectionUtil.isEmpty((Collection)upgrades)) {
            return;
        }
        List olds = this.sysPrintTemplateService.list((Wrapper)wrapper);
        Map<Long, SysPrintTemplate> oldMap = olds.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Map<Long, SysPrintTemplate> upgradeMap = upgrades.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Set<Long> ups = CollUtil.intersectionDistinct(oldMap.keySet(), upgradeMap.keySet());
        ups.forEach(e -> {
            SysPrintTemplateDto dto = new SysPrintTemplateDto();
            dto.setId(e);
            this.sysPrintTemplateService.deleteByPrintId(dto);
        });
        List adds = CollectionUtil.newArrayList((Iterable)upgrades);
        if (CollectionUtil.isEmpty((Collection)adds)) {
            return;
        }
        String templateFilePath = upgradeFormMappingDto.getFormDataInit().getTemplateFilePath();
        this.sysPrintTemplateService.importPrintTemplate((ImportMappingDto)upgradeFormMappingDto, adds, templateFilePath);
    }

    private void upgradeMsgPush(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushConfig::getAppId, (Object)upgradeFormMappingDto.getNewAppId())).eq(SysMsgPushConfig::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.equals(formUpgradeDto.getUpgradeType())) {
            List olds = this.sysMsgPushConfigService.list((Wrapper)wrapper);
            olds.forEach(e -> this.sysMsgPushConfigService.deleteConfig(e.getId()));
            this.formImportInfoService.importMsgPush((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        List upgrades = upgradeFormMappingDto.getFormDataInit().getSysMsgPushConfigs();
        if (CollectionUtil.isEmpty((Collection)upgrades)) {
            return;
        }
        List olds = this.sysMsgPushConfigService.list((Wrapper)wrapper);
        Map<Long, SysMsgPushConfig> oldMap = olds.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Map<Long, SysMsgPushConfig> upgradeMap = upgrades.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        Set<Long> ups = CollUtil.intersectionDistinct(oldMap.keySet(), upgradeMap.keySet());
        for (Long id : ups) {
            for (SysMsgPushConfig sysMsgPushConfigNew : upgrades) {
                if (!id.equals(sysMsgPushConfigNew.getId())) continue;
                SysMsgPushConfig sysMsgPushConfigOld = (SysMsgPushConfig)this.sysMsgPushConfigService.getById((Serializable)id);
                sysMsgPushConfigNew.setReminders(sysMsgPushConfigOld.getReminders());
            }
        }
        ups.forEach(e -> this.sysMsgPushConfigService.deleteConfig(e));
        this.formImportInfoService.importMsgPush(upgrades, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto, ups);
    }

    private <T, R> void mergeData(List<T> olds, List<R> upgrades, Function<T, String> idFunc, Function<R, String> idFunc1, BiFunction<R, T, T> tranFunc, HussarService<T> service) {
        if (CollectionUtil.isEmpty(upgrades)) {
            return;
        }
        Map<String, Object> oldMap = olds.stream().collect(Collectors.toMap(e -> (String)idFunc.apply(e), e -> e));
        Map<String, Object> upgradeMap = upgrades.stream().collect(Collectors.toMap(e -> (String)idFunc1.apply(e), e -> e));
        ArrayList<T> ups = new ArrayList<T>();
        for (T t : olds) {
            T mergeU;
            if (!upgradeMap.containsKey(idFunc.apply(t)) || HussarUtils.isEmpty(mergeU = tranFunc.apply(upgradeMap.get(idFunc.apply(t)), t))) continue;
            ups.add(mergeU);
        }
        Collection<String> addIds = CollUtil.subtract(upgradeMap.keySet(), oldMap.keySet());
        ArrayList<T> adds = new ArrayList<T>();
        for (String id : addIds) {
            adds.add(tranFunc.apply(upgradeMap.get(id), null));
        }
        if (CollectionUtil.isNotEmpty(adds)) {
            service.saveBatch(adds);
        }
        if (CollectionUtil.isNotEmpty(ups)) {
            service.updateBatchById(ups);
        }
    }

    private void upgradeCheckConfig(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws IOException {
        this.sysFormCheckConfigService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFormCheckConfig::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId()));
        this.formImportInfoService.importCheckConfig((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    @FormUpgradeProgressCache(status=5, msg="\u6b63\u5728\u5347\u7ea7\u6d41\u7a0b\u914d\u7f6e\u6570\u636e")
    @ImportProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u5165\u6d41\u7a0b\u914d\u7f6e\u6570\u636e")
    public void upgradeFlowBusinessData(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        this.formImportInfoService.importFlowData((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeFormViewSchema(File file, String upgradeType, FormViewSchema oldView, UpgradeFormMappingDto upgradeFormMappingDto) throws Exception {
        String viewPath = upgradeFormMappingDto.getFormDataInit().getViewPath();
        FormViewSchema formViewSchema = FormMigrateUtil.readFileToObject(viewPath, FormViewSchema.class);
        formViewSchema = FormMigrateUtil.updateObj(formViewSchema, this.getReplaceMapAppIdAndGroupId((com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto), FormViewSchema.class);
        if (FormUpgradeTypEnum.MERGE.getCode().equals(upgradeType)) {
            formViewSchema.setViews(this.mergeView(formViewSchema.getViews(), oldView.getViews()));
            formViewSchema.setViewOrder(this.mergeViewOrder(formViewSchema.getViewOrder(), oldView.getViewOrder()));
        }
        this.viewSchemaService.saveOrUpdate(formViewSchema);
    }

    private List<DataView> mergeView(List<DataView> upgradeViews, List<DataView> oldViews) {
        List oldViewIds;
        ArrayList<DataView> result = new ArrayList<DataView>();
        Map newViewMap = CollectionUtil.isEmpty(upgradeViews) ? Collections.emptyMap() : upgradeViews.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        List list = oldViewIds = CollectionUtil.isEmpty(upgradeViews) ? Collections.emptyList() : oldViews.stream().map(DataView::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(oldViews)) {
            for (DataView oldView : oldViews) {
                String viewId = oldView.getId();
                if (newViewMap.containsKey(viewId)) {
                    result.add(this.mergeDataView((DataView)newViewMap.get(viewId), oldView));
                    continue;
                }
                result.add((DataView)JSON.parseObject((String)JSON.toJSONString((Object)oldView), DataView.class));
            }
        }
        Collection<String> addIds = CollUtil.subtract(upgradeViews.stream().map(DataView::getId).collect(Collectors.toList()), oldViewIds);
        for (String addId : addIds) {
            result.add((DataView)JSON.parseObject((String)JSON.toJSONString(newViewMap.get(addId)), DataView.class));
        }
        return result;
    }

    private DataView mergeDataView(DataView upgradeDataView, DataView oldDataView) {
        DataView dataView = (DataView)JSON.parseObject((String)JSON.toJSONString((Object)oldDataView), DataView.class);
        dataView.setFilters(this.mergeFilters(upgradeDataView.getFilters(), oldDataView.getFilters()));
        dataView.setOrderBy(this.mergeOrderBys(upgradeDataView.getOrderBy(), oldDataView.getOrderBy()));
        String scriptKey = "scriptsRefer";
        Map configs = upgradeDataView.getConfigs();
        configs = configs == null ? new HashMap() : configs;
        dataView.setConfigs(configs);
        configs.put(scriptKey, this.mergeScripts(Optional.ofNullable(configs).map(e -> e.get(scriptKey)).orElse(Collections.emptyList()), Optional.ofNullable(oldDataView.getConfigs()).map(e -> e.get(scriptKey)).orElse(Collections.emptyList())));
        return dataView;
    }

    private List<Filter> mergeFilters(List<Filter> upgradeFilters, List<Filter> oldFilters) {
        ArrayList<Filter> result = new ArrayList<Filter>();
        Map newFilterMap = CollectionUtil.isEmpty(upgradeFilters) ? Collections.emptyMap() : upgradeFilters.stream().collect(Collectors.toMap(Filter::getField, e -> e));
        List oldNames = CollectionUtil.isEmpty(oldFilters) ? Collections.emptyList() : oldFilters.stream().map(Filter::getField).collect(Collectors.toList());
        Collection<String> adds = CollUtil.subtract(newFilterMap.keySet(), oldNames);
        for (String add : adds) {
            result.add((Filter)BeanUtil.copy(newFilterMap.get(add), Filter.class));
        }
        if (CollectionUtil.isNotEmpty(oldFilters)) {
            for (Filter oldFilter : oldFilters) {
                if (!newFilterMap.containsKey(oldFilter.getField())) {
                    result.add((Filter)BeanUtil.copy((Object)oldFilter, Filter.class));
                    continue;
                }
                result.add((Filter)BeanUtil.copy(newFilterMap.get(oldFilter.getField()), Filter.class));
            }
        }
        return result;
    }

    private List<OrderItem> mergeOrderBys(List<OrderItem> upgradeOrderBys, List<OrderItem> oldOrderBys) {
        ArrayList<OrderItem> result = new ArrayList<OrderItem>();
        Map newOrderMap = CollectionUtil.isEmpty(upgradeOrderBys) ? Collections.emptyMap() : upgradeOrderBys.stream().collect(Collectors.toMap(OrderItem::getColumn, e -> e));
        List oldNames = CollectionUtil.isEmpty(upgradeOrderBys) ? Collections.emptyList() : oldOrderBys.stream().map(OrderItem::getColumn).collect(Collectors.toList());
        Collection<String> adds = CollUtil.subtract(newOrderMap.keySet(), oldNames);
        for (String add : adds) {
            result.add((OrderItem)BeanUtil.copy(newOrderMap.get(add), OrderItem.class));
        }
        if (CollectionUtil.isNotEmpty(oldOrderBys)) {
            for (OrderItem oldFilter : oldOrderBys) {
                if (!newOrderMap.containsKey(oldFilter.getColumn())) {
                    result.add((OrderItem)BeanUtil.copy((Object)oldFilter, OrderItem.class));
                    continue;
                }
                result.add((OrderItem)BeanUtil.copy(newOrderMap.get(oldFilter.getColumn()), OrderItem.class));
            }
        }
        return result;
    }

    private List<Map<String, Object>> mergeScripts(List<Map<String, Object>> newScripts, List<Map<String, Object>> oldScripts) {
        ArrayList<Map<String, Object>> scripts = new ArrayList<Map<String, Object>>();
        ArrayList ids = new ArrayList();
        if (CollectionUtil.isNotEmpty(newScripts)) {
            for (Map<String, Object> script : newScripts) {
                if (ids.contains(script.get("id"))) continue;
                scripts.add(script);
            }
        }
        if (CollectionUtil.isNotEmpty(oldScripts)) {
            for (Map<String, Object> script : oldScripts) {
                if (ids.contains(script.get("id"))) continue;
                scripts.add(script);
            }
        }
        return scripts;
    }

    private List<String> mergeViewOrder(List<String> newViews, List<String> oldViews) {
        if (HussarUtils.isEmpty(oldViews)) {
            return newViews;
        }
        if (HussarUtils.isEmpty(newViews)) {
            return oldViews;
        }
        oldViews.addAll(newViews);
        return oldViews.stream().distinct().collect(Collectors.toList());
    }

    private void upgradeFormSettingSchema(File file, UpgradeFormMappingDto upgradeFormMappingDto) throws Exception {
        String settingPath = upgradeFormMappingDto.getFormDataInit().getSettingPath();
        HashMap<Object, Object> settingReplaceMap = new HashMap<Object, Object>();
        settingReplaceMap.putAll(upgradeFormMappingDto.getFormIdMap());
        settingReplaceMap.putAll(upgradeFormMappingDto.getScriptRecordMap());
        settingReplaceMap.putAll(upgradeFormMappingDto.getScriptMethodMap());
        settingReplaceMap.putAll(upgradeFormMappingDto.getAppIdMap());
        settingReplaceMap.putAll(upgradeFormMappingDto.getFormGroupMap());
        FormSettingSchema formSettingSchema = FormMigrateUtil.readFileToObjectWithReplace(settingPath, FormSettingSchema.class, settingReplaceMap);
        if (ToolUtil.isNotEmpty((Object)formSettingSchema)) {
            SettingSchemaService bean = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
            bean.saveOrUpdate((BaseSetting)formSettingSchema, String.valueOf(upgradeFormMappingDto.getCurrentForm().getId()));
        }
    }

    private void upgradeFormCanvasSchema(File file, UpgradeFormMappingDto upgradeFormMappingDto, FormUpgradeDto formUpgradeDto, FormSchema formSchemaOld) throws Exception {
        String canvasPath = upgradeFormMappingDto.getFormDataInit().getCanvasPath();
        FormCanvasSchema formCanvasSchemaUpgrade = FormMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
        formCanvasSchemaUpgrade = FormMigrateUtil.updateObj(formCanvasSchemaUpgrade, this.getReplaceMapAppIdAndGroupId((com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto), FormCanvasSchema.class);
        if ("1".equals(upgradeFormMappingDto.getCurrentForm().getFormType())) {
            if (HussarUtils.isEmpty((Object)formSchemaOld)) {
                upgradeFormMappingDto.getProcessKeyMap().put(formCanvasSchemaUpgrade.getIdentity(), formCanvasSchemaUpgrade.getIdentity());
            } else {
                FormCanvasSchema formCanvasSchemaCurrent = formSchemaOld.getFormCanvas();
                upgradeFormMappingDto.getProcessKeyMap().put(formCanvasSchemaUpgrade.getIdentity(), formCanvasSchemaCurrent.getIdentity());
            }
        }
        String upgradeType = formUpgradeDto.getUpgradeType();
        if (FormUpgradeTypEnum.MERGE.getCode().equals(upgradeType)) {
            formCanvasSchemaUpgrade.setVersion(formSchemaOld.getFormCanvas().getVersion() + 1);
            this.canvasService.saveCanvas(this.mergeCanvas(formCanvasSchemaUpgrade, formSchemaOld.getFormCanvas()));
        } else {
            this.canvasService.saveCanvasForUpgrade(formCanvasSchemaUpgrade, (ImportMappingDto)upgradeFormMappingDto);
            this.upgradeCheckConfig(formUpgradeDto, upgradeFormMappingDto);
        }
    }

    private FormCanvasSchema mergeCanvas(FormCanvasSchema canvasSchema, FormCanvasSchema oldCanvas) {
        FormCanvasSchema canvas = (FormCanvasSchema)BeanUtil.copyProperties((Object)canvasSchema, FormCanvasSchema.class);
        List<Widget> widgets = this.mergeWidgets(canvasSchema.getWidgets(), JSON.parseArray((String)JSON.toJSONString((Object)oldCanvas.getWidgets()), Widget.class));
        canvas.setWidgets(widgets);
        return canvas;
    }

    private List<Widget> mergeWidgets(List<Widget> upgradeWidges, List<Widget> oldWidgets) {
        oldWidgets = oldWidgets == null ? Collections.emptyList() : oldWidgets;
        ArrayList<Widget> result = new ArrayList<Widget>();
        Map upgradeWidgesMap = upgradeWidges.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
        List upgradeContainerWidges = upgradeWidges.stream().filter(u -> u.getIsContainer()).collect(Collectors.toList());
        Map<Object, Object> upgradeContainerWidgesMap = Maps.newHashMapWithExpectedSize((int)5);
        if (HussarUtils.isNotEmpty(upgradeContainerWidges)) {
            upgradeContainerWidgesMap = upgradeContainerWidges.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
        }
        List newWidgets = WidgetTool.flatWidget(new ArrayList(), upgradeWidges);
        Map newWidgetMap = newWidgets.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
        for (Widget widget : oldWidgets) {
            String name;
            if (HussarUtils.isNotEmpty((Object)upgradeContainerWidgesMap) && upgradeContainerWidgesMap.containsKey(widget.getName())) {
                upgradeContainerWidgesMap.remove(widget.getName());
            }
            if (!newWidgetMap.containsKey(name = widget.getName())) {
                result.add(widget);
                continue;
            }
            if (WidgetTool.isChildTableType((Widget)widget)) {
                widget.setChildren(this.mergeWidgets(((Widget)newWidgetMap.get(name)).getChildren(), widget.getChildren()));
            }
            this.mergeWidget((Widget)newWidgetMap.get(name), widget);
            result.add(widget);
        }
        ArrayList<Object> addContainerWidges = upgradeContainerWidgesMap == null ? Lists.newArrayListWithCapacity((int)0) : new ArrayList<Object>(upgradeContainerWidgesMap.values());
        List list = WidgetTool.flatWidget(new ArrayList(), oldWidgets).stream().map(Widget::getName).collect(Collectors.toList());
        Collection<String> addNames = CollUtil.subtract(newWidgets.stream().map(Widget::getName).collect(Collectors.toList()), list);
        for (Object containerWidge : addContainerWidges) {
            if (WidgetType.JXDNTabs.getType().equals(containerWidge.getType())) {
                List childrenTabs = containerWidge.getChildren();
                for (Widget cTab : childrenTabs) {
                    List widgetListChildren = WidgetTool.flatWidget(new ArrayList(), (List)cTab.getChildren());
                    widgetListChildren = widgetListChildren.stream().filter(c -> addNames.contains(c.getName())).collect(Collectors.toList());
                    cTab.setChildren(widgetListChildren);
                }
                containerWidge.setChildren(childrenTabs);
            } else if (WidgetType.GROUP.getType().equals(containerWidge.getType())) {
                List widgetListChildren = WidgetTool.flatWidget(new ArrayList(), (List)containerWidge.getChildren());
                widgetListChildren = widgetListChildren.stream().filter(c -> addNames.contains(c.getName())).collect(Collectors.toList());
                containerWidge.setChildren(widgetListChildren);
            }
            result.add((Widget)containerWidge);
        }
        List addContainerWidgetName = WidgetTool.flatWidget(new ArrayList(), (List)addContainerWidges).stream().map(Widget::getName).collect(Collectors.toList());
        for (String childName : addContainerWidgetName) {
            addNames.remove(childName);
        }
        int maxSeq = oldWidgets.stream().reduce(0, (r, e) -> r > e.getSeq() ? r.intValue() : e.getSeq(), (a, b) -> a > b ? a : b);
        int maxRow = oldWidgets.stream().reduce(0, (r, e) -> r > e.getRow() ? r.intValue() : e.getRow(), (a, b) -> a > b ? a : b);
        for (String name : addNames) {
            Widget widget = WidgetTool.deepClone((Widget)((Widget)newWidgetMap.get(name)));
            widget.setRow(++maxRow);
            widget.setSeq(++maxSeq);
            widget.setCol(0);
            widget.setSize(12);
            result.add(widget);
        }
        return result;
    }

    private void mergeWidget(Widget upgradeWidget, Widget oldWidget) {
        BeanUtil.copyProperties((Object)upgradeWidget, (Object)oldWidget, (String[])new String[]{"col", "row", "size", "seq", "children"});
    }

    @ImportProgressCache(status=4, msg="\u6b63\u5728\u5bfc\u5165\u4e1a\u52a1\u6570\u636e")
    @FormUpgradeProgressCache(status=6, msg="\u6b63\u5728\u5347\u7ea7\u4e1a\u52a1\u6570\u636e")
    @OperateLogTypeCache(mode=8)
    public void upgradeBusinessData(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) throws Exception {
        this.formImportInfoService.saveOrUpdateBusinessData((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void upgradeScript(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        List<ScriptBase> scriptBases = upgradeFormMappingDto.getFormDataInit().getScriptBases();
        if (HussarUtils.isNotEmpty((Object)scriptBases)) {
            scriptBases = FormMigrateUtil.updateObj(scriptBases, this.getReplaceMapAppIdAndGroupId((com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto), List.class);
            scriptBases = FormMigrateUtil.parseListObjectoList(scriptBases, ScriptBase.class);
        }
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        List oldRecords = scriptRecordService.list((Wrapper)new LambdaQueryWrapper().eq(ScriptRecord::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId()));
        if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.removeScriptRecord(scriptBases, oldRecords);
        }
        if (HussarUtils.isEmpty(scriptBases)) {
            return;
        }
        this.saveOrUpdateScripts(scriptBases, oldRecords, upgradeFormMappingDto);
    }

    private void removeScriptRecord(@Nullable List<ScriptBase> scriptBases, List<ScriptRecord> oldRecords) {
        List newIds = CollectionUtil.isEmpty(scriptBases) ? Collections.emptyList() : scriptBases.stream().map(ScriptBase::getId).collect(Collectors.toList());
        List oldIds = oldRecords.stream().map(ScriptRecord::getId).collect(Collectors.toList());
        Collection removeIds = CollUtil.subtract(oldIds, newIds);
        if (CollectionUtil.isEmpty(removeIds)) {
            return;
        }
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        ScriptMethodService scriptMethodService = (ScriptMethodService)SpringContextUtil.getBean(ScriptMethodService.class);
        ScriptParamService scriptParamService = (ScriptParamService)SpringContextUtil.getBean(ScriptParamService.class);
        scriptRecordService.removeByIds(removeIds);
        List scriptMethods = scriptMethodService.listByIds(removeIds);
        if (CollectionUtil.isEmpty((Collection)scriptMethods)) {
            return;
        }
        List methodIds = scriptMethods.stream().map(ScriptMethod::getId).collect(Collectors.toList());
        scriptMethodService.removeByIds(methodIds);
        scriptParamService.remove((Wrapper)Wrappers.lambdaQuery(ScriptParam.class).in(ScriptParam::getMethodId, methodIds));
    }

    private void saveOrUpdateScripts(List<ScriptBase> scriptBases, List<ScriptRecord> oldRecords, UpgradeFormMappingDto upgradeFormMappingDto) {
        ScriptBase scriptBase;
        ScriptRecordService scriptRecordService = (ScriptRecordService)SpringContextUtil.getBean(ScriptRecordService.class);
        Map<Long, ScriptBase> newScriptMap = scriptBases.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        HashMap<String, String> scriptRecordMap = new HashMap<String, String>();
        HashMap<String, String> scriptMethodMap = new HashMap<String, String>();
        ArrayList<ScriptRecord> adds = new ArrayList<ScriptRecord>();
        ArrayList<ScriptRecord> modifys = new ArrayList<ScriptRecord>();
        for (ScriptRecord oldScript : oldRecords) {
            Long id = oldScript.getId();
            scriptRecordMap.put(String.valueOf(id), String.valueOf(id));
            scriptBase = newScriptMap.get(id);
            if (scriptBase == null) continue;
            oldScript.setName(scriptBase.getName());
            oldScript.setDescription(scriptBase.getDescription());
            oldScript.setNote(scriptBase.getNote());
            oldScript.setIcon(scriptBase.getIcon());
            oldScript.setType(scriptBase.getType());
            oldScript.setAuthor(scriptBase.getAuthor());
            oldScript.setVersion(scriptBase.getVersion());
            oldScript.setEditorNote(scriptBase.getEditorNote());
            oldScript.setFileId(scriptBase.getFileId());
            modifys.add(oldScript);
            scriptRecordMap.put(id.toString(), id.toString());
        }
        Collection<Long> addIds = CollUtil.subtract(newScriptMap.keySet(), oldRecords.stream().map(ScriptRecord::getId).collect(Collectors.toList()));
        for (Long addId : addIds) {
            scriptBase = newScriptMap.get(addId);
            ScriptRecord scriptRecord = new ScriptRecord.Builder().withId(Long.valueOf(scriptBase.getId())).withName(scriptBase.getName()).withDesc(scriptBase.getDesc()).withNote(scriptBase.getNote()).withIcon(scriptBase.getIcon()).withType(scriptBase.getType()).withAuthor(scriptBase.getAuthor()).withVersion(scriptBase.getVersion()).withEditorNote(scriptBase.getEditorNote()).withFileId(scriptBase.getFileId()).withGroupId(scriptBase.getGroupId()).withFormId(scriptBase.getFormId()).build();
            adds.add(scriptRecord);
            scriptRecordMap.put(addId.toString(), addId.toString());
        }
        if (CollectionUtil.isNotEmpty(modifys)) {
            scriptRecordService.updateBatchById(modifys);
        }
        if (CollectionUtil.isNotEmpty(adds)) {
            scriptRecordService.saveBatch(adds);
        }
        this.saveOrUpdateScriptMethods(scriptBases, scriptMethodMap);
        upgradeFormMappingDto.setScriptMethodMap(scriptMethodMap);
        upgradeFormMappingDto.setScriptRecordMap(scriptRecordMap);
    }

    private void saveOrUpdateScriptMethods(List<ScriptBase> scriptBases, Map<String, String> scriptMethodMap) {
        ScriptMethodService scriptMethodService = (ScriptMethodService)SpringContextUtil.getBean(ScriptMethodService.class);
        List oldMethods = scriptMethodService.list((Wrapper)Wrappers.lambdaQuery(ScriptMethod.class).in(ScriptMethod::getScriptId, (Collection)scriptBases.stream().map(ScriptBase::getId).collect(Collectors.toList())));
        HashMap<Long, ScriptMethodConstruct> newMethods = new HashMap<Long, ScriptMethodConstruct>();
        Map<Long, ScriptMethod> oldMethodMap = oldMethods.stream().collect(Collectors.toMap(ScriptMethod::getId, e -> e));
        ArrayList<ScriptMethod> adds = new ArrayList<ScriptMethod>();
        ArrayList<ScriptMethod> modifys = new ArrayList<ScriptMethod>();
        for (ScriptBase scriptBase : scriptBases) {
            List methods = scriptBase.getMethods();
            if (CollectionUtil.isEmpty((Collection)methods)) continue;
            newMethods.putAll(methods.stream().collect(Collectors.toMap(ScriptMethodConstruct::getId, e -> e)));
            scriptMethodMap.putAll(newMethods.keySet().stream().collect(Collectors.toMap(e -> e.toString(), e -> e.toString())));
            for (ScriptMethodConstruct method : methods) {
                if (oldMethodMap.containsKey(method.getId())) {
                    ScriptMethod om = oldMethodMap.get(method.getId());
                    BeanUtil.copyProperties((Object)method, (Object)om);
                    modifys.add(om);
                    continue;
                }
                ScriptMethod nm = (ScriptMethod)BeanUtil.copyProperties((Object)method, ScriptMethod.class);
                adds.add(nm);
            }
        }
        Collection<Long> removeIds = CollUtil.subtract(oldMethodMap.keySet(), newMethods.keySet());
        if (CollectionUtil.isNotEmpty(adds)) {
            scriptMethodService.saveBatch(adds);
        }
        if (CollectionUtil.isNotEmpty(modifys)) {
            scriptMethodService.updateBatchById(modifys);
        }
        if (CollectionUtil.isNotEmpty(removeIds)) {
            scriptMethodService.removeByIds(removeIds);
            ScriptRelatedService scriptRelatedService = (ScriptRelatedService)SpringContextUtil.getBean(ScriptRelatedService.class);
            scriptRelatedService.remove((Wrapper)Wrappers.lambdaQuery(ScriptMethodRelated.class).in(ScriptMethodRelated::getMethodId, removeIds));
        }
        this.saveOrUpdateScriptParams(newMethods.values());
    }

    private void saveOrUpdateScriptParams(Collection<ScriptMethodConstruct> methods) {
        if (CollectionUtil.isEmpty(methods)) {
            return;
        }
        ScriptParamService scriptParamService = (ScriptParamService)SpringContextUtil.getBean(ScriptParamService.class);
        List oldParams = scriptParamService.list((Wrapper)Wrappers.lambdaQuery(ScriptParam.class).in(ScriptParam::getMethodId, (Collection)methods.stream().map(ScriptMethodConstruct::getId).collect(Collectors.toList())));
        HashMap<Long, ScriptParam> newParams = new HashMap<Long, ScriptParam>();
        Map<Long, ScriptParam> oldParamMap = oldParams.stream().collect(Collectors.toMap(ScriptParam::getId, e -> e));
        ArrayList<ScriptParam> adds = new ArrayList<ScriptParam>();
        ArrayList<ScriptParam> modifys = new ArrayList<ScriptParam>();
        for (ScriptMethodConstruct method : methods) {
            List params = method.getParams();
            if (CollectionUtil.isEmpty((Collection)params)) continue;
            newParams.putAll(params.stream().collect(Collectors.toMap(ScriptParam::getId, e -> e)));
            for (ScriptParam param : params) {
                if (oldParamMap.containsKey(param.getId())) {
                    ScriptParam om = oldParamMap.get(param.getId());
                    BeanUtil.copyProperties((Object)param, (Object)om);
                    modifys.add(om);
                    continue;
                }
                ScriptParam nm = (ScriptParam)BeanUtil.copyProperties((Object)param, ScriptParam.class);
                adds.add(nm);
            }
        }
        Collection<Long> removeIds = CollUtil.subtract(oldParamMap.keySet(), newParams.keySet());
        if (CollectionUtil.isNotEmpty(adds)) {
            scriptParamService.saveBatch(adds);
        }
        if (CollectionUtil.isNotEmpty(modifys)) {
            scriptParamService.updateBatchById(modifys);
        }
        if (CollectionUtil.isNotEmpty(removeIds)) {
            scriptParamService.removeByIds(removeIds);
        }
    }

    private void upgradeCustomButton(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        this.recordReplaceMapping((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)upgradeFormMappingDto.getCurrentForm().getId());
        if (FormUpgradeTypEnum.COVER.getCode().equals(formUpgradeDto.getUpgradeType())) {
            this.sysCustomButtonService.remove((Wrapper)wrapper);
            this.formImportInfoService.importCustomButton((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
            return;
        }
        List<SysCustomButton> upgrades = upgradeFormMappingDto.getFormDataInit().getCustomButton();
        if (CollectionUtil.isEmpty((Collection)(upgrades = FormMigrateUtil.updateObj(upgrades, this.getReplaceMapAppIdAndGroupId((com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto), List.class)))) {
            return;
        }
        upgrades = FormMigrateUtil.parseListObjectoList(upgrades, SysCustomButton.class);
        List olds = this.sysCustomButtonService.list((Wrapper)wrapper);
        Map<Long, SysCustomButton> oldMap = olds.stream().collect(Collectors.toMap(SysCustomButton::getId, e -> e));
        Map<Long, SysCustomButton> upgradeMap = upgrades.stream().collect(Collectors.toMap(SysCustomButton::getId, e -> e));
        Set<Long> ups = CollUtil.intersectionDistinct(oldMap.keySet(), upgradeMap.keySet());
        ups.forEach(e -> this.sysCustomButtonService.deleteSysCustomButtonById(e));
        Integer seq = this.sysCustomButtonService.getSeqMax(formUpgradeDto.getId(), formUpgradeDto.getAppId());
        if (HussarUtils.isNotEmpty((Object)seq)) {
            for (SysCustomButton sysCustomButton : upgrades) {
                seq = seq + 1;
                sysCustomButton.setSeq(seq);
            }
        }
        if (CollectionUtil.isEmpty(upgrades)) {
            return;
        }
        this.formImportInfoService.importCustomButton(upgrades, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    private void recordReplaceMapping(FormImportDto formImportDto, com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto) {
        String canvasPath = importMappingDto.getFormDataInit().getCanvasPath();
        FormCanvasSchema formCanvasSchema = FormMigrateUtil.readFileToObject(canvasPath, FormCanvasSchema.class);
        if (ToolUtil.isNotEmpty((Object)formCanvasSchema)) {
            for (Widget widget : formCanvasSchema.childTables()) {
                String oleSubTableName = widget.getName();
                importMappingDto.getSubTableNameMap().put(oleSubTableName, oleSubTableName);
                this.storeTempGrandSonTableNameMapping(importMappingDto, widget);
            }
        }
    }

    public void storeTempGrandSonTableNameMapping(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto importMappingDto, Widget widget) {
        List grandsonChild;
        List children = widget.getChildren();
        if (CollectionUtil.isNotEmpty((Collection)children) && CollectionUtil.isNotEmpty(grandsonChild = children.stream().filter(c -> WidgetType.CHILDREN_TABLE.getType().equals(c.getType())).collect(Collectors.toList()))) {
            for (Widget grandson : grandsonChild) {
                String oldGrandsonTableName = grandson.getName();
                importMappingDto.getSubTableNameMap().put(oldGrandsonTableName, oldGrandsonTableName);
            }
        }
    }

    public void importDashboardImage(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        this.formImportInfoService.importDashboardImage((FormImportDto)formUpgradeDto, (com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto)upgradeFormMappingDto);
    }

    public void importDashboardData(FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
    }

    private void importDashboardData(List<DashEntry> dashEntryList, FormUpgradeDto formUpgradeDto, UpgradeFormMappingDto upgradeFormMappingDto) {
        Long panelId = upgradeFormMappingDto.isKeepTableName() ? dashEntryList.get(0).getEntryId() : (Long)upgradeFormMappingDto.getFormIdMap().get(dashEntryList.get(0).getEntryId());
        String newFormName = (String)upgradeFormMappingDto.getFormNameMap().get(dashEntryList.get(0).getEntryName());
        String newGroupId = formUpgradeDto.getFormGroupId() == null ? null : formUpgradeDto.getFormGroupId().toString();
        String newIcon = upgradeFormMappingDto.getUpgradeForm().getFormIcon().toString();
        this.dashEntryService.importPanelData(panelId, newIcon, newGroupId, newFormName, upgradeFormMappingDto.getCurrentForm().getAppId(), dashEntryList, upgradeFormMappingDto.getFormIdMap(), upgradeFormMappingDto.getDashboardImageIdMap(), Boolean.valueOf(upgradeFormMappingDto.isKeepTableName()));
    }

    public Map<Object, Object> getReplaceMapAppIdAndGroupId(com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto upgradeFormMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.putAll(upgradeFormMappingDto.getAppIdMap());
        replaceMap.putAll(upgradeFormMappingDto.getFormGroupMap());
        return replaceMap;
    }

    public String getUnZipPathByLocalPath(String localPath) {
        return localPath.substring(0, localPath.length() - 7);
    }
}

