/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.button.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.TableUpdateDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.push.PushDataAsync;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.button.constant.CustomButtonConstant;
import com.jxdinfo.hussar.formdesign.application.button.dao.SysCustomButtonMapper;
import com.jxdinfo.hussar.formdesign.application.button.dto.CustomButtonDataPushDto;
import com.jxdinfo.hussar.formdesign.application.button.dto.CustomButtonExecDto;
import com.jxdinfo.hussar.formdesign.application.button.dto.SysCustomButtonDto;
import com.jxdinfo.hussar.formdesign.application.button.dto.SysCustomButtonMoveDto;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.button.utils.CustomButtonUtil;
import com.jxdinfo.hussar.formdesign.application.button.vo.SysCustomButtonVo;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPullConfig;
import com.jxdinfo.hussar.formdesign.application.data.model.SysDataPushConfig;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.enums.ReferenceType;
import com.jxdinfo.hussar.formdesign.application.form.model.BriefReference;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButton;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.TableButtonProps;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysCustomButtonServiceImpl
extends HussarServiceImpl<SysCustomButtonMapper, SysCustomButton>
implements ISysCustomButtonService {
    @Resource
    private ISysAppVisitRoleButtonService sysAppVisitRoleButtonService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private SysCustomButtonMapper sysCustomButtonMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private PushDataAsync pushDataAsync;
    @Resource
    private ViewService viewService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormReferenceService formReferenceService;
    private static final int MIN_BUTTON_SEQ = 0;
    private static final int BUTTON_ACTION_LENGTH = 6;
    private static final String FLOW_FROM = "1";
    private static final Logger logger = LoggerFactory.getLogger(SysCustomButtonServiceImpl.class);

    @HussarTransactional
    public ApiResponse<Boolean> saveSysCustomButton(SysCustomButtonDto sysCustomButtonDto) {
        SysCustomButton button = (SysCustomButton)BeanUtil.copy((Object)sysCustomButtonDto, SysCustomButton.class);
        CustomButtonUtil.isEmpty(button).throwMessage("\u65b0\u589e\u6216\u4fdd\u5b58\u7684\u81ea\u5b9a\u4e49\u6309\u94ae\u4e3a\u7a7a");
        CustomButtonUtil.isEmpty(button.getFormId()).throwMessage("\u8868\u5355id\u4e3a\u7a7a");
        if (button.getAlias().length() > 20) {
            throw new BaseException("\u6309\u94ae\u522b\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        }
        if (HussarUtils.isEmpty((Object)button.getId())) {
            this.saveCustomButton(button);
            this.appSyncService.syncCustomButton("add", button);
            logger.info("\u65b0\u589e\u81ea\u5b9a\u4e49\u6309\u94ae: \u5b58\u5165\u6570\u636e\u5e93");
        } else {
            CustomButtonUtil.fail(this.updateById((BaseEntity)button)).throwMessage("\u81ea\u5b9a\u4e49\u6309\u94ae\u4fee\u6539\u5931\u8d25");
            this.appSyncService.syncCustomButton("edit", button);
        }
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeDesignTask(() -> {
            SysCustomButtonServiceImpl customButtonService = (SysCustomButtonServiceImpl)((Object)((Object)SpringContextUtil.getBean(SysCustomButtonServiceImpl.class)));
            customButtonService.syncCustomButton2FormView(button, "save", dataSourceKey);
            logger.info("\u65b0\u589e\u81ea\u5b9a\u4e49\u6309\u94ae: \u540c\u6b65\u81ea\u5b9a\u4e49\u6309\u94ae\u5230\u8868\u5355\u89c6\u56fe");
        });
        if (button.getFillAction().getInteger("type") == 2) {
            ArrayList<String> referIds = new ArrayList<String>();
            referIds.add(button.getId().toString());
            this.formReferenceService.delReferenceByReferId(referIds);
            BriefReference briefReference = new BriefReference();
            briefReference.setReferFormId(button.getFormId());
            briefReference.setReferAppId(button.getAppId());
            String sourceAppId = button.getFillAction().getJSONObject("data").getString("appId");
            String sourceFormId = button.getFillAction().getJSONObject("data").getString("formId");
            briefReference.setSourceAppId(Long.valueOf(sourceAppId));
            briefReference.setSourceFormId(Long.valueOf(sourceFormId));
            briefReference.setReferId(String.valueOf(button.getId()));
            briefReference.setType(ReferenceType.CUSTOM_BUTTON.getTypeCode());
            this.formReferenceService.save((Object)briefReference);
        }
        return ApiResponse.success((Object)true, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @HussarDs(value="#dataSourceKey")
    public void syncCustomButton2FormView(SysCustomButton button, String syncType, String dataSourceKey) {
        FormDesignResponse formDesignResponse = this.viewService.getWithPublic(String.valueOf(button.getFormId()));
        FormViewSchema formViewSchema = Optional.ofNullable(formDesignResponse).map(FormDesignResponse::getData).orElseThrow(() -> new HussarException("\u8868\u5355\u89c6\u56fe\u67e5\u8be2\u5931\u8d25"));
        List dataViews = formViewSchema.getViews();
        if ("delete".equals(syncType)) {
            for (DataView dataView : dataViews) {
                List tableButtons = dataView.getButtons();
                tableButtons.removeIf(tableButton -> tableButton.getAction().equals(button.getAction()));
            }
        } else if ("save".equals(syncType)) {
            boolean isDisplayOnListPage = Arrays.asList(button.getButtonPosition()).contains(2);
            for (DataView dataView : dataViews) {
                List tableButtons = dataView.getButtons();
                List buttonActions = tableButtons.stream().map(TableButton::getAction).collect(Collectors.toList());
                boolean isExist = buttonActions.contains(button.getAction());
                if (!isExist && isDisplayOnListPage) {
                    TableButton customTableButton = new TableButton();
                    customTableButton.setType(button.getType());
                    customTableButton.setAction(button.getAction());
                    customTableButton.setChecked(true);
                    tableButtons.add(customTableButton);
                    continue;
                }
                if (!isExist || isDisplayOnListPage) continue;
                tableButtons.removeIf(tableButton -> tableButton.getAction().equals(button.getAction()));
            }
            boolean isDisplayOnListOperate = Arrays.asList(button.getButtonPosition()).contains(3);
            for (DataView dataView : dataViews) {
                List operations = dataView.getOperations();
                List operationActions = operations.stream().map(TableButton::getAction).collect(Collectors.toList());
                boolean isExist = operationActions.contains(button.getAction());
                if (!isExist && isDisplayOnListOperate) {
                    TableButton customTableButton = new TableButton();
                    customTableButton.setType(button.getType());
                    customTableButton.setAction(button.getAction());
                    customTableButton.setChecked(true);
                    operations.add(customTableButton);
                    continue;
                }
                if (!isExist || isDisplayOnListOperate) continue;
                operations.removeIf(tableButton -> tableButton.getAction().equals(button.getAction()));
            }
        }
        try {
            this.viewService.saveWithPublic(formViewSchema);
        }
        catch (Exception e) {
            throw new BaseException("\u8868\u5355\u89c6\u56fe\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6309\u94ae\u5931\u8d25");
        }
    }

    @HussarTransactional
    public void saveCustomButton(SysCustomButton button) {
        CustomButtonUtil.isEmpty(button).throwMessage("\u65b0\u589e\u7684\u81ea\u5b9a\u4e49\u6309\u94ae\u4e3a\u7a7a");
        if (HussarUtils.isEmpty((Object)button.getAction())) {
            button.setSeq(Integer.valueOf(0));
        }
        button.setAction(this.generateButtonAction());
        List customButtons = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)button.getFormId())).ge(SysCustomButton::getSeq, (Object)button.getSeq()));
        if (HussarUtils.isNotEmpty((Object)customButtons)) {
            this.sysCustomButtonMapper.increaseSeq(customButtons);
        }
        this.save((BaseEntity)button);
        this.mountBtnAuth2DevelopRole(button.getAppId(), Collections.singletonList(button));
    }

    public void mountBtnAuth2DevelopRole(Long appId, List<SysCustomButton> buttons) {
        if (HussarUtils.isNotEmpty(buttons)) {
            SysApplication application = this.sysApplicationBoService.selectById(appId);
            CustomButtonUtil.isEmpty(application).throwMessage("\u5e94\u7528\u4e0d\u5b58\u5728");
            CustomButtonUtil.isEmpty(application.getDevelopRoleId()).throwMessage("\u5f00\u53d1\u8005\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4e3a\u5176\u5206\u914d\u6309\u94ae\u6743\u9650");
            ArrayList<SysAppVisitRoleButton> appVisitRoleButtons = new ArrayList<SysAppVisitRoleButton>();
            for (SysCustomButton button : buttons) {
                SysAppVisitRoleButton appVisitRoleButton = new SysAppVisitRoleButton();
                appVisitRoleButton.setAppId(appId);
                appVisitRoleButton.setFormId(button.getFormId());
                appVisitRoleButton.setRoleId(application.getDevelopRoleId());
                appVisitRoleButton.setButtonName(button.getAlias());
                appVisitRoleButton.setButtonCode(button.getAction());
                appVisitRoleButtons.add(appVisitRoleButton);
            }
            CustomButtonUtil.fail(this.sysAppVisitRoleButtonService.saveBatch(appVisitRoleButtons)).throwMessage("\u81ea\u52a8\u6302\u8f7d\u81ea\u5b9a\u4e49\u6309\u94ae\u6743\u9650\u5230\u5f00\u53d1\u8005\u89d2\u8272\u5931\u8d25");
        }
    }

    public Map<Long, List<SysCustomButton>> listCustomButtonByAppId(Long appId, Long formId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)appId)) {
            wrapper.eq(SysCustomButton::getAppId, (Object)appId);
        }
        if (HussarUtils.isNotEmpty((Object)formId)) {
            wrapper.eq(SysCustomButton::getFormId, (Object)formId);
        }
        List customButtons = this.list((Wrapper)wrapper);
        return customButtons.stream().filter(button -> HussarUtils.isNotEmpty((Object)button.getFormId())).sorted(Comparator.comparing(SysCustomButton::getSeq)).collect(Collectors.groupingBy(SysCustomButton::getFormId));
    }

    public ApiResponse<SysCustomButtonVo> getSysCustomButtonById(Long id) {
        SysCustomButtonVo sysCustomButtonVo = new SysCustomButtonVo();
        SysCustomButton button = (SysCustomButton)this.getById(id);
        CustomButtonUtil.isEmpty(button).throwMessage("\u81ea\u5b9a\u4e49\u6309\u94ae\u4e0d\u5b58\u5728");
        BeanUtil.copyProperties((Object)button, (Object)sysCustomButtonVo);
        return ApiResponse.success((Object)sysCustomButtonVo);
    }

    public ApiResponse<List<SysCustomButtonVo>> listSysCustomButtonByFormId(Long formId) {
        List buttonList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
        List buttonVoList = buttonList.stream().map(button -> {
            SysCustomButtonVo buttonVo = new SysCustomButtonVo();
            BeanUtil.copyProperties((Object)button, (Object)buttonVo);
            return buttonVo;
        }).sorted(Comparator.comparingInt(SysCustomButton::getSeq)).collect(Collectors.toList());
        return ApiResponse.success(buttonVoList);
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteSysCustomButtonById(Long id) {
        SysCustomButton button = (SysCustomButton)this.getById(id);
        CustomButtonUtil.isEmpty(button).throwMessage("\u81ea\u5b9a\u4e49\u6309\u94ae\u4e0d\u5b58\u5728");
        CustomButtonUtil.fail(this.removeById(id)).throwMessage("\u81ea\u5b9a\u4e49\u6309\u94ae\u5220\u9664\u5931\u8d25");
        logger.info("\u5220\u9664\u81ea\u5b9a\u4e49\u6309\u94ae: \u6570\u636e\u5e93\u5220\u9664\u6210\u529f");
        this.sysAppVisitRoleButtonService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)button.getFormId())).eq(SysAppVisitRoleButton::getButtonCode, (Object)button.getAction()));
        this.appSyncService.syncCustomButton("del", button);
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeDesignTask(() -> {
            SysCustomButtonServiceImpl customButtonService = (SysCustomButtonServiceImpl)((Object)((Object)SpringContextUtil.getBean(SysCustomButtonServiceImpl.class)));
            customButtonService.syncCustomButton2FormView(button, "delete", dataSourceKey);
            logger.info("\u5220\u9664\u81ea\u5b9a\u4e49\u6309\u94ae: \u540c\u6b65\u81ea\u5b9a\u4e49\u6309\u94ae\u5230\u8868\u5355\u89c6\u56fe");
        });
        ArrayList<String> referIds = new ArrayList<String>();
        referIds.add(id.toString());
        this.formReferenceService.delReferenceByReferId(referIds);
        return ApiResponse.success((Object)true, (String)"\u81ea\u5b9a\u4e49\u6309\u94ae\u5220\u9664\u6210\u529f");
    }

    @HussarTransactional
    public void deleteSysCustomButtonByFormId(Long formId) {
        CustomButtonUtil.isEmpty(formId).throwMessage("\u8868\u5355id\u4e3a\u7a7a");
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
    }

    @HussarTransactional
    public ApiResponse<Boolean> copySysCustomButtonById(Long id) {
        SysCustomButton button = (SysCustomButton)this.getById(id);
        CustomButtonUtil.isEmpty(button).throwMessage("\u76ee\u6807\u6309\u94ae\u4e0d\u5b58\u5728");
        SysCustomButtonDto newButton = new SysCustomButtonDto();
        BeanUtil.copyProperties((Object)button, (Object)newButton, (String[])new String[]{"id"});
        newButton.setSeq(Integer.valueOf(0));
        this.saveSysCustomButton(newButton);
        SysCustomButtonVo newButtonVo = new SysCustomButtonVo();
        BeanUtil.copyProperties((Object)newButton, (Object)newButtonVo);
        return ApiResponse.success((Object)true, (String)"\u81ea\u5b9a\u4e49\u6309\u94ae\u590d\u5236\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Boolean> moveSysCustomButton(SysCustomButtonMoveDto sysCustomButtonMoveDto) {
        Map seqMap = sysCustomButtonMoveDto.getSeqMap();
        List customButtons = this.listByIds(new ArrayList(seqMap.keySet()));
        customButtons.forEach(customButton -> customButton.setSeq((Integer)seqMap.get(customButton.getId())));
        this.updateBatchById(customButtons);
        return ApiResponse.success((Object)true, (String)"\u6392\u5e8f\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Boolean> hideNotSatisfiedSysCustomButton(SysCustomButtonDto sysCustomButtonDto) {
        CustomButtonUtil.isEmpty(sysCustomButtonDto.getFormId()).throwMessage("\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        CustomButtonUtil.isEmpty(sysCustomButtonDto.getNotSatisfiedHidden()).throwMessage("\u9690\u85cf\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysCustomButton::getNotSatisfiedHidden, (Object)sysCustomButtonDto.getNotSatisfiedHidden())).eq(SysCustomButton::getFormId, (Object)sysCustomButtonDto.getFormId()));
        return ApiResponse.success((Object)true, (String)"\u66f4\u65b0\u6210\u529f");
    }

    public List<TableButton> addCustomButtonInfo(Long formId, List<TableButton> buttons) {
        if (HussarUtils.isNotEmpty(buttons)) {
            Map<String, List<TableButton>> buttonMap = buttons.stream().collect(Collectors.groupingBy(TableButton::getType));
            List sysButtons = Optional.ofNullable(buttonMap.get("sys")).orElse(new ArrayList());
            List customButtons = Optional.ofNullable(buttonMap.get("custom")).orElse(new ArrayList());
            List storageButtons = this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getFormId, (Object)formId));
            List tableButtonActions = customButtons.stream().map(TableButton::getAction).collect(Collectors.toList());
            List storageButtonActions = storageButtons.stream().map(SysCustomButton::getAction).collect(Collectors.toList());
            HashMap<String, TableButton> tableButtonMap = new HashMap<String, TableButton>();
            HashMap<String, SysCustomButton> storageButtonMap = new HashMap<String, SysCustomButton>();
            for (TableButton tableButton2 : customButtons) {
                tableButtonMap.put(tableButton2.getAction(), tableButton2);
            }
            for (SysCustomButton customButton : storageButtons) {
                storageButtonMap.put(customButton.getAction(), customButton);
            }
            List actions = Stream.concat(tableButtonActions.stream(), storageButtonActions.stream()).distinct().collect(Collectors.toList());
            for (String action : actions) {
                SysCustomButton storageButton;
                TableButton tableButton3;
                if (tableButtonActions.contains(action) && storageButtonActions.contains(action)) {
                    tableButton3 = (TableButton)tableButtonMap.get(action);
                    storageButton = (SysCustomButton)storageButtonMap.get(action);
                    BeanUtil.copyProperties((Object)storageButton, (Object)tableButton3);
                    tableButton3.setId(String.valueOf(storageButton.getId()));
                    tableButton3.setProps((TableButtonProps)BeanUtil.copy((Object)storageButton, TableButtonProps.class));
                    continue;
                }
                if (!tableButtonActions.contains(action)) {
                    tableButton3 = new TableButton();
                    storageButton = (SysCustomButton)storageButtonMap.get(action);
                    BeanUtil.copyProperties((Object)storageButton, (Object)tableButton3);
                    tableButton3.setId(String.valueOf(storageButton.getId()));
                    tableButton3.setChecked(Boolean.TRUE.booleanValue());
                    tableButton3.setProps((TableButtonProps)BeanUtil.copy((Object)storageButton, TableButtonProps.class));
                    customButtons.add(tableButton3);
                    continue;
                }
                if (storageButtonActions.contains(action)) continue;
                customButtons.removeIf(tableButton -> tableButton.getAction().equals(action));
                buttons.removeIf(tableButton -> tableButton.getAction().equals(action));
            }
            customButtons = customButtons.stream().filter(button -> HussarUtils.isNotEmpty((Object)button.getProps())).sorted(Comparator.comparing(button -> button.getProps().getSeq())).collect(Collectors.toList());
            buttons = Stream.concat(buttons.stream(), customButtons.stream()).distinct().collect(Collectors.toList());
        }
        return buttons;
    }

    public void removeCustomButtonInfo(List<TableButton> buttons) {
        if (HussarUtils.isNotEmpty(buttons)) {
            List<TableButton> customButtons = buttons.stream().filter(button -> "custom".equals(button.getType())).collect(Collectors.toList());
            customButtons.forEach(button -> {
                button.setId(null);
                button.setAlias(null);
                button.setName(null);
                button.setIcon(null);
                button.setProps(null);
            });
        }
    }

    @OperateLogTypeCache(mode=2)
    public ResponseEntity<ApiResponse<Object>> execUpdateAction(String appId, String formId, Long buttonId, CustomButtonExecDto customButtonExecDto, Integer convertVersion) {
        SysForm targetForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
        List ids = customButtonExecDto.getIds();
        for (String id : ids) {
            Map objectMap = this.appFormService.queryAllTableInfo(formId, appId, id);
            if (!(FormCreateTypeEnum.FORM_TO_FORM.getType().equals(targetForm.getCreateSource()) ? !formId.equals(String.valueOf(objectMap.get("FORM_ID"))) : objectMap.containsKey("FORM_ID") && HussarUtils.isNotEmpty(objectMap.get("FORM_ID")) && !String.valueOf(objectMap.get("FORM_ID")).equals(formId))) continue;
            return ResponseEntity.ok((Object)ApiResponse.fail((String)"\u8be5\u6570\u636e\u65e0\u6cd5\u901a\u8fc7\u5f53\u524d\u8868\u5355\u66f4\u65b0"));
        }
        AssertUtil.isNotNull((Object)targetForm, (String)"\u76ee\u6807\u8868\u5355\u4e0d\u5b58\u5728");
        this.appFormService.convertVersionCheck(formId, convertVersion);
        TableUpdateDto tableUpdateDto = new TableUpdateDto();
        tableUpdateDto.setIds(customButtonExecDto.getIds());
        tableUpdateDto.setFields(customButtonExecDto.getFields());
        AssertUtil.isNotEmpty((Collection)tableUpdateDto.getIds(), (String)"\u8981\u66f4\u65b0\u7684\u6570\u636eid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        if (customButtonExecDto.getIds().size() == 1) {
            HashMap newParam = new HashMap();
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("rule", "_eq");
            filter.put("val", (String)customButtonExecDto.getIds().get(0));
            filter.put("field", "RECORD_ID");
            filter.put("match", "AND");
            ArrayList<HashMap<String, String>> filters = new ArrayList<HashMap<String, String>>();
            filters.add(filter);
            newParam.put("superQueryConditionDto", filters);
            ResponseEntity newResponse = this.formOperateExposedService.tableQueryByCondition(appId, formId, newParam);
            PageVo newPageData = (PageVo)((ApiResponse)Objects.requireNonNull(newResponse.getBody())).getData();
            Map entity = (Map)newPageData.getData().get(0);
            Map copyFields = (Map)JSON.parseObject((String)JSONObject.toJSONString((Object)customButtonExecDto.getFields()), Map.class);
            entity.putAll(copyFields);
            ResponseEntity formSaveResponse = FLOW_FROM.equals(targetForm.getFormType()) ? this.appFormService.processUpdateWithRule(formId, entity, appId, true, new ArrayList()) : this.appFormService.formSaveWithRule(formId, entity, appId, new ArrayList());
            if (!((ApiResponse)formSaveResponse.getBody()).isSuccess()) {
                return formSaveResponse;
            }
        } else {
            this.appFormService.tableUpdate(appId, formId, tableUpdateDto, targetForm);
        }
        return ResponseEntity.ok((Object)ApiResponse.success((Object)true, (String)"\u66f4\u65b0\u6210\u529f"));
    }

    public ResponseEntity<ApiResponse<Object>> dataPullExecute(String appId, String formId, String buttonId) {
        SysForm targetForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
        AssertUtil.isNotNull((Object)targetForm, (String)"\u76ee\u6807\u8868\u5355\u4e0d\u5b58\u5728");
        SysCustomButtonVo sysCustomButtonVo = (SysCustomButtonVo)this.sysCustomButtonService.getSysCustomButtonById(Long.valueOf(buttonId)).getData();
        AssertUtil.isNotNull((Object)targetForm, (String)"\u6309\u94ae\u4e0d\u5b58\u5728");
        Long dataPullId = sysCustomButtonVo.getDataPullId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataPullConfig::getId, (Object)dataPullId)).eq(HussarDelflagEntity::getDelFlag, (Object)0);
        SysDataPullConfig config = (SysDataPullConfig)this.sysDataPullService.getOne((Wrapper)queryWrapper);
        AssertUtil.isNotNull((Object)config, (String)"\u6309\u94ae\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u6309\u94ae\u914d\u7f6e");
        ApiResponse apiResponse = new ApiResponse();
        if ("0".equals(config.getStatus())) {
            apiResponse.setSuccess(false);
            apiResponse.setCode(10000);
            apiResponse.setMsg("\u6309\u94ae\u5bf9\u5e94\u7684\u6570\u636e\u62c9\u53d6\u89c4\u5219\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458");
            return ResponseEntity.ok((Object)apiResponse);
        }
        try {
            if (HussarUtils.isNotEmpty((Object)config)) {
                SecurityUser loginUser = BaseSecurityUtil.getUser();
                TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
                apiResponse = this.sysDataPullService.asyncPullData(Long.valueOf(formId), dataPullId, FLOW_FROM);
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u62c9\u53d6\u6267\u884c\u5931\u8d25:" + e);
            return ResponseEntity.ok((Object)ApiResponse.fail((String)"\u6570\u636e\u62c9\u53d6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458\u68c0\u67e5\u914d\u7f6e"));
        }
        return ResponseEntity.ok((Object)apiResponse);
    }

    public String generateButtonAction() {
        String action = HussarUtils.random((int)6, (RandomType)RandomType.ALL);
        if (this.count((Wrapper)new LambdaQueryWrapper().eq(SysCustomButton::getAction, (Object)action)) > 0L) {
            return this.generateButtonAction();
        }
        return action;
    }

    public ResponseEntity<ApiResponse<Object>> dataPushExecute(CustomButtonDataPushDto dto) {
        AssertUtil.isNotEmpty((String)dto.getFormId(), (String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        SysForm targetForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(dto.getFormId())).getData();
        AssertUtil.isNotNull((Object)targetForm, (String)"\u76ee\u6807\u8868\u5355\u4e0d\u5b58\u5728");
        SysCustomButtonVo sysCustomButtonVo = (SysCustomButtonVo)this.sysCustomButtonService.getSysCustomButtonById(Long.valueOf(dto.getButtonId())).getData();
        AssertUtil.isNotNull((Object)targetForm, (String)"\u6309\u94ae\u4e0d\u5b58\u5728");
        Long dataPushId = sysCustomButtonVo.getDataPushId();
        SysDataPushConfig dataPushConfig = (SysDataPushConfig)this.pushDataService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataPushConfig::getId, (Object)dataPushId));
        AssertUtil.isNotNull((Object)dataPushConfig, (String)"\u6309\u94ae\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u81ea\u5b9a\u4e49\u6309\u94ae\u914d\u7f6e");
        if ("0".equals(dataPushConfig.getStatus())) {
            ApiResponse apiResponse = new ApiResponse();
            apiResponse.setSuccess(false);
            apiResponse.setCode(10000);
            apiResponse.setMsg("\u6309\u94ae\u5bf9\u5e94\u7684\u6570\u636e\u63a8\u9001\u89c4\u5219\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458");
            return ResponseEntity.ok((Object)apiResponse);
        }
        try {
            if (HussarUtils.isNotEmpty((Object)dataPushConfig)) {
                SecurityUser loginUser = BaseSecurityUtil.getUser();
                TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
                if (HussarUtils.isEmpty((Object)dto.getViewId())) {
                    switch (targetForm.getFormType()) {
                        case "0": {
                            dto.setViewId(ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId());
                            break;
                        }
                        case "1": {
                            dto.setViewId(ViewIdEnum.SYS_FLOW_ALL_DATA.getId());
                            break;
                        }
                        default: {
                            throw new HussarException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u8868\u5355\u7684\u67e5\u8be2!");
                        }
                    }
                }
                Map<String, Integer> params = new HashMap<String, String>();
                if (ToolUtil.isNotEmpty((Object)dto.getParams())) {
                    params = dto.getParams();
                }
                params.put("BC8D215A-26F1-9B83-4DE2-7867003DA241", (Integer)((Object)"BC8D215A-26F1-9B83-4DE2-7867003DA241"));
                params.put("current", 1);
                params.put("size", 500);
                if (ToolUtil.isNotEmpty((Object)dto.getBusinessIds())) {
                    Filter idsFilter = new Filter();
                    idsFilter.setField("RECORD_ID");
                    idsFilter.setMatch("AND");
                    idsFilter.setRule("_in");
                    idsFilter.setVal(String.join((CharSequence)",", dto.getBusinessIds()));
                    ArrayList<Filter> filters = new ArrayList<Filter>();
                    filters.add(idsFilter);
                    params.put("superQueryConditionDto", (Integer)((Object)filters));
                }
                ResponseEntity apiResponseFormData = this.appFormService.tableQuery(dto.getFormId(), dto.getViewId(), params, dto.getAppId());
                PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(apiResponseFormData.getBody())).getData();
                List dataTemp = pageData.getData();
                for (Map stringObjectMap : dataTemp) {
                    HussarNoCodeThreadUtil.executeUserTask(() -> this.pushDataAsync.excPushDataAsyncByActiveTrigger(dto.getAppId(), dto.getFormId(), Collections.singletonList(dataPushId), NoCodeRuleTriggerType.TriggerTypeCustomButton.getType(), new JSONObject(stringObjectMap), loginUser, DataModelUtil.currentDsName()));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u63a8\u9001\u6267\u884c\u5931\u8d25:" + e);
            return ResponseEntity.ok((Object)ApiResponse.fail((String)"\u6570\u636e\u63a8\u9001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5e94\u7528\u7ba1\u7406\u5458\u68c0\u67e5\u914d\u7f6e"));
        }
        return ResponseEntity.ok((Object)ApiResponse.success());
    }

    public ApiResponse<List<SysCustomButtonVo>> getRelationButtonByConfigId(String configId) {
        List sysCustomButtonList = this.sysCustomButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysCustomButton::getDataPushId, (Object)configId)).eq(SysCustomButton::getEvent, (Object)CustomButtonConstant.EVENT_DATA_PUSH));
        List sysCustomButtonVos = new ArrayList();
        sysCustomButtonVos = BeanUtil.copyProperties((Collection)sysCustomButtonList, SysCustomButtonVo.class);
        return ApiResponse.success(sysCustomButtonVos);
    }

    public Integer getSeqMax(Long formId, Long appId) {
        return this.sysCustomButtonMapper.getSeqMax(formId, appId);
    }
}

