/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.HussarBaseInvokeService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.RoleTreeAuthorizedVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarBaseInvokeServiceImpl
implements HussarBaseInvokeService {
    @Resource
    private ISysRolesExternalService sysRolesExternalService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private ISysAppVisitRoleButtonService sysAppVisitRoleButtonService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService sysAppVisitRoleOrganDataAuthorityService;
    @Resource
    private ISysUpAppVisitRoleFieldService sysUpAppVisitRoleFieldService;
    @Resource
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;

    public List<RoleTreeAuthorizedVo> getRoleTree(Long appId) {
        ArrayList<RoleTreeAuthorizedVo> roleTreeAuthorizedVo = new ArrayList<RoleTreeAuthorizedVo>();
        List roleTreeVo = this.sysRolesExternalService.getRoleTree(null);
        this.copyRoleTreeVo(roleTreeVo, roleTreeAuthorizedVo);
        List groupTree = ((RoleTreeAuthorizedVo)roleTreeAuthorizedVo.get(0)).getChildren();
        ArrayList roleIds = new ArrayList();
        for (RoleTreeAuthorizedVo readOnlyRoleTreeVo : groupTree) {
            roleIds.addAll(readOnlyRoleTreeVo.getChildren().stream().map(AbstractNoIconHussarLazyTreeDefinition::getId).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty((Object)appId)) {
            List formAuthorizeRolesList = this.sysAppVisitFormAuthorizeRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId)).in(SysAppVisitFormAuthorizeRoles::getRoleId, roleIds));
            Map<Long, List<SysAppVisitFormAuthorizeRoles>> formAuthorizedRolesMap = formAuthorizeRolesList.stream().collect(Collectors.groupingBy(SysAppVisitFormAuthorizeRoles::getRoleId));
            List roleButtonList = this.sysAppVisitRoleButtonService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getAppId, (Object)appId)).in(SysAppVisitRoleButton::getRoleId, roleIds));
            Map<Long, List<SysAppVisitRoleButton>> roleButtonMap = roleButtonList.stream().collect(Collectors.groupingBy(SysAppVisitRoleButton::getRoleId));
            List organDataAuthorityList = this.sysAppVisitRoleOrganDataAuthorityService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getAppId, (Object)appId)).in(SysAppVisitRoleOrganDataAuthority::getRoleId, roleIds));
            Map<Long, List<SysAppVisitRoleOrganDataAuthority>> organDataAuthorityMap = organDataAuthorityList.stream().collect(Collectors.groupingBy(SysAppVisitRoleOrganDataAuthority::getRoleId));
            List roleFieldList = this.sysUpAppVisitRoleFieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getAppId, (Object)appId)).in(SysUpAppVisitRoleField::getRoleId, roleIds));
            Map<Long, List<SysUpAppVisitRoleField>> roleFieldMap = roleFieldList.stream().collect(Collectors.groupingBy(SysUpAppVisitRoleField::getRoleId));
            List dataLogicList = this.sysAppVisitDataLogicService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId)).in(SysAppVisitDataLogic::getRoleId, roleIds));
            Map<Long, List<SysAppVisitDataLogic>> dataLogicMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getRoleId));
            for (RoleTreeAuthorizedVo roleAuthorizedVo : groupTree) {
                List roleList = roleAuthorizedVo.getChildren();
                for (RoleTreeAuthorizedVo role : roleList) {
                    Long roleId = (Long)role.getId();
                    role.setAuthorized(Boolean.valueOf(this.checkAuthority(formAuthorizedRolesMap.get(roleId), roleButtonMap.get(roleId), organDataAuthorityMap.get(roleId), roleFieldMap.get(roleId), dataLogicMap.get(roleId))));
                }
            }
        }
        return roleTreeAuthorizedVo;
    }

    private boolean checkAuthority(List<SysAppVisitFormAuthorizeRoles> formAuthorizeRolesList, List<SysAppVisitRoleButton> roleButtonList, List<SysAppVisitRoleOrganDataAuthority> organDataAuthorityList, List<SysUpAppVisitRoleField> roleFieldList, List<SysAppVisitDataLogic> dataLogicList) {
        return HussarUtils.isNotEmpty(formAuthorizeRolesList) || HussarUtils.isNotEmpty(roleButtonList) || HussarUtils.isNotEmpty(organDataAuthorityList) || HussarUtils.isNotEmpty(roleFieldList) || HussarUtils.isNotEmpty(dataLogicList);
    }

    public void copyRoleTreeVo(List<ReadOnlyRoleTreeVo> source, List<RoleTreeAuthorizedVo> target) {
        for (ReadOnlyRoleTreeVo readOnlyRoleTreeVo : source) {
            RoleTreeAuthorizedVo roleTreeAuthorizedVo = new RoleTreeAuthorizedVo();
            BeanUtil.copyProperties((Object)readOnlyRoleTreeVo, (Object)roleTreeAuthorizedVo);
            roleTreeAuthorizedVo.setChildren(new ArrayList());
            target.add(roleTreeAuthorizedVo);
            if (!HussarUtils.isNotEmpty((Object)readOnlyRoleTreeVo.getChildren())) continue;
            this.copyRoleTreeVo(readOnlyRoleTreeVo.getChildren(), roleTreeAuthorizedVo.getChildren());
        }
    }
}

