/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.service.IPermissionService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.ButtonVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FormRoleVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityFeignVo;
import com.jxdinfo.hussar.formdesign.application.sync.union.dto.CustomDataCondition;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUnionHelper;
import com.jxdinfo.hussar.formdesign.application.sync.union.util.SyncUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@HussarTokenDs
@ConditionalOnProperty(name={"hussar.nocode.permission.controlType"}, havingValue="union")
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.permissionService")
public class UnionPermissionServiceImpl
implements IPermissionService {
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private ISysOrganService organService;
    @Resource
    private SyncUnionHelper syncUnionHelper;

    public List<Long> getAuthorityFormList(List<Long> rolesList, Long appId) {
        ArrayList<Long> authFormIds = new ArrayList<Long>();
        Map<Long, Long> menuFunFormIdMap = this.syncUnionHelper.listAllPageFunctionIdsForAppForms(appId);
        Set<Long> menuFunIds = menuFunFormIdMap.keySet();
        if (HussarUtils.isNotEmpty(rolesList) && HussarUtils.isNotEmpty(menuFunIds)) {
            ArrayList<Long> funIdsList = new ArrayList<Long>();
            for (Long funId : menuFunIds) {
                funIdsList.add(funId);
            }
            List formAuth = this.rolesExternalService.listRoleFunByRoleIdsAndFunIds(rolesList, funIdsList);
            formAuth.forEach(auth -> {
                Long formId = (Long)menuFunFormIdMap.get(auth.getFunctionId());
                if (formId != null) {
                    authFormIds.add(formId);
                }
            });
        }
        return authFormIds;
    }

    public List<ButtonVo> getButtonRoleResource(Long formId, List<Long> rolesList) {
        if (HussarUtils.isEmpty(rolesList)) {
            return Collections.emptyList();
        }
        List<SysResources> allElementRes = this.syncUnionHelper.getAllElementRes(formId);
        Map resElementIdMap = allElementRes.stream().collect(Collectors.toMap(SysResources::getId, Function.identity()));
        if (HussarUtils.isEmpty(resElementIdMap)) {
            return Collections.emptyList();
        }
        Set<Long> resElementIds = resElementIdMap.keySet();
        ArrayList<Long> resIdList = new ArrayList<Long>();
        for (Long resId : resElementIds) {
            resIdList.add(resId);
        }
        List sysRoleResources = this.rolesExternalService.listRoleResByRoleAndResIds(rolesList, resIdList);
        ArrayList<ButtonVo> result = new ArrayList<ButtonVo>(sysRoleResources.size());
        sysRoleResources.forEach(sysRoleResource -> {
            SysResources sysResources = (SysResources)resElementIdMap.get(sysRoleResource.getResourceId());
            ButtonVo buttonVo = new ButtonVo();
            buttonVo.setButtonCode(sysResources.getPermissions());
            buttonVo.setButtonName(sysResources.getResourceName());
            result.add(buttonVo);
        });
        return result;
    }

    public List<FormRoleVo> getFormAuthorizeRolesList(Long formId) {
        ArrayList<FormRoleVo> result = new ArrayList<FormRoleVo>();
        Long menuFunId = this.syncUnionHelper.getMenuFunId(formId);
        List sysRoleFunctions = this.rolesExternalService.listRoleFunByFunctionId(menuFunId);
        sysRoleFunctions.forEach(sysRoleFunctions1 -> {
            FormRoleVo formRoleVo = new FormRoleVo();
            formRoleVo.setRoleId(sysRoleFunctions1.getRoleId());
            result.add(formRoleVo);
        });
        return result;
    }

    public OrganDataAuthorityFeignVo formAuthorityOrganData(Long formId, Long roleId) {
        CustomDataCondition customDataCondition;
        CustomDataCondition.CustomOrganAndUserInfo customOrganAndUserInfo;
        String customDataConditionStr;
        if (HussarUtils.isEmpty((Object)formId)) {
            throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            user = (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser");
        }
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u5f53\u524d\u65e0\u767b\u5f55\u7528\u6237");
        }
        OrganDataAuthorityFeignVo result = new OrganDataAuthorityFeignVo();
        HashSet<Long> organIds = new HashSet<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        result.setOrganIds(organIds);
        result.setUserIds(userIds);
        SysRoleDataRight roleDataRight = this.rolesExternalService.getRoleRightByFunAndRoleId(this.syncUnionHelper.getMenuFunId(formId), roleId);
        String dataScope = String.valueOf(roleDataRight.getDataScope());
        if (HussarUtils.isEmpty((Object)roleDataRight) || HussarUtils.equals((Object)"1", (Object)dataScope)) {
            return null;
        }
        if (HussarUtils.equals((Object)"4", (Object)dataScope)) {
            userIds.add(user.getUserId());
        } else if (HussarUtils.equals((Object)"3", (Object)dataScope)) {
            Object organId = user.getExtendUserMap().get("deptId");
            if (HussarUtils.isNotEmpty(organId)) {
                organIds.add(Long.valueOf(organId.toString()));
            }
        } else if (HussarUtils.equals((Object)"2", (Object)dataScope)) {
            Object organId = user.getExtendUserMap().get("deptId");
            if (HussarUtils.isNotEmpty(organId)) {
                Long userOrganId = Long.valueOf(organId.toString());
                organIds.add(userOrganId);
                SysOrgan userOrgan = (SysOrgan)this.organService.getById((Serializable)userOrganId);
                List childOrgans = this.organService.list((Wrapper)new LambdaQueryWrapper().likeLeft(SysOrgan::getOrganFcode, (Object)userOrgan.getOrganFcode()));
                List childOrganIds = childOrgans.stream().map(SysOrgan::getId).collect(Collectors.toList());
                organIds.addAll(childOrganIds);
            }
        } else if (HussarUtils.equals((Object)"5", (Object)dataScope) && HussarUtils.isNotEmpty((Object)(customDataConditionStr = roleDataRight.getCustomDataCondition())) && HussarUtils.isNotEmpty((Object)(customOrganAndUserInfo = (customDataCondition = (CustomDataCondition)JSONObject.parseObject((String)customDataConditionStr, CustomDataCondition.class)).getCustomOrganAndUserInfo()))) {
            organIds.addAll(SyncUtil.stringToLongList(customOrganAndUserInfo.getOrganIdList()));
            userIds.addAll(SyncUtil.stringToLongList(customOrganAndUserInfo.getUserIdList()));
        }
        return result;
    }

    public DataLogicAuthorityVo dataLogicAuthorityByFormId(Long formId, Long roleId) {
        DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
        SysRoleDataRight roleDataRight = this.rolesExternalService.getRoleRightByFunAndRoleId(this.syncUnionHelper.getMenuFunId(formId), roleId);
        if (HussarUtils.isNotEmpty((Object)roleDataRight) && HussarUtils.isNotEmpty((Object)roleDataRight.getCustomDataCondition())) {
            String customDataConditionStr = roleDataRight.getCustomDataCondition();
            CustomDataCondition customDataCondition = (CustomDataCondition)JSONObject.parseObject((String)customDataConditionStr, CustomDataCondition.class);
            CustomDataCondition.DataLogic dataLogic = customDataCondition.getDataLogic();
            if (HussarUtils.isNotEmpty((Object)dataLogic)) {
                dataLogicAuthorityVo.setCombineType(dataLogic.getCombineType());
                ArrayList<DataLogicFilterVo> dataLogicFilterVoList = new ArrayList<DataLogicFilterVo>();
                List<CustomDataCondition.DataLogic.Filter> filters = dataLogic.getFilters();
                if (HussarUtils.isNotEmpty(filters)) {
                    for (CustomDataCondition.DataLogic.Filter filter : filters) {
                        DataLogicFilterVo dataLogicFilterVo = new DataLogicFilterVo();
                        dataLogicFilterVo.setFieldId(filter.getFieldId());
                        dataLogicFilterVo.setFieldName(filter.getFieldName());
                        dataLogicFilterVo.setFilterCode(filter.getFilterConditionCode());
                        dataLogicFilterVo.setFilterName(filter.getFilterConditionName());
                        dataLogicFilterVo.setFilterValue(filter.getFilterValue());
                        dataLogicFilterVoList.add(dataLogicFilterVo);
                    }
                }
                dataLogicAuthorityVo.setFilters(dataLogicFilterVoList);
            }
            return dataLogicAuthorityVo;
        }
        return null;
    }

    public List<FieldAuthorityVo> getFormFieldAuthority(Long fromId, List<Long> roleIds) {
        ArrayList<FieldAuthorityVo> result = new ArrayList<FieldAuthorityVo>();
        List roleDataRights = this.rolesExternalService.getByFunIdAndRoleIds(this.syncUnionHelper.getMenuFunId(fromId), roleIds);
        for (SysRoleDataRight roleDataRight : roleDataRights) {
            List<CustomDataCondition.FieldAuthority.Rule> rules;
            CustomDataCondition customDataCondition;
            CustomDataCondition.FieldAuthority fieldAuthority;
            String customDataConditionStr = roleDataRight.getCustomDataCondition();
            if (!HussarUtils.isNotEmpty((Object)customDataConditionStr) || !HussarUtils.isNotEmpty((Object)(fieldAuthority = (customDataCondition = (CustomDataCondition)JSONObject.parseObject((String)customDataConditionStr, CustomDataCondition.class)).getFieldAuthority())) || !HussarUtils.isNotEmpty(rules = fieldAuthority.getRules())) continue;
            for (CustomDataCondition.FieldAuthority.Rule rule : rules) {
                FieldAuthorityVo fieldAuthorityVo = new FieldAuthorityVo();
                fieldAuthorityVo.setFieldId(rule.getFieldId());
                fieldAuthorityVo.setFieldName(rule.getFieldName());
                fieldAuthorityVo.setCanRead(rule.getCanRead());
                fieldAuthorityVo.setCanWrite(rule.getCanWrite());
                fieldAuthorityVo.setParentId(rule.getParentId());
                result.add(fieldAuthorityVo);
            }
        }
        return result;
    }
}

