/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.rule.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.form.enums.ReferenceType;
import com.jxdinfo.hussar.formdesign.application.form.model.BriefReference;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.rule.dao.SysRuleInfoMapper;
import com.jxdinfo.hussar.formdesign.application.rule.dto.ShortAction;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoDto;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import com.jxdinfo.hussar.formdesign.application.rule.middle.FirstTriggerTime;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleExecAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysTimingTriggerConfig;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleExcActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerConfigService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysTimingTriggerTaskService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleCardVo;
import com.jxdinfo.hussar.formdesign.application.rule.vo.RuleFullVo;
import com.jxdinfo.hussar.formdesign.application.rule.vo.SysRuleInfoVo;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.rule.service.impl.SysRuleInfoServiceImpl")
public class SysRuleInfoServiceImpl
extends HussarServiceImpl<SysRuleInfoMapper, SysRuleInfo>
implements ISysRuleInfoService {
    private static Logger logger = LoggerFactory.getLogger(SysRuleInfoServiceImpl.class);
    @Resource
    private SysRuleInfoMapper sysRuleInfoMapper;
    @Resource
    private ISysRuleExcActionService sysRuleExcActionService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private IFormReferenceService formReferenceService;
    @Resource
    private ISysTimingTriggerConfigService sysTimingTriggerConfigService;
    @Resource
    private ISysTimingTriggerTaskService sysTimingTriggerTaskService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final String CONFIG_STATUS_UNABLE = "0";
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImportInfoServiceImpl.class);

    public ApiResponse<String> saveRule(RuleFullVo ruleFullVo) {
        boolean result;
        boolean infoFlag;
        boolean flag;
        SysRuleInfoDto sysRuleInfoDto = new SysRuleInfoDto();
        sysRuleInfoDto.setRuleId(ruleFullVo.getRuleId());
        sysRuleInfoDto.setAppId(ruleFullVo.getAppId());
        sysRuleInfoDto.setRuleName(ruleFullVo.getRuleName());
        sysRuleInfoDto.setEnable(ruleFullVo.getEnable());
        List<SysRuleExecAction> sysRuleExecActionList = this.ruleExcActionsConvert(ruleFullVo, sysRuleInfoDto);
        SysRuleTriggerAction sysRuleTriggerAction = this.ruleTriggerActionConvert(ruleFullVo, sysRuleInfoDto);
        if (ruleFullVo.getEnable().booleanValue() && !(flag = this.circleAction(sysRuleExecActionList, sysRuleTriggerAction))) {
            throw new BaseException("\u4e0e\u5df2\u6709\u52a8\u4f5c\u5f62\u6210\u5faa\u73af\uff0c\u4e0d\u4e88\u521b\u5efa");
        }
        sysRuleInfoDto.setFormId(sysRuleTriggerAction.getFormId());
        if (HussarUtils.isNotEmpty((Object)ruleFullVo.getCreateTime())) {
            sysRuleInfoDto.setCreateTime(ruleFullVo.getCreateTime());
        }
        if (!(infoFlag = this.saveOrUpdate((BaseEntity)sysRuleInfoDto))) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        ArrayList<String> referIds = new ArrayList<String>();
        referIds.add(sysRuleInfoDto.getRuleId());
        this.formReferenceService.delReferenceByReferId(referIds);
        for (SysRuleExecAction execAction : sysRuleExecActionList) {
            execAction.setRuleId(sysRuleInfoDto.getRuleId());
            execAction.setActionId(null);
            if (sysRuleTriggerAction.getFormId().equals(execAction.getFormId())) continue;
            BriefReference briefReference = new BriefReference();
            briefReference.setReferAppId(Long.valueOf(ruleFullVo.getAppId()));
            briefReference.setReferFormId(Long.valueOf(sysRuleTriggerAction.getFormId()));
            SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)((Object)execAction.getFormId()));
            if (HussarUtils.isEmpty((Object)sysForm)) continue;
            Long appId = sysForm.getAppId();
            briefReference.setSourceAppId(appId);
            briefReference.setSourceFormId(Long.valueOf(execAction.getFormId()));
            briefReference.setReferId(sysRuleInfoDto.getRuleId());
            briefReference.setType(ReferenceType.RULE.getTypeCode());
            this.formReferenceService.saveBriefReference(briefReference);
        }
        boolean execFlag = this.sysRuleExcActionService.saveOrUpdateBatch(sysRuleExecActionList);
        if (!execFlag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        sysRuleTriggerAction.setRuleId(sysRuleInfoDto.getRuleId());
        sysRuleTriggerAction.setTriggerId(sysRuleInfoDto.getRuleId());
        boolean triggerFlag = this.sysRuleTriggerActionService.saveOrUpdate((Object)sysRuleTriggerAction);
        if (!triggerFlag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        String ruleId = ruleFullVo.getRuleId();
        SysRuleTriggerAction actionByRuleId = this.sysRuleTriggerActionService.getActionByRuleId(ruleId);
        if (HussarUtils.isNotEmpty((Object)actionByRuleId)) {
            String triggerAction = actionByRuleId.getTriggerAction();
            if (NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerAction) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerAction) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerAction)) {
                this.sysTimingTriggerTaskService.removeByConfigId(Long.valueOf(ruleId));
                SysTimingTriggerConfig sysTimingTriggerConfig = new SysTimingTriggerConfig();
                sysTimingTriggerConfig.setId(Long.valueOf(actionByRuleId.getTriggerId()));
                sysTimingTriggerConfig.setConfigStatus(CONFIG_STATUS_UNABLE);
                this.sysTimingTriggerConfigService.saveOrUpdate((Object)sysTimingTriggerConfig);
            }
        }
        String trigger = ruleFullVo.getTrigger();
        if ((NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(trigger) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(trigger) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(trigger)) && !(result = this.sysTimingTriggerConfigService.saveTimingTriggerConfig(ruleFullVo, sysRuleInfoDto.getRuleId()))) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((Object)sysRuleInfoDto.getRuleId(), (String)"\u4fdd\u5b58\u8868\u5355\u6210\u529f");
    }

    private List<SysRuleExecAction> ruleExcActionsConvert(RuleFullVo ruleFullVo, SysRuleInfoDto sysRuleInfoDto) {
        boolean delFlag;
        List actions = ruleFullVo.getActions();
        if (actions.isEmpty()) {
            throw new BaseException("\u4f20\u53c2\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        ArrayList<SysRuleExecAction> sysRuleExecActionList = new ArrayList<SysRuleExecAction>();
        if (HussarUtils.isNotEmpty((Object)sysRuleInfoDto.getRuleId()) && !(delFlag = this.sysRuleExcActionService.deleteByRuleId(sysRuleInfoDto.getRuleId()).booleanValue())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        for (JSONObject action : actions) {
            SysRuleExecAction sysRuleExecAction = new SysRuleExecAction();
            String type = action.getString("type");
            JSONObject filter = action.getJSONObject("filter");
            JSONObject target = action.getJSONObject("target");
            JSONArray upsert = action.getJSONArray("upsert");
            String formId = target.getString("formId");
            JSONArray actionValue = action.getJSONArray("values");
            String id = action.getString("id");
            if (!id.contains("-")) {
                sysRuleExecAction.setActionId(id);
            }
            sysRuleExecAction.setExecAction(type);
            sysRuleExecAction.setActionFilter(JSONObject.toJSONString((Object)filter));
            sysRuleExecAction.setFormId(formId);
            sysRuleExecAction.setExecContent(JSONArray.toJSONString((Object)actionValue));
            sysRuleExecAction.setRuleId(sysRuleInfoDto.getRuleId());
            sysRuleExecAction.setTarget(JSONObject.toJSONString((Object)target));
            sysRuleExecAction.setUpsert(JSONArray.toJSONString((Object)upsert));
            sysRuleExecActionList.add(sysRuleExecAction);
        }
        return sysRuleExecActionList;
    }

    private SysRuleTriggerAction ruleTriggerActionConvert(RuleFullVo ruleFullVo, SysRuleInfoDto sysRuleInfoDto) {
        SysRuleTriggerAction sysRuleTriggerAction = new SysRuleTriggerAction();
        sysRuleTriggerAction.setTriggerId(sysRuleInfoDto.getRuleId());
        sysRuleTriggerAction.setRuleId(sysRuleInfoDto.getRuleId());
        sysRuleTriggerAction.setFormId(ruleFullVo.getSourceForm());
        sysRuleTriggerAction.setTriggerConditions(JSONObject.toJSONString((Object)ruleFullVo.getCondition()));
        sysRuleTriggerAction.setTriggerAction(ruleFullVo.getTrigger());
        return sysRuleTriggerAction;
    }

    private boolean circleAction(List<SysRuleExecAction> excActions, SysRuleTriggerAction triggerAction) {
        ShortAction trigger = new ShortAction();
        trigger.setFormId(triggerAction.getFormId());
        trigger.setActionType(this.actionTypeConvert(triggerAction.getTriggerAction()));
        List triggerExcActions = this.sysRuleExcActionService.getActionByShortAction(trigger);
        triggerExcActions = triggerExcActions.stream().filter(ruleExecAction -> {
            SysRuleInfo ruleInfo = (SysRuleInfo)this.getById((Serializable)((Object)ruleExecAction.getRuleId()));
            return !HussarUtils.isEmpty((Object)ruleInfo) && ruleInfo.getEnable() != false && !"1".equals(ruleInfo.getDelFlag());
        }).collect(Collectors.toList());
        if (HussarUtils.isEmpty(triggerExcActions)) {
            return true;
        }
        ArrayList<ShortAction> allExcActions = new ArrayList<ShortAction>();
        for (SysRuleExecAction excAction : excActions) {
            ShortAction execute = new ShortAction();
            execute.setFormId(excAction.getFormId());
            execute.setActionType(excAction.getExecAction());
            if (execute.getActionType().equals(this.actionTypeConvert(trigger.getActionType())) && execute.getFormId().equals(trigger.getFormId())) {
                return false;
            }
            List<ShortAction> allExcAction = this.getAllExcAction(execute);
            if (!HussarUtils.isNotEmpty(allExcAction)) continue;
            allExcActions.addAll(allExcAction);
        }
        HashSet uniqueActions = new HashSet(allExcActions);
        ArrayList deduplicatedList = new ArrayList(uniqueActions);
        trigger.setActionType(this.actionTypeConvert(trigger.getActionType()));
        return !deduplicatedList.contains(trigger);
    }

    private String actionTypeConvert(String triggerAction) {
        String[] types = triggerAction.split("_");
        return types[1] + "_" + types[0];
    }

    private List<ShortAction> getAllExcAction(ShortAction rootAction) {
        ArrayList<ShortAction> allActions = new ArrayList<ShortAction>();
        rootAction.setActionType(this.actionTypeConvert(rootAction.getActionType()));
        List allTriggers = this.sysRuleTriggerActionService.getActionByShortAction(rootAction);
        ArrayList<SysRuleTriggerAction> triggerActions = new ArrayList<SysRuleTriggerAction>();
        for (SysRuleTriggerAction trigger : allTriggers) {
            SysRuleInfo ruleInfo = (SysRuleInfo)this.getById((Serializable)((Object)trigger.getRuleId()));
            boolean enable = ruleInfo.getEnable();
            String delFlag = ruleInfo.getDelFlag();
            if (!enable || !CONFIG_STATUS_UNABLE.equals(delFlag)) continue;
            triggerActions.add(trigger);
        }
        if (HussarUtils.isNotEmpty(triggerActions)) {
            for (SysRuleTriggerAction sysRuleTriggerAction : triggerActions) {
                String ruleId = sysRuleTriggerAction.getRuleId();
                List excActions = this.sysRuleExcActionService.getActionsByRuleId(ruleId);
                if (!HussarUtils.isNotEmpty((Object)excActions)) continue;
                for (SysRuleExecAction sysRuleExecAction : excActions) {
                    ShortAction shortAction = new ShortAction();
                    shortAction.setActionType(sysRuleExecAction.getExecAction());
                    shortAction.setFormId(sysRuleExecAction.getFormId());
                    allActions.add(shortAction);
                    if (rootAction.getFormId().equals(shortAction.getFormId())) continue;
                    List<ShortAction> a = this.getAllExcAction(shortAction);
                    allActions.addAll(a);
                }
            }
        } else {
            return allActions;
        }
        return allActions;
    }

    public ApiResponse<Boolean> editRuleInfo(SysRuleInfoDto sysRuleInfoDto) {
        boolean flag = this.updateById((BaseEntity)sysRuleInfoDto);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<Boolean> deleteRule(String ruleId) {
        boolean delRuleInfo;
        SysRuleInfo sysRuleInfo = (SysRuleInfo)this.getById((Serializable)((Object)ruleId));
        sysRuleInfo.setDelFlag("1");
        sysRuleInfo.setEnable(Boolean.valueOf(false));
        SysRuleTriggerAction triggerAction = this.sysRuleTriggerActionService.getActionByRuleId(ruleId);
        String triggerActionType = triggerAction.getTriggerAction();
        if (NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerActionType) || NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerActionType) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerActionType)) {
            Wrapper queryWrapper = (Wrapper)new LambdaQueryWrapper().eq(SysTimingTriggerConfig::getTriggerId, (Object)triggerAction.getTriggerId());
            SysTimingTriggerConfig config = (SysTimingTriggerConfig)this.sysTimingTriggerConfigService.getOne(queryWrapper);
            this.sysTimingTriggerConfigService.removeById((Serializable)config.getId());
            this.sysTimingTriggerTaskService.removeByConfigId(config.getId());
        }
        if (!(delRuleInfo = this.saveOrUpdate((BaseEntity)sysRuleInfo))) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        ArrayList<String> referIds = new ArrayList<String>();
        referIds.add(ruleId);
        this.formReferenceService.delReferenceByReferId(referIds);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<Page<RuleCardVo>> getRuleInfoList(PageInfo pageInfo, String formId) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        ArrayList<RuleCardVo> ruleCardVos = new ArrayList<RuleCardVo>();
        List triggerActions = this.sysRuleTriggerActionService.getActionsByFormId(page, formId);
        for (SysRuleTriggerAction triggerAction : triggerActions) {
            String ruleId = triggerAction.getRuleId();
            RuleCardVo cardVo = this.getRuleCardById(ruleId);
            if (!HussarUtils.isNotEmpty((Object)cardVo)) continue;
            ruleCardVos.add(cardVo);
        }
        Page ruleCardVoPage = HussarPageUtils.convert((PageInfo)pageInfo);
        ruleCardVoPage.setTotal(page.getTotal());
        ruleCardVoPage.setRecords(ruleCardVos);
        return ApiResponse.success((Object)ruleCardVoPage);
    }

    private RuleCardVo getRuleCardById(String ruleId) {
        RuleCardVo ruleCardVo = new RuleCardVo();
        SysRuleTriggerAction triggerAction = this.sysRuleTriggerActionService.getActionByRuleId(ruleId);
        SysRuleInfo sysRuleInfo = (SysRuleInfo)this.getById((Serializable)((Object)ruleId));
        if ("1".equals(sysRuleInfo.getDelFlag())) {
            return null;
        }
        List execActions = this.sysRuleExcActionService.getActionsByRuleId(ruleId);
        ruleCardVo.setRuleId(ruleId);
        ruleCardVo.setRuleName(sysRuleInfo.getRuleName());
        ruleCardVo.setFormId(triggerAction.getFormId());
        ruleCardVo.setFormName(((SysForm)this.sysFormService.getDetailById(Long.valueOf(triggerAction.getFormId())).getData()).getFormName());
        ruleCardVo.setEnable(sysRuleInfo.getEnable());
        ruleCardVo.setTriggerAction(triggerAction.getTriggerAction());
        ruleCardVo.setTriggerCondition(JSON.parseObject((String)triggerAction.getTriggerConditions()));
        ArrayList<ShortAction> shortActions = new ArrayList<ShortAction>();
        for (SysRuleExecAction execAction : execActions) {
            ShortAction shortAction = new ShortAction();
            shortAction.setActionType(execAction.getExecAction());
            shortAction.setFormId(execAction.getFormId());
            LOGGER.info("formId:{}", (Object)execAction.getFormId());
            SysForm execForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(execAction.getFormId())).getData();
            if (HussarUtils.isNotEmpty((Object)execForm)) {
                shortAction.setFormName(execForm.getFormName());
            }
            shortActions.add(shortAction);
        }
        ruleCardVo.setExecActions(shortActions);
        String triggerType = triggerAction.getTriggerAction();
        if (NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerType)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTimingTriggerConfig::getTriggerId, (Object)triggerAction.getTriggerId());
            SysTimingTriggerConfig sysTimingTriggerConfig = (SysTimingTriggerConfig)this.sysTimingTriggerConfigService.getOne((Wrapper)queryWrapper);
            JSONObject timedRule = new JSONObject();
            if (HussarUtils.isNotEmpty((Object)sysTimingTriggerConfig)) {
                if (NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerType)) {
                    LocalDateTime localDateTime;
                    FirstTriggerTime firstTriggerTime = new FirstTriggerTime();
                    LocalDateTime localDateTime2 = localDateTime = sysTimingTriggerConfig.getFirstTriggerTime() != null ? sysTimingTriggerConfig.getFirstTriggerTime() : null;
                    if (HussarUtils.isNotEmpty((Object)localDateTime)) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        String firstTriggerTimeStr = localDateTime.format(formatter);
                        firstTriggerTime.setDateTime(firstTriggerTimeStr);
                        timedRule.put("firstTriggerTime", (Object)firstTriggerTime);
                    }
                    ruleCardVo.setTriggerAction(NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType());
                } else {
                    String firstTriggerTimeConfigStr = sysTimingTriggerConfig.getFirstTriggerTimeConfig();
                    JSONObject firstTriggerTimeConfig = JSONObject.parseObject((String)firstTriggerTimeConfigStr);
                    timedRule.put("firstTriggerTime", (Object)firstTriggerTimeConfig);
                }
                String repeatRuleStr = sysTimingTriggerConfig.getRepeatRule();
                Object repeatRule = JSONObject.parse((String)repeatRuleStr);
                timedRule.put("repeatRule", repeatRule);
                timedRule.put("endTriggerTime", (Object)sysTimingTriggerConfig.getEndTriggerTime());
            }
            ruleCardVo.setTimedRule(timedRule);
        }
        return ruleCardVo;
    }

    public RuleFullVo getRuleInfoDetail(String ruleId) {
        LambdaQueryWrapper queryWrapper;
        SysTimingTriggerConfig sysTimingTriggerConfig;
        SysRuleInfo sysRuleInfo = (SysRuleInfo)this.getById((Serializable)((Object)ruleId));
        if (HussarUtils.isEmpty((Object)sysRuleInfo)) {
            logger.info("getRuleInfoDetail\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u4fe1\u606f\uff1a{}", (Object)ruleId);
            throw new BaseException("\u5931\u8d25\uff01");
        }
        SysRuleTriggerAction triggerAction = this.sysRuleTriggerActionService.getActionByRuleId(ruleId);
        if (HussarUtils.isEmpty((Object)triggerAction)) {
            logger.info("getRuleInfoDetail\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u4fe1\u606f\uff1a{}", (Object)ruleId);
            throw new BaseException("\u5931\u8d25\uff01");
        }
        List execActions = this.sysRuleExcActionService.getActionsByRuleId(ruleId);
        if (HussarUtils.isEmpty((Object)execActions)) {
            logger.info("getRuleInfoDetail\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u4fe1\u606f\uff1a{}", (Object)ruleId);
            throw new BaseException("\u5931\u8d25\uff01");
        }
        RuleFullVo ruleFullVo = new RuleFullVo();
        ruleFullVo.setRuleId(sysRuleInfo.getRuleId());
        ruleFullVo.setRuleName(sysRuleInfo.getRuleName());
        ruleFullVo.setAppId(sysRuleInfo.getAppId());
        ruleFullVo.setSourceForm(triggerAction.getFormId());
        ruleFullVo.setCondition(JSON.parseObject((String)triggerAction.getTriggerConditions()));
        ruleFullVo.setTrigger(triggerAction.getTriggerAction());
        ArrayList<JSONObject> execAction = new ArrayList<JSONObject>();
        for (SysRuleExecAction sysRuleExecAction : execActions) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)sysRuleExecAction.getExecAction());
            jsonObject.put("filter", (Object)JSON.parseObject((String)sysRuleExecAction.getActionFilter()));
            JSONObject target = JSON.parseObject((String)sysRuleExecAction.getTarget());
            String formId = target.getString("formId");
            SysForm execForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
            String formTitle = "";
            if (HussarUtils.isNotEmpty((Object)execForm)) {
                formTitle = execForm.getFormName();
            }
            target.put("formTitle", (Object)formTitle);
            jsonObject.put("target", (Object)target);
            jsonObject.put("upsert", (Object)JSONArray.parseArray((String)sysRuleExecAction.getUpsert()));
            jsonObject.put("values", (Object)JSONArray.parseArray((String)sysRuleExecAction.getExecContent()));
            jsonObject.put("id", (Object)sysRuleExecAction.getActionId());
            execAction.add(jsonObject);
        }
        ruleFullVo.setActions(execAction);
        ruleFullVo.setEnable(sysRuleInfo.getEnable());
        ruleFullVo.setRulePriority(sysRuleInfo.getRulePriority());
        ruleFullVo.setCreateTime(sysRuleInfo.getCreateTime());
        ruleFullVo.setLastTime(sysRuleInfo.getLastTime());
        String triggerType = triggerAction.getTriggerAction();
        if ((NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerType)) && HussarUtils.isNotEmpty((Object)(sysTimingTriggerConfig = (SysTimingTriggerConfig)this.sysTimingTriggerConfigService.getOne((Wrapper)(queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTimingTriggerConfig::getTriggerId, (Object)triggerAction.getTriggerId())))))) {
            JSONObject timedRule = new JSONObject();
            if (NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerType)) {
                LocalDateTime localDateTime;
                FirstTriggerTime firstTriggerTime = new FirstTriggerTime();
                LocalDateTime localDateTime2 = localDateTime = sysTimingTriggerConfig.getFirstTriggerTime() != null ? sysTimingTriggerConfig.getFirstTriggerTime() : null;
                if (HussarUtils.isNotEmpty((Object)localDateTime)) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    String firstTriggerTimeStr = localDateTime.format(formatter);
                    firstTriggerTime.setDateTime(firstTriggerTimeStr);
                    timedRule.put("firstTriggerTime", (Object)firstTriggerTime);
                }
                ruleFullVo.setTrigger(NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType());
            } else {
                String firstTriggerTimeConfig = sysTimingTriggerConfig.getFirstTriggerTimeConfig();
                JSONObject jsonObject = JSONObject.parseObject((String)firstTriggerTimeConfig);
                timedRule.put("firstTriggerTime", (Object)jsonObject);
            }
            String repeatRuleStr = sysTimingTriggerConfig.getRepeatRule();
            Object repeatRule = JSONObject.parse((String)repeatRuleStr);
            timedRule.put("repeatRule", repeatRule);
            timedRule.put("endTriggerTime", (Object)sysTimingTriggerConfig.getEndTriggerTime());
            ruleFullVo.setTimedRule(timedRule);
        }
        return ruleFullVo;
    }

    public ApiResponse<Boolean> editRuleName(SysRuleInfoVo sysRuleInfoVo) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"RULE_NAME", (Object)sysRuleInfoVo.getRuleName())).eq((Object)"RULE_ID", (Object)sysRuleInfoVo.getRuleId());
        boolean flag = this.update(null, (Wrapper)updateWrapper);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<Boolean> ruleSwitch(SysRuleInfoVo sysRuleInfoVo) {
        boolean flag;
        SysRuleTriggerAction triggerAction = this.sysRuleTriggerActionService.getActionByRuleId(sysRuleInfoVo.getRuleId());
        if (sysRuleInfoVo.getEnable().booleanValue()) {
            List sysRuleExecActions = this.sysRuleExcActionService.getActionsByRuleId(sysRuleInfoVo.getRuleId());
            Boolean legalRule = this.checkRuleLegal(triggerAction, sysRuleExecActions);
            if (!legalRule.booleanValue()) {
                throw new BaseException("\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u5728\u7f16\u8f91\u5e76\u4fdd\u5b58\u540e\u5f00\u542f");
            }
            List triggerExcActions = this.sysRuleExcActionService.getActionsByRuleId(sysRuleInfoVo.getRuleId());
            boolean circleFlag = this.circleAction(triggerExcActions, triggerAction);
            if (!circleFlag) {
                throw new BaseException("\u4e0e\u5df2\u6fc0\u6d3b\u52a8\u4f5c\u5f62\u6210\u5faa\u73af\uff0c\u4e0d\u4e88\u6fc0\u6d3b");
            }
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"ENABLE", (Object)sysRuleInfoVo.getEnable())).eq((Object)"RULE_ID", (Object)sysRuleInfoVo.getRuleId());
        String triggerActionType = triggerAction.getTriggerAction();
        if (NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerActionType) || NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerActionType) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerActionType)) {
            RuleFullVo ruleInfoDetail = this.getRuleInfoDetail(sysRuleInfoVo.getRuleId());
            ruleInfoDetail.setEnable(sysRuleInfoVo.getEnable());
            this.sysTimingTriggerConfigService.saveTimingTriggerConfig(ruleInfoDetail, ruleInfoDetail.getRuleId());
        }
        if (!(flag = this.update(null, (Wrapper)updateWrapper))) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    private Boolean checkRuleLegal(SysRuleTriggerAction ruleTriggerAction, List<SysRuleExecAction> ruleExecActions) {
        List<Object> triggerFields = new ArrayList<String>();
        String triggerConditions = ruleTriggerAction.getTriggerConditions();
        String triggerFormId = ruleTriggerAction.getFormId();
        List triggerActions = JSONArray.parseArray((String)JSONObject.parseObject((String)triggerConditions).getString("cond"), JSONObject.class);
        if (HussarUtils.isNotEmpty((Object)triggerActions)) {
            for (JSONObject triggerAction : triggerActions) {
                String field2 = triggerAction.getString("field");
                triggerFields.add(field2);
            }
        }
        for (SysRuleExecAction ruleExecAction : ruleExecActions) {
            List canvasWidgets;
            boolean flag;
            String execContent;
            List execActions;
            List<Object> execFields = new ArrayList<Object>();
            String actionFilter = ruleExecAction.getActionFilter();
            String execFormId = ruleExecAction.getFormId();
            List execFilters = JSONArray.parseArray((String)JSONObject.parseObject((String)actionFilter).getString("cond"), JSONObject.class);
            if (HussarUtils.isNotEmpty((Object)execFilters)) {
                for (JSONObject filter : execFilters) {
                    String field3 = filter.getString("field");
                    JSONObject depend = filter.getJSONObject("depend");
                    if (HussarUtils.isNotEmpty((Object)depend)) {
                        String dependField = depend.getString("field");
                        triggerFields.add(dependField);
                    }
                    execFields.add(field3);
                }
            }
            if (("create_data_subtable".equals(ruleExecAction.getExecAction()) || "remove_data_subtable".equals(ruleExecAction.getExecAction())) && HussarUtils.isNotEmpty((Object)(execActions = JSONArray.parseArray((String)(execContent = ruleExecAction.getExecContent()), JSONObject.class)))) {
                for (JSONObject execAction : execActions) {
                    String subTableName = execAction.getString("parent");
                    if (HussarUtils.isEmpty((Object)subTableName)) continue;
                    execFields.add(subTableName);
                }
            }
            execFields = execFields.stream().distinct().filter(Objects::nonNull).filter(field -> !"RECORD_ID".equals(field)).filter(field -> !field.endsWith("ref_id") && !field.endsWith("ref_child_id")).collect(Collectors.toList());
            FormCanvasSchema execFormCanvas = (FormCanvasSchema)this.canvasSchemaService.get(execFormId).getData();
            if (HussarUtils.isEmpty((Object)execFormCanvas)) {
                return false;
            }
            ArrayList execWidgets = new ArrayList();
            List widgetListE = execFormCanvas.widgetsWithSys();
            if (HussarUtils.equals((Object)execFormCanvas.getFormType(), (Object)"1")) {
                List processState = PageBuilderFactory.getProcessInfoWidgets();
                widgetListE.addAll(processState);
            }
            execWidgets.addAll(widgetListE);
            if (HussarUtils.isNotEmpty((Object)execFormCanvas.childTables())) {
                ArrayList childWidgetsAll = new ArrayList();
                for (Widget childTable : execFormCanvas.childTables()) {
                    List childWidgets = childTable.getChildren();
                    childWidgetsAll.addAll(childWidgets);
                }
                execWidgets.addAll(execFormCanvas.childTables());
                execWidgets.addAll(childWidgetsAll);
            }
            if (flag = new HashSet(canvasWidgets = execWidgets.stream().map(Widget::getName).collect(Collectors.toList())).containsAll(execFields)) continue;
            return false;
        }
        triggerFields = triggerFields.stream().distinct().filter(field -> !"RECORD_ID".equals(field)).filter(field -> !field.endsWith("ref_id") && !field.endsWith("ref_child_id")).collect(Collectors.toList());
        FormCanvasSchema triggerFormCanvas = (FormCanvasSchema)this.canvasSchemaService.get(triggerFormId).getData();
        ArrayList triggerWidgets = new ArrayList();
        List widgetListT = triggerFormCanvas.widgetsWithSys();
        if (HussarUtils.equals((Object)triggerFormCanvas.getFormType(), (Object)"1")) {
            List processState = PageBuilderFactory.getProcessInfoWidgets();
            widgetListT.addAll(processState);
        }
        triggerWidgets.addAll(widgetListT);
        if (HussarUtils.isNotEmpty((Object)triggerFormCanvas.childTables())) {
            ArrayList childWidgetsAll = new ArrayList();
            for (Widget childTable : triggerFormCanvas.childTables()) {
                List childWidgets = childTable.getChildren();
                childWidgetsAll.addAll(childWidgets);
            }
            triggerWidgets.addAll(childWidgetsAll);
        }
        List canvasWidgets = triggerWidgets.stream().map(Widget::getName).collect(Collectors.toList());
        return new HashSet(canvasWidgets).containsAll(triggerFields);
    }

    public ApiResponse<Boolean> copyRule(SysRuleInfoVo sysRuleInfoVo) {
        SysRuleTriggerAction sysRuleTriggerAction;
        List sysRuleExecActionList;
        SysRuleInfo sysRuleInfo = (SysRuleInfo)this.getById((Serializable)((Object)sysRuleInfoVo.getRuleId()));
        if (HussarUtils.isNotEmpty((Object)sysRuleInfo)) {
            sysRuleInfo.setRuleId(null);
            sysRuleInfo.setRuleName(sysRuleInfoVo.getRuleName());
            sysRuleInfo.setCreateTime(LocalDateTime.now());
            sysRuleInfo.setLastTime(LocalDateTime.now());
            boolean ruleInfoFlag = this.save((BaseEntity)sysRuleInfo);
            if (!ruleInfoFlag) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sysRuleExecActionList = this.sysRuleExcActionService.getActionsByRuleId(sysRuleInfoVo.getRuleId())))) {
            for (SysRuleExecAction sysRuleExecAction : sysRuleExecActionList) {
                sysRuleExecAction.setActionId(null);
                sysRuleExecAction.setRuleId(sysRuleInfo.getRuleId());
            }
            boolean ruleExcFlag = this.sysRuleExcActionService.saveBatch((Collection)sysRuleExecActionList);
            if (!ruleExcFlag) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(sysRuleTriggerAction = (SysRuleTriggerAction)this.sysRuleTriggerActionService.getById((Serializable)((Object)sysRuleInfoVo.getRuleId()))))) {
            sysRuleTriggerAction.setTriggerId(sysRuleInfo.getRuleId());
            sysRuleTriggerAction.setRuleId(sysRuleInfo.getRuleId());
            boolean ruleTriggerFlag = this.sysRuleTriggerActionService.save((Object)sysRuleTriggerAction);
            if (!ruleTriggerFlag) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25");
            }
            String triggerType = sysRuleTriggerAction.getTriggerAction();
            if (NoCodeRuleTriggerType.TriggerTypeTimedSingle.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedRepeated.getType().equals(triggerType) || NoCodeRuleTriggerType.TriggerTypeTimedDepend.getType().equals(triggerType)) {
                boolean result;
                RuleFullVo ruleFullVo = new RuleFullVo();
                SysTimingTriggerConfig config = (SysTimingTriggerConfig)this.sysTimingTriggerConfigService.getById((Serializable)((Object)sysRuleInfoVo.getRuleId()));
                if (HussarUtils.isNotEmpty((Object)config)) {
                    ruleFullVo.setAppId(config.getAppId().toString());
                    ruleFullVo.setSourceForm(config.getFormId().toString());
                    ruleFullVo.setRuleId(sysRuleInfo.getRuleId());
                    ruleFullVo.setEnable(sysRuleInfo.getEnable());
                    ruleFullVo.setTrigger(config.getTriggerTaskType());
                    JSONObject jsonObject = new JSONObject();
                    String firstTriggerTimeConfigStr = config.getFirstTriggerTimeConfig();
                    if (HussarUtils.isEmpty((Object)firstTriggerTimeConfigStr)) {
                        String formattedDateTime;
                        LocalDateTime firstTriggerTime = config.getFirstTriggerTime();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        firstTriggerTimeConfigStr = formattedDateTime = firstTriggerTime.format(formatter);
                    }
                    if (firstTriggerTimeConfigStr.contains("dateTime")) {
                        JSONObject firstTriggerTimeConfigObject = JSONObject.parseObject((String)firstTriggerTimeConfigStr);
                        jsonObject.put("firstTriggerTime", (Object)firstTriggerTimeConfigObject);
                    } else {
                        if (firstTriggerTimeConfigStr.startsWith("\"") && firstTriggerTimeConfigStr.endsWith("\"")) {
                            firstTriggerTimeConfigStr = firstTriggerTimeConfigStr.substring(1, firstTriggerTimeConfigStr.length() - 1);
                        }
                        jsonObject.put("firstTriggerTime", (Object)firstTriggerTimeConfigStr);
                    }
                    jsonObject.put("endTriggerTime", (Object)config.getEndTriggerTime());
                    jsonObject.put("repeatRule", (Object)config.getRepeatRule());
                    ruleFullVo.setTimedRule(jsonObject);
                }
                if (!(result = this.sysTimingTriggerConfigService.saveTimingTriggerConfig(ruleFullVo, sysRuleInfo.getRuleId()))) {
                    throw new BaseException("\u65b0\u589e\u5931\u8d25");
                }
            }
        }
        return ApiResponse.success((String)"\u590d\u5236\u6210\u529f");
    }

    public ApiResponse<List<SysRuleInfoWithDetailsDto>> getAllSysRuleInfoWithDetails(SysRuleInfoVo sysRuleInfoVo) {
        ArrayList<SysRuleInfoWithDetailsDto> sysRuleInfoWithDetailsDtos = new ArrayList<SysRuleInfoWithDetailsDto>();
        List sysRuleTriggerActions = this.sysRuleTriggerActionService.getActionsByFormId(sysRuleInfoVo.getTriggerFormId());
        if (HussarUtils.isEmpty((Object)sysRuleTriggerActions)) {
            logger.info("getAllSysRuleInfoWithDetails\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysRuleInfoVo));
            return ApiResponse.success();
        }
        LambdaQueryWrapper ruleInfoWrapper = new LambdaQueryWrapper();
        List ruleIds = sysRuleTriggerActions.stream().map(SysRuleTriggerAction::getRuleId).distinct().collect(Collectors.toList());
        List sysRuleInfos = this.sysRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ruleInfoWrapper.in(SysRuleInfo::getRuleId, ruleIds)).eq(SysRuleInfo::getEnable, (Object)1)).ne(HussarDelflagEntity::getDelFlag, (Object)1)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (HussarUtils.isEmpty((Object)sysRuleInfos)) {
            logger.info("getAllSysRuleInfoWithDetails\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)sysRuleInfoVo));
            return ApiResponse.success();
        }
        List finalRuleIds = sysRuleInfos.stream().map(SysRuleInfo::getRuleId).distinct().collect(Collectors.toList());
        List sysRuleExecActions = this.sysRuleExcActionService.getActionsByRuleIds(finalRuleIds);
        Map<String, List<SysRuleTriggerAction>> sysRuleTriggerActionsMap = sysRuleTriggerActions.stream().collect(Collectors.groupingBy(SysRuleTriggerAction::getRuleId));
        Map<Object, Object> sysRuleExcActionMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)sysRuleExecActions)) {
            sysRuleExcActionMap = sysRuleExecActions.stream().collect(Collectors.groupingBy(SysRuleExecAction::getRuleId));
        }
        for (SysRuleInfo sysRuleInfo : sysRuleInfos) {
            SysRuleInfoWithDetailsDto sysRuleInfoWithDetailsDto = new SysRuleInfoWithDetailsDto();
            BeanUtils.copyProperties((Object)sysRuleInfo, (Object)sysRuleInfoWithDetailsDto);
            sysRuleInfoWithDetailsDto.setSysRuleTriggerAction(sysRuleTriggerActionsMap.get(sysRuleInfo.getRuleId()) == null ? null : sysRuleTriggerActionsMap.get(sysRuleInfo.getRuleId()).get(0));
            sysRuleInfoWithDetailsDto.setSysRuleExcActions((List)sysRuleExcActionMap.get(sysRuleInfo.getRuleId()));
            sysRuleInfoWithDetailsDto.setSysRuleInfo(sysRuleInfo);
            sysRuleInfoWithDetailsDtos.add(sysRuleInfoWithDetailsDto);
        }
        return ApiResponse.success(sysRuleInfoWithDetailsDtos);
    }

    public ApiResponse<Boolean> disableRuleOfForm(String formId) {
        List allAction = this.sysRuleTriggerActionService.getAllActionsByFormId(formId);
        boolean[] result = new boolean[]{true};
        allAction.forEach(ra -> {
            SysRuleInfoVo sysRuleInfoVo = new SysRuleInfoVo();
            sysRuleInfoVo.setEnable(Boolean.valueOf(false));
            sysRuleInfoVo.setRuleId(ra.getRuleId());
            ApiResponse<Boolean> ruleSwitch = this.ruleSwitch(sysRuleInfoVo);
            result[0] = result[0] & ruleSwitch.isSuccess();
        });
        if (result[0]) {
            return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        throw new BaseException("\u66f4\u65b0\u5931\u8d25");
    }

    public SysRuleInfoWithDetailsDto getSysRuleInfoWithDetails(String triggerId) {
        SysRuleTriggerAction sysRuleTriggerAction = this.sysRuleTriggerActionService.getActionByTriggerId(triggerId);
        String ruleId = sysRuleTriggerAction.getRuleId();
        LambdaQueryWrapper ruleInfoWrapper = new LambdaQueryWrapper();
        List sysRuleInfos = this.sysRuleInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)ruleInfoWrapper.in(SysRuleInfo::getRuleId, new Object[]{ruleId})).eq(SysRuleInfo::getEnable, (Object)1));
        if (HussarUtils.isEmpty((Object)sysRuleInfos)) {
            logger.info("getSysRuleInfoWithDetails\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u89c4\u5219\u4fe1\u606f,triggerId\uff1a{}", (Object)triggerId);
            return null;
        }
        List finalRuleIds = sysRuleInfos.stream().map(SysRuleInfo::getRuleId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper ruleExcActionWrapper = new LambdaQueryWrapper();
        List sysRuleExecActions = this.sysRuleExcActionService.getActionsByRuleIds(finalRuleIds);
        Map<Object, Object> sysRuleExcActionMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)sysRuleExecActions)) {
            sysRuleExcActionMap = sysRuleExecActions.stream().collect(Collectors.groupingBy(SysRuleExecAction::getRuleId));
        }
        SysRuleInfo sysRuleInfo = (SysRuleInfo)sysRuleInfos.get(0);
        SysRuleInfoWithDetailsDto sysRuleInfoWithDetailsDto = new SysRuleInfoWithDetailsDto();
        BeanUtils.copyProperties((Object)sysRuleInfo, (Object)sysRuleInfoWithDetailsDto);
        sysRuleInfoWithDetailsDto.setSysRuleTriggerAction(sysRuleTriggerAction);
        sysRuleInfoWithDetailsDto.setSysRuleExcActions((List)sysRuleExcActionMap.get(sysRuleInfo.getRuleId()));
        sysRuleInfoWithDetailsDto.setSysRuleInfo(sysRuleInfo);
        return sysRuleInfoWithDetailsDto;
    }
}

