/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormSaveDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysTableToFormDto;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysCreateFormService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.tableinfo.service.ISysUserTableNameService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.service.DataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.SysTableToFormServiceImpl")
public class SysCreateFormServiceImpl
implements ISysCreateFormService {
    private final Logger LOGGER = LoggerFactory.getLogger(SysCreateFormServiceImpl.class);
    @Resource
    private ISysUserTableNameService sysUserTableNameService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private ISysFormService sysFormService;

    public ApiResponse<String> addFormAndSaveCanvas(SysTableToFormDto sysTableToFormDto) {
        String tableKey = sysTableToFormDto.getKey();
        List sysFormSaveDtos = sysTableToFormDto.getSysFormSaveDtos();
        String key = "createFromCacheKey_" + UUID.randomUUID();
        for (SysFormSaveDto formSaveDto : sysFormSaveDtos) {
            formSaveDto.setCreateSource("1");
        }
        this.sysUserTableNameService.activation(tableKey);
        this.dealAddFormAndSaveCanvas(sysFormSaveDtos, key, tableKey);
        return ApiResponse.success((Object)key, (String)"");
    }

    public void dealAddFormAndSaveCanvas(List<SysFormSaveDto> sysFormSaveDto, String key, String tableKey) {
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                this.sysFormService.dealTableToForm(sysFormSaveDto, key, tableKey, dataSourceKey);
            }
            catch (Exception e) {
                this.LOGGER.error("\u4ece\u5e93\u8868\u521b\u5efa\u8868\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                this.sysUserTableNameService.createdFail(tableKey, dataSourceKey);
            }
        });
    }
}

