/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportThreadServiceImpl")
public class FormImportThreadServiceImpl
implements IFormImportThreadService {
    @Resource
    private IFormImportInfoService formImportInfoService;
    @Resource
    private ISysFormService formService;
    @Resource
    private AppSyncService appSyncService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormImportThreadServiceImpl.class);

    @HussarDs(value="#dataSourceKey")
    public void startImportThread(FormImportDto formImportDto, String dataSourceKey) throws Exception {
        ImportMappingDto importMappingDto = new ImportMappingDto();
        try {
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            this.formImportInfoService.importFormData(formImportDto, importMappingDto);
            if ("2".equals(formImportDto.getFormType())) {
                this.formImportInfoService.importDashboardData(formImportDto, importMappingDto);
            } else {
                this.formImportInfoService.importMidFile(formImportDto, importMappingDto);
                this.formImportInfoService.importFlowData(formImportDto, importMappingDto);
                this.formImportInfoService.importBusinessData(formImportDto, importMappingDto);
                this.formImportInfoService.importBusinessRule(formImportDto, importMappingDto);
            }
            Long importFormId = importMappingDto.getFormIdMap().values().stream().findFirst().orElse(null);
            this.appSyncService.importForm(importFormId);
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)4, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty(importMappingDto.getFormIdMap().values())) {
                this.formService.removeByIds(importMappingDto.getFormIdMap().values());
            }
            LOGGER.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
    }
}

