/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.FormUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportServiceImpl")
public class FormImportServiceImpl
implements IFormImportService {
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    @Resource
    private ISysFormService sysFormService;
    private static final Logger logger = LoggerFactory.getLogger(FormImportServiceImpl.class);

    public ApiResponse<FormAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        String formPath = FileUtil.posixPath((String[])new String[]{unZipPath, "formConfig" + File.separator + "form.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            throw new BaseException("\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        Object object = jsonObject.get((Object)"form");
        JSONObject sysForm = (JSONObject)object;
        if (HussarUtils.isEmpty((Object)sysForm)) {
            throw new BaseException("\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        if (formExportMetaDto == null) {
            return ApiResponse.fail((String)"\u4e0a\u4f20\u7684\u9644\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (HussarUtils.isEmpty((Object)formExportMetaDto.getFormName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u8868\u5355\u6587\u4ef6");
        }
        FormAttachmentParseVo formAttachmentParseVo = new FormAttachmentParseVo();
        formAttachmentParseVo.setPath(unZipPath);
        formAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)formExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)formExportMetaDto, (Object)formAttachmentParseVo);
        formAttachmentParseVo.setI18nKeys(sysForm.getString("i18nKeys"));
        return ApiResponse.success((Object)formAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(FormImportDto formImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)formImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "hussar.meta"});
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        assert (formExportMetaDto != null);
        String password = formExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public void importForm(FormImportDto formImportDto) {
        String dataSourceKey = DataModelUtil.currentDsName();
        logger.info("\u8868\u5355\u5bfc\u5165 => \u5f00\u59cb\u6267\u884c..., \u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            try {
                this.formImportThreadService.startImportThread(formImportDto, dataSourceKey);
            }
            catch (Exception e) {
                logger.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                throw new HussarException((Throwable)e);
            }
        });
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.waitImport((int)1, (boolean)false, (Object)"", (boolean)false, (String)"\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")));
    }

    public ApiResponse<Boolean> importFormBatch(MultipartFile file, Long appId, String password) {
        ArrayList<String> passwordList = new ArrayList<String>();
        ArrayList<FormImportDto> formImportDtos = new ArrayList<FormImportDto>();
        if (HussarUtils.isNotEmpty((Object)password)) {
            String[] strings = password.split(",");
            passwordList.addAll(Arrays.asList(strings));
        }
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            File unzip = ZipUtil.unzip((ZipInputStream)zipInputStream, (File)new File(this.outputPath + File.separator + UUID.randomUUID() + File.separator));
            String path = unzip.getPath();
            if (HussarUtils.isNotEmpty((Object[])unzip.listFiles())) {
                for (File childFile : Objects.requireNonNull(unzip.listFiles())) {
                    MockMultipartFile multipartFile = new MockMultipartFile(childFile.getName(), childFile.getName(), ".hussar", Files.newInputStream(childFile.toPath(), new OpenOption[0]));
                    ApiResponse<FormAttachmentParseVo> formAttachmentParseVoApiResponse = this.parseAttachment((MultipartFile)multipartFile);
                    FormImportDto formImportDto = FormImportServiceImpl.getFormImportDto(appId, formAttachmentParseVoApiResponse);
                    if (formImportDto.isEncryptFlag()) {
                        if (HussarUtils.isNotEmpty(passwordList)) {
                            boolean isVerify = false;
                            for (String pwd : passwordList) {
                                formImportDto.setPassword(pwd);
                                ApiResponse<Boolean> booleanApiResponse = this.verifyPassword(formImportDto);
                                Boolean data = (Boolean)booleanApiResponse.getData();
                                if (!data.booleanValue()) continue;
                                isVerify = true;
                                break;
                            }
                            if (!isVerify) {
                                return ApiResponse.fail((String)"\u8868\u5355\u6279\u91cf\u5bfc\u5165\u5931\u8d25\uff0c\u5bc6\u7801\u9519\u8bef");
                            }
                        } else {
                            return ApiResponse.fail((String)"\u8868\u5355\u6279\u91cf\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u5bc6\u7801");
                        }
                    }
                    formImportDtos.add(formImportDto);
                }
            }
            for (FormImportDto formImportDto : formImportDtos) {
                this.importFormForBatch(formImportDto);
            }
        }
        catch (IOException e) {
            logger.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            return ApiResponse.fail((String)"\u8868\u5355\u6279\u91cf\u5bfc\u5165\u5931\u8d25");
        }
        return ApiResponse.success((Object)true, (String)"\u8868\u5355\u6279\u91cf\u5bfc\u5165\u6210\u529f");
    }

    @NotNull
    private static FormImportDto getFormImportDto(Long appId, ApiResponse<FormAttachmentParseVo> formAttachmentParseVoApiResponse) {
        FormAttachmentParseVo data = (FormAttachmentParseVo)formAttachmentParseVoApiResponse.getData();
        FormImportDto formImportDto = new FormImportDto();
        formImportDto.setEncryptFlag(data.isEncryptFlag());
        formImportDto.setAppId(appId);
        formImportDto.setFormGroupId(null);
        formImportDto.setFormIcon(data.getFormIcon());
        formImportDto.setFormIconColor(data.getFormIconColor());
        formImportDto.setFormIconType(data.getFormIconType());
        formImportDto.setFormName(data.getFormName());
        formImportDto.setI18nKeys(data.getI18nKeys());
        formImportDto.setPath(data.getPath());
        formImportDto.setTableName(FormUtil.generateTableName("0"));
        return formImportDto;
    }

    private void importFormForBatch(FormImportDto formImportDto) {
        String dataSourceKey = DataModelUtil.currentDsName();
        logger.info("\u8868\u5355\u5bfc\u5165 => \u5f00\u59cb\u6267\u884c..., \u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
        try {
            this.formImportThreadService.startImportThread(formImportDto, dataSourceKey);
        }
        catch (Exception e) {
            logger.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
    }
}

