/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppExportDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppExportService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppExportImportServiceImpl")
public class AppExportServiceImpl
implements IAppExportService {
    private static final Logger log = LoggerFactory.getLogger(AppExportServiceImpl.class);
    @Resource
    private IAppExportInfoService appExportInfoService;
    @Resource
    private ISysAppExportRecordService sysAppExportRecordService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private ISysApplicationBoService applicationBoService;

    public ApiResponse<Void> export(AppExportDto appExportDto) {
        Long usr = BaseSecurityUtil.getUser().getId();
        String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
        log.info("\u5bfc\u51fa\u5e94\u7528key: {}", (Object)exportCacheKey);
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeDesignTask(() -> {
            try {
                this.exportExecute(appExportDto, usr, dataSourceKey);
            }
            catch (Exception e) {
                ToolUtil.getLogger(AppExportServiceImpl.class).error("\u5bfc\u51fa\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
            TransmittableThreadLocalHolder.clear((String)"exportCacheKey");
        });
        return ApiResponse.success();
    }

    @HussarDs(value="#dataSourceKey")
    public void exportExecute(AppExportDto appExportDto, Long usr, String dataSourceKey) throws Exception {
        String exportCacheKey = (String)TransmittableThreadLocalHolder.get((String)"exportCacheKey");
        log.info("\u5f02\u6b65\u91cc\u5bfc\u51fa\u5e94\u7528key: {}", (Object)exportCacheKey);
        this.appExportInfoService.init(appExportDto);
        this.appExportInfoService.exportAppInfo(appExportDto);
        this.appExportInfoService.exportFormInfo(appExportDto);
        this.appExportInfoService.exportFormAuthorityInfo(appExportDto);
        this.appExportInfoService.exportDesignerMidFile(appExportDto);
        this.appExportInfoService.exportFlowConfigInfo(appExportDto);
        this.appExportInfoService.exportCommData(appExportDto);
        if (appExportDto.getExportDataFlag()) {
            this.appExportInfoService.exportBusinessData(appExportDto);
        }
        this.appExportInfoService.generateMetaInfo(appExportDto);
        if (appExportDto.isExportPluginFlag() && appExportDto.isUsedPluginFlag()) {
            this.appExportInfoService.exportPlugin(appExportDto);
        }
        Thread.sleep(1000L);
        Long exportFileId = this.appExportInfoService.uploadExportFile(appExportDto);
        SysAppExportRecord record = new SysAppExportRecord();
        record.setType("1");
        record.setName(this.applicationBoService.selectById(appExportDto.getAppId()).getAppName());
        record.setExportUserId(usr);
        record.setExportTime(LocalDateTime.now());
        record.setExportFileId(exportFileId);
        this.sysAppExportRecordService.save((Object)record);
        this.appExportInfoService.clear();
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public void downloadExportFile(Long fileId, HttpServletResponse response) {
        this.appFileExtendService.fileDownload(fileId, response);
    }
}

