/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.button.model.SysCustomButton;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.dao.SysDataOperateLogMapper;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.dto.DataOperateLogDto;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.model.SysDataOperateLog;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.service.ISysDataOperateLogService;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataOperateLogPage;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.vo.SysDataOperateLogVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.operatelog.data.service.impl.SysDataOperateLogServiceImpl")
public class SysDataOperateLogServiceImpl
extends HussarServiceImpl<SysDataOperateLogMapper, SysDataOperateLog>
implements ISysDataOperateLogService {
    @Value(value="${hussar.nocode.dataOperateLog.storageType:mysql}")
    private String storageType;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ISysUsersService usersService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;

    public ApiResponse<SysDataOperateLogPage> list(DataOperateLogDto dataOperateLogDto) {
        Long dataId = dataOperateLogDto.getDataId();
        Long formId = dataOperateLogDto.getFormId();
        int pageSize = dataOperateLogDto.getPageSize();
        int pageIndex = dataOperateLogDto.getPageIndex();
        AssertUtil.isNotNull((Object)dataId, (String)"\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)formId, (String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<SysDataOperateLogVo> sysDataOperateLogs = new ArrayList<SysDataOperateLogVo>();
        SysDataOperateLogPage sysDataOperateLogPage = new SysDataOperateLogPage();
        if (this.storageType.equals("mysql")) {
            Page page = new Page((long)pageIndex, (long)pageSize);
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDataOperateLog::getDataId, (Object)dataId)).eq(SysDataOperateLog::getFormId, (Object)formId)).orderByDesc(HussarBaseEntity::getCreateTime)).orderByDesc(SysDataOperateLog::getOperateId);
            IPage selectPage = ((SysDataOperateLogMapper)this.getBaseMapper()).selectPage((IPage)page, (Wrapper)wrapper);
            List records = selectPage.getRecords();
            long total = selectPage.getTotal();
            this.handleLog(records, sysDataOperateLogs);
            sysDataOperateLogPage.setSysDataOperateLogVos(sysDataOperateLogs);
            sysDataOperateLogPage.setTotal(Long.valueOf(total));
        } else {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"dataId").is((Object)dataId));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"formId").is((Object)formId));
            PageRequest pageable = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
            query.with((Pageable)pageable);
            List records = this.mongoTemplate.find(query, SysDataOperateLog.class);
            long total = this.mongoTemplate.count(query, SysDataOperateLog.class);
            this.handleLog(records, sysDataOperateLogs);
            sysDataOperateLogPage.setSysDataOperateLogVos(sysDataOperateLogs);
            sysDataOperateLogPage.setTotal(Long.valueOf(total));
        }
        return ApiResponse.success((Object)sysDataOperateLogPage);
    }

    private void handleLog(List<SysDataOperateLog> records, List<SysDataOperateLogVo> sysDataOperateLogs) {
        ArrayList userIds = new ArrayList();
        ArrayList triggerFormIds = new ArrayList();
        ArrayList buttonIds = new ArrayList();
        records.forEach(sysDataOperateLog -> {
            userIds.add(sysDataOperateLog.getCreator());
            triggerFormIds.add(sysDataOperateLog.getTriggerFormId());
            buttonIds.add(sysDataOperateLog.getButtonId());
        });
        ArrayList users = new ArrayList();
        if (HussarUtils.isNotEmpty(userIds)) {
            users.addAll(this.usersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, userIds)));
        }
        ArrayList sysForms = new ArrayList();
        if (HussarUtils.isNotEmpty(triggerFormIds)) {
            sysForms.addAll(this.sysFormService.list((Wrapper)new LambdaQueryWrapper().in(SysForm::getId, triggerFormIds)));
        }
        ArrayList sysCustomButtons = new ArrayList();
        if (HussarUtils.isNotEmpty(buttonIds)) {
            sysCustomButtons.addAll(this.sysCustomButtonService.list((Wrapper)new LambdaQueryWrapper().in(SysCustomButton::getId, buttonIds)));
        }
        records.forEach(sysDataOperateLog -> {
            Long creator = sysDataOperateLog.getCreator();
            Long triggerFormId = sysDataOperateLog.getTriggerFormId();
            Long buttonId = sysDataOperateLog.getButtonId();
            SysDataOperateLogVo sysDataOperateLogVo = new SysDataOperateLogVo();
            BeanUtil.copyProperties((Object)sysDataOperateLog, (Object)sysDataOperateLogVo);
            if (HussarUtils.isNotEmpty((Object)triggerFormId)) {
                boolean isFindForm = false;
                for (SysForm sysForm : sysForms) {
                    if (!sysForm.getId().equals(triggerFormId)) continue;
                    sysDataOperateLogVo.setTriggerFormName(sysForm.getFormName());
                    isFindForm = true;
                    break;
                }
                if (!isFindForm) {
                    sysDataOperateLogVo.setTriggerFormName("\u672a\u77e5\u8868\u5355");
                }
            }
            if (HussarUtils.isNotEmpty((Object)buttonId)) {
                boolean isFindButton = false;
                for (SysCustomButton sysCustomButton : sysCustomButtons) {
                    if (!sysCustomButton.getId().equals(buttonId)) continue;
                    sysDataOperateLogVo.setButtonName(sysCustomButton.getAlias());
                    isFindButton = true;
                    break;
                }
                if (!isFindButton) {
                    sysDataOperateLogVo.setButtonName("\u672a\u77e5\u6309\u94ae");
                }
            }
            boolean isFindUser = false;
            for (SysUsers sysUser : users) {
                if (!sysUser.getId().equals(creator)) continue;
                SysDataOperateLogVo.Operator operator = new SysDataOperateLogVo.Operator();
                BeanUtil.copyProperties((Object)sysUser, (Object)operator);
                sysDataOperateLogVo.setOperator(operator);
                sysDataOperateLogs.add(sysDataOperateLogVo);
                isFindUser = true;
                break;
            }
            if (!isFindUser) {
                SysDataOperateLogVo.Operator operator = new SysDataOperateLogVo.Operator();
                if (HussarUtils.isNotEmpty((Object)sysDataOperateLogVo.getTriggerFormId())) {
                    operator.setUserName("\u5b9a\u65f6\u89e6\u53d1");
                } else if (sysDataOperateLogVo.getOpMode() == 6) {
                    operator.setUserName("\u6570\u636e\u62c9\u53d6");
                } else {
                    operator.setUserName("\u5916\u90e8\u7528\u6237");
                }
                sysDataOperateLogVo.setOperator(operator);
                sysDataOperateLogs.add(sysDataOperateLogVo);
            }
        });
    }
}

