/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.core.util.PingYinUtil;
import com.jxdinfo.hussar.dashboard.model.DashEntry;
import com.jxdinfo.hussar.dashboard.service.IDashEntryService;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.AppSyncService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppFormTreeVo;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicFilterMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitFormAuthorizeRolesMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleButtonMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitRoleOrganDataAuthorityMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysUpAppVisitRoleFieldMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonAuthoritiesDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.ButtonDto;
import com.jxdinfo.hussar.formdesign.application.authority.dto.SysAppVisitFormAuthorizeRolesDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleOrganDataAuthority;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysUpAppVisitRoleField;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleOrganDataAuthorityService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysUpAppVisitRoleFieldService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldAuthWithStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.FieldVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.OrganDataAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.service.FormMapService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullRecordService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullTaskService;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormGroupMapper;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormReferenceService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormConvertHistoryService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAuthorityMap;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupWithAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormWithAuthVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupList;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysSiftGroupListWithAuth;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.panel.dto.SysPanelDto;
import com.jxdinfo.hussar.formdesign.application.panel.service.ISysPanelService;
import com.jxdinfo.hussar.formdesign.application.util.AppIoUtil;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.WidgetField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.NoCodeBusinessDB;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.FormCleaner;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.StaffScopeScemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.RandomType;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.Serializable;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.sysFormServiceImpl")
public class SysFormServiceImpl
extends HussarServiceImpl<SysFormMapper, SysForm>
implements ISysFormService {
    private final Logger LOGGER = LoggerFactory.getLogger(SysFormServiceImpl.class);
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private SysFormGroupMapper sysFormGroupMapper;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;
    @Resource
    private SysApplicationMapper applicationMapper;
    @Resource
    private ISysAppVisitRoleButtonService roleButtonService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private SysAppVisitFormAuthorizeRolesMapper formAuthorizeRolesMapper;
    @Resource
    private SysAppVisitRoleButtonMapper roleButtonMapper;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFieldMapper;
    @Resource
    private SysAppVisitRoleOrganDataAuthorityMapper roleOrganDataAuthorityMapper;
    @Resource
    private SysAppVisitDataLogicMapper dataLogicMapper;
    @Resource
    private SysAppVisitDataLogicFilterMapper dataLogicFilterMapper;
    @Resource
    private ISysAppVisitDataLogicFilterService dataLogicFilterService;
    @Resource
    private ISysPanelService sysPanelService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private FormCleaner formCleaner;
    @Resource
    private CanvasService canvasService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private SettingSchemaService<FormSettingSchema> settingSchemaService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private ViewService viewService;
    @Resource
    private StaffScopeScemaService staffScopeScemaService;
    @Resource
    private FormOperateService formOperate;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private HussarMetadataService hussarMetadataService;
    @Resource
    private FormMapService formMapService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private PushDataRecordService pushDataRecordService;
    @Value(value="${open.rePublish.saveCanvas:false}")
    private boolean saveCanvas;
    @Resource
    private ISysAppVisitRoleButtonService sysAppVisitRoleButtonService;
    @Resource
    private ISysAppVisitRoleOrganDataAuthorityService sysAppVisitRoleOrganDataAuthorityService;
    @Resource
    private ISysUpAppVisitRoleFieldService sysUpAppVisitRoleFieldService;
    @Resource
    private ISysAppVisitDataLogicService sysAppVisitDataLogicService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private SysUpAppVisitRoleFieldMapper roleFiledMapper;
    @Resource
    private ISysUpAppVisitRoleFieldService roleFiledService;
    @Resource
    private AppImportInfoServiceImpl appImportInfoService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    @Resource
    private AppSyncService appSyncService;
    @Resource
    private IFormReferenceService formReferenceService;
    @Resource
    private SysDataPullTaskService sysDataPullTaskService;
    @Resource
    private SysDataPullService sysDataPullService;
    @Resource
    private SysDataPullRecordService sysDataPullRecordService;
    @Resource
    private ISysFormConvertHistoryService sysFormConvertHistoryService;
    @Resource
    private IDashEntryService dashEntryService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private AppSyncService appFormSyncService;
    @Resource
    private IHussarAppFormService appFormService;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> addForm(SysFormDto sysFormDto) {
        int maxFormSeq = this.sysFormMapper.maxSeq(sysFormDto.getAppId(), sysFormDto.getFormGroupId());
        sysFormDto.setSeq(maxFormSeq + 1);
        if ("2".equals(sysFormDto.getFormType())) {
            DashEntry dashEntry = new DashEntry();
            dashEntry.setEntryName(sysFormDto.getFormName());
            dashEntry.setAppId(sysFormDto.getAppId());
            dashEntry.setGroupId(sysFormDto.getFormGroupId() == null ? null : sysFormDto.getFormGroupId().toString());
            dashEntry.setIcon(sysFormDto.getFormIcon());
            Long panelId = this.dashEntryService.savePanelData(dashEntry);
            sysFormDto.setId(panelId);
        }
        if ("2".equals(sysFormDto.getFormType()) || "3".equals(sysFormDto.getFormType())) {
            sysFormDto.setTableName(sysFormDto.getExtname());
            sysFormDto.setFormStatus("1");
            this.save((BaseEntity)sysFormDto);
            SysPanelDto sysPanelDto = new SysPanelDto();
            sysPanelDto.setPanelId(sysFormDto.getId());
            sysPanelDto.setPanelName(sysFormDto.getFormName());
            sysPanelDto.setAppId(sysFormDto.getAppId());
            this.sysPanelService.addPanel(sysPanelDto);
        } else {
            StringBuilder uid = new StringBuilder();
            SecureRandom rd = new SecureRandom();
            for (int i = 0; i < 16; ++i) {
                uid.append(rd.nextInt(10));
            }
            String pyIndexStr = PingYinUtil.getPYIndexStr((String)sysFormDto.getFormName(), (boolean)true);
            String fistWord = pyIndexStr.substring(0, 1);
            if (HussarUtils.isNumeric((CharSequence)fistWord)) {
                pyIndexStr = "A" + pyIndexStr;
            }
            if (pyIndexStr.length() > 6) {
                pyIndexStr = pyIndexStr.substring(0, 6);
            }
            String dbType = DataModelUtil.getDataSourceTypeByName((String)NoCodeBusinessDB.getNocodeBusinessDB());
            String tableName = null;
            tableName = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) ? pyIndexStr.toLowerCase() : pyIndexStr.toUpperCase();
            sysFormDto.setTableName(tableName + "_" + uid);
            sysFormDto.setFormStatus("1");
            this.save((BaseEntity)sysFormDto);
            BaseForm baseForm = new BaseForm();
            baseForm.setId(sysFormDto.getId().toString());
            baseForm.setName(sysFormDto.getTableName());
            baseForm.setTitle(sysFormDto.getFormName());
            baseForm.setFormType(sysFormDto.getFormType());
            baseForm.setIcon(sysFormDto.getFormIcon());
            baseForm.setAppId(sysFormDto.getAppId().toString());
            if ("1".equals(sysFormDto.getFormType())) {
                baseForm.setIdentity("bpm_" + PingYinUtil.getPYIndexStr((String)sysFormDto.getFormName(), (boolean)true) + sysFormDto.getId());
            }
            try {
                this.formOperateExposedService.create(baseForm, sysFormDto.getAppId().toString());
            }
            catch (Exception e) {
                throw new BaseException("\u8868\u5355\u521d\u59cb\u5316\u8d44\u6e90\u5931\u8d25!", (Throwable)e);
            }
        }
        this.initFormDevelopRole(sysFormDto);
        this.appSyncService.syncForm("add", (SysForm)sysFormDto);
        return ApiResponse.success((Object)sysFormDto.getId(), (String)"\u521b\u5efa\u8868\u5355\u6210\u529f");
    }

    public void initFormDevelopRole(SysFormDto sysFormDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysApplication::getId, (Object)sysFormDto.getAppId());
        SysApplication application = (SysApplication)this.applicationMapper.selectOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)application.getDevelopRoleId())) {
            return;
        }
        SysAppVisitFormAuthorizeRolesDto formAuthorizeRoles = new SysAppVisitFormAuthorizeRolesDto();
        formAuthorizeRoles.setId(Long.valueOf(IdWorker.getId((Object)new SysAppVisitFormAuthorizeRolesDto())));
        formAuthorizeRoles.setAppId(sysFormDto.getAppId());
        formAuthorizeRoles.setFormId(sysFormDto.getId());
        formAuthorizeRoles.setRoleIdList(Arrays.asList(application.getDevelopRoleId()));
        ApiResponse addFormAuthorizeRoleRes = this.sysAppVisitFormAuthorizeRolesService.addFormAuthorizeRoles(formAuthorizeRoles);
        if (!addFormAuthorizeRoleRes.isSuccess()) {
            throw new BaseException("\u5f00\u53d1\u8005\u89d2\u8272\u65b0\u589e\u8868\u5355\u53ef\u8bbf\u95ee\u6388\u6743\u5931\u8d25");
        }
        ButtonAuthoritiesDto buttonAuthoritiesDto = new ButtonAuthoritiesDto();
        buttonAuthoritiesDto.setAppId(sysFormDto.getAppId());
        buttonAuthoritiesDto.setFormId(sysFormDto.getId());
        buttonAuthoritiesDto.setRoleId(application.getDevelopRoleId());
        this.sysCreateButton(buttonAuthoritiesDto);
        ApiResponse addButtonAuthorityRoleRes = this.roleButtonService.addButtonAuthorityRoles(buttonAuthoritiesDto);
        if (!addButtonAuthorityRoleRes.isSuccess()) {
            throw new BaseException("\u5f00\u53d1\u8005\u89d2\u8272\u65b0\u589e\u8868\u5355\u64cd\u4f5c\u6743\u9650\u5931\u8d25");
        }
    }

    public void sysCreateButton(ButtonAuthoritiesDto buttonAuthoritiesDto) {
        ArrayList buttonDtos = Lists.newArrayListWithCapacity((int)7);
        ButtonDto create = new ButtonDto();
        create.setButtonCode(Button.CREATE_OPERATE.getButtonCode());
        create.setButtonName(Button.CREATE_OPERATE.getButtonName());
        ButtonDto edit = new ButtonDto();
        edit.setButtonCode(Button.EDIT_OPERATE.getButtonCode());
        edit.setButtonName(Button.EDIT_OPERATE.getButtonName());
        ButtonDto delete = new ButtonDto();
        delete.setButtonCode(Button.DELETE_OPERATE.getButtonCode());
        delete.setButtonName(Button.DELETE_OPERATE.getButtonName());
        ButtonDto formImport = new ButtonDto();
        formImport.setButtonCode(Button.IMPORT_OPTION.getButtonCode());
        formImport.setButtonName(Button.IMPORT_OPTION.getButtonName());
        ButtonDto formExport = new ButtonDto();
        formExport.setButtonCode(Button.EXPORT_OPTION.getButtonCode());
        formExport.setButtonName(Button.EXPORT_OPTION.getButtonName());
        ButtonDto print = new ButtonDto();
        print.setButtonCode(Button.PRINT_OPERATE.getButtonCode());
        print.setButtonName(Button.PRINT_OPERATE.getButtonName());
        ButtonDto download = new ButtonDto();
        download.setButtonCode(Button.DOWNLOAD_OPERATE.getButtonCode());
        download.setButtonName(Button.DOWNLOAD_OPERATE.getButtonName());
        buttonDtos.add(create);
        buttonDtos.add(edit);
        buttonDtos.add(delete);
        buttonDtos.add(formImport);
        buttonDtos.add(formExport);
        buttonDtos.add(print);
        buttonDtos.add(download);
        buttonAuthoritiesDto.setButtonDtoList((List)buttonDtos);
    }

    @HussarTransactional
    public void upgradeForm(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) throws Exception {
        List<SysFormGroup> sysFormGroupList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "formGroups", SysFormGroup.class);
        Map formGroupIdMap = upgradeMappingDto.getFormGroupIdMap();
        if (HussarUtils.isNotEmpty(sysFormGroupList)) {
            for (SysFormGroup upgradeFormGroup : sysFormGroupList) {
                if (formGroupIdMap.containsKey(upgradeFormGroup.getId())) continue;
                Long oldFormGroupId = upgradeFormGroup.getId();
                upgradeFormGroup.setId(null);
                upgradeFormGroup.setAppId(appUpgradeDto.getCurrentAppId());
                this.sysFormGroupService.save((Object)upgradeFormGroup);
                this.appFormSyncService.syncFormGroup("add", upgradeFormGroup);
                Long newFormGroupId = upgradeFormGroup.getId();
                upgradeMappingDto.getFormGroupIdMap().put(oldFormGroupId, newFormGroupId);
            }
        }
        List<SysForm> upgradeFormList = AppIoUtil.readDataByKeyToList(appUpgradeDto.getPath(), "form", "forms", SysForm.class);
        Map formIdMap = upgradeMappingDto.getFormIdMap();
        if (HussarUtils.isNotEmpty(upgradeFormList)) {
            List upgradeFormIds = upgradeFormList.stream().map(SysForm::getId).collect(Collectors.toList());
            ApiResponse<List<SysForm>> sysFormByAppIdResp = this.getSysFormByAppId(appUpgradeDto.getCurrentAppId());
            List sysFormList = (List)sysFormByAppIdResp.getData();
            if (HussarUtils.isNotEmpty((Object)sysFormList)) {
                for (SysForm form : sysFormList) {
                    if (upgradeFormIds.contains(form.getId())) continue;
                    this.deleteForm(form.getId());
                }
            }
            for (SysForm upgradeForm : upgradeFormList) {
                if (formIdMap.containsKey(upgradeForm.getId())) {
                    SysForm currentForm = (SysForm)this.getById((Serializable)formIdMap.get(upgradeForm.getId()));
                    SysForm newForm = this.mergeForm(upgradeForm, currentForm, upgradeMappingDto);
                    this.updateById((BaseEntity)newForm);
                    continue;
                }
                SysForm newForm = this.processForm(upgradeForm, upgradeMappingDto);
                this.save((BaseEntity)newForm);
                SysFormDto sysFormDto = new SysFormDto();
                BeanUtils.copyProperties((Object)newForm, (Object)sysFormDto);
                this.initFormDevelopRole(sysFormDto);
            }
        }
    }

    public SysForm mergeForm(SysForm upgradeForm, SysForm currentForm, UpgradeMappingDto upgradeMappingDto) {
        currentForm.setFormName(upgradeForm.getFormName());
        currentForm.setFormIconType(upgradeForm.getFormIconType());
        currentForm.setFormIcon(upgradeForm.getFormIcon());
        currentForm.setFormIconColor(upgradeForm.getFormIconColor());
        if (!HussarUtils.equals((Object)upgradeForm.getFormType(), (Object)currentForm.getFormType())) {
            try {
                boolean convertSuccess = (Boolean)this.appFormService.convertForm(String.valueOf(currentForm.getId())).getData();
                if (convertSuccess) {
                    String formType = currentForm.getFormType();
                    String newFormType = HussarUtils.equals((Object)formType, (Object)"0") ? "1" : "0";
                    currentForm.setFormType(newFormType);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("\u5e94\u7528\u5347\u7ea7\u65f6\uff0c\u8868\u5355\u4e92\u8f6c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        upgradeMappingDto.getTableNameMap().put(upgradeForm.getTableName(), currentForm.getTableName());
        return currentForm;
    }

    public SysForm processForm(SysForm addForm, UpgradeMappingDto upgradeMappingDto) {
        addForm.setAppId(upgradeMappingDto.getCurrentAppId());
        long newFormId = IdWorker.getId((Object)addForm);
        upgradeMappingDto.getFormIdMap().put(addForm.getId(), newFormId);
        addForm.setId(Long.valueOf(newFormId));
        addForm.setFormGroupId((Long)upgradeMappingDto.getFormGroupIdMap().get(addForm.getFormGroupId()));
        if ("0".equals(addForm.getFormType()) || "1".equals(addForm.getFormType())) {
            String uid = HussarUtils.random((int)16, (RandomType)RandomType.INT);
            String pyIndexStr = PingYinUtil.getPYIndexStr((String)addForm.getFormName(), (boolean)true);
            if (pyIndexStr.length() > 6) {
                pyIndexStr = pyIndexStr.substring(0, 6);
            }
            String newTableName = pyIndexStr + "_" + uid;
            upgradeMappingDto.getTableNameMap().put(addForm.getTableName(), newTableName);
            addForm.setTableName(newTableName);
        }
        addForm.setCreator(NoCodeSecurityUtil.getUser().getId());
        addForm.setCreateTime(LocalDateTime.now());
        addForm.setLastEditor(NoCodeSecurityUtil.getUser().getId());
        addForm.setLastTime(LocalDateTime.now());
        return addForm;
    }

    @Transactional
    public ApiResponse<Boolean> editForm(SysFormDto sysFormDto) {
        Long formId = sysFormDto.getId();
        Long appId = sysFormDto.getAppId();
        String formName = sysFormDto.getFormName();
        String formType = sysFormDto.getFormType();
        if (HussarUtils.isEmpty((Object)formType)) {
            SysForm sysFormQuery = (SysForm)this.getById(formId);
            formType = sysFormQuery.getFormType();
        }
        if (HussarUtils.isNull((Object)appId) || HussarUtils.isEmpty((Object)formName)) {
            SysForm sysForm = (SysForm)this.getById(formId);
            if (HussarUtils.isEmpty((Object)sysForm)) {
                throw new BaseException("\u8868\u5355\u4e0d\u5b58\u5728");
            }
            appId = sysForm.getAppId();
            formName = sysForm.getFormName();
            sysFormDto.setAppId(appId);
        }
        if ("3".equals(sysFormDto.getFormType())) {
            sysFormDto.setTableName(sysFormDto.getExtname());
        }
        if ("2".equals(formType)) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"ENTRY_ID", (Object)formId);
            updateWrapper.set((Object)"ENTRY_NAME", (Object)formName);
            updateWrapper.set((Object)"ICON", (Object)sysFormDto.getFormIcon());
            updateWrapper.set((Object)"GROUP_ID", sysFormDto.getFormGroupId() == null ? null : sysFormDto.getFormGroupId().toString());
            this.dashEntryService.update((Wrapper)updateWrapper);
        } else {
            TransmittableThreadLocalHolder.set((String)"appId", (Object)appId);
            FormDesignResponse formCanvasSchemaFormDesignResponse = this.canvasSchemaService.get(String.valueOf(formId));
            FormCanvasSchema formCanvasSchema = (FormCanvasSchema)formCanvasSchemaFormDesignResponse.getData();
            TransmittableThreadLocalHolder.clear((String)"appId");
            if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
                formCanvasSchema.setTitle(formName);
                formCanvasSchema.setIcon(sysFormDto.getFormIcon());
                try {
                    this.canvasSchemaService.saveOrUpdate(formCanvasSchema);
                }
                catch (JsonProcessingException e) {
                    ToolUtil.getLogger(((Object)((Object)this)).getClass()).error("\u66f4\u65b0\u8868\u5355\u753b\u5e03 ==> Storage\u4fdd\u5b58\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)sysFormDto.getId());
                    throw new BaseException("\u66f4\u65b0\u753b\u5e03\u5931\u8d25");
                }
            }
        }
        boolean flag = this.updateById((BaseEntity)sysFormDto);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.appSyncService.syncForm("edit", (SysForm)sysFormDto);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteForm(Long formId) throws JsonProcessingException {
        Boolean flagFormLink;
        SysForm form = (SysForm)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formId));
        if ("0".equals(form.getFormType()) || "1".equals(form.getFormType())) {
            FormCanvasSchema formDesignResponse = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId)).getData();
            String identity = formDesignResponse.getIdentity();
            Long appId = form.getAppId();
            AppContextUtil.setAppId((String)String.valueOf(appId));
            Boolean delMid = (Boolean)this.formCleaner.formClean(String.valueOf(formId)).getData();
            if (!delMid.booleanValue()) {
                throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
            }
        } else if ("2".equals(form.getFormType())) {
            this.dashEntryService.deleteData(formId);
        }
        if (!(flagFormLink = this.sysFormLinkService.deleteAllForm(formId)).booleanValue()) {
            throw new BaseException("\u8868\u5355\u5916\u94fe\u76f8\u5173\u6570\u636e\u5220\u9664\u5931\u8d25");
        }
        boolean flag = this.removeById(formId);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.sysFormCheckConfigService.deleteFormCheckConfig(formId);
        this.deleteFormOtherAuthorityInfo(formId);
        this.sysCustomButtonService.deleteSysCustomButtonByFormId(formId);
        this.sysDataPullService.removeByFormId(formId);
        this.sysDataPullTaskService.removeByFormId(formId);
        this.sysDataPullRecordService.removeByFormId(formId);
        this.pushDataService.deleteByFormId(formId);
        this.formMapService.deleteByFormId(formId);
        this.pushDataRecordService.deleteByFormId(formId);
        this.formReferenceService.delReferenceByFormId(formId);
        SysForm sysForm = new SysForm();
        sysForm.setId(formId);
        this.appSyncService.syncForm("del", sysForm);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void deleteFormOtherAuthorityInfo(Long formId) {
        this.formAuthorizeRolesMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getFormId, (Object)formId));
        this.roleButtonMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId));
        this.roleFieldMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUpAppVisitRoleField::getFormId, (Object)formId));
        this.roleOrganDataAuthorityMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleOrganDataAuthority::getFormId, (Object)formId));
        List sysAppVisitDataLogics = this.dataLogicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogics)) {
            List logicIds = sysAppVisitDataLogics.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
            this.dataLogicMapper.deleteBatchIds(logicIds);
            this.dataLogicFilterMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, logicIds));
        }
    }

    public SysSiftGroupList getFormList(String formName, String formStatus, String formType, Long appId) {
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(formName, formStatus, null, formType, appId);
        ArrayList<SysFormGroupVo> sysFormGroups = new ArrayList();
        sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, null);
        if (HussarUtils.isEmpty(sysFormList)) {
            sysSiftGroupList.setHaveGroupList(JSONObject.parseArray((String)JSONObject.toJSONString(sysFormGroups), SysFormGroupVo.class));
            return sysSiftGroupList;
        }
        return this.combinedData(sysFormList, sysFormGroups);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthorityFormList(appId).getData();
        return this.getFormMenuListCommon(formIds, appId);
    }

    public ApiResponse<List<AppMenuVo>> getFormMenuList(Long userId, Long appId) {
        List formIds = (List)this.sysAppVisitFormAuthorizeRolesService.getAuthFormListByUserId(userId, appId).getData();
        return this.getFormMenuListCommon(formIds, appId);
    }

    private ApiResponse<List<AppMenuVo>> getFormMenuListCommon(List<Long> formIds, Long appId) {
        if (HussarUtils.isEmpty(formIds)) {
            return ApiResponse.success(new ArrayList(), (String)"\u6ca1\u6709\u53ef\u8bbf\u95ee\u7684\u83dc\u5355");
        }
        List<Object> sysFormGroups = new ArrayList();
        List<SysFormVo> sysFormList = this.sysFormMapper.getSysFormList(null, null, formIds, null, appId);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysForm sysForm : sysFormList) {
            groupIds.add(sysForm.getFormGroupId());
        }
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysFormGroups = this.sysFormGroupMapper.getSysFormGroupList(appId, groupIds);
        }
        ArrayList<AppMenuVo> resultList = new ArrayList<AppMenuVo>();
        for (SysFormGroupVo sysFormGroup : sysFormGroups) {
            AppMenuVo appMenuVo = new AppMenuVo();
            appMenuVo.setId(sysFormGroup.getId());
            appMenuVo.setSeq(sysFormGroup.getSeq().intValue());
            appMenuVo.setName(sysFormGroup.getGroupName());
            appMenuVo.setIcon(sysFormGroup.getGroupIcon());
            appMenuVo.setIconType(sysFormGroup.getGroupIconType());
            appMenuVo.setIconColor(sysFormGroup.getGroupIconColor());
            appMenuVo.setType("1");
            resultList.add(appMenuVo);
        }
        Map map = JSON.parseArray((String)JSON.toJSONString(resultList), AppMenuVo.class).stream().distinct().collect(Collectors.toMap(AppMenuVo::getId, AppMenuVo2 -> AppMenuVo2, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            AppMenuVo appMenuVo = (AppMenuVo)map.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)appMenuVo)) {
                AppMenuVo result = this.giveAppMenuVoProperty(sysForm);
                map.put(result.getId(), result);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)appMenuVo.getAppMenuVoList())) {
                appMenuVo.getAppMenuVoList().add(this.giveAppMenuVoProperty(sysForm));
            }
            if (!HussarUtils.isEmpty((Object)appMenuVo.getAppMenuVoList())) continue;
            ArrayList<AppMenuVo> menuVoList = new ArrayList<AppMenuVo>();
            menuVoList.add(this.giveAppMenuVoProperty(sysForm));
            appMenuVo.setAppMenuVoList(menuVoList);
        }
        return ApiResponse.success(new ArrayList(map.values()));
    }

    public ApiResponse<SysForm> getDetailById(Long formId) {
        return ApiResponse.success((Object)this.getById(formId));
    }

    public ApiResponse<SysFormVo> getFormDetailById(Long formId) {
        SysForm sysForm = (SysForm)this.getById(formId);
        if (HussarUtils.isNull((Object)sysForm)) {
            return ApiResponse.fail((IResultCode)LcdpExceptionEnum.FORM_NOT_FOUND);
        }
        SysFormVo sysFormVo = (SysFormVo)HussarUtils.copyProperties((Object)sysForm, SysFormVo.class);
        int convertVersion = this.sysFormConvertHistoryService.getConvertCount(formId);
        sysFormVo.setConvertVersion(convertVersion);
        return ApiResponse.success((Object)sysFormVo);
    }

    public ApiResponse<List<SysForm>> getSysFormByAppId(Long appId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysForm::getAppId, (Object)appId);
        return ApiResponse.success((Object)this.list((Wrapper)lambdaQueryWrapper));
    }

    public ApiResponse<List<SysAppFormTreeVo>> getAppFormList(Long appId) {
        ArrayList<SysAppFormTreeVo> treeList = new ArrayList<SysAppFormTreeVo>();
        SysApplication sysApplication = (SysApplication)this.applicationService.getById((Serializable)appId);
        SysAppFormTreeVo appTreeVo = new SysAppFormTreeVo();
        appTreeVo.setLabel(sysApplication.getAppName());
        appTreeVo.setId((Serializable)((Object)sysApplication.getId().toString()));
        appTreeVo.setHasChildren(Boolean.valueOf(true));
        appTreeVo.setIcon(sysApplication.getAppIcon());
        appTreeVo.setIconType(sysApplication.getAppIconType());
        appTreeVo.setIconColor(sysApplication.getAppIconColor());
        appTreeVo.setType(1);
        treeList.add(appTreeVo);
        LambdaQueryWrapper formWrapper = Wrappers.lambdaQuery();
        formWrapper.eq(HussarUtils.isNotEmpty((Object)appId), SysFormGroup::getAppId, (Object)appId);
        formWrapper.orderByAsc(SysFormGroup::getSeq);
        List formGroupList = this.sysFormGroupMapper.selectList((Wrapper)formWrapper);
        for (SysFormGroup sysFormGroup : formGroupList) {
            SysAppFormTreeVo formGroupTreeVo = new SysAppFormTreeVo();
            formGroupTreeVo.setId((Serializable)((Object)sysFormGroup.getId().toString()));
            formGroupTreeVo.setLabel(sysFormGroup.getGroupName());
            formGroupTreeVo.setParentId((Serializable)((Object)sysFormGroup.getAppId().toString()));
            formGroupTreeVo.setIcon(sysFormGroup.getGroupIcon());
            formGroupTreeVo.setIconType(sysFormGroup.getGroupIconType());
            formGroupTreeVo.setIconColor(sysFormGroup.getGroupIconColor());
            formGroupTreeVo.setType(2);
            treeList.add(formGroupTreeVo);
        }
        LambdaQueryWrapper queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(HussarUtils.isNotEmpty((Object)appId), SysForm::getAppId, (Object)appId);
        queryWrapper2.orderByAsc(SysForm::getSeq);
        List formList = this.list((Wrapper)queryWrapper2);
        for (SysForm sysForm : formList) {
            SysAppFormTreeVo formTreeVo = new SysAppFormTreeVo();
            formTreeVo.setId((Serializable)((Object)sysForm.getId().toString()));
            formTreeVo.setLabel(sysForm.getFormName());
            if (HussarUtils.isEmpty((Object)sysForm.getFormGroupId())) {
                formTreeVo.setParentId((Serializable)((Object)sysForm.getAppId().toString()));
            } else {
                formTreeVo.setParentId((Serializable)((Object)sysForm.getFormGroupId().toString()));
            }
            formTreeVo.setIcon(sysForm.getFormIcon());
            formTreeVo.setIconType(sysForm.getFormIconType());
            formTreeVo.setIconColor(sysForm.getFormIconColor());
            formTreeVo.setType(3);
            formTreeVo.setFormType(sysForm.getFormType());
            treeList.add(formTreeVo);
        }
        return ApiResponse.success((Object)HussarTreeParser.getTreeList(treeList));
    }

    public ApiResponse<List<FieldVo>> getFormField(Long formId, String appId) {
        try {
            List widgetFields = (List)this.formOperateExposedService.widgets(formId.toString(), appId).getData();
            ArrayList<FieldVo> fieldVos = new ArrayList<FieldVo>();
            if (HussarUtils.isNotEmpty((Object)widgetFields)) {
                for (WidgetField widgetField : widgetFields) {
                    FieldVo fieldVo = new FieldVo();
                    fieldVo.setFieldId(widgetField.getName());
                    fieldVo.setFieldName(widgetField.getTitle());
                    fieldVo.setType(widgetField.getType());
                    fieldVo.setUsage(widgetField.getUsage());
                    fieldVo.setDataType(widgetField.getDataType());
                    fieldVo.setRealField(widgetField.getIsRealField());
                    fieldVo.setProps(widgetField.getProps());
                    if (HussarUtils.isNotEmpty((Object)widgetField.getChildren())) {
                        ArrayList fieldVosChildren = Lists.newArrayListWithCapacity((int)10);
                        widgetField.getChildren().forEach(c -> {
                            FieldVo cT = new FieldVo();
                            cT.setFieldId(c.getName());
                            cT.setFieldName(widgetField.getTitle() + "." + c.getTitle());
                            cT.setType(c.getType());
                            cT.setUsage(c.getUsage());
                            cT.setDataType(c.getDataType());
                            cT.setRealField(c.getIsRealField());
                            cT.setProps(c.getProps());
                            fieldVosChildren.add(cT);
                        });
                        fieldVo.setChildren((List)fieldVosChildren);
                    }
                    fieldVos.add(fieldVo);
                }
            }
            return ApiResponse.success(fieldVos);
        }
        catch (Exception e) {
            throw new BaseException("\u83b7\u53d6\u8868\u5355\u5185\u5b57\u6bb5\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public SysSiftGroupList combinedData(List<SysFormVo> sysFormList, List<SysFormGroupVo> sysFormGroups) {
        ArrayList<SysForm> noGroupList = new ArrayList<SysForm>();
        SysSiftGroupList sysSiftGroupList = new SysSiftGroupList();
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysFormGroups), SysFormGroupVo.class).stream().distinct().collect(Collectors.toMap(SysFormGroup::getId, sysFormGroupVo -> sysFormGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysForm sysForm : sysFormList) {
            SysFormGroupVo sysFormGroupVo2 = (SysFormGroupVo)resultCollect.get(sysForm.getFormGroupId());
            if (HussarUtils.isEmpty((Object)sysFormGroupVo2)) {
                noGroupList.add(sysForm);
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)sysFormGroupVo2.getSysFormList())) {
                sysFormGroupVo2.getSysFormList().add(sysForm);
            }
            if (!HussarUtils.isEmpty((Object)sysFormGroupVo2.getSysFormList())) continue;
            ArrayList<SysForm> formGroupList = new ArrayList<SysForm>();
            formGroupList.add(sysForm);
            sysFormGroupVo2.setSysFormList(formGroupList);
        }
        sysSiftGroupList.setHaveGroupList(new ArrayList(resultCollect.values()));
        sysSiftGroupList.setNoGroupList(noGroupList);
        return sysSiftGroupList;
    }

    private AppMenuVo giveAppMenuVoProperty(SysForm sysForm) {
        AppMenuVo trans = new AppMenuVo();
        trans.setId(sysForm.getId());
        trans.setSeq(sysForm.getSeq());
        trans.setName(sysForm.getFormName());
        trans.setIcon(sysForm.getFormIcon());
        trans.setIconType(sysForm.getFormIconType());
        trans.setIconColor(sysForm.getFormIconColor());
        trans.setFormType(sysForm.getFormType());
        trans.setTableName(sysForm.getTableName());
        trans.setStatus(sysForm.getFormStatus());
        trans.setType("2");
        return trans;
    }

    public List<SysForm> getFormsByAppIds(List<Long> appIds) {
        return this.list((Wrapper)new LambdaQueryWrapper().in(SysForm::getAppId, appIds));
    }

    public ApiResponse<String> addLogicalDeleteAndModifyPrimaryKey(String formIds) {
        List sysForms = null;
        if (StringUtils.isNotBlank((CharSequence)formIds)) {
            String[] split = formIds.split(",");
            List _formIds = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            sysForms = this.sysFormMapper.selectBatchIds(_formIds);
        } else {
            sysForms = this.sysFormMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysForm::getFormStatus, (Object)"0")).ne(SysForm::getFormType, (Object)"3"));
        }
        ArrayList retrySysForms = new ArrayList();
        int total = sysForms.size();
        AtomicInteger deal = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        AtomicInteger success = new AtomicInteger();
        CountDownLatch countDownLatch = new CountDownLatch(total);
        RequestContextHolder.resetRequestAttributes();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        sysForms.forEach(sysForm -> executor.execute(() -> {
            deal.getAndIncrement();
            if (!this.republish((SysForm)sysForm)) {
                retrySysForms.add(sysForm);
                fail.incrementAndGet();
            } else {
                success.incrementAndGet();
            }
            countDownLatch.countDown();
            this.LOGGER.info("\u603b\u5171\uff1a{}, \u5df2\u5904\u7406\uff1a{}, \u6210\u529f: {}, \u5931\u8d25\uff1a{}", new Object[]{total, deal.get(), success.get(), fail.get()});
        }));
        try {
            countDownLatch.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            this.LOGGER.error("\u5237\u65b0\u8868\u5355\u5f02\u5e38", (Throwable)e);
        }
        int retryTimes = 0;
        while (retrySysForms.size() > 0 && retryTimes <= 2 && this.saveCanvas) {
            this.LOGGER.info("\u5237\u65b0\u8868\u5355\uff0c\u91cd\u8bd5\u7b2c{}\u6b21\uff0c\u6570\u91cf\uff1a{}", (Object)(++retryTimes), (Object)retrySysForms.size());
            Iterator iterator = retrySysForms.iterator();
            while (iterator.hasNext()) {
                SysForm next = (SysForm)iterator.next();
                if (!this.republish(next)) continue;
                success.incrementAndGet();
                fail.decrementAndGet();
                iterator.remove();
            }
        }
        if (retrySysForms.size() > 0) {
            List failedFormIds = retrySysForms.stream().map(SysForm::getId).collect(Collectors.toList());
            this.LOGGER.info("\u5237\u65b0\u8868\u5355\u91cd\u8bd5{}\u6b21\u540e\uff0c\u5931\u8d25\u8868\u5355\u6570\u91cf\uff1a{}, formIds: {}", new Object[]{retryTimes, retrySysForms.size(), StringUtil.join(failedFormIds, (String)",")});
        }
        return ApiResponse.success((String)org.pf4j.util.StringUtils.format((String)"\u603b\u5171\u8868\u5355\u6570\uff1a%s, \u5904\u7406\u8868\u5355\u6570\uff1a%s, \u6210\u529f\u6570\uff1a%s, \u5931\u8d25\u6570\uff1a%s", (Object[])new Object[]{total, deal, success, fail}));
    }

    private boolean republish(SysForm sysForm) {
        if ("3".equals(sysForm.getFormType())) {
            return true;
        }
        try {
            TableInfoDto tableInfoDto;
            Optional<MetadataColumn> columnOptional;
            Optional<Widget> first;
            AppContextUtil.setAppId((String)sysForm.getAppId().toString());
            FormCanvasSchema oldCanvas = (FormCanvasSchema)this.canvasSchemaService.get(sysForm.getId().toString()).getData();
            if (this.saveCanvas && !(first = oldCanvas.widgets().stream().filter(widget -> "primary".equals(widget.getUsage()) && "RECORD_ID".equals(widget.getName())).findFirst()).isPresent()) {
                FormCanvasSchema newCanvas = new FormCanvasSchema();
                BeanUtils.copyProperties((Object)oldCanvas, (Object)newCanvas);
                newCanvas.setVersion(oldCanvas.getVersion() + 1);
                FormDesignResponse saveCanvasResponse = this.canvasService.saveCanvas(newCanvas);
                if (!((Boolean)saveCanvasResponse.getData()).booleanValue()) {
                    AppContextUtil.setAppId(null);
                    return false;
                }
            }
            if ((columnOptional = (tableInfoDto = this.hussarMetadataService.getTableInfoByName(sysForm.getTableName())).getColumnList().stream().filter(metadataColumn -> sysForm.getTableName().equals(metadataColumn.getColumnName())).findAny()).isPresent()) {
                this.formOperate.modifyBusinessTablePrimaryKey(sysForm, tableInfoDto.getPollName());
                List childTables = oldCanvas.childTables();
                for (Widget childTable : childTables) {
                    String subTableName = childTable.getName().toUpperCase();
                    this.formOperate.modifySubBusinessTablePrimaryKey(subTableName, sysForm.getTableName(), tableInfoDto.getPollName());
                }
            }
            AppContextUtil.setAppId(null);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.error("\u8868\u5355[{} - {}]\u66f4\u65b0\u5931\u8d25, \u5931\u8d25\u539f\u56e0: {}", new Object[]{sysForm.getId(), sysForm.getTableName(), e.toString(), e});
            return false;
        }
    }

    public String getTableNameById(Long formId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formId);
        return ((SysForm)this.getOne((Wrapper)queryWrapper)).getTableName();
    }

    public SysSiftGroupListWithAuth getFormListWithAuth(String formName, String formStatus, Long appId, Long roleId) {
        SysSiftGroupListWithAuth sysSiftGroupListWithAuth = new SysSiftGroupListWithAuth();
        SysSiftGroupList formList = this.getFormList(formName, formStatus, null, appId);
        FormAuthorityMap formAuthorityMap = new FormAuthorityMap();
        formAuthorityMap.setButtonAuthorityMap(this.sysAppVisitRoleButtonService.listButtonAuthorityByAppId(appId, roleId));
        formAuthorityMap.setOrganDataAuthorityMap(this.sysAppVisitRoleOrganDataAuthorityService.listOrganDataAuthorityByAppId(appId, roleId));
        formAuthorityMap.setDataLogicAuthorityMap(this.sysAppVisitDataLogicService.listDataLogicAuthorityByAppId(appId, roleId));
        formAuthorityMap.setFieldAuthorityMap(this.sysUpAppVisitRoleFieldService.listFieldAuthorityByAppId(appId, roleId));
        formAuthorityMap.setFormAuthorizedMap(this.sysAppVisitFormAuthorizeRolesService.listFormAuthorizedByAppId(appId, roleId));
        sysSiftGroupListWithAuth.setNoGroupList(this.addAuthority4Form(formAuthorityMap, formList.getNoGroupList()));
        List<SysFormGroupWithAuthVo> groupListWithAuth = this.addAuthority4Group(formAuthorityMap, formList.getHaveGroupList());
        sysSiftGroupListWithAuth.setHaveGroupList(groupListWithAuth);
        return sysSiftGroupListWithAuth;
    }

    private List<SysFormGroupWithAuthVo> addAuthority4Group(FormAuthorityMap formAuthorityMap, List<SysFormGroupVo> sysFormGroupList) {
        ArrayList<SysFormGroupWithAuthVo> groupListWithAuth = new ArrayList<SysFormGroupWithAuthVo>();
        sysFormGroupList.forEach(sysFormGroup -> {
            SysFormGroupWithAuthVo sysFormGroupWithAuthVo = new SysFormGroupWithAuthVo();
            BeanUtil.copyProperties((Object)sysFormGroup, (Object)sysFormGroupWithAuthVo);
            sysFormGroupWithAuthVo.setSysFormList(this.addAuthority4Form(formAuthorityMap, sysFormGroup.getSysFormList()));
            groupListWithAuth.add(sysFormGroupWithAuthVo);
        });
        return groupListWithAuth;
    }

    private List<SysFormWithAuthVo> addAuthority4Form(FormAuthorityMap formAuthorityMap, List<SysForm> sysFormList) {
        if (HussarUtils.isEmpty(sysFormList)) {
            return new ArrayList<SysFormWithAuthVo>();
        }
        return sysFormList.stream().map(form -> {
            SysFormWithAuthVo formWithAuthVo = new SysFormWithAuthVo();
            Long formId = form.getId();
            BeanUtil.copyProperties((Object)form, (Object)formWithAuthVo);
            formWithAuthVo.setButtonAuthorities((List)formAuthorityMap.getButtonAuthorityMap().get(formId));
            formWithAuthVo.setFieldAuthority((FieldAuthWithStatusVo)formAuthorityMap.getFieldAuthorityMap().get(formId));
            formWithAuthVo.setOrganDataAuthority((OrganDataAuthorityVo)formAuthorityMap.getOrganDataAuthorityMap().get(formId));
            formWithAuthVo.setDataLogicAuthority((DataLogicAuthorityVo)formAuthorityMap.getDataLogicAuthorityMap().get(formId));
            formWithAuthVo.setAuthorized(HussarUtils.isNotEmpty(formAuthorityMap.getFormAuthorizedMap().get(formId)));
            return formWithAuthVo;
        }).collect(Collectors.toList());
    }
}

