/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersion;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppPackageService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeExecuteService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.util.AppUpgradeUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppUpgradeExecuteServiceImpl
implements IAppUpgradeExecuteService {
    @Resource
    private IAppUpgradeInfoService iAppUpgradeInfoService;
    @Resource
    private IAppPackageService appPackageService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private AppFileExtendService appFileExtendService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpgradeExecuteServiceImpl.class);

    @Async
    public void executeUpgradeProcess(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto, String upgradeTaskId) {
        try {
            TransmittableThreadLocalHolder.set((String)"upgradeCacheKey", (Object)upgradeTaskId);
            this.handleFirstUpgrade(appUpgradeDto);
            this.iAppUpgradeInfoService.upgradeApp(appUpgradeDto, upgradeMappingDto);
            this.iAppUpgradeInfoService.upgradeForm(appUpgradeDto, upgradeMappingDto);
            this.iAppUpgradeInfoService.upgradeMidFile(appUpgradeDto, upgradeMappingDto);
            this.iAppUpgradeInfoService.upgradeExtension(appUpgradeDto, upgradeMappingDto);
            this.iAppUpgradeInfoService.constructTable(appUpgradeDto, upgradeMappingDto);
            this.iAppUpgradeInfoService.upgradeFlow(appUpgradeDto, upgradeMappingDto);
        }
        catch (Exception e) {
            LOGGER.error("\u5e94\u7528\u5347\u7ea7\u5931\u8d25!", (Throwable)e);
        }
    }

    public void handleFirstUpgrade(AppUpgradeDto appUpgradeDto) {
        Long appId;
        if (appUpgradeDto.isCrossPublish()) {
            return;
        }
        ISysApplicationVersionService sysApplicationVersionService = (ISysApplicationVersionService)SpringContextUtil.getBean(ISysApplicationVersionService.class);
        SysApplicationVersion currentAppVersion = Optional.ofNullable(sysApplicationVersionService.getCurrentAppVersion(appId = appUpgradeDto.getCurrentAppId())).map(ApiResponse::getData).map(version -> (SysApplicationVersion)BeanUtil.copy((Object)version, SysApplicationVersion.class)).orElseThrow(() -> new HussarException("\u5e94\u7528\u5f53\u524d\u7248\u672c\u67e5\u8be2\u5931\u8d25"));
        if (HussarUtils.isNotEmpty((Object)currentAppVersion) && HussarUtils.isEmpty((Object)currentAppVersion.getPackagePath())) {
            Long appPackageId = this.appPackageService.packageApp(appId, Boolean.FALSE.booleanValue());
            AttachmentManagerModelVo appPackage = this.attachmentManagerService.getByFileId(appPackageId);
            String packagePath = null;
            try {
                packagePath = this.appFileExtendService.fileDecrypt(appPackage.getPath());
            }
            catch (Exception e) {
                LOGGER.error("\u5e94\u7528\u5305\u89e3\u6790\u5931\u8d25!", (Throwable)e);
            }
            currentAppVersion.setPackagePath(packagePath);
            HashMap<String, Map> upgradeMapping = new HashMap<String, Map>();
            upgradeMapping.put("formGroupIdMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getFormGroupIdMap()));
            upgradeMapping.put("formIdMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getFormIdMap()));
            upgradeMapping.put("subTableNameMap", AppUpgradeUtil.valueToKey(appUpgradeDto.getSubTableNameMap()));
            currentAppVersion.setUpgradeMapping(JSON.toJSONString(upgradeMapping));
            sysApplicationVersionService.updateById((Object)currentAppVersion);
        }
    }
}

