/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppAuthRoleService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAuthRoleVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AuthRoleVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.RoleGroupTreeVo;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.AppAuthRoleServiceImpl")
@HussarTokenDs
public class AppAuthRoleServiceImpl
implements IAppAuthRoleService {
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppAuthorizeService appAuthService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private ISysRolesExternalService roleService;
    @Resource
    private ISysRolesExternalService roleGroupService;
    @Resource
    private GodAxeMigrationService flowService;

    public ApiResponse<AppAuthRoleVo> getAppAuthRoles(Long appId) {
        AppAuthRoleVo appAuthRoleVo = new AppAuthRoleVo();
        appAuthRoleVo.setAppAuthRoles(this.getAppRoles(appId));
        appAuthRoleVo.setFormAuthRoles(this.getFormRoles(appId));
        appAuthRoleVo.setFlowAuthRoles(this.getFlowRoleTree(appId));
        return ApiResponse.success((Object)appAuthRoleVo);
    }

    public AppAuthRoleVo getAppAuthRoleTree(List<Long> appAuthRoleIds, List<Long> formAuthRoleIds, List<Long> flowAuthRoleIds) {
        AppAuthRoleVo appAuthRoleVo = new AppAuthRoleVo();
        appAuthRoleVo.setAppAuthRoles(this.getAuthRoleVo(appAuthRoleIds));
        appAuthRoleVo.setFormAuthRoles(this.getAuthRoleVo(formAuthRoleIds));
        appAuthRoleVo.setFlowAuthRoles(this.getAuthRoleVo(flowAuthRoleIds));
        return appAuthRoleVo;
    }

    private AuthRoleVo getAppRoles(Long appId) {
        Long developRoleId = ((SysApplication)this.applicationService.getById((Serializable)appId)).getDevelopRoleId();
        List sysAppAuthorizes = this.appAuthService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthorize::getAppId, (Object)appId)).eq(SysAppAuthorize::getAuthorizationType, (Object)"2")).ne(SysAppAuthorize::getRoleId, (Object)developRoleId));
        List<Long> roleIds = sysAppAuthorizes.stream().map(SysAppAuthorize::getRoleId).collect(Collectors.toList());
        return this.getAuthRoleVo(roleIds);
    }

    private AuthRoleVo getFormRoles(Long appId) {
        Long developRoleId = ((SysApplication)this.applicationService.getById((Serializable)appId)).getDevelopRoleId();
        List formAuthRoles = this.formAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId)).ne(SysAppVisitFormAuthorizeRoles::getRoleId, (Object)developRoleId));
        List<Long> roleIds = formAuthRoles.stream().map(SysAppVisitFormAuthorizeRoles::getRoleId).collect(Collectors.toList());
        return this.getAuthRoleVo(roleIds);
    }

    private AuthRoleVo getFlowRoleTree(Long appId) {
        List flowRoleIds = this.flowService.queryRoleIdList(appId);
        return this.getAuthRoleVo(flowRoleIds);
    }

    private AuthRoleVo getAuthRoleVo(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return null;
        }
        AuthRoleVo authRoleVo = new AuthRoleVo();
        List roles = this.roleService.getRolesByIds(roleIds);
        List roleGroupIds = roles.stream().map(SysRoles::getGroupId).collect(Collectors.toList());
        List roleGroups = this.roleGroupService.selectRoleGroupByIds(roleGroupIds);
        ArrayList<RoleVo> roleVos = new ArrayList<RoleVo>();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            SysRoles sysRole = (SysRoles)iterator.next();
            if (!ToolUtil.isEmpty((Object)sysRole.getGroupId())) continue;
            RoleVo roleVo = new RoleVo();
            BeanUtils.copyProperties((Object)sysRole, (Object)roleVo);
            roleVos.add(roleVo);
            iterator.remove();
        }
        ArrayList<RoleGroupTreeVo> roleGroupTreeVos = new ArrayList<RoleGroupTreeVo>();
        for (SysRoleGroup sysRoleGroup : roleGroups) {
            RoleGroupTreeVo roleGroupTreeVo = new RoleGroupTreeVo();
            BeanUtils.copyProperties((Object)sysRoleGroup, (Object)roleGroupTreeVo);
            ArrayList<RoleVo> roleVos1 = new ArrayList<RoleVo>();
            Iterator iterator1 = roles.iterator();
            while (iterator1.hasNext()) {
                SysRoles sysRole = (SysRoles)iterator1.next();
                if (!ToolUtil.equals((Object)sysRole.getGroupId(), (Object)sysRoleGroup.getId())) continue;
                RoleVo roleVo1 = new RoleVo();
                BeanUtils.copyProperties((Object)sysRole, (Object)roleVo1);
                roleVos1.add(roleVo1);
                iterator1.remove();
            }
            roleGroupTreeVo.setRoles(roleVos1);
            roleGroupTreeVos.add(roleGroupTreeVo);
        }
        authRoleVo.setRoleVos(roleVos);
        authRoleVo.setRoleGroupVos(roleGroupTreeVos);
        return authRoleVo;
    }
}

