/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleTriggerType;
import com.jxdinfo.hussar.formdesign.app.frame.api.util.TriggerVerify;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.message.dao.SysMsgPushTaskMapper;
import com.jxdinfo.hussar.formdesign.application.message.enums.ReminderType;
import com.jxdinfo.hussar.formdesign.application.message.middle.EndReminderTime;
import com.jxdinfo.hussar.formdesign.application.message.middle.FirstReminderTime;
import com.jxdinfo.hussar.formdesign.application.message.middle.ReminderConfig;
import com.jxdinfo.hussar.formdesign.application.message.middle.ReminderContent;
import com.jxdinfo.hussar.formdesign.application.message.middle.RepeatRule;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushConfig;
import com.jxdinfo.hussar.formdesign.application.message.model.SysMsgPushTask;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushTaskService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.generator.nocode.tool.BuilderTool;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.TitleSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaTitleRule;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.message.service.impl.sysMsgPushTaskServiceImpl")
public class SysMsgPushTaskServiceImpl
extends HussarServiceImpl<SysMsgPushTaskMapper, SysMsgPushTask>
implements SysMsgPushTaskService {
    @Resource
    private SysMsgPushTaskMapper messagePushTaskMapper;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private FormOperateService formOperateService;
    private static final Logger LOGGER = LoggerFactory.getLogger(SysMsgPushTaskServiceImpl.class);

    @Async
    public void asyncGenerateTaskBySaveConfig(SysMsgPushConfig sysMsgPushConfig) {
        ArrayList<SysMsgPushTask> sysMsgPushTasks = new ArrayList<SysMsgPushTask>();
        ReminderType reminderType = ReminderType.valueOfType(sysMsgPushConfig.getReminderType());
        switch (reminderType) {
            case FORM_FIELD: {
                ResponseEntity tableQueryAllResult = this.formOperateExposedService.tableQueryAll(String.valueOf(sysMsgPushConfig.getAppId()), String.valueOf(sysMsgPushConfig.getFormId()));
                List data = ((PageVo)((ApiResponse)Objects.requireNonNull(tableQueryAllResult.getBody())).getData()).getData();
                List businessDataList = JSONArray.parseArray((String)JSON.toJSONString((Object)data), JSONObject.class);
                if (!HussarUtils.isNotEmpty((Object)businessDataList)) break;
                for (JSONObject businessData : businessDataList) {
                    SysMsgPushTask sysMsgPushTask = this.parseConfig(sysMsgPushConfig, businessData);
                    if (!HussarUtils.isNotEmpty((Object)sysMsgPushTask)) continue;
                    sysMsgPushTasks.add(sysMsgPushTask);
                }
                break;
            }
            case CUSTOM_TIME: {
                SysMsgPushTask sysMsgPushTask = this.parseConfig(sysMsgPushConfig, null);
                sysMsgPushTasks.add(sysMsgPushTask);
            }
        }
        if (HussarUtils.isNotEmpty(sysMsgPushTasks)) {
            this.saveBatch(sysMsgPushTasks);
        }
    }

    public void asyncGenerateTaskByDataChange(Long formId, JSONObject businessData, String changeType) {
        ArrayList sysMsgPushConfigs = new ArrayList();
        ArrayList<SysMsgPushTask> sysMsgPushTasks = new ArrayList<SysMsgPushTask>();
        SysMsgPushConfigService sysMsgPushConfigService = (SysMsgPushConfigService)SpringUtil.getBean(SysMsgPushConfigService.class);
        if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeCreate.getType())) {
            List insertConfigs = sysMsgPushConfigService.listByFormIdAndTriggerType(formId, ReminderType.INSERT_DATA.getValue());
            sysMsgPushConfigs.addAll(insertConfigs);
            List formConfigs = sysMsgPushConfigService.listByFormIdAndTriggerType(formId, ReminderType.FORM_FIELD.getValue());
            sysMsgPushConfigs.addAll(formConfigs);
        } else if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeUpdate.getType())) {
            List updateConfigs = sysMsgPushConfigService.listByFormIdAndTriggerType(formId, ReminderType.UPDATE_DATA.getValue());
            sysMsgPushConfigs.addAll(updateConfigs);
            String tableName = this.sysFormService.getTableNameById(formId);
            Long dataId = Long.valueOf(businessData.getString(tableName));
            List<Long> dataIds = Collections.singletonList(dataId);
            this.removeByFormIdAndDataIds(formId, dataIds);
            List formConfigs = sysMsgPushConfigService.listByFormIdAndTriggerType(formId, ReminderType.FORM_FIELD.getValue());
            sysMsgPushConfigs.addAll(formConfigs);
        } else if (changeType.equals(NoCodeRuleTriggerType.TriggerTypeDelete.getType())) {
            Long dataId = Long.valueOf(businessData.getString("RECORD_ID"));
            List<Long> dataIds = Collections.singletonList(dataId);
            this.removeByFormIdAndDataIds(formId, dataIds);
        }
        if (HussarUtils.isNotEmpty(sysMsgPushConfigs)) {
            for (SysMsgPushConfig sysMsgPushConfig : sysMsgPushConfigs) {
                SysMsgPushTask sysMsgPushTask = this.parseConfig(sysMsgPushConfig, businessData);
                if (!HussarUtils.isNotEmpty((Object)sysMsgPushTask)) continue;
                sysMsgPushTasks.add(sysMsgPushTask);
            }
            this.saveBatch(sysMsgPushTasks);
        }
    }

    public List<SysMsgPushTask> queryMsgPushTasks(LocalDateTime currentTime) {
        LocalDateTime startTime = currentTime.minusSeconds(20L);
        return this.messagePushTaskMapper.queryMsgPushTasks(startTime, currentTime);
    }

    public void removeByFormIdAndDataIds(Long formId, List<Long> dataIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushTask::getFormId, (Object)formId)).in(SysMsgPushTask::getDataId, dataIds)).eq(SysMsgPushTask::getReminderType, (Object)ReminderType.FORM_FIELD.getValue())).eq(SysMsgPushTask::getStatus, (Object)"0");
        this.remove((Wrapper)queryWrapper);
    }

    public void removeByConfigId(Long configId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMsgPushTask::getConfigId, (Object)configId)).eq(SysMsgPushTask::getStatus, (Object)"0");
        this.remove((Wrapper)queryWrapper);
    }

    private SysMsgPushTask parseConfig(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        SysMsgPushTask sysMsgPushTask = new SysMsgPushTask();
        boolean meetConditionFlag = this.checkWhetherMetReminderCondition(sysMsgPushConfig, businessData);
        if (!meetConditionFlag) {
            return null;
        }
        LocalDateTime now = LocalDateTime.now();
        ReminderType reminderType = ReminderType.valueOfType(sysMsgPushConfig.getReminderType());
        switch (reminderType) {
            case INSERT_DATA: 
            case UPDATE_DATA: {
                this.handleCommonPart(sysMsgPushConfig, businessData, sysMsgPushTask);
                sysMsgPushTask.setFirstReminderTime(now);
                sysMsgPushTask.setRepeatRule(JSON.toJSONString((Object)new RepeatRule("only_once")));
                sysMsgPushTask.setNextReminderTime(this.handleNextReminderTime(sysMsgPushTask, now));
                break;
            }
            case FORM_FIELD: 
            case CUSTOM_TIME: {
                this.handleCommonPart(sysMsgPushConfig, businessData, sysMsgPushTask);
                LocalDateTime firstReminderTime = this.handleFirstReminderTime(sysMsgPushConfig, businessData);
                if (HussarUtils.isEmpty((Object)firstReminderTime)) {
                    return null;
                }
                sysMsgPushTask.setFirstReminderTime(firstReminderTime);
                sysMsgPushTask.setRepeatRule(sysMsgPushConfig.getRepeatRule());
                sysMsgPushTask.setEndReminderTime(this.handleEndReminderTime(sysMsgPushConfig, sysMsgPushTask));
                LocalDateTime nextReminderTime = this.handleNextReminderTime(sysMsgPushTask, now);
                if (HussarUtils.isEmpty((Object)nextReminderTime)) {
                    return null;
                }
                sysMsgPushTask.setNextReminderTime(nextReminderTime);
            }
        }
        return sysMsgPushTask;
    }

    private boolean checkWhetherMetReminderCondition(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        JSONObject reminderCondition;
        List conditions;
        if (HussarUtils.isNotEmpty((Object)sysMsgPushConfig.getReminderCondition()) && HussarUtils.isNotEmpty((Object)(conditions = JSON.parseArray((String)(reminderCondition = JSON.parseObject((String)sysMsgPushConfig.getReminderCondition())).getString("cond"), JSONObject.class)))) {
            try {
                return TriggerVerify.conditionVerify((JSONObject)businessData, (String)sysMsgPushConfig.getReminderCondition(), (String)String.valueOf(sysMsgPushConfig.getFormId()), (String)"");
            }
            catch (Exception e) {
                throw new HussarException("\u6d88\u606f\u63a8\u9001 => \u6821\u9a8c\u63d0\u9192\u6761\u4ef6\u5931\u8d25");
            }
        }
        return true;
    }

    private void handleCommonPart(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData, SysMsgPushTask sysMsgPushTask) {
        sysMsgPushTask.setAppId(sysMsgPushConfig.getAppId());
        sysMsgPushTask.setFormId(sysMsgPushConfig.getFormId());
        sysMsgPushTask.setConfigId(sysMsgPushConfig.getId());
        if (HussarUtils.isNotEmpty((Object)businessData)) {
            sysMsgPushTask.setDataId(this.handleDataId(sysMsgPushConfig, businessData));
        }
        sysMsgPushTask.setReminderType(sysMsgPushConfig.getReminderType());
        sysMsgPushTask.setReminderContent(this.handleReminderContent(sysMsgPushConfig, businessData));
        sysMsgPushTask.setReminders(this.handelReminders(sysMsgPushConfig, businessData));
        sysMsgPushTask.setReminderMode(sysMsgPushConfig.getReminderMode());
        sysMsgPushTask.setStatus("0");
    }

    private Long handleDataId(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        String tableName = this.sysFormService.getTableNameById(sysMsgPushConfig.getFormId());
        return Long.valueOf(businessData.getString(tableName));
    }

    private LocalDateTime handleFirstReminderTime(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        LocalDateTime firstReminderTime = null;
        FirstReminderTime firstReminderTimeConfig = (FirstReminderTime)JSON.parseObject((String)sysMsgPushConfig.getFirstReminderTime(), FirstReminderTime.class);
        ReminderType reminderType = ReminderType.valueOfType(sysMsgPushConfig.getReminderType());
        block0 : switch (reminderType) {
            case FORM_FIELD: {
                String fieldName = firstReminderTimeConfig.getFieldName();
                LocalDateTime fieldValue = (LocalDateTime)businessData.getObject(fieldName, LocalDateTime.class);
                if (HussarUtils.isEmpty((Object)fieldValue)) {
                    return null;
                }
                String fieldType = firstReminderTimeConfig.getFieldType();
                if ("yyyy-MM".equals(fieldType)) {
                    LocalTime time = LocalTime.parse(firstReminderTimeConfig.getTime());
                    fieldValue = fieldValue.withDayOfMonth(1).with(time);
                } else if ("yyyy-MM-dd".equals(fieldType)) {
                    LocalTime localTime = LocalTime.parse(firstReminderTimeConfig.getTime());
                    fieldValue = fieldValue.with(localTime);
                }
                String offsetType = firstReminderTimeConfig.getOffsetType();
                int offsetValue = firstReminderTimeConfig.getOffsetValue();
                String offsetUnit = firstReminderTimeConfig.getOffsetUnit();
                if (offsetType.equals("today") || offsetType.equals("moment")) {
                    firstReminderTime = fieldValue;
                    break;
                }
                if (!offsetType.equals("before") && !offsetType.equals("after")) break;
                offsetValue = offsetType.equals("before") ? -offsetValue : offsetValue;
                switch (offsetUnit) {
                    case "minute": {
                        firstReminderTime = fieldValue.plusMinutes(offsetValue);
                        break block0;
                    }
                    case "hour": {
                        firstReminderTime = fieldValue.plusHours(offsetValue);
                        break block0;
                    }
                    case "day": {
                        firstReminderTime = fieldValue.plusDays(offsetValue);
                        break block0;
                    }
                }
                throw new HussarException("\u504f\u79fb\u5355\u4f4d\u4e0d\u7b26\u5408\u89c4\u8303");
            }
            case CUSTOM_TIME: {
                String dateTime = firstReminderTimeConfig.getDateTime();
                firstReminderTime = LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
        }
        return firstReminderTime;
    }

    private LocalDateTime handleNextReminderTime(SysMsgPushTask sysMsgPushTask, LocalDateTime currentTime) {
        RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)sysMsgPushTask.getRepeatRule(), RepeatRule.class);
        LocalDateTime nextReminderTime = repeatRule.calculateNextReminderTime(sysMsgPushTask.getFirstReminderTime(), currentTime);
        if (HussarUtils.isNotEmpty((Object)sysMsgPushTask.getEndReminderTime()) && nextReminderTime.isAfter(sysMsgPushTask.getEndReminderTime()) || nextReminderTime.isBefore(currentTime)) {
            return null;
        }
        return nextReminderTime;
    }

    private LocalDateTime handleEndReminderTime(SysMsgPushConfig config, SysMsgPushTask task) {
        EndReminderTime endReminderTimeConfig = (EndReminderTime)JSON.parseObject((String)config.getEndReminderTime(), EndReminderTime.class);
        LocalDateTime firstReminderTime = task.getFirstReminderTime();
        RepeatRule repeatRule = (RepeatRule)JSON.parseObject((String)config.getRepeatRule(), RepeatRule.class);
        if (repeatRule.getType().equals("only_once")) {
            return null;
        }
        return endReminderTimeConfig.calculate(firstReminderTime, repeatRule);
    }

    private String handleReminderContent(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        try {
            String reminderContentConfig = sysMsgPushConfig.getReminderContent();
            ReminderContent reminderContent = (ReminderContent)((Object)JSON.parseObject((String)reminderContentConfig, ReminderContent.class));
            reminderContent.setMode("custom");
            reminderContent.setCustom(reminderContent.getValue());
            FormSchema formSchema = (FormSchema)this.formOperateService.get(String.valueOf(sysMsgPushConfig.getFormId())).getData();
            BuilderTool.wrapTitle((FormSchema)formSchema, (TitleSchema)reminderContent);
            reminderContentConfig = JSON.toJSONString((Object)((Object)reminderContent));
            return MetaTitleRule.parseAndFormat((String)reminderContentConfig, (String)String.valueOf(sysMsgPushConfig.getFormId()), (Map)businessData, null);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u63d0\u9192\u6587\u5b57\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            throw new HussarException("\u89e3\u6790\u63d0\u9192\u6587\u5b57\u5931\u8d25");
        }
    }

    private String handelReminders(SysMsgPushConfig sysMsgPushConfig, JSONObject businessData) {
        List collect;
        HashSet<Object> userIds = new HashSet<Object>();
        HashSet<Long> structureIds = new HashSet<Long>();
        ReminderConfig reminderConfig = (ReminderConfig)JSON.parseObject((String)sysMsgPushConfig.getReminders(), ReminderConfig.class);
        List<JSONObject> organs = reminderConfig.getOrgans();
        List<JSONObject> staffs = reminderConfig.getStaffs();
        List<JSONObject> showFields = reminderConfig.getShowFields();
        if (HussarUtils.isNotEmpty(organs)) {
            collect = organs.stream().map(organ -> organ.getLong("id")).collect(Collectors.toList());
            structureIds.addAll(collect);
        }
        if (HussarUtils.isNotEmpty(staffs)) {
            collect = staffs.stream().map(staff -> staff.getLong("id")).collect(Collectors.toList());
            userIds.addAll(collect);
        }
        if (HussarUtils.isNotEmpty(showFields)) {
            for (JSONObject widget : showFields) {
                String fieldName = widget.getString("name") + "_id";
                String fieldValue = businessData.getString(fieldName);
                if (!HussarUtils.isNotEmpty((Object)fieldValue)) continue;
                List collect2 = Arrays.stream(fieldValue.split(",")).map(Long::parseLong).collect(Collectors.toList());
                String widgetType = widget.getString("type");
                if (widgetType.equals(WidgetType.JXDNUser.getType()) || widgetType.equals(WidgetType.JXDNUserMulti.getType())) {
                    userIds.addAll(collect2);
                }
                if (!widgetType.equals(WidgetType.JXDNOrg.getType()) && !widgetType.equals(WidgetType.JXDNOrgMulti.getType())) continue;
                structureIds.addAll(collect2);
            }
        }
        if (HussarUtils.isNotEmpty(structureIds)) {
            userIds.addAll(this.getUserIdsByStructureIds(structureIds));
        }
        return JSON.toJSONString(userIds);
    }

    private List<Long> getUserIdsByStructureIds(Set<Long> structureIds) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getStruId, structureIds);
        List sysStruUsers = this.sysStruUserService.list((Wrapper)wrapper);
        return sysStruUsers.stream().map(SysStruUser::getUserId).collect(Collectors.toList());
    }
}

