/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.util.redislock.RedisLock;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportThreadServiceImpl")
public class FormImportThreadServiceImpl
implements IFormImportThreadService {
    @Resource
    private IFormImportInfoService formImportInfoService;
    @Resource
    private ISysFormService formService;

    @RedisLock(key="form:startImportThread:")
    public void startImportThread(FormImportDto formImportDto) throws Exception {
        ImportMappingDto importMappingDto = new ImportMappingDto();
        try {
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            this.formImportInfoService.importFormData(formImportDto, importMappingDto);
            if ("2".equals(formImportDto.getFormType())) {
                this.formImportInfoService.importDashboardData(formImportDto, importMappingDto);
            } else {
                this.formImportInfoService.importMidFile(formImportDto, importMappingDto);
                this.formImportInfoService.importFlowData(formImportDto, importMappingDto);
                this.formImportInfoService.importBusinessData(formImportDto, importMappingDto);
            }
            this.formImportInfoService.syncForm(formImportDto, importMappingDto);
            Thread.sleep(5000L);
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)4, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty(importMappingDto.getFormIdMap().values())) {
                this.formService.removeByIds(importMappingDto.getFormIdMap().values());
            }
            throw new HussarException((Throwable)e);
        }
    }
}

