/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportServiceImpl")
public class FormImportServiceImpl
implements IFormImportService {
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysFormService sysFormService;
    private static final Logger logger = LoggerFactory.getLogger(FormImportServiceImpl.class);

    public ApiResponse<FormAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        if (formExportMetaDto == null) {
            return ApiResponse.fail((String)"\u4e0a\u4f20\u7684\u9644\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (HussarUtils.isEmpty((Object)formExportMetaDto.getFormName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u8868\u5355\u6587\u4ef6");
        }
        FormAttachmentParseVo formAttachmentParseVo = new FormAttachmentParseVo();
        formAttachmentParseVo.setPath(unZipPath);
        formAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)formExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)formExportMetaDto, (Object)formAttachmentParseVo);
        return ApiResponse.success((Object)formAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(FormImportDto formImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)formImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "hussar.meta"});
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        assert (formExportMetaDto != null);
        String password = formExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    @Async
    public void importForm(FormImportDto formImportDto, SecurityUser user, String importCacheKey) throws Exception {
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        this.formImportThreadService.startImportThread(formImportDto);
        TransmittableThreadLocalHolder.clear((String)"loginUser");
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.waitImport((int)1, (boolean)false, (Object)"", (boolean)false, (String)"\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")));
    }
}

