/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.button.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class TableButtonViewAspect {
    @Resource
    private ISysCustomButtonService sysCustomButtonService;

    @Pointcut(value="execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.get(..)) || execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.getWithPublic(..))")
    public void addSysCustomButtonInfo() {
    }

    @Pointcut(value="execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.save(..)) || execution(* com.jxdinfo.hussar.formdesign.no.code.business.service.impl.ViewServiceImpl.saveWithPublic(..))")
    public void removeSysCustomButtonInfo() {
    }

    @AfterReturning(value="addSysCustomButtonInfo()", returning="viewResponse")
    @HussarDs(value="master")
    public FormDesignResponse<FormViewSchema> afterReturningFormViewSchema(FormDesignResponse<FormViewSchema> viewResponse) {
        FormViewSchema view = (FormViewSchema)viewResponse.getData();
        if (HussarUtils.isNotEmpty((Object)view)) {
            String viewJsonString = JSON.toJSONString((Object)view);
            FormViewSchema formView = (FormViewSchema)JSONObject.parseObject((String)viewJsonString, FormViewSchema.class);
            List dataViews = formView.getViews();
            for (DataView dataView : dataViews) {
                List buttons;
                if ("1".equals(view.getFormType()) && !"0".equals(dataView.getTabType())) {
                    buttons = dataView.getButtons();
                    if (HussarUtils.isNotEmpty((Object)buttons)) {
                        buttons = buttons.stream().filter(button -> !"custom".equals(button.getType())).collect(Collectors.toList());
                    }
                } else {
                    buttons = this.sysCustomButtonService.addCustomButtonInfo(Long.valueOf(view.getFormId()), dataView.getButtons());
                }
                dataView.setButtons(buttons);
            }
            viewResponse.setData((Object)formView);
        }
        return viewResponse;
    }

    @Before(value="removeSysCustomButtonInfo()")
    public void beforeSaveFormViewSchema(JoinPoint joinPoint) {
        FormViewSchema view;
        Object[] args = joinPoint.getArgs();
        if (HussarUtils.isNotEmpty((Object[])args) && HussarUtils.isNotEmpty((Object)(view = (FormViewSchema)args[0]))) {
            List dataViews = view.getViews();
            dataViews.forEach(dataView -> {
                List buttons = dataView.getButtons();
                this.sysCustomButtonService.removeCustomButtonInfo(buttons);
            });
        }
    }
}

