/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationVersionMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysApplicationVersion;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationVersionService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVersionVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.util.AppUpgradeUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysApplicationVersionServiceImpl
extends HussarServiceImpl<SysApplicationVersionMapper, SysApplicationVersion>
implements ISysApplicationVersionService {
    @Resource
    private ISysUsersService usersService;
    @Resource
    private IAppUpgradeService appUpgradeService;
    @Resource
    private ISysApplicationService sysApplicationService;

    public ApiResponse<List<SysApplicationVersionVo>> listApplicationVersionByAppId(Long appId) {
        List appHistoryVersionList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).orderByDesc(HussarBaseEntity::getCreateTime));
        List<SysApplicationVersionVo> SysApplicationVersionVos = appHistoryVersionList.stream().map(version -> (SysApplicationVersionVo)BeanUtil.copy((Object)version, SysApplicationVersionVo.class)).collect(Collectors.toList());
        ArrayList userIds = new ArrayList();
        SysApplicationVersionVos.forEach(SysApplicationVersionVo2 -> {
            Long upgradedBy = SysApplicationVersionVo2.getCreator();
            if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
                Long userId = (long)upgradedBy;
                userIds.add(userId);
            }
        });
        List sysUsers = this.usersService.listByIds(userIds);
        HashMap userMap = new HashMap();
        sysUsers.forEach(sysUser -> userMap.put(String.valueOf(sysUser.getId()), sysUser.getUserName()));
        SysApplicationVersionVos.forEach(SysApplicationVersionVo2 -> {
            Long upgradedBy = SysApplicationVersionVo2.getCreator();
            if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
                SysApplicationVersionVo2.setUpgradeByName(userMap.getOrDefault(String.valueOf(upgradedBy), "\u672a\u77e5\u7528\u6237"));
            }
        });
        return ApiResponse.success(SysApplicationVersionVos);
    }

    public ApiResponse<String> rollback(Long appId, Long versionId) {
        SysApplicationVersion historyVersion = (SysApplicationVersion)this.getById(versionId);
        String packagePath = historyVersion.getPackagePath();
        String upgradeMapping = historyVersion.getUpgradeMapping();
        JSONObject jsonObject = JSON.parseObject((String)upgradeMapping);
        Map formGroupIdMap = AppUpgradeUtil.stringToLongKey((Map)jsonObject.getObject("formGroupIdMap", Map.class));
        Map formIdMap = AppUpgradeUtil.stringToLongKey((Map)jsonObject.getObject("formIdMap", Map.class));
        Map subTableNameMap = Optional.ofNullable(jsonObject.getObject("formGroupIdMap", Map.class)).orElse(new HashMap());
        AppUpgradeDto appUpgradeDto = new AppUpgradeDto();
        appUpgradeDto.setCurrentAppId(appId);
        appUpgradeDto.setPath(packagePath);
        appUpgradeDto.getFormGroupIdMap().putAll(formGroupIdMap);
        appUpgradeDto.getFormIdMap().putAll(formIdMap);
        appUpgradeDto.getSubTableNameMap().putAll(subTableNameMap);
        String taskId = (String)this.appUpgradeService.execute(appUpgradeDto).getData();
        return ApiResponse.success((Object)taskId, (String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public ApiResponse<SysApplicationVersionVo> getCurrentAppVersion(Long appId) {
        SysApplicationVersion appHistoryVersion = (SysApplicationVersion)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplicationVersion::getAppId, (Object)appId)).eq(SysApplicationVersion::isCurrentFlag, (Object)true));
        SysApplicationVersionVo SysApplicationVersionVo2 = new SysApplicationVersionVo();
        if (HussarUtils.isNotEmpty((Object)appHistoryVersion)) {
            BeanUtil.copy((Object)appHistoryVersion, (Object)SysApplicationVersionVo2);
            Long upgradedBy = SysApplicationVersionVo2.getCreator();
            if (HussarUtils.isNotEmpty((Object)upgradedBy)) {
                SysUsers sysUser = this.usersService.getById(upgradedBy);
                if (HussarUtils.isNotEmpty((Object)sysUser)) {
                    SysApplicationVersionVo2.setUpgradeByName(sysUser.getUserName());
                } else {
                    SysApplicationVersionVo2.setUpgradeByName("\u672a\u77e5\u7528\u6237");
                }
            }
        } else {
            appHistoryVersion = new SysApplicationVersion();
            ApiResponse appDetail = this.sysApplicationService.getAppDetail(appId);
            SysApplicationVo applicationVo = (SysApplicationVo)appDetail.getData();
            if (HussarUtils.isEmpty((Object)applicationVo)) {
                throw new BaseException("\u5e94\u7528\u4e0d\u5b58\u5728");
            }
            Long creator = applicationVo.getCreator();
            LocalDateTime createTime = applicationVo.getCreateTime();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String formattedDateTime = createTime.format(formatter);
            appHistoryVersion.setAppId(appId);
            appHistoryVersion.setCurrentFlag(true);
            appHistoryVersion.setCreateTime(applicationVo.getCreateTime());
            appHistoryVersion.setCreator(creator);
            appHistoryVersion.setVersionNumber(formattedDateTime);
            this.save((BaseEntity)appHistoryVersion);
            BeanUtil.copy((Object)appHistoryVersion, (Object)SysApplicationVersionVo2);
            SysUsers sysUser = this.usersService.getById(creator);
            if (HussarUtils.isNotEmpty((Object)sysUser)) {
                SysApplicationVersionVo2.setUpgradeByName(sysUser.getUserName());
            } else {
                SysApplicationVersionVo2.setUpgradeByName("\u672a\u77e5\u7528\u6237");
            }
        }
        return ApiResponse.success((Object)SysApplicationVersionVo2);
    }

    public void updateCurrentFlag(Long appId, Long lastAppVersionId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(SysApplicationVersion::getAppId, (Object)appId)).eq(SysApplicationVersion::getId, (Object)lastAppVersionId)).set(SysApplicationVersion::isCurrentFlag, (Object)false);
        this.update((Wrapper)updateWrapper);
    }

    public ApiResponse<Boolean> rollbackSuccessCallback(Long appId, Long versionId) {
        SysApplicationVersionVo currentVersionVo = (SysApplicationVersionVo)this.getCurrentAppVersion(appId).getData();
        currentVersionVo.setCurrentFlag(Boolean.FALSE.booleanValue());
        SysApplicationVersion currentVersion = (SysApplicationVersion)BeanUtil.copy((Object)currentVersionVo, SysApplicationVersion.class);
        SysApplicationVersion backVersion = (SysApplicationVersion)this.getById(versionId);
        backVersion.setCurrentFlag(Boolean.TRUE.booleanValue());
        this.saveOrUpdate((BaseEntity)currentVersion);
        this.saveOrUpdate((BaseEntity)backVersion);
        return ApiResponse.success((Object)Boolean.TRUE);
    }
}

