/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.UpgradeMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.service.impl.AppImportInfoServiceImpl;
import com.jxdinfo.hussar.formdesign.application.button.service.ISysCustomButtonService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.data.service.SysDataPullService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.message.service.SysMsgPushConfigService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.tool.annotation.UpgradeProgressCache;
import com.jxdinfo.hussar.formdesign.application.util.AppIoUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.application.util.AppUpgradeUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.BaseSetting;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CustomViewService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormOperateService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.ViewService;
import com.jxdinfo.hussar.formdesign.no.code.cured.SettingSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.FormSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.model.setting.FormSettingSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.CustomView;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataModelBuilder;
import com.jxdinfo.hussar.formdesign.no.code.tool.ModelBuilderAdapter;
import com.jxdinfo.hussar.formdesign.no.code.tool.NoCodeModelHandler;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.vo.WorkflowDumpVo;
import com.jxdinfo.hussar.workflow.godaxe.migration.GodAxeMigrationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppUpgradeInfoServiceImpl
implements IAppUpgradeInfoService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private CanvasService canvasService;
    @Resource
    private ViewService viewService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormLinkService sysFormLinkService;
    @Resource
    private ISysCustomButtonService sysCustomButtonService;
    @Resource
    private AppImportInfoServiceImpl appImportInfoService;
    @Resource
    private ISysFormCheckConfigService sysFormCheckConfigService;
    @Resource
    private SysMsgPushConfigService msgPushConfigService;
    @Resource
    private SysDataPullService pullDataService;
    @Resource
    private PushDataService pushDataService;
    @Resource
    private ISysRuleInfoService sysRuleInfoService;
    @Resource
    private CustomViewService customViewService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Resource
    private FormOperateService formOperateService;
    @Resource
    private GodAxeMigrationService flowMigrateService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppUpgradeInfoServiceImpl.class);

    @UpgradeProgressCache(status=1, msg="\u6b63\u5728\u5347\u7ea7\u5e94\u7528\u4fe1\u606f...")
    public void upgradeApp(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.sysApplicationService.upgradeApp(appUpgradeDto, upgradeMappingDto);
        LOGGER.info("\u5347\u7ea7\u5e94\u7528\u4fe1\u606f\u5b8c\u6210");
    }

    @UpgradeProgressCache(status=2, msg="\u6b63\u5728\u5347\u7ea7\u8868\u5355\u4fe1\u606f...")
    public void upgradeForm(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.sysFormService.upgradeForm(appUpgradeDto, upgradeMappingDto);
        LOGGER.info("\u5347\u7ea7\u8868\u5355\u4fe1\u606f\u5b8c\u6210");
    }

    @UpgradeProgressCache(status=3, msg="\u6b63\u5728\u5347\u7ea7\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6...")
    public void upgradeMidFile(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.upgradeCustomButton(appUpgradeDto, upgradeMappingDto);
        SettingSchemaService settingService = (SettingSchemaService)SpringUtil.getBean((String)"no.code.setting", SettingSchemaService.class);
        List<FormSchema> formSchemas = AppIoUtil.readMidFiles(appUpgradeDto.getPath(), String.valueOf(upgradeMappingDto.getUpgradeAppId()));
        Map formIdMap = upgradeMappingDto.getFormIdMap();
        List upgradeFormIdList = upgradeMappingDto.getUpgradeFormIdList();
        if (HussarUtils.isNotEmpty(formSchemas)) {
            for (FormSchema formSchema : formSchemas) {
                FormCanvasSchema upgradeCanvas = formSchema.getFormCanvas();
                FormViewSchema upgradeView = formSchema.getView();
                FormSettingSchema upgradeSetting = formSchema.getSetting();
                try {
                    if (upgradeFormIdList.contains(Long.valueOf(upgradeCanvas.getId()))) {
                        Long currentFormId = (Long)formIdMap.get(Long.valueOf(upgradeCanvas.getId()));
                        FormCanvasSchema currentCanvas = (FormCanvasSchema)this.canvasService.get(String.valueOf(currentFormId)).getData();
                        FormCanvasSchema newCanvas = this.mergeCanvas(upgradeCanvas, currentCanvas, upgradeMappingDto);
                        this.canvasService.saveCanvas(newCanvas);
                        FormViewSchema currentView = (FormViewSchema)this.viewService.get(String.valueOf(currentFormId)).getData();
                        FormViewSchema newView = this.mergeView(upgradeView, currentView, upgradeMappingDto);
                        this.viewService.save(newView);
                        FormSettingSchema currentSetting = (FormSettingSchema)settingService.get(String.valueOf(currentFormId)).getData();
                        FormSettingSchema newSetting = this.mergeSetting(upgradeSetting, currentSetting, upgradeMappingDto);
                        settingService.saveOrUpdate((BaseSetting)newSetting, currentCanvas.getId());
                        continue;
                    }
                    FormCanvasSchema canvas = this.processCanvas(upgradeCanvas, upgradeMappingDto);
                    this.canvasService.saveCanvasForImport(canvas, null);
                    FormViewSchema view = this.processView(upgradeView, upgradeMappingDto);
                    this.viewService.save(view);
                    FormSettingSchema setting = this.processSetting(upgradeSetting, upgradeMappingDto);
                    settingService.saveOrUpdate((BaseSetting)setting, canvas.getId());
                }
                catch (Exception e) {
                    LOGGER.error("\u5e94\u7528\u5347\u7ea7 -> \u4e2d\u95f4\u6587\u4ef6\u5347\u7ea7\u5931\u8d25\uff0c\u8868\u5355\u540d\u79f0\uff1a{}", (Object)upgradeCanvas.getName());
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
                }
            }
        }
        LOGGER.info("\u5347\u7ea7\u8bbe\u8ba1\u5668\u4e2d\u95f4\u6587\u4ef6\u5b8c\u6210");
    }

    @UpgradeProgressCache(status=4, msg="\u6b63\u5728\u5347\u7ea7\u6269\u5c55\u529f\u80fd...")
    public void upgradeExtension(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        AppUpgradeUtil.runUnstoppable(() -> this.sysRuleInfoService.upgradeBusinessRule(appUpgradeDto, upgradeMappingDto), () -> this.msgPushConfigService.upgradeMsgPush(appUpgradeDto, upgradeMappingDto), () -> this.sysFormLinkService.upgradeFormLink(appUpgradeDto, upgradeMappingDto), () -> this.pullDataService.upgradeDataPull(appUpgradeDto, upgradeMappingDto), () -> this.pushDataService.upgradeDataPush(appUpgradeDto, upgradeMappingDto), () -> this.upgradePublicView(appUpgradeDto, upgradeMappingDto), () -> this.sysFormCheckConfigService.upgradeCheckConfig(appUpgradeDto, upgradeMappingDto), () -> this.sysPrintTemplateService.upgradePrintTemplate(appUpgradeDto, upgradeMappingDto));
        LOGGER.info("\u5347\u7ea7\u6269\u5c55\u529f\u80fd\u5b8c\u6210");
    }

    @UpgradeProgressCache(status=5, msg="\u6b63\u5728\u6784\u5efa\u8868\u7ed3\u6784...")
    public void constructTable(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        List newFormIds = upgradeMappingDto.getFormIdMap().values().stream().filter(formId -> !appUpgradeDto.getFormIdMap().containsKey(formId)).collect(Collectors.toList());
        for (Long formId2 : newFormIds) {
            try {
                FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasService.get(String.valueOf(formId2)).getData();
                if (HussarUtils.isEmpty((Object)formCanvasSchema)) {
                    return;
                }
                FormSchema formSchema = new FormSchema.Builder().formPage(formCanvasSchema).build();
                DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)formSchema);
                NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
                DataModelBase dataModelBase = builder.direct();
                noCodeModelHandler.updateTable(dataModelBase, builder.createContrast());
                this.reSync(String.valueOf(formId2));
            }
            catch (Exception e) {
                LOGGER.error("\u8868\u7ed3\u6784\u6784\u5efa\u5931\u8d25\uff0c\u8868\u5355ID\uff1a{}", (Object)formId2);
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
            }
        }
        LOGGER.info("\u5347\u7ea7\u6784\u5efa\u8868\u7ed3\u6784\u5b8c\u6210");
    }

    @UpgradeProgressCache(status=6, msg="\u6b63\u5728\u5347\u7ea7\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f...", finish=true)
    public void upgradeFlow(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.appImportInfoService.recordReplaceMappingOfFlow((ImportMappingDto)upgradeMappingDto);
        JSONObject flowData = AppIoUtil.readData(appUpgradeDto.getPath(), "flowData", JSONObject.class);
        HashMap<String, List<WorkflowDumpVo>> workflowDumpVoListMap = new HashMap<String, List<WorkflowDumpVo>>();
        if (HussarUtils.isNotEmpty((Object)flowData)) {
            for (String key : flowData.keySet()) {
                JSONArray data = (JSONArray)flowData.getObject(key, JSONArray.class);
                List<WorkflowDumpVo> workflowDumpVos = AppMigrateUtil.parseJsonArrayToList(data, WorkflowDumpVo.class);
                workflowDumpVoListMap.put(key, workflowDumpVos);
            }
        }
        com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto flowImportMappingDto = new com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.ImportMappingDto();
        BeanUtils.copyProperties((Object)upgradeMappingDto, (Object)flowImportMappingDto);
        if (HussarUtils.isNotEmpty((Object)upgradeMappingDto.getTableNameMap())) {
            Map<String, String> mainTableNameMap = upgradeMappingDto.getTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setMainTableNameMap(mainTableNameMap);
        }
        if (HussarUtils.isNotEmpty((Object)upgradeMappingDto.getTaskTableNameMap())) {
            Map<String, String> taskTableNameMap = upgradeMappingDto.getTaskTableNameMap().entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(), entry -> ((String)entry.getValue()).toUpperCase()));
            flowImportMappingDto.setTaskTableNameMap(taskTableNameMap);
        }
        flowImportMappingDto.setMainTableBusinessKeyMap(upgradeMappingDto.getTableNameMap());
        flowImportMappingDto.getMainTableBusinessKeyMap().put("RECORD_ID", "RECORD_ID");
        this.flowMigrateService.importWorkflow(workflowDumpVoListMap, flowImportMappingDto);
        LOGGER.info("\u5347\u7ea7\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210");
    }

    @HussarDs(value="master")
    private void reSync(String formId) throws Exception {
        FormDesignResponse form = this.formOperateService.get(formId);
        DataModelBuilder builder = ModelBuilderAdapter.adaptBuilder((FormSchema)((FormSchema)form.getData()));
        NoCodeModelHandler noCodeModelHandler = (NoCodeModelHandler)SpringUtil.getBean((String)"no.code.handler", NoCodeModelHandler.class);
        DataModelBase dataModelBase = builder.direct();
        noCodeModelHandler.sync(dataModelBase);
    }

    public FormCanvasSchema mergeCanvas(FormCanvasSchema upgradeCanvas, FormCanvasSchema currentCanvas, UpgradeMappingDto upgradeMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeCanvas.getId(), currentCanvas.getId());
        replaceMap.put(upgradeCanvas.getName(), currentCanvas.getName());
        List upgradeSubTableNameList = upgradeMappingDto.getUpgradeSubTableNameList();
        Map subTableNameMap = upgradeMappingDto.getSubTableNameMap();
        List childTables = upgradeCanvas.childTables();
        for (Widget widget : childTables) {
            String oldSubTableName = widget.getName();
            String newSubTableName = upgradeSubTableNameList.contains(oldSubTableName) ? (String)subTableNameMap.get(oldSubTableName) : "table" + RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)11);
            upgradeMappingDto.getSubTableNameMap().put(oldSubTableName, newSubTableName);
            replaceMap.put(oldSubTableName, newSubTableName);
        }
        if ("1".equals(currentCanvas.getFormType())) {
            upgradeMappingDto.getProcessKeyMap().put(upgradeCanvas.getIdentity(), currentCanvas.getIdentity());
            replaceMap.put(upgradeCanvas.getIdentity(), currentCanvas.getIdentity());
        }
        upgradeCanvas.setVersion(currentCanvas.getVersion() + 1);
        return this.updateObj(upgradeCanvas, replaceMap, FormCanvasSchema.class);
    }

    public FormCanvasSchema processCanvas(FormCanvasSchema canvas, UpgradeMappingDto upgradeMappingDto) {
        List tableWidgets = canvas.childTables();
        if (HussarUtils.isNotEmpty((Object)tableWidgets)) {
            for (Widget widget : tableWidgets) {
                String oldSubTableName = widget.getName();
                String newSubTableName = "table" + RandomUtil.randomString((String)"abcdefghijklmnopqrstuvwxyz0123456789", (int)11);
                upgradeMappingDto.getSubTableNameMap().put(oldSubTableName, newSubTableName);
            }
        }
        if ("1".equals(canvas.getFormType())) {
            String oldFlowIdentity = canvas.getIdentity();
            String newFlowIdentity = oldFlowIdentity.substring(0, oldFlowIdentity.length() - 18) + upgradeMappingDto.getFormIdMap().get(Long.valueOf(canvas.getId()));
            upgradeMappingDto.getProcessKeyMap().put(oldFlowIdentity, newFlowIdentity);
        }
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeMappingDto.getUpgradeAppId(), upgradeMappingDto.getCurrentAppId());
        replaceMap.putAll(upgradeMappingDto.getFormIdMap());
        replaceMap.putAll(upgradeMappingDto.getTableNameMap());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        replaceMap.putAll(upgradeMappingDto.getProcessKeyMap());
        return this.updateObj(canvas, replaceMap, FormCanvasSchema.class);
    }

    public FormViewSchema mergeView(FormViewSchema upgradeView, FormViewSchema currentView, UpgradeMappingDto upgradeMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeView.getAppId(), currentView.getAppId());
        replaceMap.put(upgradeView.getFormId(), currentView.getFormId());
        replaceMap.put(upgradeView.getFormName(), currentView.getFormName());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        return this.updateObj(upgradeView, replaceMap, FormViewSchema.class);
    }

    public FormViewSchema processView(FormViewSchema view, UpgradeMappingDto upgradeMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeMappingDto.getUpgradeAppId(), upgradeMappingDto.getCurrentAppId());
        replaceMap.putAll(upgradeMappingDto.getFormIdMap());
        replaceMap.putAll(upgradeMappingDto.getTableNameMap());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        return this.updateObj(view, replaceMap, FormViewSchema.class);
    }

    public FormSettingSchema mergeSetting(FormSettingSchema upgradeSetting, FormSettingSchema currentSetting, UpgradeMappingDto upgradeMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeMappingDto.getUpgradeAppId(), upgradeMappingDto.getCurrentAppId());
        replaceMap.putAll(upgradeMappingDto.getFormIdMap());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        return this.updateObj(upgradeSetting, replaceMap, FormSettingSchema.class);
    }

    public FormSettingSchema processSetting(FormSettingSchema setting, UpgradeMappingDto upgradeMappingDto) {
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeMappingDto.getUpgradeAppId(), upgradeMappingDto.getCurrentAppId());
        replaceMap.putAll(upgradeMappingDto.getFormIdMap());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        return this.updateObj(setting, replaceMap, FormSettingSchema.class);
    }

    private <T> T updateObj(T t, Map<Object, Object> replaceMap, Class<T> type) {
        String text = JSON.toJSONString(t);
        ArrayList<Map.Entry<Object, Object>> sortedEntries = new ArrayList<Map.Entry<Object, Object>>(replaceMap.entrySet());
        sortedEntries.sort((o1, o2) -> o2.getKey().toString().length() - o1.getKey().toString().length());
        for (Map.Entry entry : sortedEntries) {
            text = text.replace(entry.getKey().toString(), entry.getValue().toString());
        }
        return (T)JSONObject.parseObject((String)text, type);
    }

    private void upgradeCustomButton(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.sysCustomButtonService.upgradeCustomButton(appUpgradeDto, upgradeMappingDto);
    }

    public void upgradePublicView(AppUpgradeDto appUpgradeDto, UpgradeMappingDto upgradeMappingDto) {
        this.customViewService.remove((Wrapper)new LambdaQueryWrapper().eq(CustomView::getAppId, (Object)upgradeMappingDto.getCurrentAppId()));
        List<DataView> dataViewList = AppIoUtil.readDataToList(appUpgradeDto.getPath(), "publicView", DataView.class);
        HashMap<Object, Object> replaceMap = new HashMap<Object, Object>();
        replaceMap.put(upgradeMappingDto.getUpgradeAppId(), upgradeMappingDto.getCurrentAppId());
        replaceMap.putAll(upgradeMappingDto.getFormIdMap());
        replaceMap.putAll(upgradeMappingDto.getTableNameMap());
        replaceMap.putAll(upgradeMappingDto.getSubTableNameMap());
        List<DataView> dataViews = AppIoUtil.replaceMappingToList(dataViewList, DataView.class, replaceMap);
        List<CustomView> publicViewList = dataViews.stream().map(dataView -> this.customViewService.convertToCustomView(dataView)).collect(Collectors.toList());
        publicViewList.forEach(customView -> customView.setViewId(null));
        this.customViewService.saveBatch(publicViewList);
    }
}

