/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.dto.SysAppAuthorizationDto;
import com.jxdinfo.hussar.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.application.factory.HussarAppVisitAuthCallBackFactory;
import com.jxdinfo.hussar.application.model.SysApplicationRecord;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportInfoService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.appImportThreadServiceImpl")
@HussarTokenDs
public class AppImportThreadServiceImpl
implements IAppImportThreadService {
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    @Resource
    private IAppImportInfoService appImportInfoService;
    @Resource
    private ISysApplicationService appService;
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppImportThreadServiceImpl.class);

    @HussarTransactional
    public void startImportThread(AppImportDto appImportDto) {
        ImportMappingDto importMappingDto = new ImportMappingDto();
        Long userId = ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId();
        try {
            this.appImportInfoService.init(appImportDto);
            this.appImportInfoService.importCommonData(appImportDto);
            this.appImportInfoService.importAppData(appImportDto, importMappingDto);
            TransmittableThreadLocalHolder.set((String)"appId", (Object)String.valueOf(importMappingDto.getNewAppId()));
            this.appImportInfoService.importFormData(appImportDto, importMappingDto);
            this.appImportInfoService.importFormAuthData(appImportDto, importMappingDto);
            this.appImportInfoService.importMidFile(appImportDto, importMappingDto);
            this.appImportInfoService.importFlowData(appImportDto, importMappingDto);
            this.appImportInfoService.importBusinessData(appImportDto, importMappingDto);
            this.pushAppAuthToPortalCenter(importMappingDto.getNewAppId(), "1");
            String importCacheKey = (String)TransmittableThreadLocalHolder.get((String)"importCacheKey");
            HussarCacheUtil.put((String)"import_progress", (Object)importCacheKey, (Object)ImportStatusVo.success((int)8, (boolean)true, (Object)importMappingDto.getNewAppId()));
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty((Object)importMappingDto.getNewAppId())) {
                this.appService.removeById((Serializable)importMappingDto.getNewAppId());
            }
            LOGGER.error("\u5e94\u7528\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u5bfc\u5165\u5931\u8d25");
        }
        finally {
            String path = appImportDto.getPath();
            int index = path.lastIndexOf("/");
            Long fileId = 0L;
            String fileName = "";
            if (index != -1) {
                String name = path.substring(index + 1);
                int index1 = name.lastIndexOf("#");
                fileName = name.substring(0, index1);
                AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
                attachmentManagerModelVo.setAttachmentName(fileName + ".hussar");
                attachmentManagerModelVo.setAttachmentDir(this.outputPath);
                attachmentManagerModelVo.setAttachmentType("hussar");
                this.attachmentManagerService.save((Object)attachmentManagerModelVo);
                fileId = attachmentManagerModelVo.getId();
            }
            try {
                int bytesRead;
                FileInputStream inputStream = new FileInputStream(path + ".hussar");
                String newPath = this.outputPath + fileId + ".hussar";
                FileOutputStream outputStream = new FileOutputStream(newPath);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u6d41\u8f93\u51fa\u5931\u8d25");
            }
            SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
            ImportStatusVo importStatusVo = (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)((String)TransmittableThreadLocalHolder.get((String)"importCacheKey")), ImportStatusVo.class);
            if (importStatusVo.getStatus() == 8) {
                sysApplicationRecord.setRecordStatus("2");
                sysApplicationRecord.setShowMsg("\u5bfc\u5165\u6210\u529f");
                sysApplicationRecord.setAppId(Long.valueOf(String.valueOf(importStatusVo.getData())));
            } else {
                sysApplicationRecord.setAppId(Long.valueOf(0L));
                sysApplicationRecord.setRecordStatus("3");
                sysApplicationRecord.setShowMsg("\u5bfc\u5165\u5931\u8d25");
            }
            sysApplicationRecord.setRecordFileId(fileId);
            sysApplicationRecord.setRecordFileName(fileName);
            sysApplicationRecord.setCreator(userId);
            sysApplicationRecord.setRecordType("0");
            sysApplicationRecord.setAppMode("1");
            sysApplicationRecord.setRecordFilePassword(appImportDto.getPassword());
            this.sysApplicationRecordService.save((Object)sysApplicationRecord);
        }
    }

    private void pushAppAuthToPortalCenter(Long newAppId, String appType) {
        ArrayList<SysAppAuthorizationDto> appAuthorList = new ArrayList<SysAppAuthorizationDto>();
        SysAppAuthorizationDto appAuthorizationDto = new SysAppAuthorizationDto();
        Long userId = ((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserId();
        appAuthorizationDto.setId(userId);
        appAuthorizationDto.setType("4");
        appAuthorList.add(appAuthorizationDto);
        SysAppVisitAuthorizeDto appAuthorizeDto = new SysAppVisitAuthorizeDto();
        appAuthorizeDto.setAppId(newAppId);
        appAuthorizeDto.setAppAuthorList(appAuthorList);
        LOGGER.info("\u5bfc\u5165\u5e94\u7528\u540c\u6b65\u5230\u95e8\u6237\uff1aappAuthorizeDto={}, appType={}", (Object)JSONObject.toJSONString((Object)appAuthorizeDto), (Object)appType);
        HussarAppVisitAuthCallBackFactory.addAuthorization((SysAppVisitAuthorizeDto)appAuthorizeDto, (String)appType);
    }
}

