/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.constants.AppPublishConstant;
import com.jxdinfo.hussar.formdesign.application.application.constants.AppUpgradeConstant;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppCrossPublishDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppImportDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppPublishFullDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppPublishIncrementDto;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppUpgradeDto;
import com.jxdinfo.hussar.formdesign.application.application.model.SysPublishServer;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppCrossPublishService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppImportThreadService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppPackageService;
import com.jxdinfo.hussar.formdesign.application.application.service.IAppUpgradeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysPublishServerService;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppPublishStatusVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupContrast;
import com.jxdinfo.hussar.formdesign.application.application.vo.AppUpGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysPublishServerVo;
import com.jxdinfo.hussar.formdesign.application.util.AppUpgradeUtil;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class AppCrossPublishServiceImpl
implements IAppCrossPublishService {
    @Resource
    private IAppUpgradeService appUpgradeService;
    @Resource
    private IAppImportService appImportService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private IAppImportThreadService appImportThreadService;
    @Resource
    private IAppPackageService appPackageService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private ISysPublishServerService sysPublishServerService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AppCrossPublishServiceImpl.class);
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();

    public ApiResponse<String> sendFullInst(AppCrossPublishDto appCrossPublishDto) {
        String taskId = this.startPublishTask();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)NoCodeSecurityUtil.getUser());
        TransmittableThreadLocalHolder.set((String)"publishCacheKey", (Object)taskId);
        ThreadPoolUtil.execute(() -> {
            Long packageFileId = this.appPackageService.packageApp(appCrossPublishDto.getCurrentAppId(), Boolean.TRUE.booleanValue());
            this.fullPublishCall(appCrossPublishDto.getPublishServerId(), packageFileId, taskId);
        });
        return ApiResponse.success((String)taskId);
    }

    private void fullPublishCall(Long serverId, Long packageFileId, String taskId) {
        AttachmentManagerModelVo attachmentManagerModelVo = this.attachmentManagerService.getByFileId(packageFileId);
        String packagePath = attachmentManagerModelVo.getPath();
        File file = new File(packagePath);
        AppPublishFullDto appPublishFullDto = new AppPublishFullDto();
        appPublishFullDto.setTaskId(taskId);
        RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("appUpgradePackage", file.getName(), requestBody).addFormDataPart("appPublishFullDto", JSON.toJSONString((Object)appPublishFullDto)).build();
        SysPublishServer publishServer = (SysPublishServer)this.sysPublishServerService.getById((Serializable)serverId);
        AssertUtil.isNotNull((Object)publishServer, (String)"\u73af\u5883\u4e0d\u5b58\u5728");
        String tcode = publishServer.getTcode();
        String path = "/hussarBase/application/crossPublish/fullInst/execute";
        String url = this.concatUrl(publishServer, path);
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Content-Type", "application/json").post((RequestBody)body);
        Request request = HussarUtils.isEmpty((Object)tcode) ? requestBuilder.build() : requestBuilder.addHeader("tcode", tcode).build();
        try (Response response = OK_HTTP_CLIENT.newCall(request).execute();){
            LOGGER.info("\u5168\u91cf\u53d1\u5e03\u5347\u7ea7\u5305\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5168\u91cf\u53d1\u5e03\u5347\u7ea7\u5305\u53d1\u9001\u5931\u8d25: {}", (Object)e.getMessage());
            HussarCacheUtil.put((String)"publish_progress", (Object)taskId, (Object)AppPublishStatusVo.fail((String)e.getMessage()));
        }
    }

    public ApiResponse<Boolean> execFullInst(MultipartFile appUpgradePackage, AppPublishFullDto appPublishFullDto) {
        LOGGER.info("\u6210\u529f\u63a5\u6536\u5168\u91cf\u5305");
        AppAttachmentParseVo data = (AppAttachmentParseVo)this.appImportService.parseAttachment(appUpgradePackage).getData();
        SecurityUser loginUser = new SecurityUser();
        loginUser.setUserId(AppUpgradeConstant.SUPER_ADMIN);
        loginUser.setId(AppUpgradeConstant.SUPER_ADMIN);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
        TransmittableThreadLocalHolder.set((String)"publishCacheKey", (Object)appPublishFullDto.getTaskId());
        LOGGER.info("\u5168\u91cf\u5305\u89e3\u6790\u5b8c\u6210");
        ThreadPoolUtil.execute(() -> {
            AppImportDto appImportDto = new AppImportDto();
            appImportDto.setPath(data.getPath());
            boolean availableAppNameFlag = this.appImportService.verifyAppName(data.getAppName());
            if (!availableAppNameFlag) {
                appImportDto.setAppName(data.getAppName() + RandomUtil.randomNumbers((int)3));
            } else {
                appImportDto.setAppName(data.getAppName());
            }
            appImportDto.setCrossPublish(Boolean.TRUE.booleanValue());
            appImportDto.setAppGroupId(AppPublishConstant.DEFAULT_APP_GROUP);
            try {
                LOGGER.info("\u5e94\u7528\u5168\u91cf\u53d1\u5e03\u5f00\u59cb");
                this.appImportThreadService.startImportThread(appImportDto);
                LOGGER.info("\u5e94\u7528\u5168\u91cf\u53d1\u5e03\u6210\u529f");
            }
            catch (Exception e) {
                LOGGER.error("\u5e94\u7528\u5168\u91cf\u53d1\u5e03\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<List<AppUpGroupContrast>> contrastForm(AppCrossPublishDto appCrossPublishDto) {
        Long currentAppId = appCrossPublishDto.getCurrentAppId();
        Long targetAppId = appCrossPublishDto.getTargetAppId();
        Long serverId = appCrossPublishDto.getPublishServerId();
        AssertUtil.isNotNull((Object)currentAppId, (String)"\u5f53\u524d\u5e94\u7528\u4e0d\u5b58\u5728");
        AssertUtil.isNotNull((Object)currentAppId, (String)"\u76ee\u6807\u5e94\u7528\u4e0d\u5b58\u5728");
        AssertUtil.isNotNull((Object)currentAppId, (String)"\u53d1\u5e03\u73af\u5883\u4e0d\u5b58\u5728");
        SysPublishServer publishServer = (SysPublishServer)this.sysPublishServerService.getById((Serializable)serverId);
        AssertUtil.isNotNull((Object)publishServer, (String)"\u73af\u5883\u4e0d\u5b58\u5728");
        String tcode = publishServer.getTcode();
        String path = "/hussarBase/application/crossPublish/formGroup/list?appId=" + targetAppId;
        String url = this.concatUrl(publishServer, path);
        List<Object> targetGroupList = new ArrayList();
        Request request = this.buildRequest(url, tcode);
        try (Response response = OK_HTTP_CLIENT.newCall(request).execute();){
            if (this.isResponseValid(response)) {
                targetGroupList = this.handleResponseToList(response, AppUpGroupVo.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u76ee\u6807\u73af\u5883\u4e0b\u8868\u5355\u4fe1\u606f\u5931\u8d25!", (Throwable)e);
        }
        List currentGroupList = this.appUpgradeService.listFormGroupByAppId(currentAppId);
        List appUpGroupContrastList = this.appUpgradeService.contrastGroup(targetGroupList, currentGroupList);
        return ApiResponse.success((Object)appUpGroupContrastList);
    }

    public ApiResponse<String> sendIncrementInst(AppCrossPublishDto appCrossPublishDto) {
        String taskId = this.startPublishTask();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)NoCodeSecurityUtil.getUser());
        TransmittableThreadLocalHolder.set((String)"publishCacheKey", (Object)taskId);
        ThreadPoolUtil.execute(() -> {
            Long packageFileId = this.appPackageService.packageApp(appCrossPublishDto.getCurrentAppId(), Boolean.TRUE.booleanValue());
            this.incrementPublishCall(appCrossPublishDto, packageFileId, taskId);
        });
        return ApiResponse.success((String)taskId);
    }

    private void incrementPublishCall(AppCrossPublishDto appCrossPublishDto, Long packageFileId, String taskId) {
        AttachmentManagerModelVo attachmentManagerModelVo = this.attachmentManagerService.getByFileId(packageFileId);
        String packagePath = attachmentManagerModelVo.getPath();
        File file = new File(packagePath);
        AppPublishIncrementDto appPublishIncrementDto = new AppPublishIncrementDto();
        appPublishIncrementDto.setTaskId(taskId);
        appPublishIncrementDto.setUpgradeAppId(appCrossPublishDto.getTargetAppId());
        appPublishIncrementDto.getFormGroupIdMap().putAll(AppUpgradeUtil.longToStringKey(appCrossPublishDto.getFormGroupIdMap()));
        appPublishIncrementDto.getFormIdMap().putAll(AppUpgradeUtil.longToStringKey(appCrossPublishDto.getFormIdMap()));
        appPublishIncrementDto.getSubTableNameMap().putAll(appCrossPublishDto.getSubTableNameMap());
        SysPublishServer publishServer = (SysPublishServer)this.sysPublishServerService.getById((Serializable)appCrossPublishDto.getPublishServerId());
        AssertUtil.isNotNull((Object)publishServer, (String)"\u73af\u5883\u4e0d\u5b58\u5728");
        String tcode = publishServer.getTcode();
        String path = "/hussarBase/application/crossPublish/incrementInst/execute";
        String url = this.concatUrl(publishServer, path);
        RequestBody requestBody = RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"));
        MultipartBody body = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("appUpgradePackage", file.getName(), requestBody).addFormDataPart("appPublishIncrementDto", JSON.toJSONString((Object)appPublishIncrementDto)).build();
        Request.Builder requestBuilder = new Request.Builder().url(url).post((RequestBody)body).addHeader("Content-Type", "application/json");
        Request request = HussarUtils.isEmpty((Object)tcode) ? requestBuilder.build() : requestBuilder.addHeader("tcode", tcode).build();
        try (Response response = OK_HTTP_CLIENT.newCall(request).execute();){
            LOGGER.info("\u589e\u91cf\u53d1\u5e03\u5347\u7ea7\u5305\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u589e\u91cf\u53d1\u5e03\u5347\u7ea7\u5305\u53d1\u9001\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            HussarCacheUtil.put((String)"publish_progress", (Object)taskId, (Object)AppPublishStatusVo.fail((String)e.getMessage()));
        }
    }

    public ApiResponse<Boolean> execIncrementInst(MultipartFile appUpgradePackage, AppPublishIncrementDto appPublishIncrementDto) {
        LOGGER.info("\u6210\u529f\u63a5\u6536\u589e\u91cf\u5305");
        AppAttachmentParseVo data = (AppAttachmentParseVo)this.appImportService.parseAttachment(appUpgradePackage).getData();
        LOGGER.info("\u589e\u91cf\u5305\u89e3\u6790\u5b8c\u6210");
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)NoCodeSecurityUtil.getUser());
        TransmittableThreadLocalHolder.set((String)"publishCacheKey", (Object)appPublishIncrementDto.getTaskId());
        ThreadPoolUtil.execute(() -> {
            AppUpgradeDto appUpgradeDto = new AppUpgradeDto();
            appUpgradeDto.setCurrentAppId(appPublishIncrementDto.getUpgradeAppId());
            appUpgradeDto.setPath(data.getPath());
            appUpgradeDto.setAppName(data.getAppName());
            appUpgradeDto.setCrossPublish(Boolean.TRUE.booleanValue());
            appUpgradeDto.getFormGroupIdMap().putAll(AppUpgradeUtil.stringToLongKey(appPublishIncrementDto.getFormGroupIdMap()));
            appUpgradeDto.getFormIdMap().putAll(AppUpgradeUtil.stringToLongKey(appPublishIncrementDto.getFormIdMap()));
            appUpgradeDto.setSubTableNameMap(appPublishIncrementDto.getSubTableNameMap());
            try {
                LOGGER.info("\u5e94\u7528\u589e\u91cf\u53d1\u5e03\u5f00\u59cb");
                this.appUpgradeService.execute(appUpgradeDto);
            }
            catch (Exception e) {
                LOGGER.error("\u5e94\u7528\u589e\u91cf\u53d1\u5e03\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<List<AppUpGroupVo>> listFormGroup(Long appId) {
        return ApiResponse.success((Object)this.appUpgradeService.listFormGroupByAppId(appId));
    }

    private ApiResponse<List<SysApplicationVo>> getCurrentServerAppList(String appName) {
        return ApiResponse.success(this.sysApplicationMapper.getAppList(appName, null));
    }

    private ApiResponse<List<SysApplicationVo>> getPublishServerAppList(Long publishServerId, String appName) {
        List<Object> result = new ArrayList();
        SysPublishServer publishServer = (SysPublishServer)this.sysPublishServerService.getById((Serializable)publishServerId);
        AssertUtil.isNotNull((Object)publishServer, (String)"\u73af\u5883\u4e0d\u5b58\u5728");
        String tcode = publishServer.getTcode();
        String path = "/hussarBase/application/crossPublish/getAppList";
        path = HussarUtils.isEmpty((Object)appName) ? path : path + "?appName=" + appName;
        String url = this.concatUrl(publishServer, path);
        Request request = this.buildRequest(url, tcode);
        try (Response response = OK_HTTP_CLIENT.newCall(request).execute();){
            if (this.isResponseValid(response)) {
                result = this.handleResponseToList(response, SysApplicationVo.class).stream().filter(app -> HussarUtils.isNotEmpty((Object)app.getAppType())).filter(app -> HussarUtils.equals((Object)"1", (Object)app.getAppType())).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u53d1\u5e03\u73af\u5883\u5e94\u7528\u5931\u8d25!", (Throwable)e);
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<List<SysApplicationVo>> listApplicationByAppName(Long publishServerId, String appName) {
        if (HussarUtils.isEmpty((Object)publishServerId)) {
            return this.getCurrentServerAppList(appName);
        }
        return this.getPublishServerAppList(publishServerId, appName);
    }

    public ApiResponse<List<SysPublishServerVo>> getPublishServerList() {
        return this.sysPublishServerService.getPublishServerList();
    }

    public ApiResponse<AppPublishStatusVo> getAppPublishProgress(String cacheKey, Long serverId) {
        AssertUtil.isNotNull((Object)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
        AppPublishStatusVo appPublishStatusVo = (AppPublishStatusVo)HussarCacheUtil.get((String)"publish_progress", (Object)cacheKey, AppPublishStatusVo.class);
        if (appPublishStatusVo.getStatus() >= 9) {
            appPublishStatusVo = this.fetchRemotePublishProgress(serverId, cacheKey);
        }
        return ApiResponse.success((Object)appPublishStatusVo);
    }

    private AppPublishStatusVo fetchRemotePublishProgress(Long serverId, String cacheKey) {
        SysPublishServer publishServer = (SysPublishServer)this.sysPublishServerService.getById((Serializable)serverId);
        AssertUtil.isNotNull((Object)publishServer, (String)"\u73af\u5883\u4e0d\u5b58\u5728");
        String tcode = publishServer.getTcode();
        String path = "/hussarBase/application/crossPublish/progress/get?taskId=" + cacheKey;
        String url = this.concatUrl(publishServer, path);
        Request request = this.buildRequest(url, tcode);
        AppPublishStatusVo appPublishStatusVo = null;
        try (Response response = OK_HTTP_CLIENT.newCall(request).execute();){
            if (this.isResponseValid(response)) {
                appPublishStatusVo = this.handleResponseToObject(response, AppPublishStatusVo.class);
            }
        }
        catch (IOException e) {
            LOGGER.error("\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25: {}", (Object)e.getMessage());
        }
        return appPublishStatusVo;
    }

    private <T> T handleResponseToObject(Response response, Class<T> clazz) {
        try {
            ApiResponse apiResponse;
            if (HussarUtils.isNotEmpty((Object)response.body()) && HussarUtils.isNotEmpty((Object)(apiResponse = (ApiResponse)JSON.parseObject((String)response.body().string(), ApiResponse.class)).getData())) {
                return (T)JSON.parseObject((String)JSON.toJSONString((Object)apiResponse.getData()), clazz);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u54cd\u5e94\u89e3\u6790\u5931\u8d25!", (Throwable)e);
        }
        return null;
    }

    private boolean isResponseValid(Response response) {
        return response.isSuccessful() && HussarUtils.isNotEmpty((Object)response.body());
    }

    private <T> List<T> handleResponseToList(Response response, Class<T> clazz) {
        try {
            ApiResponse apiResponse;
            if (HussarUtils.isNotEmpty((Object)response.body()) && HussarUtils.isNotEmpty((Object)(apiResponse = (ApiResponse)JSON.parseObject((String)response.body().string(), ApiResponse.class)).getData())) {
                return JSON.parseArray((String)JSON.toJSONString((Object)apiResponse.getData()), clazz);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u54cd\u5e94\u89e3\u6790\u5931\u8d25!", (Throwable)e);
        }
        return new ArrayList();
    }

    private Request buildRequest(String url, String tcode) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (HussarUtils.isNotEmpty((Object)tcode)) {
            requestBuilder.addHeader("tcode", tcode);
        }
        return requestBuilder.build();
    }

    private String startPublishTask() {
        String taskId = String.valueOf(UUID.randomUUID());
        HussarCacheUtil.put((String)"publish_progress", (Object)taskId, (Object)AppPublishStatusVo.start((String)"\u53d1\u5e03\u5f00\u59cb"));
        return taskId;
    }

    private String concatUrl(SysPublishServer publishServer, String path) {
        String serverIp = publishServer.getIp();
        Integer serverPort = publishServer.getPort();
        String forwardingFlag = publishServer.getForwardingFlag();
        String serverAddress = "http://" + serverIp + ":" + serverPort;
        return HussarUtils.isNotEmpty((Object)forwardingFlag) ? serverAddress + "/hussarApi/" + forwardingFlag + path : serverAddress + "/hussarApi" + path;
    }
}

