/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.print.service.impl;

import com.alibaba.excel.util.FileUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFrameService;
import com.jxdinfo.hussar.formdesign.application.application.dto.ImportMappingDto;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleInnerService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleStatusService;
import com.jxdinfo.hussar.formdesign.application.print.dao.SysPrintTemplateMapper;
import com.jxdinfo.hussar.formdesign.application.print.dto.SysPrintTemplateDto;
import com.jxdinfo.hussar.formdesign.application.print.dto.WordPrintParamsDto;
import com.jxdinfo.hussar.formdesign.application.print.enums.FileNameMode;
import com.jxdinfo.hussar.formdesign.application.print.enums.PrintTemplateType;
import com.jxdinfo.hussar.formdesign.application.print.enums.PrintUsingScope;
import com.jxdinfo.hussar.formdesign.application.print.enums.PrintVisibleScope;
import com.jxdinfo.hussar.formdesign.application.print.enums.ProcessState;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandleForCopy;
import com.jxdinfo.hussar.formdesign.application.print.model.SysPrintTemplate;
import com.jxdinfo.hussar.formdesign.application.print.model.SysWordPrintTask;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysPrintTemplateService;
import com.jxdinfo.hussar.formdesign.application.print.service.ISysWordPrintTaskService;
import com.jxdinfo.hussar.formdesign.application.print.strategy.WidgetStrategyContext;
import com.jxdinfo.hussar.formdesign.application.print.util.PrintTemplateUtil;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintGeneFileName;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintTemplateVo;
import com.jxdinfo.hussar.formdesign.application.print.vo.SysPrintVisibleScope;
import com.jxdinfo.hussar.formdesign.application.print.vo.WidgetsAndData;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@Service
@HussarTokenDs
public class SysPrintTemplateServiceImpl
extends HussarServiceImpl<SysPrintTemplateMapper, SysPrintTemplate>
implements ISysPrintTemplateService {
    @Resource
    private OssProperties ossProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private WordHandle wordHandle;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    ISysWordPrintTaskService wordPrintTaskService;
    @Resource
    ISysFormLinkSingleService sysFormLinkSingleService;
    @Resource
    ISysFormLinkSingleInnerService sysFormLinkSingleInnerService;
    @Resource
    private SysPrintTemplateMapper printTemplateMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysFormLinkSingleStatusService sysFormLinkSingleStatusService;
    @Resource
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Resource
    private WordHandleForCopy wordHandleForCopy;
    @Resource
    private OssService ossService;
    @Resource
    private IHussarAppFrameService appFrameService;
    @Resource
    private ISysPrintTemplateService sysPrintTemplateService;
    @Value(value="${hussar.nocode.redirect.long.ip}")
    private String ip;
    @Value(value="${hussar.nocode.redirect.publicSingleInner}")
    private String publicSingleInner;
    @Value(value="${hussar.nocode.redirect.publicSingle}")
    private String publicSingle;
    private static final String DEFAULT_VISIBLE_SCOPE;
    private static final String DEFAULT_FILE_NAME;
    private static final Logger LOGGER;

    @HussarTransactional
    public synchronized ApiResponse<SysPrintTemplateVo> initExcelTemp(Long formId) {
        LambdaQueryWrapper excelQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)excelQuery.eq(SysPrintTemplate::getFormId, (Object)formId)).eq(SysPrintTemplate::getType, (Object)"excel-system");
        List sysPrintTemplates = this.list((Wrapper)excelQuery);
        if (HussarUtils.isNotEmpty((Object)sysPrintTemplates)) {
            SysPrintTemplate sysPrintTemplate = (SysPrintTemplate)sysPrintTemplates.get(0);
            sysPrintTemplates.remove(sysPrintTemplate);
            if (HussarUtils.isNotEmpty((Object)sysPrintTemplates)) {
                this.removeByIds(sysPrintTemplates.stream().map(SysPrintTemplate::getId).collect(Collectors.toList()));
            }
            SysPrintTemplateVo oneVo = new SysPrintTemplateVo();
            PrintTemplateUtil.copyProperties(sysPrintTemplate, oneVo);
            return ApiResponse.success((Object)oneVo);
        }
        SysPrintTemplate excelTemp = new SysPrintTemplate();
        excelTemp.setFormId(formId);
        excelTemp.setName("Excel\u5bfc\u51fa\u6a21\u677f");
        excelTemp.setType("excel-system");
        excelTemp.setExportType("export");
        this.initPrintTemplate(excelTemp);
        this.save((BaseEntity)excelTemp);
        SysPrintTemplateVo oneVo = new SysPrintTemplateVo();
        PrintTemplateUtil.copyProperties(excelTemp, oneVo);
        return ApiResponse.success((Object)oneVo);
    }

    @HussarTransactional
    public synchronized ApiResponse<SysPrintTemplateVo> initSysTemp(Long formId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysPrintTemplate::getFormId, (Object)formId)).eq(SysPrintTemplate::getType, (Object)"system");
        List sysPrintTemplates = this.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysPrintTemplates)) {
            SysPrintTemplate sysPrintTemplate = (SysPrintTemplate)sysPrintTemplates.get(0);
            sysPrintTemplates.remove(sysPrintTemplate);
            if (HussarUtils.isNotEmpty((Object)sysPrintTemplates)) {
                this.removeByIds(sysPrintTemplates.stream().map(SysPrintTemplate::getId).collect(Collectors.toList()));
            }
            SysPrintTemplateVo oneVo = new SysPrintTemplateVo();
            PrintTemplateUtil.copyProperties(sysPrintTemplate, oneVo);
            return ApiResponse.success((Object)oneVo);
        }
        SysPrintTemplate sysPrintTemplate = new SysPrintTemplate();
        sysPrintTemplate.setFormId(formId);
        sysPrintTemplate.setName("\u7cfb\u7edf\u6253\u5370");
        sysPrintTemplate.setType("system");
        this.initPrintTemplate(sysPrintTemplate);
        sysPrintTemplate.setUsingScope(PrintUsingScope.DETAIL.getValue() + ',' + PrintUsingScope.LINK_OPEN.getValue() + "," + PrintUsingScope.LINK_SINGLE.getValue());
        this.save((BaseEntity)sysPrintTemplate);
        SysPrintTemplateVo oneVo = new SysPrintTemplateVo();
        PrintTemplateUtil.copyProperties(sysPrintTemplate, oneVo);
        return ApiResponse.success((Object)oneVo);
    }

    public ApiResponse<Long> create(SysPrintTemplateDto sysPrintTemplateDto) {
        AssertUtil.isNotNull((Object)sysPrintTemplateDto, (String)"\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isNotNull((Object)PrintTemplateType.getPtType((String)sysPrintTemplateDto.getType()), (String)"\u975e\u6cd5\u7684\u6253\u5370\u6a21\u677f\u7c7b\u578b\uff01");
        SysPrintTemplate sysPrintTemplate = new SysPrintTemplate();
        PrintTemplateUtil.copyProperties(sysPrintTemplateDto, sysPrintTemplate);
        this.initPrintTemplate(sysPrintTemplate);
        this.save((BaseEntity)sysPrintTemplate);
        return ApiResponse.success((Object)sysPrintTemplate.getId());
    }

    private void initPrintTemplate(SysPrintTemplate sysPrintTemplate) {
        sysPrintTemplate.setEnabled(Boolean.TRUE);
        sysPrintTemplate.setUsingScope(PrintUsingScope.DETAIL.getValue());
        sysPrintTemplate.setVisibleScope(DEFAULT_VISIBLE_SCOPE);
        sysPrintTemplate.setFileName(DEFAULT_FILE_NAME);
    }

    public ApiResponse<SysPrintTemplateVo> detailById(Long id) {
        SysPrintTemplate sysPrintTemplate = (SysPrintTemplate)this.getById(id);
        JSONObject content = JSON.parseObject((String)sysPrintTemplate.getContent());
        SysPrintTemplateVo sysPrintTemplateVo = new SysPrintTemplateVo();
        PrintTemplateUtil.copyProperties(sysPrintTemplate, sysPrintTemplateVo);
        return ApiResponse.success((Object)sysPrintTemplateVo);
    }

    public ApiResponse<List<SysPrintTemplateVo>> listByFormId(Long formId, String exportType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty((Object)exportType)) {
            queryWrapper.isNull(SysPrintTemplate::getExportType);
        } else {
            queryWrapper.eq(SysPrintTemplate::getExportType, (Object)exportType);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(SysPrintTemplate::getFormId, (Object)formId)).orderByDesc(HussarBaseEntity::getCreateTime);
        AssertUtil.isNotNull((Object)formId, (String)"\u8868\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        List sysPrintTemplates = this.list((Wrapper)queryWrapper);
        boolean hasSystem = true;
        SysPrintTemplateVo dataVo = null;
        SysPrintTemplate data = new SysPrintTemplate();
        if (HussarUtils.isEmpty((Object)exportType)) {
            this.handleRepeatData(sysPrintTemplates);
            for (SysPrintTemplate sysPrintTemplate : sysPrintTemplates) {
                if (!sysPrintTemplate.getType().equals("system")) continue;
                hasSystem = false;
                break;
            }
            if (hasSystem) {
                dataVo = (SysPrintTemplateVo)this.initSysTemp(formId).getData();
            }
        } else {
            this.handleRepeatData(sysPrintTemplates);
            for (SysPrintTemplate sysPrintTemplate : sysPrintTemplates) {
                if (!sysPrintTemplate.getType().equals("excel-system")) continue;
                hasSystem = false;
                break;
            }
            if (hasSystem) {
                dataVo = (SysPrintTemplateVo)this.initExcelTemp(formId).getData();
            }
        }
        if (HussarUtils.isNotEmpty(dataVo)) {
            PrintTemplateUtil.copyProperties(dataVo, data);
            sysPrintTemplates.add(data);
        }
        List collected = sysPrintTemplates.stream().sorted((pt1, pt2) -> {
            String type1 = pt1.getType();
            String type2 = pt2.getType();
            if (type1.equals(PrintTemplateType.EXCEL_SYSTEM.getType()) || type1.equals(PrintTemplateType.SYSTEM.getType())) {
                return -1;
            }
            if (type2.equals(PrintTemplateType.EXCEL_SYSTEM.getType()) || type2.equals(PrintTemplateType.SYSTEM.getType())) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
        List sysPrintTemplateVos = collected.stream().map(template -> PrintTemplateUtil.copyProperties(template, SysPrintTemplateVo.class)).collect(Collectors.toList());
        return ApiResponse.success(sysPrintTemplateVos);
    }

    private void handleRepeatData(List<SysPrintTemplate> sysPrintTemplates) {
        if (HussarUtils.isNotEmpty(sysPrintTemplates)) {
            List collected = sysPrintTemplates.stream().filter(sysPrintTemplate -> sysPrintTemplate.getType().equals("system") || sysPrintTemplate.getType().equals("excel-system")).collect(Collectors.toList());
            sysPrintTemplates.removeAll(collected);
            if (HussarUtils.isNotEmpty(collected)) {
                SysPrintTemplate sysPrintTemplate2 = (SysPrintTemplate)collected.get(0);
                collected.remove(sysPrintTemplate2);
                if (HussarUtils.isNotEmpty(collected)) {
                    this.removeByIds(collected.stream().map(SysPrintTemplate::getId).collect(Collectors.toList()));
                }
                sysPrintTemplates.add(sysPrintTemplate2);
            }
        }
    }

    public ApiResponse<List<SysPrintTemplateVo>> listAvailableByFormId(Long formId, String exportType) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getId();
        Long organId = user.getDeptId();
        List rolesList = user.getRolesList();
        SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)formId);
        AssertUtil.isNotNull((Object)sysForm, (String)"\u8868\u5355\u4e0d\u5b58\u5728\uff01");
        Long appId = sysForm.getAppId();
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        AssertUtil.isNotNull((Object)sysApplication, (String)"\u5e94\u7528\u4e0d\u5b58\u5728\uff01");
        Long developRoleId = sysApplication.getDevelopRoleId();
        boolean isAdmin = user.isSuperAdmin() || rolesList.contains(developRoleId);
        return ApiResponse.success(Optional.ofNullable(this.listByFormId(formId, exportType)).map(ApiResponse::getData).orElse(Collections.emptyList()).stream().filter(SysPrintTemplateDto::getEnabled).filter(this.visible(isAdmin, userId, organId)).collect(Collectors.toList()));
    }

    private Predicate<SysPrintTemplateVo> visible(boolean isAdmin, Long userId, Long organId) {
        return pt -> {
            if (isAdmin) {
                return true;
            }
            SysPrintVisibleScope visibleScope = pt.getVisibleScope();
            String allStaff = visibleScope.getAllStaff();
            if ("1".equals(allStaff)) {
                return true;
            }
            List staffs = visibleScope.getStaffs();
            boolean containCurrentUser = staffs.stream().map(staff -> PrintTemplateUtil.ObjectToLong(staff.get((Object)"id"))).anyMatch(id -> HussarUtils.equals((Object)id, (Object)userId));
            if (containCurrentUser) {
                return true;
            }
            List organs = visibleScope.getOrgans();
            List organIds = organs.stream().map(organ -> PrintTemplateUtil.ObjectToLong(organ.get((Object)"id"))).collect(Collectors.toList());
            ArrayList visibleOrganIds = new ArrayList(organIds);
            if (HussarUtils.equals((Object)Boolean.TRUE, (Object)visibleScope.getContainSub())) {
                for (Long id2 : organIds) {
                    List allSubOrgan = this.appFrameService.getAllSubOrgan(id2);
                    visibleOrganIds.addAll(allSubOrgan.stream().map(organ -> Long.valueOf(organ.getId())).collect(Collectors.toList()));
                }
            }
            return visibleOrganIds.contains(organId);
        };
    }

    @HussarTransactional
    public ApiResponse<Boolean> update(SysPrintTemplateDto sysPrintTemplateDto) {
        AssertUtil.isNotNull((Object)sysPrintTemplateDto, (String)"\u6253\u5370\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a!");
        SysPrintTemplate printTemplate = (SysPrintTemplate)this.getById(sysPrintTemplateDto.getId());
        AssertUtil.isNotNull((Object)printTemplate, (String)"\u5f85\u4fee\u6539\u7684\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728");
        SysPrintTemplate sysPrintTemplate = new SysPrintTemplate();
        PrintTemplateUtil.copyProperties(sysPrintTemplateDto, sysPrintTemplate);
        this.updateById((BaseEntity)sysPrintTemplate);
        return ApiResponse.success((Object)true, (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteByPrintId(SysPrintTemplateDto sysPrintTemplateDto) {
        SysPrintTemplate printTemplate = (SysPrintTemplate)this.getById(sysPrintTemplateDto.getId());
        AssertUtil.isNotNull((Object)printTemplate, (String)"\u5f85\u5220\u9664\u7684\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728");
        this.deletePrintTemplate(printTemplate);
        this.sysFormLinkSingleStatusService.cleanPrintArr(printTemplate.getId(), printTemplate.getFormId());
        this.sysFormLinkOpenService.cleanPrintArr(printTemplate.getId(), printTemplate.getFormId());
        return ApiResponse.success((Object)true, (String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private void deletePrintTemplate(SysPrintTemplate printTemplate) {
        Long printId = printTemplate.getId();
        AssertUtil.isNotNull((Object)printId, (String)"\u5220\u9664\u6253\u5370\u6a21\u677f\u65f6\uff0c\u6a21\u677fid\u4e3a\u7a7a!");
        this.removeById(printId);
    }

    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id, String tabType, String appId) {
        ResponseEntity responseEntity = this.appFormService.formQuery(formId, id, tabType, appId);
        EngineResultEntity entity = Optional.ofNullable(responseEntity).map(HttpEntity::getBody).map(ApiResponse::getData).map(o -> (EngineResultEntity)HussarUtils.convert((Object)o, EngineResultEntity.class)).orElseThrow(() -> new BaseException("\u8868\u5355\u6570\u636e\u67e5\u8be2\u5931\u8d25"));
        if (entity.containsKey((Object)"PROCESS_STATE")) {
            String processStateDesc = ProcessState.getDescByCode((String)String.valueOf(entity.get((Object)"PROCESS_STATE")));
            entity.put((Object)"PROCESS_STATE", (Object)processStateDesc);
        }
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        List originWidgets = canvasSchema.widgets();
        List childrenWidgets = canvasSchema.childTables();
        List systemWidgets = canvasSchema.systemWidgets();
        childrenWidgets.addAll(systemWidgets);
        List<Widget> widgets = PrintTemplateUtil.castList(CollectionUtils.union((Iterable)originWidgets, (Iterable)childrenWidgets), Widget.class);
        HashMap<String, String> map = new HashMap<String, String>();
        JSONArray list = new JSONArray();
        widgets.forEach(widget -> {
            entity.put((Object)widget.getName(), this.dealFieldValue(entity, (Widget)widget));
            map.put(widget.getName(), widget.getType());
            list.add(widget);
            if (widget.getType().equals(WidgetType.CHILDREN_TABLE.getType()) || widget.getType().equals(WidgetType.JXDNChildrenTableAgg.getType())) {
                List children = widget.getChildren();
                children.forEach(widget1 -> {
                    map.put(widget1.getName(), widget1.getType());
                    list.add(widget1);
                });
            }
        });
        String widgetsStr = JSON.toJSONString((Object)list);
        map.put("widgetsStr", widgetsStr);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)new WidgetsAndData(entity, map)));
    }

    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, String viewId, Map<String, Object> params, String appId) {
        ArrayList allData = new ArrayList();
        int i = 1;
        while (true) {
            params.put("current", i);
            params.put("size", 500);
            ResponseEntity response = this.appFormService.tableQuery(formId, viewId, params, appId);
            PageVo pageVo = (PageVo)((ApiResponse)response.getBody()).getData();
            if (HussarUtils.isEmpty((Object)((ApiResponse)response.getBody()).getData())) break;
            ArrayList oneData = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                oneData = (ArrayList)pageVo.getData();
            }
            allData.addAll(oneData);
            if (oneData.size() < 500) break;
            ++i;
        }
        ArrayList entities = new ArrayList();
        allData.forEach(entity -> {
            EngineResultEntity convert = (EngineResultEntity)HussarUtils.convert((Object)entity, EngineResultEntity.class);
            assert (convert != null);
            if (convert.containsKey((Object)"PROCESS_STATE")) {
                String processStateDesc = ProcessState.getDescByCode((String)String.valueOf(convert.get((Object)"PROCESS_STATE")));
                convert.put((Object)"PROCESS_STATE", (Object)processStateDesc);
            }
            entities.add(convert);
        });
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        List originWidgets = canvasSchema.widgets();
        List childrenWidgets = canvasSchema.childTables();
        List systemWidgets = canvasSchema.systemWidgets();
        childrenWidgets.addAll(systemWidgets);
        List<Widget> widgets = PrintTemplateUtil.castList(CollectionUtils.union((Iterable)originWidgets, (Iterable)childrenWidgets), Widget.class);
        HashMap<String, String> map = new HashMap<String, String>();
        JSONArray list = new JSONArray();
        list.addAll(widgets);
        widgets.forEach(widget -> entities.forEach(entity -> {
            entity.put((Object)widget.getName(), this.dealFieldValue((EngineResultEntity)entity, (Widget)widget));
            map.put(widget.getName(), widget.getType());
            if (widget.getType().equals(WidgetType.CHILDREN_TABLE.getType()) || widget.getType().equals(WidgetType.JXDNChildrenTableAgg.getType())) {
                List children = widget.getChildren();
                children.forEach(widget1 -> map.put(widget1.getName(), widget1.getType()));
            }
        }));
        String widgetsStr = JSON.toJSONString((Object)list);
        map.put("widgetsStr", widgetsStr);
        ArrayList list1 = new ArrayList();
        EngineResultEntity engineResult = new EngineResultEntity();
        entities.forEach(entity -> {
            HashMap map2 = new HashMap();
            map2.putAll(entity);
            list1.add(map2);
        });
        engineResult.put((Object)"\u4e3b\u8868", list1);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)new WidgetsAndData(engineResult, map)));
    }

    public ApiResponse<Long> wordPrint(WordPrintParamsDto wordPrintParamsDto) {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        wordPrintParamsDto.setTaskId(taskId);
        SysWordPrintTask sysWordPrintTask = new SysWordPrintTask();
        sysWordPrintTask.setTaskId(taskId);
        sysWordPrintTask.setTaskStatus(Integer.valueOf(0));
        this.wordPrintTaskService.save((Object)sysWordPrintTask);
        EngineUserUtil.setUser((UserDetails)HussarSecurityUtils.getLoginUserDetails());
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        wordPrintParamsDto.setUserDetails(loginUserDetails);
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String dataSourceKey = DataModelUtil.currentDsName();
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.wordHandle.wordHandle(wordPrintParamsDto, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    public ApiResponse<Long> wordHandleBatch(WordPrintParamsDto wordPrintParamsDto) {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        wordPrintParamsDto.setTaskId(taskId);
        SysWordPrintTask sysWordPrintTask = new SysWordPrintTask();
        sysWordPrintTask.setTaskId(taskId);
        sysWordPrintTask.setTaskStatus(Integer.valueOf(0));
        this.wordPrintTaskService.save((Object)sysWordPrintTask);
        EngineUserUtil.setUser((UserDetails)HussarSecurityUtils.getLoginUserDetails());
        UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails();
        wordPrintParamsDto.setUserDetails(loginUserDetails);
        TransmittableThreadLocalHolder.set((String)"loginUserDetails", (Object)HussarSecurityUtils.getLoginUserDetails());
        String dataSourceKey = DataModelUtil.currentDsName();
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.wordHandle.wordHandleBatch(wordPrintParamsDto, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    public ApiResponse<SysWordPrintTask> getTaskDetail(Long taskId) {
        SysWordPrintTask wordPrintTask = (SysWordPrintTask)this.wordPrintTaskService.getById((Serializable)taskId);
        if (HussarUtils.isEmpty((Object)wordPrintTask)) {
            throw new BaseException("word\u6253\u5370\u6a21\u677f\u89e3\u6790\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (wordPrintTask.getTaskStatus() == -1) {
            return ApiResponse.success((Object)wordPrintTask, (String)"\u89e3\u6790\u5931\u8d25");
        }
        return ApiResponse.success((Object)wordPrintTask);
    }

    @HussarTransactional
    public ApiResponse<SysPrintTemplateVo> copy(Long printId) {
        SysPrintTemplate printTemplate = (SysPrintTemplate)this.getById(printId);
        AssertUtil.isNotNull((Object)printTemplate, (String)"\u5f85\u590d\u5236\u7684\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728");
        JSONObject content = JSON.parseObject((String)printTemplate.getContent());
        SysPrintTemplate targetPrintTemplate = new SysPrintTemplate();
        if ("barCode".equals(printTemplate.getType()) || "qrCode".equals(printTemplate.getType())) {
            BeanUtil.copyProperties((Object)printTemplate, (Object)targetPrintTemplate);
            targetPrintTemplate.setId(null);
            targetPrintTemplate.setContent(String.valueOf(content));
            this.save((BaseEntity)targetPrintTemplate);
        } else {
            Long sourceFileId = Long.valueOf(String.valueOf(content.get((Object)"id")));
            Long targetFileId = this.copyTemplateFile(sourceFileId);
            targetPrintTemplate = this.copyPrintTemplate(printId, targetFileId);
        }
        return ApiResponse.success((Object)PrintTemplateUtil.copyProperties(targetPrintTemplate, SysPrintTemplateVo.class));
    }

    private SysPrintTemplate copyPrintTemplate(Long printId, Long fileId) {
        SysPrintTemplate sourcePrintTemplate = (SysPrintTemplate)this.getById(printId);
        AssertUtil.isNotNull((Object)sourcePrintTemplate, (String)"\u5f85\u590d\u5236\u7684\u6253\u5370\u6a21\u677f\u4e0d\u5b58\u5728");
        SysPrintTemplate targetPrintTemplate = new SysPrintTemplate();
        BeanUtil.copyProperties((Object)sourcePrintTemplate, (Object)targetPrintTemplate);
        targetPrintTemplate.setId(null);
        targetPrintTemplate.setContent(JSON.toJSONString((Object)this.attachmentManagerService.getByFileId(fileId)));
        targetPrintTemplate.setCreateTime(null);
        this.save((BaseEntity)targetPrintTemplate);
        return targetPrintTemplate;
    }

    private Long copyTemplateFile(Long sourceFileId) {
        AttachmentManagerModelVo sourceAttachment = this.attachmentManagerService.getByFileId(sourceFileId);
        AttachmentManagerModelVo targetAttachment = new AttachmentManagerModelVo();
        BeanUtil.copyProperties((Object)sourceAttachment, (Object)targetAttachment);
        targetAttachment.setId(null);
        Long targetFileId = this.attachmentManagerService.saveAttachment((AttachmentManagerModel)targetAttachment);
        Path inputFilePath = Paths.get(sourceAttachment.getPath(), new String[0]);
        Path outputFilePath = Paths.get(targetAttachment.getAttachmentDir() + targetFileId + ".docx", new String[0]);
        try (InputStream inputStream = Files.newInputStream(inputFilePath, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(outputFilePath, new OpenOption[0]);){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOGGER.error("\u6a21\u677f\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01{}", (Object)e.getMessage());
        }
        return targetFileId;
    }

    public void exportPrintTemplate(List<SysPrintTemplate> printTemplates, String templateFilePath) {
        if (HussarUtils.isNotEmpty(printTemplates)) {
            for (SysPrintTemplate pt : printTemplates) {
                try {
                    JSONObject content = (JSONObject)JSON.parseObject((String)pt.getContent(), JSONObject.class);
                    Long fileId = Long.valueOf(String.valueOf(content.get((Object)"id")));
                    AttachmentManagerModelVo sourceAttachment = this.attachmentManagerService.getByFileId(fileId);
                    Path inputFilePath = Paths.get(sourceAttachment.getPath(), new String[0]);
                    String filePath = FileUtil.posixPath((String[])new String[]{templateFilePath, String.valueOf(pt.getId())});
                    File file = new File(filePath);
                    if (!file.exists() && !file.mkdirs()) {
                        throw new HussarException("\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u65f6\uff0c\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25!");
                    }
                    Path outputFilePath = Paths.get(filePath, sourceAttachment.getAttachmentName());
                    try {
                        InputStream inputStream = Files.newInputStream(inputFilePath, new OpenOption[0]);
                        Throwable throwable = null;
                        try {
                            OutputStream outputStream = Files.newOutputStream(outputFilePath, new OpenOption[0]);
                            Throwable throwable2 = null;
                            try {
                                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (outputStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        outputStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                outputStream.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6a21\u677f\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01{}", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u6a21\u677f\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01{},\u6a21\u677f\u6587\u4ef6id\uff1a{}", (Object)e.getMessage(), (Object)pt.getId());
                }
            }
        }
    }

    public void importPrintTemplate(ImportMappingDto importMappingDto, List<SysPrintTemplate> printTemplates, String templateFilePath) {
        if (HussarUtils.isNotEmpty(printTemplates)) {
            for (SysPrintTemplate pt : printTemplates) {
                try {
                    File file;
                    JSONObject content = (JSONObject)JSON.parseObject((String)pt.getContent(), JSONObject.class);
                    if (HussarUtils.isNotEmpty((Object)content.get((Object)"id")) && (file = new File(templateFilePath + File.separator + pt.getId())).exists()) {
                        Object[] files = file.listFiles();
                        AssertUtil.isNotEmpty((Object[])files, (String)"\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728!");
                        String fileName = ((File)files[0]).getName();
                        String filePath = FileUtil.posixPath((String[])new String[]{templateFilePath, String.valueOf(pt.getId()), fileName});
                        Long sourceFileId = this.fileUpload(filePath);
                        JSONObject replaceMapping = new JSONObject();
                        replaceMapping.putAll(importMappingDto.getSubTableNameMap());
                        Long targetFileId = this.wordHandleForCopy.entry(replaceMapping, this.attachmentManagerService.getByFileId(sourceFileId), null);
                        pt.setContent(JSON.toJSONString((Object)this.attachmentManagerService.getByFileId(targetFileId)));
                    }
                }
                catch (Exception e) {
                    pt.setContent(null);
                    LOGGER.error("\u6a21\u677f\u6587\u4ef6\u7ed1\u5b9a\u5931\u8d25\uff01:{},\u6a21\u677fid:{}", (Object)e.getMessage(), (Object)pt.getId());
                }
                Long newTemplateId = IdWorker.getId((Object)pt);
                importMappingDto.getPrintTemplateIdMap().put(pt.getId(), newTemplateId);
                pt.setId(newTemplateId);
                pt.setAppId(importMappingDto.getNewAppId());
                pt.setFormId((Long)importMappingDto.getFormIdMap().get(pt.getFormId()));
            }
            this.saveBatch(printTemplates);
        }
    }

    public void copyPrintTemplate(ImportMappingDto importMappingDto, List<SysPrintTemplate> printTemplates) {
        if (HussarUtils.isNotEmpty(printTemplates)) {
            printTemplates.forEach(pt -> {
                long newTemplateId = IdWorker.getId((Object)pt);
                importMappingDto.getPrintTemplateIdMap().put(pt.getId(), newTemplateId);
                pt.setId(Long.valueOf(newTemplateId));
                pt.setAppId(importMappingDto.getNewAppId());
                pt.setFormId((Long)importMappingDto.getFormIdMap().get(pt.getFormId()));
                try {
                    JSONObject content = (JSONObject)JSON.parseObject((String)pt.getContent(), JSONObject.class);
                    if (HussarUtils.isNotEmpty((Object)content.get((Object)"id"))) {
                        Long sourceFileId = Long.valueOf(String.valueOf(content.get((Object)"id")));
                        JSONObject replaceMapping = new JSONObject();
                        replaceMapping.putAll(importMappingDto.getSubTableNameMap());
                        Long targetFileId = this.wordHandleForCopy.entry(replaceMapping, this.attachmentManagerService.getByFileId(sourceFileId), null);
                        pt.setContent(JSON.toJSONString((Object)this.attachmentManagerService.getByFileId(targetFileId)));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u590d\u5236\u6a21\u677f\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
                }
            });
            this.saveBatch(printTemplates);
        }
    }

    private Long fileUpload(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), "application/form-data", FileUtils.readFileToByteArray((File)file));
                return (Long)this.ossService.backgroundUpload((MultipartFile)mockMultipartFile).getData();
            }
            throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException iOException) {
            throw new BaseException("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public void fileDownload(Long fileId, HttpServletResponse response, HttpServletRequest request) {
        if (!HussarUtils.isEmpty((Object)response) && !HussarUtils.isEmpty((Object)fileId)) {
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            if (!HussarUtils.isEmpty((Object)attachmentModel)) {
                String fileName = attachmentModel.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String path = attachmentModel.getAttachmentDir() + fileId + suffix;
                File file = new File(path);
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 10240);
                     BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                    int len;
                    fileName = fileName.replace(" ", "");
                    fileName = fileName.replace("\\", "");
                    fileName = fileName.replace("/", "");
                    fileName = fileName.replace(":", "");
                    fileName = fileName.replace("*", "");
                    fileName = fileName.replace("?", "");
                    fileName = fileName.replace("\"", "");
                    fileName = fileName.replace(">", "");
                    fileName = fileName.replace("<", "");
                    fileName = fileName.replace("|", "");
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                    response.setContentType("multipart/form-data");
                    response.setContentLengthLong(file.length());
                    byte[] buff = new byte[this.ossProperties.getDownloadBuffSize()];
                    while ((len = ((InputStream)bis).read(buff)) > 0) {
                        out.write(buff, 0, len);
                        out.flush();
                    }
                }
                catch (FileNotFoundException var45) {
                    LOGGER.error("inputParams:{} and errorMessage:{}", new Object[]{fileName.toString(), var45.getMessage(), var45});
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
                }
                catch (UnsupportedEncodingException var46) {
                    LOGGER.error("inputParams:{} and errorMessage:{}", new Object[]{"\u7f16\u7801\u5f02\u5e38\uff1a", var46.getMessage(), var46});
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
                catch (IOException var47) {
                    LOGGER.error("inputParams:{} and errorMessage:{}", new Object[]{"IO\u5f02\u5e38\uff1a", var47.getMessage(), var47});
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
            }
        } else {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    public Object dealFieldValue(EngineResultEntity engineResultEntity, Widget widget) {
        WidgetType widgetType = WidgetType.getWidgetType((String)widget.getType());
        AssertUtil.isNotNull((Object)widgetType, (String)"\u7ec4\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728!");
        Object widgetValue = engineResultEntity.get((Object)widget.getName());
        if (engineResultEntity.containsKey((Object)widget.getName()) && HussarUtils.isNull((Object)widgetValue)) {
            return "";
        }
        return WidgetStrategyContext.getStrategy(widgetType).deal(engineResultEntity, widget);
    }

    static {
        LOGGER = LoggerFactory.getLogger(SysPrintTemplateServiceImpl.class);
        SysPrintVisibleScope printVisibleScope = new SysPrintVisibleScope.Builder().allStaff(PrintVisibleScope.ALL.getValue()).organs(Collections.emptyList()).staffs(Collections.emptyList()).containSub(Boolean.FALSE).build();
        DEFAULT_VISIBLE_SCOPE = JSON.toJSONString((Object)printVisibleScope);
        SysPrintGeneFileName printGeneFileName = new SysPrintGeneFileName.Builder().mode(FileNameMode.DEFAULT.getType()).template("").params(Collections.emptyList()).build();
        DEFAULT_FILE_NAME = JSON.toJSONString((Object)printGeneFileName);
    }
}

