/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.AddOutsideUserRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.OutsideRoleGroupDto;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dao.ThirdRoleMapper;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtRoleDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtRoleGroupDelDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtRoleGroupDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ExtUserRoleAddDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.dto.ThirdRoleDto;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdRoleRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdRoleService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdRoleServiceImpl
extends HussarServiceImpl<ThirdRoleMapper, ThirdRoleRela>
implements IThirdRoleService {
    @Resource
    private IHussarBaseSyncRoleService hussarBaseSyncRoleService;
    @Resource
    private ISysRolesService rolesService;
    @Resource
    private IThirdUserService thirdUserService;
    private static final String ROLE_GROUP = "roleGroup";
    private static final String ROLE = "role";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdRoleServiceImpl.class);

    @Override
    public ApiResponse<Void> addRoleGroup(ExtRoleGroupDto extRoleGroupDto) {
        LOGGER.info("openApi -> \u65b0\u589e\u89d2\u8272\u5206\u7ec4\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extRoleGroupDto)));
        R roleGroupAddRes = this.hussarBaseSyncRoleService.addRoleGroup((OutsideRoleGroupDto)extRoleGroupDto);
        if (!roleGroupAddRes.isSuccess()) {
            LOGGER.error("openApi -> \u65b0\u589e\u89d2\u8272\u5206\u7ec4\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)roleGroupAddRes.getErrorList()));
            return ApiResponse.fail((String)"\u65b0\u589e\u89d2\u8272\u5206\u7ec4\u5931\u8d25");
        }
        ThirdRoleRela thirdRoleRela = new ThirdRoleRela();
        thirdRoleRela.setThirdRoleId(extRoleGroupDto.getExtGroupId());
        thirdRoleRela.setRoleId(((DataMapping)roleGroupAddRes.getSuccessList().get(0)).getId());
        thirdRoleRela.setThirdRoleSource(ROLE_GROUP);
        this.save((BaseEntity)thirdRoleRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editRoleGroup(ExtRoleGroupDto extRoleGroupDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u89d2\u8272\u5206\u7ec4\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extRoleGroupDto)));
        extRoleGroupDto.setGroupId(this.getPlatformRoleGroupId(extRoleGroupDto.getExtGroupId()));
        R roleGroupEditRes = this.hussarBaseSyncRoleService.editRoleGroup((OutsideRoleGroupDto)extRoleGroupDto);
        if (!roleGroupEditRes.isSuccess()) {
            LOGGER.error("openApi -> \u4fee\u6539\u89d2\u8272\u5206\u7ec4\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)roleGroupEditRes.getErrorList()));
            return ApiResponse.fail((String)"\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delRoleGroup(ExtRoleGroupDelDto extRoleGroupDelDto) {
        String extRoleGroupId = extRoleGroupDelDto.getExtRoleGroupId();
        LOGGER.info("openApi -> \u5220\u9664\u89d2\u8272\u5206\u7ec4\uff0c\u5165\u53c2\uff1a{}", (Object)extRoleGroupId);
        Long roleGroupId = this.getPlatformRoleGroupId(extRoleGroupId);
        R delRoleGroupRes = this.hussarBaseSyncRoleService.deleteRoleGroup(roleGroupId);
        if (!delRoleGroupRes.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u89d2\u8272\u5206\u7ec4\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)delRoleGroupRes.getErrorList()));
            return ApiResponse.fail((String)"\u5220\u9664\u89d2\u8272\u5206\u7ec4\u5931\u8d25");
        }
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)extRoleGroupId)).eq(ThirdRoleRela::getThirdRoleSource, (Object)ROLE_GROUP));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> addRole(ThirdRoleDto thirdRoleDto) {
        Long roleId;
        LOGGER.info("openApi -> \u65b0\u589e\u89d2\u8272\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdRoleDto)));
        thirdRoleDto.setGroupId(this.getPlatformRoleGroupId(thirdRoleDto.getExtRoleGroupId()));
        try {
            roleId = this.rolesService.saveRoleNoSign((SysRolesDto)thirdRoleDto);
        }
        catch (Exception e) {
            LOGGER.error("openApi -> \u65b0\u589e\u89d2\u8272\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResponse.fail((String)"\u65b0\u589e\u89d2\u8272\u5931\u8d25");
        }
        ThirdRoleRela thirdRoleRela = new ThirdRoleRela();
        thirdRoleRela.setRoleId(roleId);
        thirdRoleRela.setThirdRoleId(thirdRoleDto.getExtRoleId());
        thirdRoleRela.setThirdRoleSource(ROLE);
        this.save((BaseEntity)thirdRoleRela);
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> editRole(ThirdRoleDto thirdRoleDto) {
        LOGGER.info("openApi -> \u4fee\u6539\u89d2\u8272\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)thirdRoleDto)));
        thirdRoleDto.setId(this.getPlatformRoleId(thirdRoleDto.getExtRoleId()));
        thirdRoleDto.setGroupId(this.getPlatformRoleGroupId(thirdRoleDto.getExtRoleGroupId()));
        try {
            this.rolesService.updateRoleNoSign((SysRoles)thirdRoleDto);
        }
        catch (Exception e) {
            LOGGER.error("openApi -> \u4fee\u6539\u89d2\u8272\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResponse.fail((String)"\u4fee\u6539\u89d2\u8272\u5931\u8d25");
        }
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> delRole(ExtRoleDelDto extRoleDelDto) {
        String extRoleId = extRoleDelDto.getExtRoleId();
        LOGGER.info("openApi -> \u5220\u9664\u89d2\u8272\uff0c\u5165\u53c2\uff1a{}", (Object)extRoleId);
        Long roleId = this.getPlatformRoleId(extRoleId);
        ApiResponse delRoleResult = this.rolesService.deleteRole(roleId);
        if (!delRoleResult.isSuccess()) {
            LOGGER.error("openApi -> \u5220\u9664\u89d2\u8272\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)delRoleResult.getMsg());
            return ApiResponse.fail((String)"\u5220\u9664\u89d2\u8272\u5931\u8d25");
        }
        this.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)extRoleId)).eq(ThirdRoleRela::getThirdRoleSource, (Object)ROLE));
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<Void> saveUserRole(ExtUserRoleAddDto extUserRoleAddDto) {
        LOGGER.info("openApi -> \u4fdd\u5b58\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)extUserRoleAddDto)));
        if (HussarUtils.isNotEmpty(extUserRoleAddDto.getExtIds())) {
            switch (extUserRoleAddDto.getType()) {
                case "user": {
                    extUserRoleAddDto.setIds(this.thirdUserService.listPlatformUserIds(extUserRoleAddDto.getExtIds()));
                    break;
                }
                case "role": {
                    extUserRoleAddDto.setIds(this.listPlatformRoleIds(extUserRoleAddDto.getExtIds()));
                    break;
                }
            }
        }
        if (HussarUtils.isNotEmpty(extUserRoleAddDto.getExtUserRoles())) {
            List<ExtUserRoleAddDto.ExtUserRole> extUserRoles = extUserRoleAddDto.getExtUserRoles();
            ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>(extUserRoles.size());
            for (ExtUserRoleAddDto.ExtUserRole extUserRole : extUserRoles) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(this.thirdUserService.getPlatformUserId(extUserRole.getExtUserId()));
                sysUserRole.setGrantedRole(this.getPlatformRoleId(extUserRole.getExtRoleId()));
                userRoles.add(sysUserRole);
            }
            extUserRoleAddDto.setUserRoleList(userRoles);
        }
        try {
            this.hussarBaseSyncRoleService.saveUserRole((AddOutsideUserRoleDto)extUserRoleAddDto);
        }
        catch (Exception e) {
            LOGGER.error("openApi -> \u4fdd\u5b58\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb\uff0c\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResponse.fail((String)"\u4fdd\u5b58\u7528\u6237\u89d2\u8272\u5173\u8054\u5173\u7cfb");
        }
        return ApiResponse.success();
    }

    @Override
    public Long getPlatformRoleGroupId(String extRoleGroupId) {
        ThirdRoleRela roleRela = (ThirdRoleRela)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)extRoleGroupId)).eq(ThirdRoleRela::getThirdRoleSource, (Object)ROLE_GROUP)));
        return roleRela.getRoleId();
    }

    @Override
    public Long getPlatformRoleId(String extRoleId) {
        ThirdRoleRela roleRela = (ThirdRoleRela)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ThirdRoleRela::getThirdRoleId, (Object)extRoleId)).eq(ThirdRoleRela::getThirdRoleSource, (Object)ROLE)));
        return roleRela.getRoleId();
    }

    @Override
    public List<Long> listPlatformRoleIds(List<String> extRoleIds) {
        List roleRelas = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ThirdRoleRela::getThirdRoleId, extRoleIds)).eq(ThirdRoleRela::getThirdRoleSource, (Object)ROLE));
        return roleRelas.stream().map(ThirdRoleRela::getRoleId).collect(Collectors.toList());
    }
}

