/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppAuthorize;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.AppMenuVo;
import com.jxdinfo.hussar.formdesign.application.openapi.application.service.OpenAppService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.OpenUserService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.external.openapi.application.service.impl.OpenAppServiceImpl")
public class OpenAppServiceImpl
implements OpenAppService {
    @Resource
    private OpenUserService openUserService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysFormService formService;

    @Override
    public ApiResponse<List<SysAppGroupVo>> getAppList(String loginUserId, String appName) {
        Long userId = this.openUserService.getPlatformUserId(loginUserId);
        List<Long> appIds = this.getCurrentUserAuthorityApp(userId);
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        List<SysApplicationVo> appList = this.sysApplicationMapper.getAppList(appName, appIds);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (SysApplicationVo sysApplicationVo : appList) {
            groupIds.add(sysApplicationVo.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroupByIds(groupIds);
        }
        ArrayList<SysApplicationVo> appListVo = new ArrayList<SysApplicationVo>();
        for (SysApplicationVo app : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)app, (Object)vo);
            appListVo.add(vo);
        }
        return ApiResponse.success(this.combinedData(appListVo, sysAppGroups));
    }

    @Override
    public ApiResponse<List<AppMenuVo>> getFormMenuList(String loginUserId, Long appId) {
        Long userId = this.openUserService.getPlatformUserId(loginUserId);
        return this.formService.getFormMenuList(userId, appId);
    }

    private List<Long> getCurrentUserAuthorityApp(Long userId) {
        List<Long> roleIds = new ArrayList<Long>();
        LambdaQueryWrapper sysUserRoleWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId);
        List sysUserRoles = this.sysUserRoleService.list((Wrapper)sysUserRoleWrapper);
        if (HussarUtils.isNotEmpty((Object)sysUserRoles)) {
            roleIds = sysUserRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
        }
        roleIds.add(userId);
        LambdaQueryWrapper sysAppAuthorizeWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysAppAuthorize::getRoleId, roleIds);
        List authorizeList = this.sysAppAuthorizeService.list((Wrapper)sysAppAuthorizeWrapper);
        return authorizeList.stream().map(SysAppAuthorize::getAppId).distinct().collect(Collectors.toList());
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }
}

