/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lang.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.lang.dao.SysMultiLangMgtMapper;
import com.jxdinfo.hussar.formdesign.application.lang.dto.SysMultiLangMgtDto;
import com.jxdinfo.hussar.formdesign.application.lang.model.SysLangTask;
import com.jxdinfo.hussar.formdesign.application.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.formdesign.application.lang.service.ISysLangTaskService;
import com.jxdinfo.hussar.formdesign.application.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.formdesign.application.lang.service.impl.LangAsync;
import com.jxdinfo.hussar.formdesign.application.lang.vo.LangImportVo;
import com.jxdinfo.hussar.formdesign.application.lang.vo.LangQueryVo;
import com.jxdinfo.hussar.formdesign.application.lang.vo.QueryVo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.lang.service.impl.SysMultiLangMgtImpl")
public class SysMultiLangMgtImpl
extends HussarServiceImpl<SysMultiLangMgtMapper, SysMultiLangMgt>
implements ISysMultiLangMgtService {
    private static Logger logger = LoggerFactory.getLogger(SysMultiLangMgtImpl.class);
    @Resource
    private ISysLangTaskService sysLangTaskService;
    @Resource
    private LangAsync langAsync;
    @Resource
    private SysMultiLangMgtMapper sysMultiLangMgtMapper;
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    public static final String CUSTOM_LANG = "custom";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    public static final String SYSTEM_LANG = "system";

    @HussarTransactional
    public ApiResponse<Map<String, Object>> add() {
        long startTime = System.currentTimeMillis();
        String key = this.generateLangKey();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(LANG_KEY, key);
        HashMap<String, String> langTextMap = new HashMap<String, String>();
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        long time1 = System.currentTimeMillis();
        logger.error("--------------1--------------------:{}", (Object)(time1 - startTime));
        for (String lang : langList) {
            SysMultiLangMgt sysMultiLangMgt = new SysMultiLangMgt();
            sysMultiLangMgt.setLangKey(key);
            sysMultiLangMgt.setLang(lang);
            sysMultiLangMgt.setLangText("");
            sysMultiLangMgt.setType(CUSTOM_LANG);
            sysMultiLangMgtList.add(sysMultiLangMgt);
            langTextMap.put(lang, "");
        }
        long time2 = System.currentTimeMillis();
        logger.error("--------------2--------------------:{}", (Object)(time2 - time1));
        this.saveBatch(sysMultiLangMgtList);
        long time3 = System.currentTimeMillis();
        logger.error("--------------3--------------------:{}", (Object)(time3 - time2));
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        this.langAsync.updateLangTime(sysMultiLangMgtList, dataSourceKey);
        long time4 = System.currentTimeMillis();
        logger.error("--------------4--------------------:{}", (Object)(time4 - time3));
        map.put(LANG_TEXT, langTextMap);
        return ApiResponse.success(map);
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> update(SysMultiLangMgtDto sysMultiLangMgtDto) {
        String langKey = sysMultiLangMgtDto.getLangKey();
        String lang = sysMultiLangMgtDto.getLang();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey)).eq(SysMultiLangMgt::getLang, (Object)lang);
        SysMultiLangMgt multiLangMgt = (SysMultiLangMgt)this.getOne((Wrapper)updateWrapper);
        if (HussarUtils.isNotEmpty((Object)multiLangMgt)) {
            multiLangMgt.setLangText(sysMultiLangMgtDto.getLangText());
            this.updateById((BaseEntity)multiLangMgt);
        } else {
            this.save((BaseEntity)sysMultiLangMgtDto);
        }
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.langAsync.updateLangTime(sysMultiLangMgtDto, dataSourceKey);
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.getLangTextByLangKey(langKey, map);
        return ApiResponse.success(map);
    }

    private void getLangTextByLangKey(String langKey, Map<String, Object> map) {
        ArrayList<String> langList = new ArrayList<String>();
        this.langAsync.getLangs(langList);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
        List sysMultiLangMgts = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysMultiLangMgts)) {
            map.put(LANG_KEY, langKey);
            HashMap<String, String> langTextMap = new HashMap<String, String>();
            for (SysMultiLangMgt sysMultiLangMgt : sysMultiLangMgts) {
                String lang = sysMultiLangMgt.getLang();
                if (!HussarUtils.isNotEmpty((Object)lang) || !langList.contains(lang)) continue;
                langTextMap.put(sysMultiLangMgt.getLang(), sysMultiLangMgt.getLangText());
            }
            map.put(LANG_TEXT, langTextMap);
        } else {
            map.put(LANG_KEY, "");
            map.put(LANG_TEXT, new HashMap());
        }
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteByKey(String langKey) {
        if (HussarUtils.isEmpty((Object)langKey)) {
            throw new BaseException("\u5220\u9664\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (langKey.contains(",")) {
            String[] langKeys = langKey.split(",");
            keys.addAll(Arrays.asList(langKeys));
        } else {
            keys.add(langKey);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLangMgt::getLangKey, keys);
        List sysMultiLangMgtList = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        this.remove((Wrapper)queryWrapper);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        this.langAsync.updateLangTime(sysMultiLangMgtList, dataSourceKey);
        return ApiResponse.success((Object)true, (String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<LangQueryVo> queryList(Long appId, String langText, int pageIndex, int pageSize, String type) {
        List<QueryVo> records = this.sysMultiLangMgtMapper.queryList(appId, langText, (pageIndex - 1) * pageSize, pageSize, type);
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMultiLangMgt::getType, (Object)type)).like(SysMultiLangMgt::getLangText, (Object)langText)).groupBy(SysMultiLangMgt::getLangKey)).select(new SFunction[]{SysMultiLangMgt::getLangKey});
        List list = this.list((Wrapper)wrapper);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList maps = new ArrayList();
        for (QueryVo queryVo : records) {
            String key = queryVo.getLangKey();
            if (keys.contains(key)) continue;
            keys.add(key);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put(LANG_KEY, key);
            map2.put(LANG_TEXT, new HashMap());
            maps.add(map2);
        }
        maps.forEach(map -> {
            Object object = map.get(LANG_KEY);
            String langKey = String.valueOf(object);
            this.getLangTextByLangKey(langKey, (Map<String, Object>)map);
        });
        LangQueryVo langQueryVo = new LangQueryVo();
        langQueryVo.setContent(maps);
        langQueryVo.setTotal(Long.valueOf(list.size()));
        langQueryVo.setPageIndex(pageIndex);
        return ApiResponse.success((Object)langQueryVo, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public ApiResponse<Map<String, String>> getTextListByLang(String lang) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLang, (Object)lang);
        List sysMultiLangMgts = ((SysMultiLangMgtMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
        HashMap map = new HashMap();
        sysMultiLangMgts.forEach(sysMultiLangMgt -> {
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangKey()) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                map.put(sysMultiLangMgt.getLangKey(), sysMultiLangMgt.getLangText());
            }
        });
        return ApiResponse.success(map, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Map<String, Object>> copyLangPack(Map<String, Object> map) {
        String langKey = this.generateLangKey();
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        for (String key : map.keySet()) {
            SysMultiLangMgt sysMultiLangMgt = new SysMultiLangMgt();
            sysMultiLangMgt.setType(CUSTOM_LANG);
            sysMultiLangMgt.setLangText(String.valueOf(map.get(key)));
            sysMultiLangMgt.setLang(key);
            sysMultiLangMgt.setLangKey(langKey);
            sysMultiLangMgtList.add(sysMultiLangMgt);
        }
        this.saveBatch(sysMultiLangMgtList);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        this.langAsync.updateLangTime(sysMultiLangMgtList, dataSourceKey);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put(LANG_KEY, langKey);
        newMap.put(LANG_TEXT, map);
        return ApiResponse.success(newMap, (String)"\u590d\u5236\u6210\u529f");
    }

    public ApiResponse<Long> langExport() {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        SysLangTask sysLangTask = new SysLangTask();
        sysLangTask.setTaskId(taskId);
        sysLangTask.setTaskStatus(0);
        sysLangTask.setTaskType(EXPORT);
        this.sysLangTaskService.save((Object)sysLangTask);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.langAsync.langExport(sysLangTask, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    @HussarTransactional
    public ApiResponse<Long> langImport(Long appId, Long fileId) {
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        SysLangTask sysLangTask = new SysLangTask();
        sysLangTask.setTaskId(taskId);
        sysLangTask.setTaskStatus(0);
        sysLangTask.setTaskType(IMPORT);
        this.sysLangTaskService.save((Object)sysLangTask);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25", (Throwable)e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.langAsync.langImport(appId, fileId, sysLangTask, dataSourceKey);
        });
        return ApiResponse.success((Object)taskId);
    }

    public ApiResponse<LangImportVo> preImport(Long appId, MultipartFile file) {
        return ApiResponse.success((Object)this.langAsync.preLangImport(appId, file));
    }

    public String generateLangKey() {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getLangKey, (Object)uuid);
        if (this.count((Wrapper)queryWrapper) > 0L) {
            this.generateLangKey();
        }
        return uuid;
    }

    public ApiResponse<Map<String, Object>> getTextByLangKey(String langKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.getLangTextByLangKey(langKey, map);
        return ApiResponse.success(map);
    }

    @HussarTransactional
    public void initialSysLangPack(JSONObject jsonObject, String langCode) {
        ArrayList<String> langKeys = new ArrayList<String>();
        ArrayList<SysMultiLangMgt> sysMultiLangMgtList = new ArrayList<SysMultiLangMgt>();
        for (String key : jsonObject.keySet()) {
            if (!HussarUtils.isNotEmpty((Object)key)) continue;
            Object object = jsonObject.get((Object)key);
            if (langKeys.contains(key)) {
                SysMultiLangMgt multiLangMgt = sysMultiLangMgtList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getLangKey().equals(key)).findFirst().get();
                multiLangMgt.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
                continue;
            }
            langKeys.add(key);
            SysMultiLangMgt sysMultiLangMgt2 = new SysMultiLangMgt();
            sysMultiLangMgt2.setLangKey(key);
            sysMultiLangMgt2.setLangText(HussarUtils.isNotEmpty((Object)object) ? String.valueOf(object) : "");
            sysMultiLangMgt2.setLang(langCode);
            sysMultiLangMgt2.setType(SYSTEM_LANG);
            sysMultiLangMgtList.add(sysMultiLangMgt2);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysMultiLangMgt::getLang, (Object)langCode)).in(SysMultiLangMgt::getLangKey, langKeys);
        this.remove((Wrapper)wrapper);
        this.saveBatch(sysMultiLangMgtList);
    }
}

