/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.lang.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.lang.dto.SysMultiLangMgtDto;
import com.jxdinfo.hussar.formdesign.application.lang.enums.LangEnum;
import com.jxdinfo.hussar.formdesign.application.lang.model.SysLangTask;
import com.jxdinfo.hussar.formdesign.application.lang.model.SysMultiLang;
import com.jxdinfo.hussar.formdesign.application.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.formdesign.application.lang.service.ISysLangTaskService;
import com.jxdinfo.hussar.formdesign.application.lang.service.ISysMultiLangMgtService;
import com.jxdinfo.hussar.formdesign.application.lang.service.ISysMultiLangService;
import com.jxdinfo.hussar.formdesign.application.lang.vo.LangImportVo;
import com.jxdinfo.hussar.formdesign.application.lang.vo.SysMultiLangVo;
import com.jxdinfo.hussar.formdesign.application.print.handle.WordHandle;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@Component
public class LangAsync {
    @Value(value="${hussar-formdesign.workspace:}")
    private String outPath;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private ISysLangTaskService sysLangTaskService;
    @Resource
    private ISysMultiLangService sysMultiLangService;
    @Resource
    private ISysMultiLangMgtService sysMultiLangMgtService;
    private static Logger LOGGER = LoggerFactory.getLogger(LangAsync.class);
    public static final String CUSTOM_WORKBOOK_NAME = "\u81ea\u5b9a\u4e49\u8bed\u8a00\u5305";
    public static final String SYSTEM_WORKBOOK_NAME = "\u7cfb\u7edf\u8bed\u8a00\u5305";
    public static final String LANG_KEY = "langKey";
    public static final String LANG_TEXT = "langText";
    public static final String FIRST_CELL_VALUE = "i18n Key";
    public static final int DEFAULT_WIDTH = 8500;
    public static final int EXPORT_SUCCESS = 1;
    public static final int EXPORT_FAIL = -1;
    public static final String CUSTOM_LANG = "custom";
    public static final String SYSTEM_LANG = "system";
    private static final int ENABLED = 1;
    private static final int NO_DEFAULT = 0;
    private static final int SHOW = 1;

    public void getLangs(List<String> langs) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysMultiLang::getIsShow, (Object)1)).orderByAsc(SysMultiLang::getAddTime);
        List list = this.sysMultiLangService.list((Wrapper)wrapper);
        list.forEach(sysMultiLang -> {
            String langCode = sysMultiLang.getLangCode();
            if (HussarUtils.isNotEmpty((Object)langCode) && LangEnum.checkLangValue((String)langCode)) {
                langs.add(sysMultiLang.getLangCode());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void langExport(SysLangTask task, String dataSourceKey) {
        JSONObject customLang = new JSONObject();
        JSONObject systemLang = new JSONObject();
        try {
            this.formatData(customLang, CUSTOM_LANG);
            this.formatData(systemLang, SYSTEM_LANG);
            XSSFWorkbook workbook = new XSSFWorkbook();
            this.opSheet((Workbook)workbook, customLang, CUSTOM_WORKBOOK_NAME);
            this.opSheet((Workbook)workbook, systemLang, SYSTEM_WORKBOOK_NAME);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String currentDate = sdf.format(new Date());
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            this.attachmentManagerService.save((Object)attachmentManagerModelVo);
            Long fileId = attachmentManagerModelVo.getId();
            String fileName = "\u591a\u8bed\u8a00\u7ffb\u8bd1\u8868-" + currentDate + ".xlsx";
            String path = this.outPath + fileId + ".xlsx";
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            workbook.close();
            long fileSize = Files.size(Paths.get(path, new String[0]));
            attachmentManagerModelVo.setAttachmentName(fileName);
            attachmentManagerModelVo.setAttachmentDir(this.outPath);
            attachmentManagerModelVo.setAttachmentType(WordHandle.getSuffix(attachmentManagerModelVo.getAttachmentName()).replace(".", ""));
            attachmentManagerModelVo.setAttachmentSize(Long.valueOf(fileSize));
            this.attachmentManagerService.updateById((Object)attachmentManagerModelVo);
            task.setTaskStatus(1);
            task.setFileId(fileId);
        }
        catch (Exception e) {
            task.setTaskStatus(-1);
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u51fa\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            this.sysLangTaskService.updateById((Object)task);
        }
    }

    private void formatData(JSONObject langJson, String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLangMgt::getType, (Object)type);
        List sysMultiLangMgtList = this.sysMultiLangMgtService.getBaseMapper().selectList((Wrapper)queryWrapper);
        HashSet<String> langs = new HashSet<String>();
        for (SysMultiLangMgt sysMultiLangMgt : sysMultiLangMgtList) {
            String lang = sysMultiLangMgt.getLang();
            if (!langs.contains(lang)) {
                langs.add(lang);
                JSONArray array = new JSONArray();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(LANG_KEY, (Object)sysMultiLangMgt.getLangKey());
                jsonObject.put(LANG_TEXT, (Object)sysMultiLangMgt.getLangText());
                array.add((Object)jsonObject);
                langJson.put(lang, (Object)array);
                continue;
            }
            Object object = langJson.get((Object)lang);
            JSONArray array = (JSONArray)object;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(LANG_KEY, (Object)sysMultiLangMgt.getLangKey());
            jsonObject.put(LANG_TEXT, (Object)sysMultiLangMgt.getLangText());
            array.add((Object)jsonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    @HussarTransactional
    public void langImport(Long appId, Long fileId, SysLangTask sysLangTask, String dataSourceKey) {
        String path = this.outPath + fileId + ".xlsx";
        ArrayList<SysMultiLangMgt> addList = new ArrayList<SysMultiLangMgt>();
        HashSet<String> langs = new HashSet<String>();
        ArrayList<SysMultiLangMgt> updateList = new ArrayList<SysMultiLangMgt>();
        ArrayList<String> langKeys = new ArrayList<String>();
        InputStream stream = null;
        int errorNum = 0;
        try {
            stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            XSSFWorkbook workbook = new XSSFWorkbook(stream);
            Iterator sheetIterator = workbook.sheetIterator();
            LOGGER.info("------------\u5f00\u59cb\u89e3\u6790\u591a\u8bed\u8a00\u5305------------");
            errorNum = this.opImportSheet(sheetIterator, langs, appId, addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u89e3\u6790\u5b8c\u6bd5------------");
            LOGGER.info("------------\u5f00\u59cb\u6dfb\u52a0\u65b0\u589e\u8bed\u8a00------------");
            this.opImportLang(appId, langs);
            LOGGER.info("------------\u65b0\u589e\u8bed\u8a00\u6dfb\u52a0\u5b8c\u6bd5------------");
            LOGGER.info("------------\u5f00\u59cb\u66f4\u65b0\u591a\u8bed\u8a00\u5305------------");
            this.batchHandleImportData(addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u66f4\u65b0\u5b8c\u6bd5------------");
            int addNum = addList.size();
            int updateNum = updateList.size();
            LOGGER.info("\u65b0\u589e\u8bed\u8a00\u5305\u6570\u91cf\uff1a" + addNum + "\uff0c\u66f4\u65b0\u8bed\u8a00\u5305\u6570\u91cf\uff1a" + updateNum);
            LOGGER.info("\u5bfc\u5165\u6570\u636e\uff1a{}\u6761", (Object)langKeys.size());
            LOGGER.info("\u5f02\u5e38\u6570\u636e\uff1a{}\u6761", (Object)errorNum);
            sysLangTask.setImportNum(langKeys.size());
            sysLangTask.setErrorNum(errorNum);
            sysLangTask.setTaskStatus(1);
        }
        catch (Exception e) {
            sysLangTask.setTaskStatus(-1);
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.sysLangTaskService.updateById((Object)sysLangTask);
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public LangImportVo preLangImport(Long appId, MultipartFile file) {
        LangImportVo langImportVo = new LangImportVo();
        ArrayList<SysMultiLangMgt> addList = new ArrayList<SysMultiLangMgt>();
        HashSet<String> langs = new HashSet<String>();
        ArrayList<SysMultiLangMgt> updateList = new ArrayList<SysMultiLangMgt>();
        ArrayList<String> langKeys = new ArrayList<String>();
        InputStream stream = null;
        int errorNum = 0;
        try {
            stream = file.getInputStream();
            AttachmentManagerModelVo attachmentManagerModelVo = new AttachmentManagerModelVo();
            this.attachmentManagerService.save((Object)attachmentManagerModelVo);
            Long fileId = attachmentManagerModelVo.getId();
            String path = this.outPath + fileId + ".xlsx";
            File dest = new File(path);
            file.transferTo(dest);
            attachmentManagerModelVo.setAttachmentName("\u591a\u8bed\u8a00\u5305\u5bfc\u5165-" + fileId + ".xlsx");
            attachmentManagerModelVo.setAttachmentDir(this.outPath);
            attachmentManagerModelVo.setAttachmentType(WordHandle.getSuffix(attachmentManagerModelVo.getAttachmentName()).replace(".", ""));
            attachmentManagerModelVo.setAttachmentSize(Long.valueOf(Files.size(Paths.get(path, new String[0]))));
            this.attachmentManagerService.updateById((Object)attachmentManagerModelVo);
            XSSFWorkbook workbook = new XSSFWorkbook(stream);
            Iterator sheetIterator = workbook.sheetIterator();
            LOGGER.info("------------\u5f00\u59cb\u89e3\u6790\u591a\u8bed\u8a00\u5305------------");
            errorNum = this.opImportSheet(sheetIterator, langs, appId, addList, langKeys, updateList);
            LOGGER.info("------------\u591a\u8bed\u8a00\u5305\u89e3\u6790\u5b8c\u6bd5------------");
            langImportVo.setFileId(fileId);
            langImportVo.setErrorNum(errorNum);
            LangImportVo langImportVo2 = langImportVo;
            return langImportVo2;
        }
        catch (Exception e) {
            LOGGER.error("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            throw new BaseException("\u8bed\u8a00\u5305\u5bfc\u5165\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void opSheet(Workbook workbook, JSONObject targetLang, String sheetName) {
        Object lang;
        Object object;
        Sheet sheet = workbook.createSheet(sheetName);
        sheet.createFreezePane(2, 1);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Row row = sheet.createRow(0);
        Cell rowCell = row.createCell(0);
        rowCell.setCellValue(FIRST_CELL_VALUE);
        rowCell.setCellStyle(style);
        sheet.setColumnWidth(0, 8500);
        int cellIndex = 1;
        ArrayList<String> langs = new ArrayList<String>();
        ArrayList<String> langKeys = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        this.getLangs(keys);
        for (String key : keys) {
            if (!key.equals(LangEnum.ZH_CN.getLangValue())) continue;
            langs.add(key);
        }
        for (String key : keys) {
            if (key.equals(LangEnum.ZH_CN.getLangValue())) continue;
            langs.add(key);
        }
        for (String lang2 : langs) {
            Cell cell = row.createCell(cellIndex);
            cell.setCellValue(LangEnum.getLabelByValue((String)lang2));
            cell.setCellStyle(style);
            sheet.setColumnWidth(cellIndex, 8500);
            ++cellIndex;
        }
        if (HussarUtils.isNotEmpty(langs) && (object = targetLang.get(lang = (String)langs.get(0))) instanceof JSONArray) {
            JSONArray arrayList = (JSONArray)object;
            for (Object object1 : arrayList) {
                if (!(object1 instanceof JSONObject)) continue;
                JSONObject linkedHashMap = (JSONObject)object1;
                String langKey = linkedHashMap.get((Object)LANG_KEY).toString();
                langKeys.add(langKey);
            }
        }
        for (String langKey : langKeys) {
            Row langKeyRow = sheet.createRow(langKeys.indexOf(langKey) + 1);
            Cell langKeyCell = langKeyRow.createCell(0);
            langKeyCell.setCellValue(langKey);
        }
        Iterator rowIterator = sheet.rowIterator();
        while (rowIterator.hasNext()) {
            Row row1 = (Row)rowIterator.next();
            String langKey = row1.getCell(0).getStringCellValue();
            if (langKey.equals(FIRST_CELL_VALUE)) continue;
            block6: for (int i = 0; i < langs.size(); ++i) {
                Cell cell = row1.createCell(i + 1);
                String stringCellValue = LangEnum.getValueByLabel((String)sheet.getRow(0).getCell(i + 1).getStringCellValue());
                Object object2 = targetLang.get((Object)stringCellValue);
                if (!(object2 instanceof JSONArray)) continue;
                JSONArray arrayList = (JSONArray)object2;
                for (Object object1 : arrayList) {
                    JSONObject linkedHashMap;
                    if (!(object1 instanceof JSONObject) || !(linkedHashMap = (JSONObject)object1).get((Object)LANG_KEY).equals(langKey)) continue;
                    cell.setCellValue(linkedHashMap.get((Object)LANG_TEXT).toString());
                    continue block6;
                }
            }
        }
    }

    private boolean judgeCellValue(Cell cell) {
        if (HussarUtils.isEmpty((Object)cell)) {
            return true;
        }
        cell.setCellType(CellType.STRING);
        return HussarUtils.isEmpty((Object)cell.getStringCellValue());
    }

    private int opImportSheet(Iterator<Sheet> sheetIterator, Set<String> langs, Long appId, List<SysMultiLangMgt> addList, List<String> langKeys, List<SysMultiLangMgt> updateList) {
        int errorNum = 0;
        boolean firstSheet = true;
        while (sheetIterator.hasNext()) {
            String type = firstSheet ? CUSTOM_LANG : SYSTEM_LANG;
            firstSheet = false;
            Sheet sheet = sheetIterator.next();
            Iterator rowIterator = sheet.rowIterator();
            int rowIndex = 0;
            while (rowIterator.hasNext()) {
                ++rowIndex;
                Row row = (Row)rowIterator.next();
                String langKey = "";
                try {
                    SysMultiLangMgt sysMultiLangMgt;
                    String label;
                    SysMultiLangMgt sysMultiLangMgt2;
                    Object cell1;
                    if (row.getRowNum() == 0) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell12 = (Cell)cellIterator.next();
                            cell12.setCellType(CellType.STRING);
                            if (cell12.getColumnIndex() == 0 || !LangEnum.checkLang((String)cell12.getStringCellValue())) continue;
                            langs.add(LangEnum.getValueByLabel((String)cell12.getStringCellValue()));
                        }
                        continue;
                    }
                    Cell cell = row.getCell(0);
                    if (this.judgeCellValue(cell)) {
                        String key = this.sysMultiLangMgtService.generateLangKey();
                        langKeys.add(key);
                        Iterator cellIterator = row.cellIterator();
                        ArrayList<String> cellLangs = new ArrayList<String>();
                        while (cellIterator.hasNext()) {
                            cell1 = (Cell)cellIterator.next();
                            cell1.setCellType(CellType.STRING);
                            if (cell1.getColumnIndex() == 0) continue;
                            sysMultiLangMgt2 = new SysMultiLangMgt();
                            sysMultiLangMgt2.setAppId(appId);
                            sysMultiLangMgt2.setLangText(cell1.getStringCellValue());
                            sysMultiLangMgt2.setLangKey(key);
                            sysMultiLangMgt2.setType(type);
                            label = sheet.getRow(0).getCell(cell1.getColumnIndex()).getStringCellValue();
                            if (!LangEnum.checkLang((String)label)) continue;
                            sysMultiLangMgt2.setLang(LangEnum.getValueByLabel((String)label));
                            cellLangs.add(sysMultiLangMgt2.getLang());
                            addList.add(sysMultiLangMgt2);
                        }
                        for (String lang : langs) {
                            if (cellLangs.contains(lang)) continue;
                            sysMultiLangMgt = new SysMultiLangMgt();
                            sysMultiLangMgt.setAppId(appId);
                            sysMultiLangMgt.setLangText("");
                            sysMultiLangMgt.setLangKey(key);
                            sysMultiLangMgt.setLang(lang);
                            sysMultiLangMgt.setType(type);
                            addList.add(sysMultiLangMgt);
                        }
                        continue;
                    }
                    Iterator cellIterator = row.cellIterator();
                    ArrayList<String> cellLangs = new ArrayList<String>();
                    boolean isRepeat = false;
                    while (cellIterator.hasNext()) {
                        cell1 = (Cell)cellIterator.next();
                        cell1.setCellType(CellType.STRING);
                        if (cell1.getColumnIndex() == 0) {
                            langKey = cell1.getStringCellValue();
                            if (!langKeys.contains(langKey)) {
                                langKeys.add(langKey);
                                continue;
                            }
                            isRepeat = true;
                            break;
                        }
                        sysMultiLangMgt2 = new SysMultiLangMgt();
                        sysMultiLangMgt2.setLangKey(row.getCell(0).getStringCellValue());
                        sysMultiLangMgt2.setAppId(appId);
                        sysMultiLangMgt2.setLangText(cell1.getStringCellValue());
                        sysMultiLangMgt2.setType(type);
                        label = sheet.getRow(0).getCell(cell1.getColumnIndex()).getStringCellValue();
                        if (!LangEnum.checkLang((String)label)) continue;
                        sysMultiLangMgt2.setLang(LangEnum.getValueByLabel((String)label));
                        cellLangs.add(sysMultiLangMgt2.getLang());
                        updateList.add(sysMultiLangMgt2);
                    }
                    if (isRepeat) continue;
                    for (String lang : langs) {
                        if (cellLangs.contains(lang)) continue;
                        sysMultiLangMgt = new SysMultiLangMgt();
                        sysMultiLangMgt.setAppId(appId);
                        sysMultiLangMgt.setLangText("");
                        sysMultiLangMgt.setLangKey(row.getCell(0).getStringCellValue());
                        sysMultiLangMgt.setLang(lang);
                        sysMultiLangMgt.setType(type);
                        updateList.add(sysMultiLangMgt);
                    }
                }
                catch (Exception e) {
                    langKeys.remove(langKey);
                    LOGGER.error("\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                    LOGGER.error("\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38,\u5f02\u5e38\u884c\u6570:{}", (Object)rowIndex);
                    ++errorNum;
                }
            }
        }
        return errorNum;
    }

    @HussarTransactional
    public void batchHandleImportData(List<SysMultiLangMgt> addList, List<String> langKeys, List<SysMultiLangMgt> updateList) {
        List noSysAddList = addList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getType().equals(CUSTOM_LANG)).collect(Collectors.toList());
        ArrayList list = new ArrayList(noSysAddList);
        List noSysUpdateList = updateList.stream().filter(sysMultiLangMgt -> sysMultiLangMgt.getType().equals(CUSTOM_LANG)).collect(Collectors.toList());
        updateList.removeAll(noSysUpdateList);
        List sysUpdateList = updateList.stream().filter(sysMultiLangMgt -> {
            String langKey = sysMultiLangMgt.getLangKey();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysMultiLangMgt::getLangKey, (Object)langKey);
            List mgtList = this.sysMultiLangMgtService.list((Wrapper)wrapper);
            if (HussarUtils.isEmpty((Object)mgtList)) {
                langKeys.remove(langKey);
            }
            return HussarUtils.isNotEmpty((Object)mgtList);
        }).collect(Collectors.toList());
        list.addAll(noSysUpdateList);
        list.addAll(sysUpdateList);
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.updateLangTime(list, dataSourceKey);
        });
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLangMgt::getLangKey, langKeys);
        this.sysMultiLangMgtService.remove((Wrapper)queryWrapper);
        this.sysMultiLangMgtService.saveBatch(list);
    }

    private void opImportLang(Long appId, Set<String> langs) {
        SysMultiLangVo sysMultiLangVo = this.sysMultiLangService.getLang(appId);
        List sysMultiLangs = sysMultiLangVo.getSysMultiLangs();
        ArrayList<String> langList = new ArrayList<String>();
        for (SysMultiLang sysMultiLang : sysMultiLangs) {
            langList.add(LangEnum.getValueByLabel((String)sysMultiLang.getLang()));
        }
        for (String lang : langs) {
            if (langList.contains(lang) || !HussarUtils.isNotEmpty((Object)lang)) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysMultiLang::getLangCode, (Object)lang);
            SysMultiLang one = (SysMultiLang)this.sysMultiLangService.getOne((Wrapper)queryWrapper);
            one.setIsShow(1);
            this.sysMultiLangService.updateById((Object)one);
        }
    }

    @HussarDs(value="#dataSourceKey")
    public void updateLangTime(List<SysMultiLangMgt> list, String dataSourceKey) {
        ArrayList<String> langs = new ArrayList<String>();
        for (SysMultiLangMgt sysMultiLangMgt : list) {
            String lang = sysMultiLangMgt.getLang();
            if (langs.contains(lang)) continue;
            langs.add(lang);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysMultiLang::getLangCode, langs);
        List sysMultiLangs = this.sysMultiLangService.getBaseMapper().selectList((Wrapper)queryWrapper);
        this.sysMultiLangService.updateBatchById((Collection)sysMultiLangs);
    }

    @HussarDs(value="#dataSourceKey")
    public void updateLangTime(SysMultiLangMgtDto sysMultiLangMgtDto, String dataSourceKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMultiLang::getLangCode, (Object)sysMultiLangMgtDto.getLang());
        SysMultiLang sysMultiLang = (SysMultiLang)this.sysMultiLangService.getOne((Wrapper)queryWrapper);
        this.sysMultiLangService.updateById((Object)sysMultiLang);
    }
}

