/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.formdesign.application.form.service.IRenewWorkflowFileService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RenewWorkflowFileServiceImpl
implements IRenewWorkflowFileService {
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private GodAxeModelService godAxeModelService;
    @Lazy
    @Autowired
    private RepositoryService repositoryService;
    private static Logger logger = LoggerFactory.getLogger(RenewWorkflowFileServiceImpl.class);

    public void renewWorkflowFile(String processKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey)).eq(SysActProcessFile::getType, (Object)"wfd");
        List sysActProcessFileList = this.sysActProcessFileService.list((Wrapper)queryWrapper);
        for (SysActProcessFile sysActProcessFile : sysActProcessFileList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)wfdFile);
            JSONObject props = jsonObject.getJSONObject("props");
            Object isBackFill = props.get((Object)"isBackfill");
            if (HussarUtils.isEmpty((Object)isBackFill) || !((Boolean)isBackFill).booleanValue()) {
                props.put("isBackfill", (Object)true);
                wfdFile = JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                SysActProcessFile processFile = new SysActProcessFile();
                processFile.setContent(wfdFile.getBytes(StandardCharsets.UTF_8));
                LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
                if (HussarUtils.isEmpty((Object)sysActProcessFile.getProcessId())) {
                    updateWrapper.isNull(SysActProcessFile::getProcessId);
                } else {
                    updateWrapper.eq(SysActProcessFile::getProcessId, (Object)sysActProcessFile.getProcessId());
                }
                updateWrapper.eq(SysActProcessFile::getProcessKey, (Object)processKey);
                updateWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
                this.sysActProcessFileService.update((Object)processFile, (Wrapper)updateWrapper);
            }
            if (!HussarUtils.isNotEmpty((Object)sysActProcessFile.getProcessId())) continue;
            BpmnModel bm = this.repositoryService.getBpmnModel(sysActProcessFile.getProcessId());
            Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
            List isBackFillElement = (List)extensionElementList.get("isBackfill");
            boolean isbackFill = false;
            if (HussarUtils.isNotEmpty((Object)isBackFillElement) && HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill"))) {
                String isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue();
                isbackFill = HussarUtils.isEmpty((Object)isBackFillText) ? false : Boolean.valueOf(isBackFillText);
            }
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessDefId(sysActProcessFile.getProcessId());
            JSONObject workflowJson = JSON.parseObject((String)workFlow.getData());
            JSONObject workFlowProps = workflowJson.getJSONObject("props");
            Object workflowIsBackFill = workFlowProps.get((Object)"isBackfill");
            if (isbackFill && !HussarUtils.isEmpty((Object)workflowIsBackFill) && ((Boolean)workflowIsBackFill).booleanValue()) continue;
            workFlowProps.put("isBackfill", (Object)true);
            workFlow.setData(JSONObject.toJSONString((Object)workflowJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            this.godAxeModelService.saveWorkflowMetaAndData(workFlow, "1");
        }
    }

    public List<String> upWorkflowCheck() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        List sysActProcessFileList = this.sysActProcessFileService.list((Wrapper)queryWrapper);
        LinkedHashSet<String> processKeySet = new LinkedHashSet<String>();
        for (SysActProcessFile sysActProcessFile : sysActProcessFileList) {
            String wfdFile = new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)wfdFile);
            JSONObject props = jsonObject.getJSONObject("props");
            Object isBackFill = props.get((Object)"isBackfill");
            if (HussarUtils.isEmpty((Object)isBackFill) || !((Boolean)isBackFill).booleanValue()) {
                processKeySet.add(sysActProcessFile.getProcessKey());
            }
            if (!HussarUtils.isNotEmpty((Object)sysActProcessFile.getProcessId())) continue;
            BpmnModel bm = this.repositoryService.getBpmnModel(sysActProcessFile.getProcessId());
            Map extensionElementList = ((Process)bm.getProcesses().get(0)).getExtensionElements();
            List isBackFillElement = (List)extensionElementList.get("isBackfill");
            boolean isbackFill = false;
            if (HussarUtils.isNotEmpty((Object)isBackFillElement) && HussarUtils.isNotEmpty(((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill"))) {
                String isBackFillText = ((ExtensionAttribute)((List)((ExtensionElement)isBackFillElement.get(0)).getAttributes().get("isBackfill")).get(0)).getValue();
                boolean bl = isbackFill = HussarUtils.isEmpty((Object)isBackFillText) ? false : Boolean.valueOf(isBackFillText);
            }
            if (isbackFill) continue;
            processKeySet.add(sysActProcessFile.getProcessKey());
        }
        ArrayList<String> processKeyList = new ArrayList<String>(processKeySet);
        return processKeyList;
    }
}

