/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.form.dao.FormRecentUsedHisMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.FormRecentUsedHis;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormRecentUsedHisService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormRecentUsedHisVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormRecentUsedHisServiceImpl")
public class FormRecentUsedHisServiceImpl
implements IFormRecentUsedHisService {
    @Resource
    private FormRecentUsedHisMapper formRecentUsedHisMapper;
    private static final int MAX_HISTORY_SIZE = 8;
    private static final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(FormRecentUsedHisServiceImpl.class);

    public ApiResponse<List<FormRecentUsedHisVo>> getRecentUsedHisList() {
        String recentUsedHis;
        JSONArray jsonArray;
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        List<Object> formRecentUsedHisVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)formRecentUsedHis) && HussarUtils.isNotEmpty((Object)(jsonArray = JSONArray.parseArray((String)(recentUsedHis = formRecentUsedHis.getRecentUsedHis()))))) {
            ArrayList<String> formIds = new ArrayList<String>();
            HashMap formIdToVoMap = new HashMap();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String formId = jsonObject.getString("formId");
                formIds.add(formId);
                formIdToVoMap.put(formId, null);
            }
            formRecentUsedHisVoList = this.formRecentUsedHisMapper.getFormAndAppInfos(formIds);
            formRecentUsedHisVoList.stream().forEach(vo -> formIdToVoMap.put(vo.getFormId(), vo));
            boolean delFlag = false;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JSONObject jsonObject = (JSONObject)iterator.next();
                String formId = jsonObject.getString("formId");
                String accessTime = jsonObject.getString("accessTime");
                FormRecentUsedHisVo vo2 = (FormRecentUsedHisVo)formIdToVoMap.get(formId);
                if (HussarUtils.isNotEmpty((Object)vo2)) {
                    vo2.setAccessTime(accessTime);
                    continue;
                }
                formIdToVoMap.remove(formId);
                iterator.remove();
                delFlag = true;
            }
            if (delFlag) {
                formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
                this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
            }
            formRecentUsedHisVoList.clear();
            formRecentUsedHisVoList.addAll(formIdToVoMap.values());
            this.sortListByAccessTime(formRecentUsedHisVoList);
        }
        return ApiResponse.success(formRecentUsedHisVoList);
    }

    public ApiResponse<Boolean> updateRecentUsedHis(String formId) {
        FormRecentUsedHis formRecentUsedHis = this.getFormRecentUsedHis();
        String currentTime = HussarUtils.formatDateTime((TemporalAccessor)LocalDateTime.now());
        if (HussarUtils.isEmpty((Object)formRecentUsedHis)) {
            formRecentUsedHis = new FormRecentUsedHis();
            Long userId = BaseSecurityUtil.getUser().getUserId();
            formRecentUsedHis.setUserId(userId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("formId", (Object)formId);
            jsonObject.put("accessTime", (Object)currentTime);
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)jsonObject);
            formRecentUsedHis.setRecentUsedHis(jsonArray.toJSONString());
            int isSuccess = this.formRecentUsedHisMapper.insert(formRecentUsedHis);
            if (isSuccess > 0) {
                return ApiResponse.success((Object)true);
            }
            return ApiResponse.success((Object)false);
        }
        String recentUsedHis = formRecentUsedHis.getRecentUsedHis();
        JSONArray jsonArray = JSONArray.parseArray((String)recentUsedHis);
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        boolean found = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entry = jsonArray.getJSONObject(i);
            jsonObjects.add(entry);
            if (!entry.getString("formId").equals(formId)) continue;
            entry.put("accessTime", (Object)currentTime);
            found = true;
        }
        if (!found) {
            JSONObject newEntry = new JSONObject();
            newEntry.put("formId", (Object)formId);
            newEntry.put("accessTime", (Object)currentTime);
            jsonObjects.add(newEntry);
        }
        this.sortJsonObjectsByAccessTime(jsonObjects);
        while (jsonObjects.size() > 8) {
            jsonObjects.remove(jsonObjects.size() - 1);
        }
        String newRecentUsedHis = JSONArray.toJSONString(jsonObjects);
        formRecentUsedHis.setRecentUsedHis(newRecentUsedHis);
        int isSuccess = this.formRecentUsedHisMapper.updateById(formRecentUsedHis);
        if (isSuccess > 0) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }

    private FormRecentUsedHis getFormRecentUsedHis() {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = String.valueOf(user.getUserId());
        return this.formRecentUsedHisMapper.selectByUserId(userId);
    }

    private void sortJsonObjectsByAccessTime(List<JSONObject> jsonObjects) {
        jsonObjects.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getString("accessTime"), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getString("accessTime"), sdf);
            return date2.compareTo(date1);
        });
    }

    private void sortListByAccessTime(List<FormRecentUsedHisVo> formRecentUsedHisVo) {
        formRecentUsedHisVo.sort((o1, o2) -> {
            LocalDateTime date1 = LocalDateTime.parse(o1.getAccessTime(), sdf);
            LocalDateTime date2 = LocalDateTime.parse(o2.getAccessTime(), sdf);
            return date2.compareTo(date1);
        });
    }
}

