/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.application.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportMetaDto;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormImportDto;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormImportThreadService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormAttachmentParseVo;
import com.jxdinfo.hussar.formdesign.application.util.AppMigrateUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.DigestUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormImportServiceImpl")
public class FormImportServiceImpl
implements IFormImportService {
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private IFormImportThreadService formImportThreadService;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysFormService sysFormService;
    private static final Logger logger = LoggerFactory.getLogger(FormImportServiceImpl.class);

    public ApiResponse<FormAttachmentParseVo> parseAttachment(MultipartFile file) {
        String path;
        try {
            path = this.appFileExtendService.fileDecrypt(file);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ApiResponse.fail((String)"\u9644\u4ef6\u52a0\u5bc6\u548c\u89e3\u5bc6\u7684\u5bc6\u94a5\u4e0d\u4e00\u81f4");
        }
        String unZipPath = path.substring(0, path.length() - 7);
        String metaFilePath = FileUtil.posixPath((String[])new String[]{unZipPath, "hussar.meta"});
        String formPath = FileUtil.posixPath((String[])new String[]{unZipPath, "formConfig" + File.separator + "form.json"});
        JSONObject jsonObject = AppMigrateUtil.readFileToObject(formPath, JSONObject.class);
        if (HussarUtils.isEmpty((Object)jsonObject)) {
            throw new BaseException("\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        Object object = jsonObject.get((Object)"form");
        JSONObject sysForm = (JSONObject)object;
        if (HussarUtils.isEmpty((Object)sysForm)) {
            throw new BaseException("\u8bfb\u53d6\u8868\u5355\u4fe1\u606f\u5931\u8d25");
        }
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        if (formExportMetaDto == null) {
            return ApiResponse.fail((String)"\u4e0a\u4f20\u7684\u9644\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (HussarUtils.isEmpty((Object)formExportMetaDto.getFormName())) {
            return ApiResponse.fail((String)"\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u8868\u5355\u6587\u4ef6");
        }
        FormAttachmentParseVo formAttachmentParseVo = new FormAttachmentParseVo();
        formAttachmentParseVo.setPath(unZipPath);
        formAttachmentParseVo.setEncryptFlag(ToolUtil.isNotEmpty((Object)formExportMetaDto.getPassword()));
        BeanUtils.copyProperties((Object)formExportMetaDto, (Object)formAttachmentParseVo);
        formAttachmentParseVo.setI18nKeys(sysForm.getString("i18nKeys"));
        return ApiResponse.success((Object)formAttachmentParseVo);
    }

    public ApiResponse<Boolean> verifyPassword(FormImportDto formImportDto) {
        String inputPwd = DigestUtil.sha1Hex((String)formImportDto.getPassword());
        String metaFilePath = FileUtil.posixPath((String[])new String[]{formImportDto.getPath(), "hussar.meta"});
        FormExportMetaDto formExportMetaDto = AppMigrateUtil.readFileToObject(metaFilePath, FormExportMetaDto.class);
        assert (formExportMetaDto != null);
        String password = formExportMetaDto.getPassword();
        return ApiResponse.success((Object)inputPwd.equals(password));
    }

    public void importForm(FormImportDto formImportDto) {
        String dataSourceKey = DataModelUtil.currentDsName();
        logger.info("\u8868\u5355\u5bfc\u5165 => \u5f00\u59cb\u6267\u884c..., \u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey);
        DatasourceConfigDTO dataSourceConfigByName = null;
        try {
            dataSourceConfigByName = DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            logger.error("\u8868\u5355\u5bfc\u5165 => \u83b7\u53d6\u6570\u636e\u6e90\u914d\u7f6e\u5f02\u5e38\uff0c\u6570\u636e\u6e90\uff1a{}", (Object)dataSourceKey, (Object)e);
        }
        DatasourceConfigDTO finalDataSourceConfigByName = dataSourceConfigByName;
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            String cacheKey = String.format("DATASOURCE_NAME_CACHE_KEY_%s", dataSourceKey);
            TransmittableThreadLocalHolder.set((String)cacheKey, (Object)finalDataSourceConfigByName);
            logger.info("\u8868\u5355\u5bfc\u5165 => TransmittableThreadLocalHolder \u6570\u636e\u6e901\uff1a{}", TransmittableThreadLocalHolder.get((String)cacheKey));
            try {
                this.formImportThreadService.startImportThread(formImportDto, dataSourceKey);
                TransmittableThreadLocalHolder.clear((String)"loginUser");
            }
            catch (Exception e) {
                logger.error("\u8868\u5355\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                throw new HussarException((Throwable)e);
            }
        });
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)(HussarUtils.isNotEmpty((Object)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class)) ? (ImportStatusVo)HussarCacheUtil.get((String)"import_progress", (Object)importCacheKey, ImportStatusVo.class) : ImportStatusVo.waitImport((int)1, (boolean)false, (Object)"", (boolean)false, (String)"\u6b63\u5728\u5bfc\u5165\u8868\u5355\u6570\u636e")));
    }
}

