/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.application.application.model.SysAppExportRecord;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppExportRecordService;
import com.jxdinfo.hussar.formdesign.application.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.formdesign.application.authority.service.AppFileExtendService;
import com.jxdinfo.hussar.formdesign.application.form.dto.FormExportDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportInfoService;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormExportService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

@Service(value="com.jxdinfo.hussar.formdesign.application.form.service.impl.FormExportServiceImpl")
public class FormExportServiceImpl
implements IFormExportService {
    @Resource
    private IFormExportInfoService formExportInfoService;
    @Resource
    private ISysAppExportRecordService sysAppExportRecordService;
    @Resource
    private AppFileExtendService appFileExtendService;
    @Resource
    private ISysFormService formService;

    public ApiResponse<Void> export(FormExportDto formExportDto) {
        Long usr = BaseSecurityUtil.getUser().getId();
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        SysForm form = (SysForm)this.formService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysForm::getId, (Object)formExportDto.getFormId()));
        String dataSourceKey = DataModelUtil.currentDsName();
        try {
            DataModelUtil.getDataSourceConfigByName((String)dataSourceKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ThreadPoolUtil.execute(() -> {
            RequestContextHolder.resetRequestAttributes();
            try {
                this.exportExecute(formExportDto, form, usr, dataSourceKey);
            }
            catch (Exception e) {
                ToolUtil.getLogger(FormExportServiceImpl.class).error("\u5bfc\u51fa\u5e94\u7528\u65f6\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
        return ApiResponse.success();
    }

    @HussarDs(value="#dataSourceKey")
    public void exportExecute(FormExportDto formExportDto, SysForm form, Long usr, String dataSourceKey) throws InterruptedException, IOException {
        this.formExportInfoService.init(formExportDto);
        this.formExportInfoService.exportFormInfo(formExportDto);
        if ("2".equals(form.getFormType())) {
            this.formExportInfoService.exportDashboardData(formExportDto);
        } else {
            this.formExportInfoService.exportDesignerMidFile(formExportDto);
            this.formExportInfoService.exportFlowConfigInfo(formExportDto);
        }
        if (formExportDto.getExportDataFlag()) {
            this.formExportInfoService.exportBusinessData(formExportDto);
        }
        this.formExportInfoService.generateMetaInfo(formExportDto);
        Thread.sleep(1000L);
        Long exportFileId = this.formExportInfoService.uploadExportFile(formExportDto);
        SysAppExportRecord record = new SysAppExportRecord();
        record.setType("2");
        record.setName(((SysForm)this.formService.getById((Serializable)formExportDto.getFormId())).getFormName());
        record.setExportUserId(usr);
        record.setExportTime(LocalDateTime.now());
        record.setExportFileId(exportFileId);
        this.sysAppExportRecordService.save((Object)record);
        this.formExportInfoService.clear();
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"export_progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public void downloadExportFile(Long fileId, HttpServletResponse response) {
        this.appFileExtendService.fileDownload(fileId, response);
    }
}

