/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.authority.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.application.authority.dao.SysAppVisitDataLogicMapper;
import com.jxdinfo.hussar.formdesign.application.authority.dto.DataLogicAuthorityDto;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogic;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitDataLogicFilter;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicFilterService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitDataLogicService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicAuthorityVo;
import com.jxdinfo.hussar.formdesign.application.authority.vo.DataLogicFilterVo;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormRoleAuthVo;
import com.jxdinfo.hussar.formdesign.engine.util.HeExternalApiUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.authority.service.impl.sysAppVisitDataLogicServiceImpl")
public class SysAppVisitDataLogicServiceImpl
extends HussarServiceImpl<SysAppVisitDataLogicMapper, SysAppVisitDataLogic>
implements ISysAppVisitDataLogicService {
    @Autowired
    private ISysAppVisitDataLogicFilterService sysAppVisitDataLogicFilterService;
    @Resource
    private ISysFormService sysFormService;
    @Autowired
    private ISysAppVisitFormAuthorizeRolesService sysAppVisitFormAuthorizeRolesService;

    @HussarTransactional
    public ApiResponse<Boolean> dataLogicAuthoritySave(DataLogicAuthorityDto dataLogicAuthorityDto) {
        SysAppVisitDataLogic sysAppVisitDataLogic = new SysAppVisitDataLogic();
        BeanUtil.copy((Object)dataLogicAuthorityDto, (Object)sysAppVisitDataLogic);
        SysAppVisitDataLogic lastSysAppVisitDataLogic = (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)dataLogicAuthorityDto.getFormId())).eq(SysAppVisitDataLogic::getRoleId, (Object)dataLogicAuthorityDto.getRoleId()));
        sysAppVisitDataLogic.setId(Long.valueOf(HussarUtils.isNotEmpty((Object)lastSysAppVisitDataLogic) ? lastSysAppVisitDataLogic.getId() : IdWorker.getId((Object)sysAppVisitDataLogic)));
        this.saveOrUpdate(sysAppVisitDataLogic, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)dataLogicAuthorityDto.getFormId())).eq(SysAppVisitDataLogic::getRoleId, (Object)dataLogicAuthorityDto.getRoleId()));
        this.sysAppVisitDataLogicFilterService.dataLogicFilterSave(dataLogicAuthorityDto.getFilters(), sysAppVisitDataLogic.getId());
        return ApiResponse.success((Object)Boolean.TRUE, (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @HussarTransactional
    public void saveBatchDataLogicAuthority(List<DataLogicAuthorityDto> dataLogicAuthorityDtoList) {
        if (HussarUtils.isEmpty(dataLogicAuthorityDtoList)) {
            return;
        }
        ArrayList<SysAppVisitDataLogic> sysAppVisitDataLogicList = new ArrayList<SysAppVisitDataLogic>();
        ArrayList sysAppVisitDataLogicFilterList = new ArrayList();
        ArrayList<Long> delDataLogicIds = new ArrayList<Long>();
        for (DataLogicAuthorityDto dataLogicAuthorityDto : dataLogicAuthorityDtoList) {
            SysAppVisitDataLogic sysAppVisitDataLogic = new SysAppVisitDataLogic();
            BeanUtil.copy((Object)dataLogicAuthorityDto, (Object)sysAppVisitDataLogic);
            SysAppVisitDataLogic lastSysAppVisitDataLogic = (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)dataLogicAuthorityDto.getFormId())).eq(SysAppVisitDataLogic::getRoleId, (Object)dataLogicAuthorityDto.getRoleId()));
            sysAppVisitDataLogic.setId(Long.valueOf(HussarUtils.isNotEmpty((Object)lastSysAppVisitDataLogic) ? lastSysAppVisitDataLogic.getId() : IdWorker.getId((Object)sysAppVisitDataLogic)));
            sysAppVisitDataLogicList.add(sysAppVisitDataLogic);
            delDataLogicIds.add(sysAppVisitDataLogic.getId());
            dataLogicAuthorityDto.getFilters().forEach(dataLogicFilterDto -> {
                SysAppVisitDataLogicFilter sysAppVisitDataLogicFilter = new SysAppVisitDataLogicFilter();
                BeanUtil.copy((Object)dataLogicFilterDto, (Object)sysAppVisitDataLogicFilter);
                sysAppVisitDataLogicFilter.setRoleDataLogicId(sysAppVisitDataLogic.getId());
                sysAppVisitDataLogicFilter.setFilterConditionCode(dataLogicFilterDto.getFilterCode());
                sysAppVisitDataLogicFilter.setFilterConditionName(dataLogicFilterDto.getFilterName());
                sysAppVisitDataLogicFilterList.add(sysAppVisitDataLogicFilter);
            });
        }
        if (HussarUtils.isNotEmpty(sysAppVisitDataLogicList)) {
            this.saveOrUpdateBatch(sysAppVisitDataLogicList);
            if (HussarUtils.isNotEmpty(delDataLogicIds)) {
                this.sysAppVisitDataLogicFilterService.remove((Wrapper)new LambdaQueryWrapper().in(SysAppVisitDataLogicFilter::getRoleDataLogicId, delDataLogicIds));
                this.sysAppVisitDataLogicFilterService.saveBatch(sysAppVisitDataLogicFilterList);
            }
        }
    }

    public ApiResponse<DataLogicAuthorityVo> dataLogicAuthorityList(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId) && HussarUtils.isNotEmpty((Object)roleId)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            SysAppVisitDataLogic sysAppVisitDataLogic = (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
                BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
                List dataLogicFilterVos = this.sysAppVisitDataLogicFilterService.dataLogicFilterList(sysAppVisitDataLogic.getId());
                dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
            }
            return ApiResponse.success((Object)dataLogicAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u6216\u89d2\u8272id\u4e3a\u7a7a");
    }

    public Map<Long, DataLogicAuthorityVo> listDataLogicAuthorityByAppId(Long appId, Long roleId) {
        HashMap<Long, DataLogicAuthorityVo> dataLogicAuthorityVoMap = new HashMap<Long, DataLogicAuthorityVo>();
        List dataLogicList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
        Map<Long, List<SysAppVisitDataLogic>> dataLogicGroupMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getFormId));
        List sysFormList = this.sysFormService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        for (SysForm sysForm : sysFormList) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            dataLogicAuthorityVoMap.put(sysForm.getId(), dataLogicAuthorityVo);
            List<SysAppVisitDataLogic> dataLogicAuthorities = dataLogicGroupMap.get(sysForm.getId());
            if (HussarUtils.isEmpty(dataLogicAuthorities) || HussarUtils.isNull((Object)dataLogicAuthorities.get(0))) continue;
            SysAppVisitDataLogic sysAppVisitDataLogic = dataLogicAuthorities.get(0);
            BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
            List dataLogicFilterVos = this.sysAppVisitDataLogicFilterService.dataLogicFilterList(sysAppVisitDataLogic.getId());
            dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
        }
        return dataLogicAuthorityVoMap;
    }

    public void prepareDataLogicAuthorityByFormId(List<SysFormRoleAuthVo> result, Long appId, Long formId) {
        List dataLogicList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getAppId, (Object)appId)).eq(SysAppVisitDataLogic::getFormId, (Object)formId));
        List logicIds = dataLogicList.stream().map(SysAppVisitDataLogic::getId).collect(Collectors.toList());
        List dataLogicFilterListByLogicIds = this.sysAppVisitDataLogicFilterService.dataLogicFilterListByLogicIds(logicIds);
        Map<Long, List<SysAppVisitDataLogicFilter>> mapDataLogicFilter = dataLogicFilterListByLogicIds.stream().collect(Collectors.groupingBy(SysAppVisitDataLogicFilter::getRoleDataLogicId));
        Map<Long, List<SysAppVisitDataLogic>> dataLogicGroupMap = dataLogicList.stream().collect(Collectors.groupingBy(SysAppVisitDataLogic::getRoleId));
        for (SysFormRoleAuthVo formRoleAuthVo : result) {
            DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
            formRoleAuthVo.setDataLogicAuthority(dataLogicAuthorityVo);
            List<SysAppVisitDataLogic> dataLogicAuthorities = dataLogicGroupMap.get(formRoleAuthVo.getRoleId());
            if (HussarUtils.isEmpty(dataLogicAuthorities)) continue;
            SysAppVisitDataLogic sysAppVisitDataLogic = dataLogicAuthorities.get(0);
            BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
            List<SysAppVisitDataLogicFilter> dataLogicFilters = mapDataLogicFilter.get(sysAppVisitDataLogic.getId());
            List<Object> dataLogicFilterVos = new ArrayList();
            if (HussarUtils.isNotEmpty(dataLogicFilters)) {
                dataLogicFilterVos = dataLogicFilters.stream().map(item -> {
                    DataLogicFilterVo dataLogicVo = new DataLogicFilterVo();
                    dataLogicVo.setFieldId(item.getFieldId());
                    dataLogicVo.setFieldName(item.getFieldName());
                    dataLogicVo.setFilterCode(item.getFilterConditionCode());
                    dataLogicVo.setFilterName(item.getFilterConditionName());
                    dataLogicVo.setFilterValue(item.getFilterValue());
                    return dataLogicVo;
                }).collect(Collectors.toList());
            }
            dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
        }
    }

    @HussarTransactional
    public void dataLogicAuthorityCancel(Long formId, Long roleId) {
        SysAppVisitDataLogic sysAppVisitDataLogic = (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
        if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
            this.removeById((BaseEntity)sysAppVisitDataLogic);
            this.sysAppVisitDataLogicFilterService.dataLogicFilterCancel(sysAppVisitDataLogic.getId());
        }
    }

    public ApiResponse<List<DataLogicAuthorityVo>> dataLogicAuthorityByFormId(Long formId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            List sysAppVisitDataLogics;
            List rolesList;
            SecurityUser user = BaseSecurityUtil.getUser();
            ArrayList<DataLogicAuthorityVo> dataLogicAuthorityVos = new ArrayList<DataLogicAuthorityVo>();
            if (HussarUtils.isNotEmpty((Object)user) && HussarUtils.isNotEmpty((Object)(rolesList = user.getRolesList())) && HussarUtils.isNotEmpty((Object)(sysAppVisitDataLogics = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).in(SysAppVisitDataLogic::getRoleId, (Collection)rolesList))))) {
                for (SysAppVisitDataLogic sysAppVisitDataLogic : sysAppVisitDataLogics) {
                    DataLogicAuthorityVo dataLogicAuthorityVo = new DataLogicAuthorityVo();
                    BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
                    List dataLogicFilterVos = this.sysAppVisitDataLogicFilterService.dataLogicFilterList(sysAppVisitDataLogic.getId());
                    for (DataLogicFilterVo dataLogicFilterVo : dataLogicFilterVos) {
                        dataLogicFilterVo.setFilterCode(HeExternalApiUtil.getOperatorType((String)dataLogicFilterVo.getFilterCode()).toString());
                    }
                    dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
                    dataLogicAuthorityVos.add(dataLogicAuthorityVo);
                }
            }
            return ApiResponse.success(dataLogicAuthorityVos);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }

    public ApiResponse<DataLogicAuthorityVo> dataLogicAuthorityByFormId(Long formId, Long roleId) {
        if (HussarUtils.isNotEmpty((Object)formId)) {
            DataLogicAuthorityVo dataLogicAuthorityVo = null;
            SysAppVisitDataLogic sysAppVisitDataLogic = (SysAppVisitDataLogic)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitDataLogic::getFormId, (Object)formId)).eq(SysAppVisitDataLogic::getRoleId, (Object)roleId));
            if (HussarUtils.isNotEmpty((Object)sysAppVisitDataLogic)) {
                dataLogicAuthorityVo = new DataLogicAuthorityVo();
                BeanUtil.copy((Object)sysAppVisitDataLogic, (Object)dataLogicAuthorityVo);
                List dataLogicFilterVos = this.sysAppVisitDataLogicFilterService.dataLogicFilterList(sysAppVisitDataLogic.getId());
                for (DataLogicFilterVo dataLogicFilterVo : dataLogicFilterVos) {
                    dataLogicFilterVo.setFilterCode(HeExternalApiUtil.getOperatorType((String)dataLogicFilterVo.getFilterCode()).toString());
                }
                dataLogicAuthorityVo.setFilters(dataLogicFilterVos);
            }
            return ApiResponse.success(dataLogicAuthorityVo);
        }
        throw new BaseException("\u8868\u5355id\u4e3a\u7a7a");
    }
}

