/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppAuthorizeMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppDevelopTeamMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.formdesign.application.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.formdesign.application.application.enums.SysUserRoleEnum;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppAuthorizeService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationService;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.formdesign.application.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.formdesign.application.form.dao.SysFormMapper;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormGroupVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.formdesign.application.application.service.impl.sysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private SysFormMapper sysFormMapper;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysFormGroupService sysFormGroupService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysAppAuthorizeService sysAppAuthorizeService;
    @Resource
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private SysAppDevelopTeamMapper developTeamMapper;
    @Resource
    private SysAppAuthorizeMapper appAuthorizeMapper;
    @Resource
    private ISysRolesExternalService rolesExternalService;
    @Resource
    private ISysAppRecycleService recycleService;
    private static final Long ALL_STAFF = -1L;

    public List<SysAppGroupVo> getAppList(String appName) {
        List<Long> appIds = this.getCurrentUserAuthorityApp();
        if (HussarUtils.isEmpty(appIds)) {
            return null;
        }
        List<Object> appList = new ArrayList();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        appList = this.sysApplicationMapper.getAppList(appName, appIds);
        for (SysApplicationVo sysApplicationVo : appList) {
            groupIds.add(sysApplicationVo.getAppGroupId());
        }
        ArrayList<SysAppGroup> sysAppGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroupByIds(groupIds);
        }
        ArrayList<SysApplicationVo> arrayList = new ArrayList<SysApplicationVo>();
        for (SysApplicationVo sysApplicationVo : appList) {
            SysApplicationVo vo = new SysApplicationVo();
            BeanUtils.copyProperties((Object)sysApplicationVo, (Object)vo);
            arrayList.add(vo);
        }
        return this.combinedData(arrayList, sysAppGroups);
    }

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus) {
        List<Long> appIds;
        ArrayList appListVo = Lists.newArrayListWithCapacity((int)10);
        SecurityUser user = BaseSecurityUtil.getUser();
        List<SysApplicationVo> appList = null;
        List<Object> sysAppGroups = new ArrayList();
        if (user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue())) {
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, null);
            if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus)) {
                LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
                wrapper.orderByDesc(HussarBaseEntity::getCreateTime);
                sysAppGroups = this.sysAppGroupService.list((Wrapper)wrapper);
            } else {
                LinkedHashSet groupIds = Sets.newLinkedHashSetWithExpectedSize((int)10);
                for (SysApplication sysApplication : appList) {
                    groupIds.add(sysApplication.getAppGroupId());
                }
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                if (HussarUtils.isNotEmpty((Object)groupIds)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroup(null, new ArrayList<Long>(groupIds));
                }
            }
        } else {
            appIds = this.developTeamService.selectAppListByCurrentUser();
            if (HussarUtils.isEmpty((Object)appIds)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            appList = this.sysApplicationMapper.getAppListManage(appGroupId, appName, appStatus, appIds);
            if (HussarUtils.isEmpty(appList)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    sysAppGroups = this.sysAppGroupMapper.getAppGroupById(appGroupId);
                    return this.combinedData(appListVo, sysAppGroups);
                }
                return Lists.newArrayListWithCapacity((int)0);
            }
            Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
            if (HussarUtils.isNotEmpty((Object)appGroupId) || HussarUtils.isNotEmpty((Object)appName) || HussarUtils.isNotEmpty((Object)appStatus)) {
                if (HussarUtils.isNotEmpty((Object)appGroupId)) {
                    groupIds.add(appGroupId);
                }
                sysAppGroups = this.sysAppGroupMapper.getAppGroupByIds(new ArrayList<Long>(groupIds));
            } else {
                sysAppGroups = this.sysAppGroupMapper.getAppGroup(BaseSecurityUtil.getUser().getUserId(), new ArrayList<Long>(groupIds));
            }
        }
        appIds = appList.stream().map(SysApplication::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(appIds)) {
            List<SysAppDevelopTeam> sysAppDevelopTeams = this.developTeamMapper.selectAppDevelopTeamList(appIds);
            Map map = sysAppDevelopTeams.stream().collect(Collectors.toMap(SysAppDevelopTeam::getAppId, Function.identity()));
            for (SysApplicationVo app : appList) {
                SysApplicationVo vo = new SysApplicationVo();
                BeanUtils.copyProperties((Object)app, (Object)vo);
                if (null != map.get(vo.getId())) {
                    vo.setTeamId(((SysAppDevelopTeam)map.get(vo.getId())).getId());
                }
                appListVo.add(vo);
            }
        }
        return this.combinedData(appListVo, sysAppGroups);
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        return ApiResponse.success((Object)this.sysApplicationMapper.getAppDetailContainUserName(appId));
    }

    public SysApplicationVo getAuthorityAppDetail(Long appId) {
        List dataFormGroup;
        SysApplicationVo appDetail = this.sysApplicationMapper.getAppDetail(appId);
        AssertUtil.isNotNull((Object)appDetail, (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean authorityFlag = this.validateAuthorityByAppId(appId);
        if (!authorityFlag.booleanValue()) {
            throw new BaseException("\u60a8\u6ca1\u6709\u8be5\u5e94\u7528\u7684\u8bbf\u95ee\u6743\u9650");
        }
        boolean designedOrNotFlag = false;
        List dataForm = (List)this.formService.getSysFormByAppId(appId).getData();
        if (HussarUtils.isNotEmpty((Object)dataForm)) {
            designedOrNotFlag = true;
        }
        if (!designedOrNotFlag && HussarUtils.isNotEmpty((Object)(dataFormGroup = (List)this.sysFormGroupService.getFormGroupList(appId).getData()))) {
            designedOrNotFlag = true;
        }
        Boolean hasAuthorityCreateForm = user.isSuperAdmin() || user.getRolesList().contains(SysUserRoleEnum.APPLICATIONADMIN.getValue()) || user.getRolesList().contains(SysUserRoleEnum.TENANT_ROLE.getValue()) ? Boolean.valueOf(true) : this.developTeamService.checkCurrentUserInTeam(appId);
        appDetail.setDesignedOrNot(Boolean.valueOf(designedOrNotFlag));
        appDetail.setHasAuthorityCreateForm(hasAuthorityCreateForm);
        return appDetail;
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    public String getCurrentCode() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        for (SysApplicationVo sysApplication : appList) {
            SysAppGroupVo sysAppGroupVo2 = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isEmpty((Object)sysAppGroupVo2)) continue;
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo2.getSysApplicationList())) {
                sysAppGroupVo2.getSysApplicationList().add(sysApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysAppGroupVo2.getSysApplicationList())) continue;
            ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
            sysApplicationList.add(sysApplication);
            sysAppGroupVo2.setSysApplicationList(sysApplicationList);
        }
        return new ArrayList<SysAppGroupVo>(resultCollect.values());
    }

    public Boolean validateAuthorityByAppId(Long appId) {
        HashSet currentUserRoleSet;
        Sets.SetView intersectionSet;
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean isInDevelopTeam = this.developTeamService.checkCurrentUserInTeam(appId);
        boolean isTenantAdmin = false;
        if (HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            isTenantAdmin = user.getRolesList().contains(TenantConstant.ADMIN_ROLE);
        }
        if (user.isSuperAdmin() || isInDevelopTeam || isTenantAdmin) {
            return true;
        }
        SysApplicationVo app = this.applicationService.getAppDetailById(appId);
        if (user.getId().equals(app.getCreator())) {
            return true;
        }
        ApiResponse appRoleList = this.sysAppAuthorizeService.getAppRoleList(appId);
        List roleVoList = (List)appRoleList.getData();
        if (HussarUtils.isEmpty((Object)roleVoList)) {
            return false;
        }
        List roleIdList = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toList());
        if (roleIdList.contains(ALL_STAFF)) {
            return true;
        }
        Map extendUserMap = user.getExtendUserMap();
        Set authorityRoleSet = roleVoList.stream().map(RoleVo::getId).collect(Collectors.toSet());
        List currentUserRoleList = user.getRolesList();
        if (currentUserRoleList.contains(TenantConstant.ADMIN_ROLE)) {
            return true;
        }
        currentUserRoleList.add(user.getId());
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("deptId"))) {
            currentUserRoleList.add(Long.valueOf(extendUserMap.get("deptId").toString()));
        }
        if (HussarUtils.isNotEmpty((Object)extendUserMap) && HussarUtils.isNotEmpty(extendUserMap.get("postId"))) {
            currentUserRoleList.add(Long.valueOf(extendUserMap.get("postId").toString()));
        }
        return !HussarUtils.isEmpty((Object)(intersectionSet = Sets.intersection(authorityRoleSet, currentUserRoleSet = new HashSet(currentUserRoleList))));
    }

    public List<Long> getCurrentUserAuthorityApp() {
        return this.sysAppAuthorizeService.getCurrentUserAuthorityApp();
    }

    public List<SysApplicationVo> getAppContainFormInfoList() {
        ArrayList resultApps = Lists.newArrayListWithCapacity((int)10);
        List appIds = this.developTeamService.selectAppListByCurrentUser();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<SysApplicationVo> appList = this.sysApplicationMapper.getAppListManage(null, null, null, appIds);
        List sysForms = this.sysFormService.getFormsByAppIds(appIds);
        if (HussarUtils.isEmpty((Object)sysForms)) {
            return resultApps;
        }
        List sysFormGroups = this.sysFormGroupService.getFormGroupsByAppIds(appIds);
        ArrayList<SysFormGroupVo> formGroupTreeVos = new ArrayList<SysFormGroupVo>();
        if (HussarUtils.isNotEmpty((Object)sysFormGroups)) {
            for (SysFormGroup sysFormGroup : sysFormGroups) {
                SysFormGroupVo formGroupTreeVo2 = new SysFormGroupVo();
                formGroupTreeVo2.setId(sysFormGroup.getId());
                formGroupTreeVo2.setGroupName(sysFormGroup.getGroupName());
                formGroupTreeVo2.setAppId(sysFormGroup.getAppId());
                List haveGroupForms = sysForms.stream().filter(sysForm -> HussarUtils.equals((Object)sysFormGroup.getId(), (Object)sysForm.getFormGroupId())).collect(Collectors.toList());
                formGroupTreeVo2.setSysFormList(haveGroupForms);
                formGroupTreeVos.add(formGroupTreeVo2);
            }
        }
        for (SysApplicationVo applicationVo : appList) {
            SysApplicationVo appTreeVo = new SysApplicationVo();
            appTreeVo.setId(applicationVo.getId());
            appTreeVo.setAppName(applicationVo.getAppName());
            List noGroupForms = sysForms.stream().filter(sysForm -> HussarUtils.equals((Object)appTreeVo.getId(), (Object)sysForm.getAppId()) && HussarUtils.isEmpty((Object)sysForm.getFormGroupId())).collect(Collectors.toList());
            appTreeVo.setNoGroupList(noGroupForms);
            if (HussarUtils.isNotEmpty(formGroupTreeVos)) {
                List formGroupTreesOfApp = formGroupTreeVos.stream().filter(formGroupTreeVo -> HussarUtils.equals((Object)formGroupTreeVo.getAppId(), (Object)appTreeVo.getId())).collect(Collectors.toList());
                appTreeVo.setSysFormGroupVos(formGroupTreesOfApp);
            }
            resultApps.add(appTreeVo);
        }
        return resultApps;
    }

    public String getNewAppName() {
        String appName = "\u672a\u547d\u540d\u5e94\u7528";
        return this.getNewAppName(appName);
    }

    public String getUniqueAppName(String appName) {
        if (HussarUtils.isNotEmpty((Object)appName) && appName.length() > 19) {
            appName = appName.substring(0, 19);
        }
        return this.getNewAppName(appName);
    }

    private String getNewAppName(String appName) {
        ArrayList appNames = new ArrayList();
        List apps = this.list();
        List recycles = this.recycleService.list();
        if (ObjectUtils.isNotEmpty((Object)apps)) {
            List appNameInDb = apps.stream().map(SysApplication::getAppName).collect(Collectors.toList());
            appNames.addAll(appNameInDb);
            if (ObjectUtils.isNotEmpty((Object)recycles)) {
                List recycleAppNames = recycles.stream().map(SysAppRecycle::getAppName).collect(Collectors.toList());
                appNames.addAll(recycleAppNames);
            }
        }
        int count = 1;
        String newAppName;
        while (appNames.contains(newAppName = appName + count)) {
            ++count;
        }
        return newAppName;
    }
}

