/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.DataExportDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewSchemaVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelWaterRemarkUtils;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExelTaskUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.UserAndOrgHandle;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.WaterMarkComponent;
import com.jxdinfo.hussar.formdesign.application.application.dto.SysAppWatermarkDto;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysAppWatermarkService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportCellVo;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.ShowField;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.enums.FormQuerySortEnum;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FormSecurityLevelService;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.formdesign.no.code.util.TimeFormatUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.lang.model.SysMultiLang;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangBoService;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import reactor.core.publisher.Flux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Component
public class ExcelExport {
    private static Logger logger = LoggerFactory.getLogger(ExcelExport.class);
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private HussarFormDesignProperties hussarFormDesignFrameProperties;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Autowired
    private ExelTaskUtil exelTaskUtil;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ExcelImport excelImport;
    @Resource
    private ISysAppWatermarkService sysAppWatermarkService;
    @Resource
    private WaterMarkComponent waterMarkComponent;
    @Resource
    private ISysMultiLangBoService sysMultiLangService;
    @Resource
    private ISysMultiLangMgtBoService sysMultiLangMgtService;
    @Resource
    private UserAndOrgHandle userAndOrgHandle;
    @Resource
    private OssService ossService;
    @Resource
    private FormSecurityLevelService formSecurityLevelService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private ISysFormService sysFormService;
    private static final String PRIMARY_KEY_TITLE_NAME = "\u6570\u636eid\uff08\u4e0d\u53ef\u66f4\u6539\uff09";
    private static final String FORM_DATA_EXPORT = "\u8868\u5355\u6570\u636e\u5bfc\u51fa";
    private static final String FORM_DATA_IMPORT = "\u8868\u5355\u6570\u636e\u5bfc\u5165";
    private static final String EXAMPLE_DATA = "\u793a\u4f8b\u6570\u636e";
    private static final String IMPORT_TEMPLATE = "\u5bfc\u5165\u6a21\u677f";
    private static final String CACHE_TEMPLATE = "%s_%s";
    private static final String SUPER_QUERY_CONDITION_DTO = "superQueryConditionDto";
    private static final String ORDERS = "orders";
    private static final String CURRENT = "current";
    private static final String FORM_ID = "formId";
    private static final String APP_ID = "appId";
    private static final String ASYNC_TYPE = "asyncType";
    private static final String FORM_MISS = "\u8868\u5355\u4e0d\u5b58\u5728";
    private static final String NO_SUPPORT_QUERY = "\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u8868\u5355\u7684\u67e5\u8be2!";
    private static final String LABEL = "_label";
    private static final String EXTERNAL_API = "externalAPI";
    private static final int MAXSIZEEVERYPAGE = 500;
    private static final Long SECURITY_LEVEL_TYPE_ID = 1450742089372590091L;

    String getSaticName(String langCode, String temp) {
        if (HussarUtils.isNotEmpty((Object)langCode)) {
            List list = this.sysMultiLangMgtService.listByLangTextAndLang(temp, LangEnum.ZH_CN.getLangValue());
            if (HussarUtils.isNotEmpty((Object)list)) {
                String langKey = ((SysMultiLangMgt)list.get(0)).getLangKey();
                SysMultiLangMgt sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(langKey, langCode);
                if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                    return sysMultiLangMgt.getLangText();
                }
                SysMultiLang sysMultiLang = this.sysMultiLangService.getDefaultLang();
                if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
                    String code = sysMultiLang.getLangCode();
                    sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(langKey, code);
                    if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                        return sysMultiLangMgt.getLangText();
                    }
                    return temp;
                }
                return temp;
            }
            return temp;
        }
        return temp;
    }

    public void export(String sheetName, String[] headers, List<List<Object>> dataList, File destFile) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        this.createSheet(sheetName, headers, dataList, workbook);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(destFile);
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        finally {
            if (HussarUtils.isNotEmpty(fileOutputStream)) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void exportForImport(String sheetName, List<List<ExcelImportCellVo>> headers1, List<List<Object>> list1, List<List<ExcelImportCellVo>> headers2, List<List<Object>> list2, String fileName, HttpServletResponse response, String langCode, SysForm form, List<Widget> widgets) throws IOException {
        void var19_26;
        void var19_24;
        String key;
        SysMultiLangMgt sysMultiLangMgt;
        JSONObject parse;
        Object object;
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        ArrayList<CellRangeAddress> ranges1 = new ArrayList<CellRangeAddress>();
        ArrayList<List<Object>> headerObjects1 = new ArrayList<List<Object>>();
        ArrayList<List<Object>> headerTypes1 = new ArrayList<List<Object>>();
        HashMap<String, List<String>> relatedData1 = new HashMap<String, List<String>>();
        for (List<ExcelImportCellVo> row : headers1) {
            ArrayList headerObjectsRow = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ExcelImportCellVo excelImportCellVo : row) {
                if (excelImportCellVo.getRowspan() != 1 || excelImportCellVo.getColspan() != 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(excelImportCellVo.getRow(), excelImportCellVo.getRow() + excelImportCellVo.getRowspan() - 1, excelImportCellVo.getCol(), excelImportCellVo.getCol() + excelImportCellVo.getColspan() - 1);
                    ranges1.add(cellRangeAddress);
                }
                headerObjectsRow.add(excelImportCellVo.getValue());
                boolean hasValue = false;
                for (Widget widget : widgets) {
                    if (!ToolUtil.isNotEmpty((Object)excelImportCellVo.getFieldName()) || !ToolUtil.isNotEmpty((Object)excelImportCellVo.getFieldType()) || !excelImportCellVo.getFieldName().equals(HussarUtils.isEmpty((Object)widget.getParentKey()) ? widget.getName() : String.format(CACHE_TEMPLATE, widget.getParentKey(), widget.getName())) && !HussarUtils.equals((Object)excelImportCellVo.getFieldName(), (Object)(HussarUtils.isEmpty((Object)widget.getParentKey()) ? widget.getOldName() : String.format(CACHE_TEMPLATE, widget.getParentKey(), widget.getOldName())))) continue;
                    String value = "";
                    arrayList.add(excelImportCellVo.getFieldType() + this.dealComponent(value, excelImportCellVo.getFieldType(), widget, relatedData1, new ArrayList<EngineResultEntity>()));
                    hasValue = true;
                    break;
                }
                if (!hasValue) {
                    arrayList.add(null);
                }
                if (excelImportCellVo.getColspan() == 1) continue;
                for (int i = 1; i < excelImportCellVo.getColspan(); ++i) {
                    headerObjectsRow.add(null);
                    arrayList.add(null);
                }
            }
            headerObjects1.add(headerObjectsRow);
            headerTypes1.add(arrayList);
        }
        ArrayList<CellRangeAddress> ranges2 = new ArrayList<CellRangeAddress>();
        ArrayList<List<Object>> headerObjects2 = new ArrayList<List<Object>>();
        for (List list : headers2) {
            ArrayList<String> headerObjectsRow = new ArrayList<String>();
            for (ExcelImportCellVo excelImportCellVo : list) {
                if (excelImportCellVo.getRowspan() != 1 || excelImportCellVo.getColspan() != 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(excelImportCellVo.getRow(), excelImportCellVo.getRow() + excelImportCellVo.getRowspan() - 1, excelImportCellVo.getCol(), excelImportCellVo.getCol() + excelImportCellVo.getColspan() - 1);
                    ranges2.add(cellRangeAddress);
                }
                headerObjectsRow.add(excelImportCellVo.getValue());
            }
            headerObjects2.add(headerObjectsRow);
        }
        if (HussarUtils.isNotEmpty(relatedData1)) {
            list1 = new ArrayList<List<Object>>();
            list1.add(null);
        }
        this.createSheet2(this.getSaticName(langCode, FORM_DATA_IMPORT), headerObjects1, headerTypes1, list1, workbook, ranges1, false, relatedData1);
        if (HussarUtils.isNotEmpty(relatedData1)) {
            list1.clear();
        }
        this.createSheet2(this.getSaticName(langCode, EXAMPLE_DATA), headerObjects2, null, list2, workbook, ranges2, true, null);
        response.reset();
        response.setContentType("application/octet-stream; charset=utf-8");
        String i18nKeys = form.getI18nKeys();
        String string = "";
        if (HussarUtils.isNotEmpty((Object)i18nKeys) && HussarUtils.isNotEmpty((Object)(object = (parse = (JSONObject)JSON.parse((String)i18nKeys)).get((Object)"formName"))) && HussarUtils.isNotEmpty((Object)(sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(key = object.toString(), langCode)))) {
            String string2 = sysMultiLangMgt.getLangText();
        }
        if (HussarUtils.isEmpty((Object)var19_24)) {
            String string3 = form.getFormName();
        }
        fileName = (String)var19_26 + "-" + this.getSaticName(langCode, IMPORT_TEMPLATE) + ".xlsx";
        fileName = fileName.replaceAll(" ", "");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = response.getOutputStream();
            workbook.write((OutputStream)servletOutputStream);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            throw new IOException(iOException);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)servletOutputStream)) {
                try {
                    servletOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        workbook.dispose();
    }

    public void export(String sheetName, String[] headers, List<List<Object>> dataList, String fileName, HttpServletResponse response) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        this.createSheet(sheetName, headers, dataList, workbook);
        response.reset();
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = response.getOutputStream();
            workbook.write((OutputStream)servletOutputStream);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)servletOutputStream)) {
                try {
                    servletOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        workbook.dispose();
    }

    public void exportToExcel(String sheetName, List<List<Object>> headers, List<List<Object>> headerTypes, List<List<Object>> dataList, String fileName, FileOutputStream fileOutputStream, List<CellRangeAddress> ranges, Boolean watermark, Map<String, List<String>> relatedData) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook(-1);
        this.createSheet2(sheetName, headers, headerTypes, dataList, workbook, ranges, false, relatedData);
        if (watermark.booleanValue()) {
            this.addWatermark(workbook, sheetName);
        }
        try {
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)fileOutputStream)) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        workbook.dispose();
    }

    public void createSheet(String sheetName, String[] headers, List<List<Object>> dataList, SXSSFWorkbook wb) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        CellStyle headStyle = this.setHeaderStyle(wb);
        CellStyle bodyStyle = this.setBodyStyle(wb);
        this.createHeader(headers, sheet, headStyle);
        this.createBody(dataList, sheet, bodyStyle, wb);
    }

    public void createSheet2(String sheetName, List<List<Object>> headers, List<List<Object>> headerTypes, List<List<Object>> dataList, SXSSFWorkbook wb, List<CellRangeAddress> ranges, boolean exampleFlag, Map<String, List<String>> relatedData) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        if (HussarUtils.isNotEmpty(ranges)) {
            for (CellRangeAddress range : ranges) {
                sheet.addMergedRegion(range);
            }
        }
        CellStyle headStyle = this.setHeaderStyle(wb);
        CellStyle bodyStyle = this.setBodyStyle(wb);
        this.createHeader2(headers, sheet, headStyle);
        this.createBody2(headers, dataList, sheet, bodyStyle, wb, exampleFlag);
        this.dealCellStyle(headers, wb, headerTypes, sheet, relatedData, dataList);
    }

    private void dealCellStyle(List<List<Object>> headers, SXSSFWorkbook wb, List<List<Object>> headerTypes, SXSSFSheet sheet, Map<String, List<String>> relatedData, List<List<Object>> dataList) {
        int numRows = headers.size();
        if (dataList != null) {
            numRows += dataList.size();
        }
        for (int i = headers.size(); i < numRows; ++i) {
            SXSSFRow row = null;
            row = ToolUtil.isNotEmpty((Object)sheet.getRow(i)) ? sheet.getRow(i) : sheet.createRow(i);
            if (!ToolUtil.isNotEmpty(headerTypes)) continue;
            for (int k = 0; k < headerTypes.size(); ++k) {
                if (!ToolUtil.isNotEmpty(headerTypes.get(k))) continue;
                for (int j = 0; j < headerTypes.get(k).size(); ++j) {
                    if (ToolUtil.isEmpty((Object)headerTypes.get(k).get(j))) continue;
                    SXSSFCell cell = row.getCell(j) != null ? row.getCell(j) : row.createCell(j);
                    if (i > headers.size() && ToolUtil.isNotEmpty((Object)sheet.getRow(i - 1)) && ToolUtil.isNotEmpty((Object)sheet.getRow(i - 1).getCell(j)) && ToolUtil.isNotEmpty((Object)sheet.getRow(i - 1).getCell(j).getCellStyle())) {
                        String numericCellValue;
                        cell.setCellStyle(sheet.getRow(i - 1).getCell(j).getCellStyle());
                        String fieldType = headerTypes.get(k).get(j).toString();
                        if (fieldType.contains("&&&")) {
                            String[] strings = fieldType.split("&&&");
                            fieldType = strings[0];
                        }
                        if (!"JXDNNumber".equals(fieldType) || !HussarUtils.isNotEmpty((Object)(numericCellValue = cell.getStringCellValue()))) continue;
                        try {
                            double numericCellValue1 = Double.parseDouble(numericCellValue);
                            cell.setCellValue(numericCellValue1);
                        }
                        catch (Exception e) {
                            logger.error("numericCellValue\u8f6cDouble\u5f02\u5e38", (Throwable)e);
                            logger.error("numericCellValue\u8f6cDouble\u5f02\u5e38:{}", (Object)numericCellValue);
                        }
                        continue;
                    }
                    this.setNumberAndDateStyle(wb, sheet, headerTypes.get(k).get(j).toString(), cell, headers.size(), relatedData);
                }
            }
        }
    }

    private void createHeader(String[] headers, SXSSFSheet sheet, CellStyle headStyle) {
        SXSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(31.0f);
        for (int i = 0; i < headers.length; ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellStyle(headStyle);
            XSSFRichTextString text = new XSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            sheet.trackAllColumnsForAutoSizing();
            sheet.setColumnWidth(i, 5120);
        }
    }

    private void createHeader2(List<List<Object>> headers, SXSSFSheet sheet, CellStyle headStyle) {
        for (int i = 0; i < headers.size(); ++i) {
            List<Object> headerRow = headers.get(i);
            SXSSFRow row = sheet.createRow(i);
            row.setHeightInPoints(30.0f);
            for (int j = 0; j < headerRow.size(); ++j) {
                Object value = headerRow.get(j);
                SXSSFCell cell = row.createCell(j);
                cell.setCellStyle(headStyle);
                XSSFRichTextString text = new XSSFRichTextString(value == null ? null : value.toString());
                cell.setCellValue((RichTextString)text);
                sheet.trackAllColumnsForAutoSizing();
                if (HussarUtils.isEmpty((Object)String.valueOf(text))) continue;
                int width = Math.max(5120, text.length() * 1280);
                if (width < 65280) {
                    sheet.setColumnWidth(j, width);
                    continue;
                }
                sheet.setColumnWidth(j, 5120);
            }
        }
    }

    public void setSelectCell(SXSSFSheet sheet, String[] options, int colIndex, int rowStart) {
        if (options.length > 0) {
            DataValidationHelper dvHelper = sheet.getDataValidationHelper();
            XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(options);
            CellRangeAddressList addressList = new CellRangeAddressList(rowStart, 20000, colIndex, colIndex);
            XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
            sheet.addValidationData((DataValidation)validation);
        }
    }

    public void setNumberAndDateStyle(SXSSFWorkbook workbook, SXSSFSheet sheet, String fieldType, SXSSFCell cell, int rowStart, Map<String, List<String>> relatedData) {
        String rule = "";
        String showType = "number";
        if (fieldType.contains("&&&")) {
            String[] strings = fieldType.split("&&&");
            if (HussarUtils.equals((Object)"JXDNNumber", (Object)(fieldType = strings[0]))) {
                showType = HussarUtils.isNotEmpty((Object)strings[2]) ? strings[2] : "number";
            }
            rule = strings[1];
        }
        switch (fieldType) {
            case "JXDNDate": {
                DataFormat format = workbook.createDataFormat();
                CellStyle dateStyle = this.setBodyStyle(workbook);
                dateStyle.setDataFormat(format.getFormat(ToolUtil.isEmpty((Object)rule) ? "yyyy-MM-dd" : rule));
                cell.setCellStyle(dateStyle);
                break;
            }
            case "JXDNRadioGroup": 
            case "JXDNSelect": 
            case "JXDNLinkForm": {
                List<Object> data = new ArrayList();
                if (ToolUtil.isNotEmpty(relatedData)) {
                    data = relatedData.get(rule);
                }
                if (!data.isEmpty()) {
                    this.setSelectCell(sheet, data.toArray(new String[0]), cell.getColumnIndex(), rowStart);
                }
                CellStyle style = this.setBodyStyle(workbook);
                cell.setCellStyle(style);
                style.setDataFormat(workbook.createDataFormat().getFormat("@"));
                break;
            }
            case "JXDNNumber": {
                StringBuilder stringBuilder = new StringBuilder();
                if (ToolUtil.isNotEmpty((Object)rule)) {
                    for (int i = 0; i < Integer.parseInt(rule); ++i) {
                        stringBuilder.append("0");
                    }
                }
                CellStyle numberStyle = this.setBodyStyle(workbook);
                DataFormat dataFormat = workbook.createDataFormat();
                if (HussarUtils.isEmpty((Object)stringBuilder)) {
                    if ("number".equals(showType)) {
                        numberStyle.setDataFormat(dataFormat.getFormat("#,##0"));
                    } else {
                        numberStyle.setDataFormat(dataFormat.getFormat("0%"));
                    }
                } else if ("number".equals(showType)) {
                    numberStyle.setDataFormat(dataFormat.getFormat("#,##0." + stringBuilder));
                } else {
                    numberStyle.setDataFormat(dataFormat.getFormat("0." + stringBuilder + "%"));
                }
                cell.setCellStyle(numberStyle);
                String numericCellValue = cell.getStringCellValue();
                if (!HussarUtils.isNotEmpty((Object)numericCellValue)) break;
                try {
                    double numericCellValue1 = Double.parseDouble(numericCellValue);
                    cell.setCellValue(numericCellValue1);
                }
                catch (Exception e) {
                    logger.error("numericCellValue\u8f6cDouble\u5f02\u5e38", (Throwable)e);
                    logger.error("numericCellValue\u8f6cDouble\u5f02\u5e38:{}", (Object)numericCellValue);
                }
                break;
            }
            default: {
                CellStyle defaultStyle = this.setBodyStyle(workbook);
                cell.setCellStyle(defaultStyle);
            }
        }
    }

    private void createBody(List<List<Object>> dataList, SXSSFSheet sheet, CellStyle bodyStyle, SXSSFWorkbook wb) {
        if (dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            SXSSFRow row = sheet.createRow(i + 1);
            row.setHeightInPoints(30.0f);
            List<Object> rowList = dataList.get(i);
            if (rowList == null) continue;
            for (int j = 0; j < rowList.size(); ++j) {
                SXSSFCell cell = row.createCell(j);
                cell.setCellStyle(bodyStyle);
                Object data = rowList.get(j);
                if (data instanceof Double) {
                    DataFormat format = wb.createDataFormat();
                    bodyStyle.setDataFormat(format.getFormat("#,##0.00"));
                    cell.setCellStyle(bodyStyle);
                    cell.setCellValue(Double.parseDouble(String.valueOf(data)));
                } else {
                    String textStr = Optional.ofNullable(rowList.get(j)).orElse("").toString();
                    XSSFRichTextString text = new XSSFRichTextString(textStr);
                    cell.setCellValue((RichTextString)text);
                }
                sheet.trackAllColumnsForAutoSizing();
                sheet.setColumnWidth(i, 5120);
            }
        }
    }

    private void createBody2(List<List<Object>> headers, List<List<Object>> dataList, SXSSFSheet sheet, CellStyle bodyStyle, SXSSFWorkbook wb, boolean exampleFlag) {
        if (dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            SXSSFRow row = null;
            row = ToolUtil.isNotEmpty((Object)sheet.getRow(i + headers.size())) ? sheet.getRow(i + headers.size()) : sheet.createRow(i + headers.size());
            row.setHeightInPoints(30.0f);
            List<Object> rowList = dataList.get(i);
            if (rowList == null) continue;
            for (int j = 0; j < rowList.size(); ++j) {
                SXSSFCell cell = row.getCell(j) != null ? row.getCell(j) : row.createCell(j);
                cell.setCellStyle(bodyStyle);
                Object data = rowList.get(j);
                if (data instanceof Double) {
                    DataFormat format = wb.createDataFormat();
                    bodyStyle.setDataFormat(format.getFormat("#,##0.00"));
                    cell.setCellStyle(bodyStyle);
                    cell.setCellValue(Double.parseDouble(String.valueOf(data)));
                } else {
                    String textStr = Optional.ofNullable(rowList.get(j)).orElse("").toString();
                    XSSFRichTextString text = new XSSFRichTextString(textStr);
                    cell.setCellValue((RichTextString)text);
                }
                sheet.trackAllColumnsForAutoSizing();
            }
        }
        this.createThirdRow(headers, sheet, bodyStyle, exampleFlag);
    }

    private void createThirdRow(List<List<Object>> headers, SXSSFSheet sheet, CellStyle bodyStyle, boolean exampleFlag) {
        if (exampleFlag) {
            CellRangeAddress cellRangeAddress = new CellRangeAddress(2, 2, 0, headers.get(0).size() - 1);
            sheet.addMergedRegion(cellRangeAddress);
            int numMergedRegions = sheet.getNumMergedRegions();
            for (int i = 0; i < numMergedRegions; ++i) {
                CellRangeAddress mergedRegion = sheet.getMergedRegion(i);
                for (int rowIndex = mergedRegion.getFirstRow(); rowIndex <= mergedRegion.getLastRow(); ++rowIndex) {
                    SXSSFRow rowT = sheet.getRow(rowIndex);
                    if (rowT == null) {
                        rowT = sheet.createRow(rowIndex);
                    }
                    for (int colIndex = mergedRegion.getFirstColumn(); colIndex <= mergedRegion.getLastColumn(); ++colIndex) {
                        Cell currentCell = rowT.getCell(colIndex);
                        if (currentCell == null) {
                            currentCell = rowT.createCell(colIndex);
                            currentCell.setCellValue("\u591a\u9879\u9009\u62e9\u4ee5\u82f1\u6587\u9017\u53f7\u5206\u9694\uff1b\u65f6\u95f4\u7c7b\u7684\u6570\u636e\u8bf7\u4f7f\u7528\u6587\u672c\uff0c \u4f8b\uff1a 2023-01-01 12:00:00");
                        }
                        currentCell.setCellStyle(bodyStyle);
                    }
                }
            }
        }
    }

    private CellStyle setBodyStyle(SXSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)14);
        style.setFont(font);
        return style;
    }

    private CellStyle setHeaderStyle(SXSSFWorkbook wb) {
        byte[] fillRgb = new byte[]{-32, -22, -8};
        XSSFColor fillForegroundColor = new XSSFColor(fillRgb, null);
        byte[] borderRgb = new byte[]{-83, -86, -86};
        XSSFColor borderColor = new XSSFColor(borderRgb, null);
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(borderColor);
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(borderColor);
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(borderColor);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(borderColor);
        style.setFillForegroundColor(fillForegroundColor);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = wb.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)14);
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    @HussarDs(value="#dataSourceKey")
    public void selectDataAndExport(DataExportDTO dataExportDTO, String dataSourceKey) {
        String key;
        SysMultiLangMgt sysMultiLangMgt;
        JSONObject parse;
        Object object;
        String taskId = dataExportDTO.getTaskId();
        Long time1 = System.currentTimeMillis();
        logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u8fdb\u5165\u5bfc\u51fa\u65b9\u6cd5\uff0c\u4efb\u52a1id\uff1a{}", new Object[]{((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserName(), TimeFormatUtil.now(), taskId});
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(dataExportDTO.getFormId())));
        Long time2 = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "form\u67e5\u8be2\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time2 + "\u8017\u65f6" + (time2 - time1) + "\u6beb\u79d2\uff0c\u7ea6" + (time2 - time1) / 1000L + "\u79d2");
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        List<Widget> widgets = new ArrayList<Widget>();
        if (dataExportDTO.isContainDataId()) {
            Widget dataId = this.createDataIdWidget(form);
            dataId.setTitle(this.getSaticName(dataExportDTO.getLangCode(), PRIMARY_KEY_TITLE_NAME));
            widgets.add(dataId);
            widgets.addAll(dataExportDTO.getFields());
            widgets = this.addAllChildId(widgets);
        } else {
            widgets.addAll(dataExportDTO.getFields());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List filters = dataExportDTO.getFilter();
        if (HussarUtils.isNotEmpty((Object)dataExportDTO.getIdList())) {
            Filter idsFilter = new Filter();
            idsFilter.setField("RECORD_ID");
            idsFilter.setMatch("AND");
            idsFilter.setRule("_in");
            idsFilter.setVal(dataExportDTO.getIdList().stream().collect(Collectors.joining(",")));
            filters.add(idsFilter);
        }
        params.put(SUPER_QUERY_CONDITION_DTO, filters);
        AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
        ArrayList orderItems = Lists.newArrayListWithCapacity((int)1);
        this.addChildSort(orderItems, dataExportDTO);
        ArrayList sort = dataExportDTO.getSort();
        if (HussarUtils.isEmpty((Object)sort)) {
            sort = new ArrayList();
        }
        sort.addAll(orderItems);
        dataExportDTO.setSort(sort);
        params.put(ORDERS, dataExportDTO.getSort());
        Long time3 = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u4e1a\u52a1\u6570\u636e\u67e5\u8be2\u524d\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time3 + "\u8017\u65f6" + (time3 - time2) + "\u6beb\u79d2\uff0c\u7ea6" + (time3 - time2) / 1000L + "\u79d2");
        List<Object> allData = new ArrayList<EngineResultEntity>();
        Long time4 = System.currentTimeMillis();
        logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u5f00\u59cb\u6267\u884c\u5206\u6279\u67e5\u8be2,\u6bcf500\u6761\u6570\u636e\u6267\u884c\u4e00\u6b21\u67e5\u5e93\u64cd\u4f5c", (Object)((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserName(), (Object)TimeFormatUtil.now());
        int i = 1;
        while (true) {
            params.put(CURRENT, i);
            params.put("size", 500);
            ResponseEntity response = this.hussarAppFormService.tableQuery(dataExportDTO.getFormId(), dataExportDTO.getViewId(), params, dataExportDTO.getAppId());
            ApiResponse body = (ApiResponse)response.getBody();
            PageVo pageVo = null;
            if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
                pageVo = (PageVo)body.getData();
            }
            time4 = System.currentTimeMillis();
            logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u4e1a\u52a1\u6570\u636e\u7b2c" + i + "\u6b21\u67e5\u8be2\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time4 + "\u603b\u8017\u65f6" + (time4 - time3) + "\u6beb\u79d2\uff0c\u7ea6" + (time4 - time3) / 1000L + "\u79d2");
            if (HussarUtils.isEmpty((Object)((ApiResponse)response.getBody()).getData())) {
                logger.info("\u7b2c" + i + "\u6b21\u67e5\u8be2\u65f6\uff0c\u6570\u636e\u91cf\u4e3a0\uff0c\u67e5\u8be2\u7ed3\u675f");
                break;
            }
            ArrayList oneData = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)pageVo) && HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                oneData = (ArrayList)pageVo.getData();
            }
            allData.addAll(oneData);
            if (oneData.size() < 500) {
                logger.info("\u7b2c{}\u6b21\u67e5\u8be2\u65f6\uff0c\u6570\u636e\u91cf\u5c0f\u4e8e{}\uff0c\u67e5\u8be2\u7ed3\u675f", (Object)i, (Object)500);
                logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u7ed3\u675f\u67e5\u5e93\u64cd\u4f5c\uff0c\u603b\u6570\u636e\u91cf\uff1a {}", new Object[]{((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserName(), TimeFormatUtil.now(), allData.size()});
                break;
            }
            ++i;
        }
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(dataExportDTO.getFormId())).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        List originWidgets = canvasSchema.widgets();
        List childrenWidgets = canvasSchema.childTables();
        this.userAndOrgHandle.userAndOrgChanged(allData, UserAndOrgHandle.castList(CollectionUtils.union((Iterable)originWidgets, (Iterable)childrenWidgets), Widget.class));
        if ("1".equals(form.getFormType())) {
            allData = allData.stream().filter(engineResultEntity -> HussarUtils.isNotEmpty((Object)engineResultEntity.get((Object)"PROCESS_KEY"))).collect(Collectors.toList());
        }
        List<List<ExcelImportCellVo>> headers = this.packageHeaders2(widgets, CollectionUtils.union((Iterable)canvasSchema.widgetsWithSys(), (Iterable)childrenWidgets).stream().collect(Collectors.toList()), null, dataExportDTO.getLangCode());
        ArrayList<List<Object>> headerObjects = new ArrayList<List<Object>>();
        ArrayList<List<Object>> headerTypes = new ArrayList<List<Object>>();
        ArrayList<List<Object>> busiData = new ArrayList();
        int currentRowNum = headers.size();
        ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
        HashMap<String, List<String>> relatedData = new HashMap<String, List<String>>();
        for (List<ExcelImportCellVo> row : headers) {
            ArrayList<String> headerObjectsRow = new ArrayList<String>();
            ArrayList<String> headerTypesRow = new ArrayList<String>();
            for (ExcelImportCellVo excelImportCellVo : row) {
                if (excelImportCellVo.getRowspan() != 1 || excelImportCellVo.getColspan() != 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(excelImportCellVo.getRow(), excelImportCellVo.getRow() + excelImportCellVo.getRowspan() - 1, excelImportCellVo.getCol(), excelImportCellVo.getCol() + excelImportCellVo.getColspan() - 1);
                    ranges.add(cellRangeAddress);
                }
                headerObjectsRow.add(excelImportCellVo.getValue());
                boolean hasValue = false;
                for (Widget widget : widgets) {
                    if (!ToolUtil.isNotEmpty((Object)excelImportCellVo.getFieldName()) || !ToolUtil.isNotEmpty((Object)excelImportCellVo.getFieldType()) || !excelImportCellVo.getFieldName().equals(HussarUtils.isEmpty((Object)widget.getParentKey()) ? widget.getName() : String.format(CACHE_TEMPLATE, widget.getParentKey(), widget.getName()))) continue;
                    String value = "";
                    headerTypesRow.add(excelImportCellVo.getFieldType() + this.dealComponent(value, excelImportCellVo.getFieldType(), widget, relatedData, allData));
                    hasValue = true;
                    break;
                }
                if (!hasValue) {
                    headerTypesRow.add(null);
                }
                if (excelImportCellVo.getColspan() == 1) continue;
                for (int i2 = 1; i2 < excelImportCellVo.getColspan(); ++i2) {
                    headerObjectsRow.add(null);
                    headerTypesRow.add(null);
                }
            }
            headerObjects.add(headerObjectsRow);
            headerTypes.add(headerTypesRow);
        }
        Map<String, Integer> field2Count = Flux.fromIterable((Iterable)headers.get(headers.size() - 1)).groupBy(ExcelImportCellVo::getFieldName).flatMap(g -> g.reduce((Object)0, (a, b) -> a + 1).map(e -> Tuples.of((Object)g.key(), (Object)e))).collectList().blockOptional().orElse(Collections.emptyList()).stream().collect(Collectors.toMap(e -> (String)e.getT1(), e -> (Integer)e.getT2()));
        Tuple2<List<List<Object>>, List<CellRangeAddress>> sheetData = this.transSheetData(allData, widgets, (List<Widget>)canvasSchema.getWidgets(), headers.size(), field2Count);
        busiData = (List)sheetData.getT1();
        ranges.addAll((Collection)sheetData.getT2());
        Long time5 = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u4e1a\u52a1\u6570\u636e\u5904\u7406\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time5 + "\u8017\u65f6" + (time5 - time4) + "\u6beb\u79d2\uff0c\u7ea6" + (time5 - time4) / 1000L + "\u79d2");
        String tempFileName = this.hussarFormDesignFrameProperties.getWorkspace() + File.separator + "export";
        File file1 = new File(tempFileName);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        tempFileName = tempFileName + File.separator + taskId + ".xlsx";
        String i18nKeys = form.getI18nKeys();
        String excelName = "";
        if (HussarUtils.isNotEmpty((Object)i18nKeys) && HussarUtils.isNotEmpty((Object)(object = (parse = (JSONObject)JSON.parse((String)i18nKeys)).get((Object)"formName"))) && HussarUtils.isNotEmpty((Object)(sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(key = object.toString(), dataExportDTO.getLangCode())))) {
            excelName = sysMultiLangMgt.getLangText();
        }
        if (HussarUtils.isEmpty((Object)excelName)) {
            excelName = form.getFormName();
        }
        excelName = excelName + this.getSaticName(dataExportDTO.getLangCode(), FORM_DATA_EXPORT);
        Long fileId = 0L;
        try {
            SysAppWatermarkDto sysAppWatermark = this.sysAppWatermarkService.getAppWatermark((Object)form.getAppId());
            Boolean watermark = sysAppWatermark.isDataWatermark();
            fileOutputStream = new FileOutputStream(tempFileName);
            fileInputStream = new FileInputStream(new File(tempFileName));
            this.exportToExcel(this.getSaticName(dataExportDTO.getLangCode(), FORM_DATA_EXPORT), headerObjects, headerTypes, busiData, null, fileOutputStream, ranges, watermark, relatedData);
            MockMultipartFile multipartFile = new MockMultipartFile(excelName + ".xlsx", excelName + ".xlsx", ".xlsx", (InputStream)fileInputStream);
            fileId = (Long)this.ossService.backgroundUpload((MultipartFile)multipartFile).getData();
        }
        catch (IOException e2) {
            logger.error(e2.getMessage());
            throw new BaseException((Throwable)e2);
        }
        finally {
            if (HussarUtils.isNotEmpty(fileInputStream)) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e3) {
                    logger.error(e3.getMessage());
                }
            }
            if (HussarUtils.isNotEmpty(fileOutputStream)) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e4) {
                    logger.error(e4.getMessage());
                }
            }
        }
        Long time6 = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u5bfc\u51fa\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time6 + "\u8017\u65f6" + (time6 - time5) + "\u6beb\u79d2\uff0c\u7ea6" + (time6 - time5) / 1000L + "\u79d2");
        SysExcelTaskNoCode task = new SysExcelTaskNoCode();
        task.setId(Long.valueOf(taskId));
        task.setTaskStatus(Integer.valueOf(6));
        task.setTaskFile(fileId);
        task.setExcelName(excelName + ".xlsx");
        HussarNoCodeThreadUtil.executeUserTask(() -> this.exelTaskUtil.updateExelTask(task, dataSourceKey));
        Long time7 = System.currentTimeMillis();
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u4efb\u52a1\u72b6\u6001\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time7 + "\u8017\u65f6" + (time7 - time6) + "\u6beb\u79d2\uff0c\u7ea6" + (time7 - time6) / 1000L + "\u79d2");
        logger.info("\u5bfc\u51fa\u4efb\u52a1\uff1a" + taskId + "\u6587\u4ef6\u5bfc\u51fa\u5f02\u6b65\u65b9\u6cd5\u5b8c\u6bd5\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + time7 + "\u603b\u4f53\u8017\u65f6" + (time7 - time1) + "\u6beb\u79d2\uff0c\u7ea6" + (time7 - time1) / 1000L + "\u79d2");
        logger.info("\u7528\u6237 \u3010{}\u3011 \u4e8e \u3010{}\u3011 \u7ed3\u675f\u5168\u90e8\u5bfc\u51fa\u64cd\u4f5c", (Object)((SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser")).getUserName(), (Object)TimeFormatUtil.now());
    }

    public String dealComponent(String value, String fieldType, Widget widget, Map<String, List<String>> relatedData, List<EngineResultEntity> allData) {
        switch (fieldType) {
            case "JXDNDate": {
                value = "&&&" + widget.getProps().getString("format");
                break;
            }
            case "JXDNNumber": {
                value = "&&&" + widget.getProps().getString("decimalNum") + "&&&" + widget.getProps().getString("showType");
                break;
            }
            case "JXDNRadioGroup": 
            case "JXDNSelect": {
                String selectName = widget.getName();
                String optionType = widget.getProps().get((Object)"optionType").toString();
                ArrayList<String> selectOptions = new ArrayList<String>();
                if (HussarUtils.equals((Object)optionType, (Object)"dict")) {
                    JSONObject dictParams = JSON.parseObject((String)JSON.toJSONString((Object)widget.getProps().get((Object)"dict")));
                    String dictId = dictParams.get((Object)"dictId").toString();
                    List levelDictByType = this.sysDicRefService.getLevelDictByType(Long.valueOf(dictId));
                    for (DicLevelTreeVo dicLevelTreeVo : levelDictByType) {
                        selectOptions.add(dicLevelTreeVo.getLabel());
                    }
                    this.addOpenOtherValue(fieldType, widget, allData, selectOptions);
                } else if (HussarUtils.equals((Object)optionType, (Object)"async")) {
                    String viewId;
                    Map asyncMap = (Map)widget.getProps().get((Object)"async");
                    String formId = asyncMap.get(FORM_ID).toString();
                    String appId = asyncMap.get(APP_ID).toString();
                    String fieldName = asyncMap.get("fieldName").toString();
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                    params.put(SUPER_QUERY_CONDITION_DTO, new ArrayList());
                    params.put(ORDERS, new ArrayList());
                    params.put(CURRENT, Integer.valueOf(1));
                    params.put("size", Integer.valueOf(20));
                    SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
                    AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysForm), (String)FORM_MISS);
                    switch (sysForm.getFormType()) {
                        case "0": {
                            viewId = ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId();
                            break;
                        }
                        case "1": {
                            viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
                            break;
                        }
                        default: {
                            throw new HussarException(NO_SUPPORT_QUERY);
                        }
                    }
                    ResponseEntity response = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
                    ApiResponse body = (ApiResponse)response.getBody();
                    PageVo pageVo = null;
                    if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
                        pageVo = (PageVo)body.getData();
                    }
                    List datas = new ArrayList();
                    if (HussarUtils.isNotEmpty(pageVo) && HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                        datas = pageVo.getData();
                    }
                    for (EngineResultEntity data : datas) {
                        selectOptions.add((String)data.get((Object)fieldName));
                    }
                } else if (HussarUtils.equals((Object)optionType, (Object)"static")) {
                    List options = (List)widget.getProps().get((Object)"options");
                    for (Map option : options) {
                        selectOptions.add(option.get("value").toString());
                    }
                    this.addOpenOtherValue(fieldType, widget, allData, selectOptions);
                } else if (HussarUtils.equals((Object)optionType, (Object)"dataLinkage")) {
                    String viewId;
                    Map dataLinkageMap = (Map)widget.getProps().get((Object)"dataLinkage");
                    Map filter = (Map)dataLinkageMap.get("filter");
                    Map data = (Map)dataLinkageMap.get("data");
                    String formId = data.get(FORM_ID).toString();
                    String appId = data.get(APP_ID).toString();
                    String fieldName = data.get("fieldName").toString();
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                    params.put(SUPER_QUERY_CONDITION_DTO, new ArrayList());
                    params.put(ORDERS, new ArrayList());
                    params.put(CURRENT, Integer.valueOf(1));
                    params.put("size", Integer.valueOf(20));
                    SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
                    FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(formId);
                    FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
                    boolean dictFlag = this.dictFlag(canvas, fieldName);
                    AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysForm), (String)FORM_MISS);
                    switch (sysForm.getFormType()) {
                        case "0": {
                            viewId = ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId();
                            break;
                        }
                        case "1": {
                            viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
                            break;
                        }
                        default: {
                            throw new HussarException(NO_SUPPORT_QUERY);
                        }
                    }
                    ResponseEntity response = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
                    ApiResponse body = (ApiResponse)response.getBody();
                    PageVo pageVo = null;
                    if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
                        pageVo = (PageVo)body.getData();
                    }
                    List datas = new ArrayList();
                    if (HussarUtils.isNotEmpty(pageVo) && HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                        datas = pageVo.getData();
                    }
                    for (EngineResultEntity entity : datas) {
                        if (!HussarUtils.isNotEmpty((Object)entity.get((Object)fieldName))) continue;
                        if (dictFlag) {
                            selectOptions.add((String)entity.get((Object)(fieldName + LABEL)));
                            continue;
                        }
                        selectOptions.add((String)entity.get((Object)fieldName));
                    }
                }
                relatedData.put(selectName, selectOptions);
                value = "&&&" + widget.getName();
                break;
            }
            case "JXDNLinkForm": {
                Map linkTableInfo = (Map)widget.getProps().get((Object)"linkTableInfo");
                String name = widget.getName();
                String appType = linkTableInfo.get(ASYNC_TYPE).toString();
                ArrayList<String> options = new ArrayList<String>();
                if (!HussarUtils.equals((Object)EXTERNAL_API, (Object)appType)) {
                    String viewId;
                    String formId = linkTableInfo.get(FORM_ID).toString();
                    String appId = linkTableInfo.get(APP_ID).toString();
                    Map fieldinfoMap = (Map)linkTableInfo.get("linkFieldInfo");
                    String fieldName = (String)fieldinfoMap.get("name");
                    String type = (String)fieldinfoMap.get("type");
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                    params.put(SUPER_QUERY_CONDITION_DTO, new ArrayList());
                    params.put(ORDERS, new ArrayList());
                    params.put(CURRENT, Integer.valueOf(1));
                    params.put("size", Integer.valueOf(20));
                    SysForm sysForm = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
                    AssertUtil.isTrue((boolean)HussarUtils.isNotEmpty((Object)sysForm), (String)FORM_MISS);
                    switch (sysForm.getFormType()) {
                        case "0": {
                            viewId = ViewIdEnum.SYS_ORDINARY_ALL_DATA.getId();
                            break;
                        }
                        case "1": {
                            viewId = ViewIdEnum.SYS_FLOW_ALL_DATA.getId();
                            break;
                        }
                        default: {
                            throw new HussarException(NO_SUPPORT_QUERY);
                        }
                    }
                    String response = this.hussarAppFormService.tableQuery(formId, viewId, params, appId);
                    ApiResponse body = (ApiResponse)response.getBody();
                    PageVo pageVo = null;
                    if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
                        pageVo = (PageVo)body.getData();
                    }
                    List datas = new ArrayList();
                    if (HussarUtils.isNotEmpty(pageVo) && HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                        datas = pageVo.getData();
                    }
                    for (EngineResultEntity data : datas) {
                        if (!HussarUtils.isNotEmpty((Object)data.get((Object)fieldName))) continue;
                        if (HussarUtils.isNotEmpty((Object)type) && (type.equals(WidgetType.SELECT.getType()) || type.equals(WidgetType.SELECT_MUL.getType()) || type.equals(WidgetType.RADIO_GROUP.getType()) || type.equals(WidgetType.CHECK_BOX_GROUP.getType()))) {
                            options.add((String)data.get((Object)(fieldName + LABEL)));
                            continue;
                        }
                        options.add((String)data.get((Object)fieldName));
                    }
                }
                relatedData.put(name, options);
                value = "&&&" + widget.getName();
                break;
            }
        }
        return value;
    }

    private void addChildSort(List<OrderItem> orderItems, DataExportDTO dataExportDTO) {
        try {
            FormDesignResponse formDesignResponse = this.canvasSchemaService.get(dataExportDTO.getFormId());
            FormCanvasSchema formCanvasSchema = null;
            if (HussarUtils.isNotEmpty((Object)formDesignResponse) && HussarUtils.isNotEmpty((Object)formDesignResponse.getData())) {
                formCanvasSchema = (FormCanvasSchema)formDesignResponse.getData();
                List childTables = formCanvasSchema.childTables();
                List widgetList = WidgetTool.flatAllTableWidget((List)childTables);
                this.dealChildTableFieldSorted(widgetList, orderItems);
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5b50\u8868\u6392\u5e8f\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            logger.error("\u6dfb\u52a0\u5b50\u8868\u6392\u5e8f\u5b57\u6bb5\u5931\u8d25,\u8868\u5355id:{}", (Object)dataExportDTO.getFormId());
        }
    }

    public void dealChildTableFieldSorted(List<Widget> widgets, List<OrderItem> orders) {
        for (Widget widget : widgets) {
            String orderType = String.valueOf(widget.getProps().get((Object)FormQuerySortEnum.ORDER_TYPE.getValue()));
            if (HussarUtils.equals((Object)orderType, (Object)FormQuerySortEnum.FIELD_SORT.getValue()) || HussarUtils.isEmpty((Object)orderType)) {
                Object childrenOrders = widget.getProps().get((Object)FormQuerySortEnum.ORDER_BY.getValue());
                List childOrders = JSON.parseArray((String)JSON.toJSONString((Object)childrenOrders), OrderItem.class);
                if (HussarUtils.isEmpty((Object)childOrders)) {
                    OrderItem orderItem = new OrderItem();
                    orderItem.setColumn(widget.getName() + "." + FormQuerySortEnum.CREATE_TIME_DATE.getValue());
                    orders.add(orderItem);
                    continue;
                }
                for (OrderItem order : childOrders) {
                    order.setColumn(widget.getName() + "." + order.getColumn());
                }
                orders.addAll(childOrders);
                continue;
            }
            OrderItem orderItem = new OrderItem();
            orderItem.setColumn(widget.getName() + "." + FormQuerySortEnum.SEQ.getValue());
            orders.add(orderItem);
        }
    }

    public boolean dictFlag(FormCanvasSchema canvas, String fieldName) {
        List widgets = canvas.widgetsWithChildren();
        Map widgetMap = widgets.stream().collect(Collectors.toMap(Widget::getName, Function.identity()));
        Widget linkFormWidget = (Widget)widgetMap.get(fieldName);
        if (HussarUtils.isEmpty((Object)linkFormWidget)) {
            logger.warn("\u8868\u5355\u753b\u5e03{} \u672a\u627e\u5230\u5bf9\u5e94\u7ec4\u4ef6 {}", (Object)canvas.getId(), (Object)fieldName);
            return false;
        }
        Object optionType = linkFormWidget.getProps().get((Object)"optionType");
        return HussarUtils.isNotEmpty((Object)optionType) && HussarUtils.equals((Object)optionType.toString(), (Object)"dict");
    }

    private void addOpenOtherValue(String fieldType, Widget widget, List<EngineResultEntity> allData, List<String> selectOptions) {
        HashSet selectOptionsSet = Sets.newHashSetWithExpectedSize((int)5);
        if ((fieldType.equals(WidgetType.SELECT.getType()) || fieldType.equals(WidgetType.RADIO_GROUP.getType())) && widget.getProps().containsKey((Object)"openOther") && widget.getProps().getBoolean("openOther").booleanValue()) {
            for (EngineResultEntity entity : allData) {
                if (!HussarUtils.isNotEmpty((Object)entity.get((Object)(widget.getName() + LABEL)))) continue;
                selectOptionsSet.add((String)entity.get((Object)(widget.getName() + LABEL)));
            }
            selectOptions.addAll(selectOptionsSet);
        }
    }

    public List<Widget> addAllChildId(List<Widget> widgetList) {
        ArrayList<String> pkeys = new ArrayList<String>();
        String pkey = null;
        ArrayList<Widget> result = new ArrayList<Widget>();
        for (int i = 0; i < widgetList.size(); ++i) {
            Widget widget = widgetList.get(i);
            String parentKey = widget.getParentKey();
            if (HussarUtils.isNotEmpty((Object)parentKey) && parentKey != pkey && !pkeys.contains(pkey = parentKey)) {
                pkeys.add(pkey);
                Widget idw = WidgetTool.genIdWidget((String)parentKey);
                result.add(idw);
            }
            result.add(widget);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object dealFieldValue(EngineResultEntity engineResultEntity, Widget widget) {
        if (WidgetType.RADIO_GROUP.getType().equals(widget.getType())) {
            Object label = engineResultEntity.get((Object)(widget.getName() + LABEL));
            if (HussarUtils.isNotEmpty((Object)label)) {
                return label;
            }
            List options = (List)widget.getProps().get((Object)"options");
            HashMap<String, String> optionMap = new HashMap<String, String>();
            Iterator iterator = options.iterator();
            while (iterator.hasNext()) {
                Map option = (Map)iterator.next();
                optionMap.put(option.get("value").toString(), option.get("label").toString());
            }
            return optionMap.get(engineResultEntity.get((Object)widget.getName()));
        }
        if (WidgetType.SELECT.getType().equals(widget.getType())) {
            return engineResultEntity.get((Object)(widget.getName() + LABEL));
        }
        if (WidgetType.CHECK_BOX_GROUP.getType().equals(widget.getType())) {
            Object value = engineResultEntity.get((Object)(widget.getName() + LABEL));
            return value == null ? value : value.toString().replace("[", "").replace("]", "").replace("\"", "");
        }
        if (WidgetType.SELECT_MUL.getType().equals(widget.getType())) {
            Object value = engineResultEntity.get((Object)(widget.getName() + LABEL));
            return value == null ? value : value.toString().replace("[", "").replace("]", "").replace("\"", "");
        }
        if (WidgetType.JXDN_CASCADER.getType().equals(widget.getType())) {
            String value = (String)engineResultEntity.get((Object)(widget.getName() + LABEL));
            JSONObject jsonObject2 = JSON.parseObject((String)value);
            Boolean showAllLevels = widget.getProps().getBoolean("showAllLevels");
            if (jsonObject2 == null) {
                return null;
            }
            String string = this.parseLabel(jsonObject2, showAllLevels);
            return string;
        }
        if (WidgetType.JXDN_CASCADER_MULTI.getType().equals(widget.getType())) {
            String value = (String)engineResultEntity.get((Object)(widget.getName() + LABEL));
            JSONArray jsonArray = JSON.parseArray((String)value);
            ArrayList list = Lists.newArrayListWithCapacity((int)10);
            if (!HussarUtils.isNotEmpty((Object)jsonArray)) return HussarUtils.join((Collection)list, (String)",");
            Boolean showAllLevels = widget.getProps().getBoolean("showAllLevels");
            jsonArray.stream().forEach(jsonObject -> {
                String label = this.parseLabel((JSONObject)jsonObject, showAllLevels);
                if (HussarUtils.isNotEmpty((Object)label)) {
                    list.add(label);
                }
            });
            return HussarUtils.join((Collection)list, (String)",");
        }
        if (WidgetType.JXDNUser.getType().equals(widget.getType())) {
            return engineResultEntity.get((Object)(widget.getName() + LABEL));
        }
        if (WidgetType.JXDNUserMulti.getType().equals(widget.getType())) {
            return engineResultEntity.get((Object)(widget.getName() + LABEL));
        }
        if (WidgetType.JXDNOrg.getType().equals(widget.getType())) {
            return engineResultEntity.get((Object)(widget.getName() + LABEL));
        }
        if (WidgetType.JXDNOrgMulti.getType().equals(widget.getType())) {
            return engineResultEntity.get((Object)(widget.getName() + LABEL));
        }
        if (WidgetType.ADDRESS.getType().equals(widget.getType())) {
            Object detailed = engineResultEntity.get((Object)(widget.getName() + "_detailed"));
            if (detailed == null) return engineResultEntity.get((Object)(widget.getName() + LABEL));
            if ("".equals(detailed)) return engineResultEntity.get((Object)(widget.getName() + LABEL));
            return engineResultEntity.get((Object)(widget.getName() + LABEL)) + " / " + detailed;
        }
        if (WidgetType.JXDNSwitch.getType().equals(widget.getType())) {
            try {
                return ((ArrayList)widget.getProps().get((Object)"textEntry")).get(Integer.parseInt(engineResultEntity.get((Object)widget.getName()).toString()));
            }
            catch (Exception e) {
                return "";
            }
        }
        if (WidgetType.DATE.getType().equals(widget.getType())) {
            try {
                String format = widget.getProps().get((Object)"format").toString();
                return DateTimeFormatter.ofPattern(format).format((LocalDateTime)engineResultEntity.get((Object)widget.getName()));
            }
            catch (Exception e) {
                return engineResultEntity.get((Object)widget.getName());
            }
        }
        if (!WidgetType.NUMBER.getType().equals(widget.getType())) {
            if (!WidgetType.JXDNAggregate.getType().equals(widget.getType())) return engineResultEntity.get((Object)widget.getName());
        }
        try {
            Object dataFromDb = engineResultEntity.get((Object)widget.getName());
            if (HussarUtils.isEmpty((Object)dataFromDb)) {
                return dataFromDb;
            }
            int decimalNum = Integer.parseInt(widget.getProps().get((Object)"decimalNum").toString());
            if ("percent".equals(widget.getProps().get((Object)"showType").toString())) {
                decimalNum += 2;
            }
            StringBuilder format = new StringBuilder("#");
            if (decimalNum > 0) {
                format.append(".");
            }
            for (int i = 0; i < decimalNum; ++i) {
                format.append("0");
            }
            DecimalFormat decimalFormat = new DecimalFormat(format.toString());
            String value = decimalFormat.format(dataFromDb);
            if (!value.startsWith(".")) return value;
            return "0" + value;
        }
        catch (Exception e) {
            try {
                return engineResultEntity.get((Object)widget.getName());
            }
            catch (Exception e2) {
                logger.error("\u5904\u7406\u5b57\u6bb5\u8fd4\u56de\u663e\u793a\u9519\u8bef", (Throwable)e2);
                return engineResultEntity.get((Object)widget.getName());
            }
        }
    }

    public List<List<ExcelImportCellVo>> packageHeaders(List<Widget> widgets, List<String> allowFeildTypes, String appId, String langCode, String viewId, String formId) {
        Tuple2 tmp;
        DataView viewById = new DataView();
        long startTime = System.currentTimeMillis();
        try {
            FormViewVo formViewVo = this.hussarAppFormService.getViewByUser(formId, appId);
            FormViewSchemaVo formView = formViewVo.getFormView();
            List views = formView.getViews();
            if (HussarUtils.isNotEmpty((Object)views)) {
                for (DataView view : views) {
                    if (!view.getId().equals(viewId)) continue;
                    viewById = view;
                }
            }
        }
        catch (Exception e2) {
            logger.error("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25", (Throwable)e2);
        }
        long time1 = System.currentTimeMillis();
        logger.info("\u89c6\u56fe\u67e5\u8be2\u8017\u65f6\uff1a{}", (Object)(time1 - startTime));
        int maxLvl = 0;
        LinkedList buff = new LinkedList();
        buff.addAll(widgets.stream().map(e -> Tuples.of((Object)1, (Object)e)).collect(Collectors.toList()));
        Tuple2 tuple2 = tmp = buff.isEmpty() ? null : (Tuple2)buff.pollLast();
        while (tmp != null) {
            List cs;
            if ((Integer)tmp.getT1() > maxLvl) {
                maxLvl = (Integer)tmp.getT1();
            }
            if (CollUtil.isNotEmpty((Collection)(cs = ((Widget)tmp.getT2()).getChildren()))) {
                int lvl = (Integer)tmp.getT1();
                buff.addAll(cs.stream().map(e -> Tuples.of((Object)(lvl + 1), (Object)e)).collect(Collectors.toList()));
            }
            if (buff.isEmpty()) {
                tmp = null;
                continue;
            }
            tmp = (Tuple2)buff.pollLast();
        }
        ArrayList<List<ExcelImportCellVo>> headers = new ArrayList<List<ExcelImportCellVo>>();
        for (int i = 0; i < maxLvl; ++i) {
            headers.add(new ArrayList());
        }
        int nowCol = 0;
        for (Widget widget : widgets) {
            nowCol = this.genWidgetHeader(headers, maxLvl, nowCol, 0, widget, allowFeildTypes, langCode, viewById);
        }
        return headers;
    }

    public List<List<ExcelImportCellVo>> packageHeaders2(List<Widget> widgets, List<Widget> mainWidgets, List<String> allowFeildTypes, String langCode) {
        Widget widget;
        Tuple2 tmp;
        widgets = this.excelImport.dealWidgets(widgets, langCode);
        mainWidgets = this.excelImport.dealWidgets(mainWidgets, langCode);
        int maxLvl = 0;
        HashMap<String, String> pmap = new HashMap<String, String>();
        LinkedList buff = new LinkedList();
        buff.addAll(widgets.stream().map(e -> Tuples.of((Object)1, (Object)e)).collect(Collectors.toList()));
        Tuple2 tuple2 = tmp = buff.isEmpty() ? null : (Tuple2)buff.pollLast();
        while (tmp != null) {
            int finalLvl;
            Optional<Widget> childWidget;
            int lvl = 1;
            Widget p = (Widget)tmp.getT2();
            if (HussarUtils.isNotEmpty((Object)p.getParentKey()) && (childWidget = WidgetTool.flatAllWidget(mainWidgets).stream().filter(e -> HussarUtils.equals((Object)e.getName(), (Object)p.getParentKey()) && (HussarUtils.equals((Object)e.getType(), (Object)WidgetType.CHILDREN_TABLE.getType()) || HussarUtils.equals((Object)e.getType(), (Object)WidgetType.JXDNChildrenTableAgg.getType()))).findFirst()).isPresent()) {
                lvl = 2;
                pmap.put(p.getName(), p.getParentKey());
                widget = childWidget.get();
                if (widget.getIsInChild()) {
                    lvl = 3;
                    pmap.put(p.getParentKey(), widget.getParentKey());
                }
            }
            if ((finalLvl = lvl) > maxLvl) {
                maxLvl = finalLvl;
            }
            if (buff.isEmpty()) {
                tmp = null;
                continue;
            }
            tmp = (Tuple2)buff.pollLast();
        }
        HashMap<String, Integer> childFiledNum = new HashMap<String, Integer>();
        for (Widget widget2 : widgets) {
            if (!widget2.getIsInChild()) continue;
            Integer num = (Integer)childFiledNum.get(widget2.getParentKey());
            if (num == null) {
                num = 0;
            }
            childFiledNum.put(widget2.getParentKey(), num + 1);
        }
        ListIterator<Widget> it = widgets.listIterator(widgets.size());
        ArrayList<String> ts = new ArrayList<String>();
        while (it.hasPrevious()) {
            widget = it.previous();
            String parentKey = widget.getParentKey();
            if (HussarUtils.isEmpty((Object)parentKey) || ts.contains(parentKey)) continue;
            ts.add(parentKey);
            String p = (String)pmap.get(parentKey);
            if (p == null) continue;
            if (!childFiledNum.containsKey(p)) {
                childFiledNum.put(p, (Integer)childFiledNum.get(parentKey));
                continue;
            }
            childFiledNum.put(p, (Integer)childFiledNum.get(p) + (Integer)childFiledNum.get(parentKey));
        }
        ArrayList<List<ExcelImportCellVo>> headers = new ArrayList<List<ExcelImportCellVo>>();
        HashMap<Integer, Integer> curRowCol = new HashMap<Integer, Integer>();
        for (int i = 0; i < maxLvl; ++i) {
            headers.add(new ArrayList());
            curRowCol.put(i, 0);
        }
        ArrayList<String> addeds = new ArrayList<String>();
        for (Widget widget3 : widgets) {
            if (allowFeildTypes != null && !allowFeildTypes.contains(widget3.getType())) continue;
            String parentKey = widget3.getParentKey();
            ArrayList<String> path = new ArrayList<String>();
            ArrayList<String> parents = new ArrayList<String>();
            path.add(widget3.getName());
            parents.add(widget3.getParentKey());
            while (childFiledNum.containsKey(parentKey)) {
                path.add(0, parentKey);
                parentKey = (String)pmap.get(parentKey);
                parents.add(0, parentKey);
            }
            for (int nowRow = 0; nowRow < path.size(); ++nowRow) {
                String name = (String)path.get(nowRow);
                boolean isChildTable = childFiledNum.containsKey(name);
                if (isChildTable) {
                    if (addeds.contains(name)) continue;
                    addeds.add(name);
                }
                Integer startCol = (Integer)curRowCol.get(nowRow);
                ExcelImportCellVo excelImportCellVo1 = new ExcelImportCellVo();
                String sign = (String)path.get(nowRow);
                String parentId = HussarUtils.isNull(parents.get(nowRow)) ? "" : (String)parents.get(nowRow);
                Optional<Widget> nowWidgets = WidgetTool.flatAllWidget(mainWidgets).stream().peek(e -> {
                    if (HussarUtils.isNull((Object)e.getParentKey())) {
                        e.setParentKey("");
                    }
                }).filter(e -> HussarUtils.equals((Object)e.getName(), (Object)sign) && HussarUtils.equals((Object)e.getParentKey(), (Object)parentId)).findFirst();
                if (nowWidgets.isPresent()) {
                    Widget nowWidget = nowWidgets.get();
                    excelImportCellVo1.setValue(nowWidget.getTitle());
                } else if (HussarUtils.equals((Object)sign, (Object)"RECORD_ID")) {
                    excelImportCellVo1.setValue(PRIMARY_KEY_TITLE_NAME);
                }
                excelImportCellVo1.setRow(nowRow);
                excelImportCellVo1.setCol(startCol.intValue());
                excelImportCellVo1.setRowspan(isChildTable ? 1 : maxLvl - nowRow);
                excelImportCellVo1.setColspan(isChildTable ? (Integer)childFiledNum.get(name) : 1);
                String fieldName = HussarUtils.isEmpty((Object)widget3.getOldName()) ? widget3.getName() : widget3.getOldName();
                excelImportCellVo1.setFieldName(HussarUtils.isEmpty((Object)widget3.getParentKey()) ? fieldName : String.format(CACHE_TEMPLATE, widget3.getParentKey(), fieldName));
                excelImportCellVo1.setFieldType(widget3.getType());
                ((List)headers.get(nowRow)).add(excelImportCellVo1);
                curRowCol.put(nowRow, (Integer)curRowCol.get(nowRow) + excelImportCellVo1.getColspan());
                if (isChildTable) continue;
                for (int i = nowRow + 1; i < maxLvl; ++i) {
                    ExcelImportCellVo vo = new ExcelImportCellVo();
                    vo.setValue(null);
                    vo.setRow(i);
                    vo.setCol(startCol.intValue());
                    vo.setRowspan(1);
                    vo.setColspan(1);
                    vo.setFieldName(HussarUtils.isEmpty((Object)widget3.getParentKey()) ? fieldName : String.format(CACHE_TEMPLATE, widget3.getParentKey(), fieldName));
                    ((List)headers.get(i)).add(vo);
                    curRowCol.put(i, (Integer)curRowCol.get(i) + 1);
                }
            }
        }
        return headers;
    }

    private int genWidgetHeader(List<List<ExcelImportCellVo>> headers, int maxLvl, int nowColP, int nowRow, Widget widget, List<String> allowFeildTypes, String langCode, DataView viewById) {
        int startCol = nowColP;
        int nowCol = nowColP;
        boolean isChildTable = WidgetTool.isChildTableType((Widget)widget);
        if (isChildTable) {
            List cs = WidgetTool.flatButNotChildrenWithSecurityLevel(new ArrayList(), (List)widget.getChildren(), (boolean)this.formSecurityLevelService.checkChildSecurityLevel(widget)).stream().filter(e -> allowFeildTypes == null || allowFeildTypes.contains(e.getType())).collect(Collectors.toList());
            for (Widget c : cs) {
                nowCol = this.genWidgetHeader(headers, maxLvl, nowCol, nowRow + 1, c, allowFeildTypes, langCode, viewById);
            }
            cs = WidgetTool.flatButChildren(new ArrayList(), (List)widget.getChildren());
            for (Widget c : cs) {
                nowCol = this.genWidgetHeader(headers, maxLvl, nowCol, nowRow + 1, c, allowFeildTypes, langCode, viewById);
            }
        }
        ExcelImportCellVo excelImportCellVo1 = new ExcelImportCellVo();
        String json = JsonUtil.toJson((Object)widget);
        WidgetDTO widgetDTO = (WidgetDTO)JsonUtil.parse((String)json, WidgetDTO.class);
        excelImportCellVo1.setValue(widget.getType().equals(WidgetType.ADDRESS.getType()) ? widgetDTO.getTitle() : this.getTitle(widgetDTO, langCode, viewById));
        excelImportCellVo1.setRow(nowRow);
        excelImportCellVo1.setCol(startCol);
        excelImportCellVo1.setRowspan(isChildTable ? 1 : maxLvl - nowRow);
        excelImportCellVo1.setColspan(isChildTable ? nowCol - startCol : 1);
        String fieldName = HussarUtils.isEmpty((Object)widget.getOldName()) ? widget.getName() : widget.getOldName();
        excelImportCellVo1.setFieldName(HussarUtils.isEmpty((Object)widget.getParentKey()) ? fieldName : String.format(CACHE_TEMPLATE, widget.getParentKey(), fieldName));
        excelImportCellVo1.setFieldType(widget.getType());
        headers.get(nowRow).add(excelImportCellVo1);
        if (isChildTable) {
            return nowCol;
        }
        for (int i = nowRow + 1; i < maxLvl; ++i) {
            ExcelImportCellVo vo = new ExcelImportCellVo();
            vo.setValue(null);
            vo.setRow(i);
            vo.setCol(nowCol);
            vo.setRowspan(1);
            vo.setColspan(1);
            headers.get(i).add(vo);
        }
        return nowCol + 1;
    }

    private Tuple2<List<List<Object>>, List<CellRangeAddress>> transSheetData(List<EngineResultEntity> allData, List<Widget> cols, List<Widget> widgets, int startRow, Map<String, Integer> field2Count) {
        Map<String, Object> tableMap = WidgetTool.flatAllTableWidget(widgets).stream().collect(Collectors.toMap(e -> e.getName(), e -> e));
        HashMap<String, Object> newTableMap = new HashMap<String, Object>();
        Set parentKeys = cols.stream().map(Widget::getParentKey).collect(Collectors.toSet());
        for (String key : tableMap.keySet()) {
            if (!parentKeys.contains(key)) continue;
            newTableMap.put(key, tableMap.get(key));
        }
        ArrayList rows = new ArrayList();
        ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
        int curRow = startRow;
        for (EngineResultEntity resultEntity : allData) {
            List<List<Tuple2<Integer, Object>>> rs = this.transSheetData("", resultEntity, cols, newTableMap, field2Count);
            for (List<Tuple2<Integer, Object>> r : rs) {
                ArrayList<Object> row = new ArrayList<Object>();
                rows.add(row);
                for (int i = 0; i < r.size(); ++i) {
                    Tuple2<Integer, Object> tp = r.get(i);
                    if (tp == null) {
                        row.add(null);
                        continue;
                    }
                    row.add(tp.getT2());
                    if ((Integer)tp.getT1() == 1) continue;
                    ranges.add(new CellRangeAddress(curRow, curRow + (Integer)tp.getT1() - 1, i, i));
                }
                ++curRow;
            }
        }
        return Tuples.of(rows, ranges);
    }

    private List<List<Tuple2<Integer, Object>>> transSheetData(String tableName, EngineResultEntity resultEntity, List<Widget> cols, Map<String, Object> tableMap, Map<String, Integer> field2Count) {
        ArrayList<List<Tuple2<Integer, Object>>> children = new ArrayList<List<Tuple2<Integer, Object>>>();
        for (Map.Entry et : resultEntity.entrySet()) {
            if (!tableMap.containsKey(et.getKey()) || !(et.getValue() instanceof List)) continue;
            List obj = (List)et.getValue();
            ArrayList<List<Tuple2<Integer, Object>>> ct = new ArrayList<List<Tuple2<Integer, Object>>>();
            for (EngineResultEntity childEntity : obj) {
                ct.addAll(this.transSheetData((String)et.getKey(), childEntity, cols, tableMap, field2Count));
            }
            if (ct.size() > children.size()) {
                while (ct.size() > children.size()) {
                    ArrayList<Object> vals = new ArrayList<Object>();
                    for (int j = 0; j < ((List)ct.get(0)).size(); ++j) {
                        vals.add(null);
                    }
                    children.add(vals);
                }
            }
            for (int i = 0; i < children.size(); ++i) {
                List cdt;
                List child = (List)children.get(i);
                List list = cdt = ct.size() > i ? (List)ct.get(i) : null;
                if (cdt == null) continue;
                for (int j = 0; j < cdt.size(); ++j) {
                    Tuple2 val = (Tuple2)cdt.get(j);
                    if (val == null) continue;
                    child.set(j, val);
                }
            }
        }
        ArrayList<Tuple2> row = new ArrayList<Tuple2>();
        int rowspan = children.size() == 0 ? 1 : children.size();
        for (int i = 0; i < cols.size(); ++i) {
            Widget widget = cols.get(i);
            if (!StringUtil.equals((CharSequence)tableName, (CharSequence)widget.getParentKey())) {
                for (int j = 0; j < field2Count.get(HussarUtils.isEmpty((Object)widget.getParentKey()) ? widget.getName() : String.format(CACHE_TEMPLATE, widget.getParentKey(), widget.getName())); ++j) {
                    row.add(null);
                }
                continue;
            }
            Object val = this.dealFieldValue(resultEntity, widget);
            List<Object> newCells = this.dealCellData(StringUtil.toStringOrNull((Object)val), widget);
            for (int j = 0; j < newCells.size(); ++j) {
                row.add(Tuples.of((Object)rowspan, (Object)(newCells.get(j) == null ? "" : newCells.get(j))));
            }
        }
        if (CollectionUtil.isAllEmpty((Object[])new Object[]{row})) {
            return children;
        }
        if (CollectionUtils.isEmpty(children)) {
            return Arrays.asList(row);
        }
        List row1 = (List)children.get(0);
        for (int j = 0; j < row.size(); ++j) {
            Tuple2 val = (Tuple2)row.get(j);
            if (val == null) continue;
            row1.set(j, val);
        }
        return children;
    }

    private String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    private List<Object> dealCellData(String value, Widget widget) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (WidgetType.ADDRESS.getType().equals(widget.getType())) {
            String[] address;
            int i;
            int count;
            boolean fullAddress;
            if (widget.getProps() == null) {
                result.add(value);
                return result;
            }
            JSONObject props = JSON.parseObject((String)widget.getProps().toString());
            int addressLevel = props.getInteger("addressLevel") == null ? 1 : props.getInteger("addressLevel");
            boolean bl = fullAddress = props.getInteger("fullAddress") == null ? false : props.getBoolean("fullAddress");
            if (fullAddress && (count = StringUtil.count((CharSequence)value, (CharSequence)"/")) < addressLevel) {
                for (i = 0; i < addressLevel - count; ++i) {
                    value = value + "/ ";
                }
            }
            String[] stringArray = address = value == null ? new String[addressLevel] : value.split("/");
            if (fullAddress) {
                ++addressLevel;
            }
            for (i = 0; i < addressLevel; ++i) {
                result.add(Optional.ofNullable(address[i]).map(String::trim).orElse(""));
            }
        } else if (WidgetType.JXDNSecurityLevel.getType().equals(widget.getType())) {
            List levelDictByType = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
            if (HussarUtils.isNotEmpty((Object)levelDictByType)) {
                String finalValue = value;
                Optional<DicLevelTreeVo> any = levelDictByType.stream().filter(d -> HussarUtils.equals((Object)finalValue, (Object)d.getValue())).findAny();
                any.ifPresent(dicLevelTreeVo -> result.add(dicLevelTreeVo.getLabel()));
            }
        } else {
            result.add(value);
        }
        return result;
    }

    public Widget createDataIdWidget(SysForm form) {
        Widget dataIdWidget = new Widget();
        dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
        dataIdWidget.setName("RECORD_ID");
        dataIdWidget.setType(WidgetType.INPUT.getType());
        dataIdWidget.setDataType("string");
        dataIdWidget.setParentKey("");
        return dataIdWidget;
    }

    public void addWatermark(SXSSFWorkbook workbook, String sheetName) throws IOException {
        UserDetails userDetails = (UserDetails)TransmittableThreadLocalHolder.get((String)"loginUserDetails");
        String text = this.waterMarkComponent.getDataWaterMark(Long.parseLong(Objects.requireNonNull(AppContextUtil.getAppId())), userDetails);
        byte[] bytes = text.getBytes();
        text = new String(bytes, StandardCharsets.UTF_8);
        BufferedImage bufferedImage = ExcelWaterRemarkUtils.createWaterMarkImage(text);
        ExcelWaterRemarkUtils.addWatermarkExcel(workbook, bufferedImage);
    }

    public String getTitle(WidgetDTO widget, String langCode, DataView view) {
        if (HussarUtils.isNotEmpty((Object)view)) {
            String i18nKeys = "";
            List showFields = view.getShowFields();
            ShowField field = null;
            for (ShowField showField : showFields) {
                String name = showField.getName();
                if (widget.getIsInChild()) {
                    return this.getWidgetAlias(widget, langCode, view);
                }
                if (!name.equals(widget.getName())) continue;
                field = showField;
                i18nKeys = showField.getI18nKeys();
                break;
            }
            if (HussarUtils.isNotEmpty((Object)i18nKeys)) {
                JSONObject parse = (JSONObject)JSONObject.parse((String)i18nKeys);
                Object object = parse.get((Object)"alias");
                if (HussarUtils.isNotEmpty((Object)object)) {
                    String key = object.toString();
                    SysMultiLangMgt sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(key, langCode);
                    if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                        return sysMultiLangMgt.getLangText();
                    }
                    SysMultiLang sysMultiLang = this.sysMultiLangService.getDefaultLang();
                    if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
                        String code = sysMultiLang.getLangCode();
                        sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(key, code);
                        if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                            return sysMultiLangMgt.getLangText();
                        }
                        return this.getViewAlias(widget, langCode, view, field);
                    }
                    return this.getViewAlias(widget, langCode, view, field);
                }
                return this.getViewAlias(widget, langCode, view, field);
            }
            return this.getViewAlias(widget, langCode, view, field);
        }
        return this.getWidgetAlias(widget, langCode, view);
    }

    private String getViewAlias(WidgetDTO widget, String langCode, DataView view, ShowField field) {
        if (HussarUtils.isNotEmpty((Object)field) && HussarUtils.isNotEmpty((Object)field.getAlias())) {
            return field.getAlias();
        }
        return this.getWidgetAlias(widget, langCode, view);
    }

    private String getWidgetAlias(WidgetDTO widget, String langCode, DataView view) {
        String i18ntitle = widget.getI18ntitle();
        if (HussarUtils.isNotEmpty((Object)i18ntitle)) {
            SysMultiLangMgt sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(i18ntitle, langCode);
            if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                return sysMultiLangMgt.getLangText();
            }
            SysMultiLang sysMultiLang = this.sysMultiLangService.getDefaultLang();
            if (HussarUtils.isNotEmpty((Object)sysMultiLang)) {
                String code = sysMultiLang.getLangCode();
                sysMultiLangMgt = this.sysMultiLangMgtService.getOneByLangKeyAndLangCode(i18ntitle, code);
                if (HussarUtils.isNotEmpty((Object)sysMultiLangMgt) && HussarUtils.isNotEmpty((Object)sysMultiLangMgt.getLangText())) {
                    return sysMultiLangMgt.getLangText();
                }
                return widget.getTitle();
            }
            return widget.getTitle();
        }
        return widget.getTitle();
    }

    public List<Widget> createChildDataIdWidget(SysForm form, DataExportDTO dataExportDTO) {
        String formId = dataExportDTO.getFormId();
        String appId = dataExportDTO.getAppId();
        String viewId = dataExportDTO.getViewId();
        DataView viewById = new DataView();
        try {
            FormViewVo formViewVo = this.hussarAppFormService.getViewByUser(formId, appId);
            FormViewSchemaVo formView = formViewVo.getFormView();
            List views = formView.getViews();
            if (HussarUtils.isNotEmpty((Object)views)) {
                for (DataView view : views) {
                    if (!view.getId().equals(viewId)) continue;
                    viewById = view;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5931\u8d25", (Throwable)e);
        }
        String langCode = dataExportDTO.getLangCode();
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
        List widgets = formCanvasSchemaDTO.getWidgets();
        if (HussarUtils.isEmpty((Object)widgets)) {
            return widgetList;
        }
        String json = JsonUtil.toJson((Object)widgets);
        List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
        DataView finalViewById = viewById;
        widgetDTOS.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).forEach(widget -> {
            String parentKey = widget.getName();
            String title = this.getTitle((WidgetDTO)widget, dataExportDTO.getLangCode(), finalViewById);
            Widget dataIdWidget = new Widget();
            String childTitle = title + "." + this.getSaticName(langCode, PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setTitle(childTitle);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            String title = this.getTitle((WidgetDTO)child, dataExportDTO.getLangCode(), finalViewById);
            Widget dataIdWidget = new Widget();
            String childTitle = title + "." + this.getSaticName(langCode, PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setTitle(childTitle);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.JXDNTabs.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            String title = this.getTitle((WidgetDTO)child, dataExportDTO.getLangCode(), finalViewById);
            Widget dataIdWidget = new Widget();
            String childTitle = title + "." + this.getSaticName(langCode, PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setTitle(childTitle);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        return widgetList;
    }

    private String parseLabel(JSONObject jsonObject, boolean showAllLevels) {
        String result = null;
        String label = jsonObject.getString("label");
        if (HussarUtils.isNotEmpty((Object)label)) {
            if (label.startsWith("[") && label.endsWith("]")) {
                JSONArray labelArray = JSON.parseArray((String)label);
                result = showAllLevels ? HussarUtils.join((Collection)labelArray, (String)"/") : labelArray.getString(labelArray.size() - 1);
            } else {
                logger.error("label\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e", (Object)label);
                result = label;
            }
        }
        return result;
    }
}

