/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rabbit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleExec;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues={"nocodeRuleExec"}, autoStartup="${hussar.nocode.businessRule.rabbitmqenable:false}")
public class RabbitmqListenerExec {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqListenerExec.class);
    @Autowired
    private NoCodeRuleExec noCodeRuleExec;

    @RabbitHandler
    public void receive(String message) {
        JSONObject json = JSON.parseObject((String)message);
        SysRuleInfoWithDetailsDto ruleInfoWithDetails = (SysRuleInfoWithDetailsDto)JSON.parseObject((String)json.getString("ruleInfoWithDetails"), SysRuleInfoWithDetailsDto.class);
        JSONObject businessData = (JSONObject)JSON.parseObject((String)json.getString("businessData"), JSONObject.class);
        SecurityUser loginUser = (SecurityUser)JSON.parseObject((String)json.getString("loginUser"), SecurityUser.class);
        String formId = (String)JSON.parseObject((String)json.getString("formId"), String.class);
        String appId = (String)JSON.parseObject((String)json.getString("appId"), String.class);
        String traceId = (String)JSON.parseObject((String)json.getString("traceId"), String.class);
        List ruleIds = JSON.parseArray((String)json.getString("ruleIds"), String.class);
        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\uff1a\u63a5\u6536\u5230rabbitmq\u63a8\u9001\u7684\u6267\u884c\u4fe1\u606f\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{ruleInfoWithDetails.getSysRuleTriggerAction().getFormId(), businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
        HussarNoCodeThreadUtil.executeUserTask(() -> this.noCodeRuleExec.excRule(appId, formId, businessData, ruleInfoWithDetails, loginUser, traceId, ruleIds));
    }
}

