/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeToAi {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeToAi.class);
    private static final List<String> TEXT_STR = new ArrayList<String>(Arrays.asList("JXDNAggregate", "JXDNExtWidget", "JXDNFile", "JXDNHandwrittenSignature", "JXDNImage", "JXDNInput", "JXDNRichText", "JXDNSerialNumber", "JXDNSuggestion", "JXDNTextarea"));
    private static final List<String> TEXT_NUM = new ArrayList<String>(Arrays.asList("JXDNNumber"));
    private static final List<String> SINGLE_CHOICE = new ArrayList<String>(Arrays.asList("JXDNCascader", "JXDNLinkForm", "JXDNOrg", "JXDNRadioGroup", "JXDNSecurityLevel", "JXDNSelect", "JXDNUser"));
    private static final List<String> MULTIPLE_CHOICE = new ArrayList<String>(Arrays.asList("JXDNCascaderMulti", "JXDNCheckBoxGroup", "JXDNLinkFormMulti", "JXDNOrgMulti", "JXDNSeletMulti", "JXDNUserMulti"));
    private static final List<String> TRUE_FALSE = new ArrayList<String>(Arrays.asList("JXDNSwitch"));
    private static final List<String> DATE_TIME = new ArrayList<String>(Arrays.asList("JXDNDate"));
    private static final List<String> ADDRESS = new ArrayList<String>(Arrays.asList("JXDNAddress"));

    public static String convertWidgetType(String widgetType) {
        if (TEXT_STR.contains(widgetType)) {
            return "text_str";
        }
        if (TEXT_NUM.contains(widgetType)) {
            return "text_num";
        }
        if (SINGLE_CHOICE.contains(widgetType)) {
            return "single_choice";
        }
        if (MULTIPLE_CHOICE.contains(widgetType)) {
            return "multiple_choice";
        }
        if (TRUE_FALSE.contains(widgetType)) {
            return "true_false";
        }
        if (DATE_TIME.contains(widgetType)) {
            return "date_time";
        }
        if (ADDRESS.contains(widgetType)) {
            return "address";
        }
        LOGGER.error("\u672a\u627e\u5230\u7ec4\u4ef6\u7c7b\u578b\uff1a{} \u5bf9\u5e94\u7684ai\u7ec4\u4ef6\u7c7b\u578b,\u8fd4\u56de\u9ed8\u8ba4\u7c7b\u578b", (Object)widgetType);
        return "text_str";
    }
}

