/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleSendType;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleExec;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleTrigger;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.properties.BusinessRuleProperties;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleInfoService;
import com.jxdinfo.hussar.formdesign.application.rule.vo.SysRuleInfoVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jeasy.rules.annotation.Action;
import org.jeasy.rules.annotation.Condition;
import org.jeasy.rules.annotation.Fact;
import org.jeasy.rules.annotation.Rule;
import org.jeasy.rules.api.Facts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Rule(name="noCodeRule", description="\u96f6\u4ee3\u7801\u901a\u7528\u4e1a\u52a1\u89c4\u5219")
@HussarTokenDs
@Component
public class NoCodeRule {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeRule.class);
    @Resource
    private RabbitTemplate rabbitTemplate;

    @Condition
    public boolean ruleConditon(@Fact(value="formId") String formId, @Fact(value="businessData") JSONObject businessData, @Fact(value="triggerType") String triggerType, @Fact(value="traceId") String traceId, @Fact(value="ruleIds") List<String> ruleIds) {
        NoCodeRuleTrigger noCodeRuleTrigger = (NoCodeRuleTrigger)SpringUtil.getBean(NoCodeRuleTrigger.class);
        ISysRuleInfoService sysRuleInfoService = (ISysRuleInfoService)SpringUtil.getBean(ISysRuleInfoService.class);
        if (HussarUtils.isEmpty((Object)formId)) {
            logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u5931\u8d25:\u89e6\u53d1\u8868\u5355id\u4e3a\u7a7a\uff0c\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, businessData, traceId});
            return false;
        }
        SysRuleInfoVo sysRuleInfoVo = new SysRuleInfoVo();
        sysRuleInfoVo.setTriggerFormId(formId);
        ApiResponse apiResponse = sysRuleInfoService.getAllSysRuleInfoWithDetails(sysRuleInfoVo);
        if (ApiResponse.isNotSuccess((ApiResponse)apiResponse)) {
            logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u5931\u8d25:\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u5931\u8d25\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u67e5\u8be2\u4e1a\u52a1\u89c4\u5219\u8fd4\u56de\u4fe1\u606f\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, businessData, JSON.toJSONString((Object)apiResponse), traceId});
            return false;
        }
        List sysRuleInfoWithDetails = (List)apiResponse.getData();
        if (HussarUtils.isEmpty((Object)sysRuleInfoWithDetails)) {
            logger.info("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u89c4\u5219\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, traceId});
            return false;
        }
        ArrayList newSysRuleInfoWithDetails = new ArrayList();
        for (SysRuleInfoWithDetailsDto ruleInfoWithDetails : sysRuleInfoWithDetails) {
            try {
                JSONObject jsonObject = noCodeRuleTrigger.triggerRule(businessData, ruleInfoWithDetails, triggerType);
                if (HussarUtils.isNotEmpty((Object)jsonObject)) {
                    logger.info("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u901a\u8fc7\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
                    HashMap<String, Object> verifyRule = new HashMap<String, Object>();
                    verifyRule.put("rule", ruleInfoWithDetails);
                    verifyRule.put("data", jsonObject);
                    newSysRuleInfoWithDetails.add(verifyRule);
                    continue;
                }
                logger.info("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u5f02\u5e38\uff0c\u89c6\u4e3a\u672a\u901a\u8fc7\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u94fe\u8defid\uff1a{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
                logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u9a8c\u8bc1\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
        logger.info("\u89e6\u53d1\u8868\u5355{}\u67e5\u8be2\u5230\u7684\u89e6\u53d1\u9a8c\u8bc1\u901a\u8fc7\u7684\u4e1a\u52a1\u89c4\u5219\u6570\u91cf{},\u94fe\u8defid\uff1a{}", new Object[]{formId, newSysRuleInfoWithDetails.size(), traceId});
        if (HussarUtils.isEmpty(newSysRuleInfoWithDetails)) {
            return false;
        }
        TransmittableThreadLocalHolder.set((String)"ruleInfoWithDetails", newSysRuleInfoWithDetails);
        return true;
    }

    @Action
    public void ruleAction(Facts facts) {
        NoCodeRuleExec noCodeRuleExec = (NoCodeRuleExec)SpringUtil.getBean(NoCodeRuleExec.class);
        Object details = TransmittableThreadLocalHolder.get((String)"ruleInfoWithDetails");
        List ruleInfoWithDetailsList = (List)JSON.parseObject((String)JSON.toJSONString((Object)details), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        JSONObject businessData = (JSONObject)facts.get("businessData");
        String formId = (String)facts.get("formId");
        String sourceAppId = (String)facts.get("appId");
        String traceId = (String)facts.get("traceId");
        SecurityUser loginUser = (SecurityUser)facts.get("loginUser");
        List ruleIds = (List)facts.get("ruleIds");
        if (HussarUtils.isEmpty((Object)ruleInfoWithDetailsList) || HussarUtils.isEmpty((Object)businessData) || HussarUtils.isEmpty((Object)formId)) {
            logger.error("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u52a8\u4f5c\u4e3a\u7a7a\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetailsList), traceId});
            return;
        }
        for (Map verifyRuleAndData : ruleInfoWithDetailsList) {
            Object ruleObject = verifyRuleAndData.get("rule");
            SysRuleInfoWithDetailsDto ruleInfoWithDetails = (SysRuleInfoWithDetailsDto)JSON.parseObject((String)JSON.toJSONString(ruleObject), SysRuleInfoWithDetailsDto.class);
            businessData = (JSONObject)verifyRuleAndData.get("data");
            logger.info("\u5f00\u59cb\u5f02\u6b65\u5904\u7406\u4e1a\u52a1\u89c4\u5219\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
            try {
                BusinessRuleProperties businessRuleProperties = (BusinessRuleProperties)SpringContextUtil.getBean(BusinessRuleProperties.class);
                if (NoCodeRuleSendType.RABBITMQ.getType().equalsIgnoreCase(businessRuleProperties.getSendType())) {
                    try {
                        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\uff0c\u53d1\u9001rabbitmq\u6d88\u606f\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
                        this.sendRabbitmq(formId, businessData, ruleInfoWithDetails, loginUser, traceId, ruleIds);
                    }
                    catch (Exception e) {
                        logger.error("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\uff0c\u53d1\u9001rabbitmq\u6d88\u606f\u5931\u8d25\uff0c\u672c\u5730\u5f02\u6b65\u6267\u884c\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), e.getMessage(), traceId});
                        JSONObject finalBusinessData = businessData;
                        HussarNoCodeThreadUtil.executeUserTask(() -> noCodeRuleExec.excRule(sourceAppId, formId, finalBusinessData, ruleInfoWithDetails, loginUser, traceId, ruleIds));
                    }
                    continue;
                }
                logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\uff0c\u672c\u5730\u5f02\u6b65\u6267\u884c\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), traceId});
                JSONObject finalBusinessData1 = businessData;
                HussarNoCodeThreadUtil.executeUserTask(() -> noCodeRuleExec.excRule(sourceAppId, formId, finalBusinessData1, ruleInfoWithDetails, loginUser, traceId, ruleIds));
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u6267\u884c\u5f02\u5e38\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSON.toJSONString((Object)ruleInfoWithDetails), e.getMessage(), traceId});
                logger.error("\u4e1a\u52a1\u89c4\u5219\u89e6\u53d1\u6267\u884c\u5f02\u5e38:", (Throwable)e);
            }
        }
    }

    private void sendRabbitmq(String formId, JSONObject businessData, SysRuleInfoWithDetailsDto ruleInfoWithDetails, SecurityUser loginUser, String traceId, List<String> ruleIds) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ruleInfoWithDetails", (Object)ruleInfoWithDetails);
        jsonObject.put("businessData", (Object)businessData);
        jsonObject.put("loginUser", (Object)loginUser);
        jsonObject.put("formId", (Object)formId);
        jsonObject.put("traceId", (Object)traceId);
        jsonObject.put("ruleIds", ruleIds);
        this.rabbitTemplate.convertAndSend("nocodeRuleExec", (Object)JSON.toJSONString((Object)jsonObject));
    }
}

