/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.eai.client.sdk.api.bo.EaiApiSdkInvokeParams;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiApiSdkInvokService;
import com.jxdinfo.hussar.eai.client.sdk.api.service.EaiSyncApiSdkService;
import com.jxdinfo.hussar.eai.client.sdk.datapack.service.EaiDataPacketSdkService;
import com.jxdinfo.hussar.eai.client.sdk.properties.EaiClientSdkProperties;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.EaiDataPacketField;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.EaiDataPacketMarketInfo;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.EaiQueryPacketData;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.PageQueryDto;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.QueryDataPacketDetailDto;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.QueryPacketDataDto;
import com.jxdinfo.hussar.eai.sysapi.api.datapack.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiDetailDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoSdkDto;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.sysapi.api.dto.EaiApiParamsItem;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryConditionDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderByIdsDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.SearchDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.FilterConditionEnum;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.dao.SysIdConvertsFrameMapper;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.engine.api.service.EngineApiService;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.config.EaiCrossServiceProperties;
import com.jxdinfo.hussar.formdesign.no.code.constant.ViewIdEnum;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.cured.ViewSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.view.FormViewSchema;
import com.jxdinfo.hussar.formdesign.no.code.tool.DataTypeConvert;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.sync.idconverts.model.SysIdConverts;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class HussarAppDataSourceServiceImpl
implements IHussarAppDataSourceService {
    private static Logger logger = LogManager.getLogger(HussarAppDataSourceServiceImpl.class);
    @Resource
    private ISysApplicationExternalService applicationService;
    private static final String TABLE_QUERY_FROM = "_tableQuery_from";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private EngineApiService engineApiService;
    @Resource
    private ViewSchemaService viewSchemaService;
    @Resource
    private EaiApiSdkInvokService eaiApiSdkInvokService;
    @Resource
    private EaiDataPacketSdkService eaiDataPacketSdkService;
    @Resource
    private EaiSyncApiSdkService eaiSyncApiSdkService;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private EaiClientSdkProperties eaiClientSdkProperties;
    @Resource
    private EaiCrossServiceProperties eaiCrossServiceProperties;
    @Resource
    private SysIdConvertsFrameMapper sysIdConvertsFrameMapper;
    @Resource
    private IHussarBaseUserBoService userBoService;
    @Resource
    private ISysFormService sysFormService;
    private static final Integer BAD_GATEWAY_ERROR_CODE = 17002;
    private static final String BAD_GATEWAY_ERROR_MSG = "\u8bbf\u95ee\u670d\u52a1\u5931\u8d25\uff01";
    private static final String TABLE_QUERY_ALL = "TableQueryAll";
    private static final String FLOW_RULE = "_isNotNull";
    private static final String FLOW_FIELD = "PROCESS_KEY";
    private static final String FLOW_MATCH = "AND";
    private static final String QUERY_ERR = "\u67e5\u8be2\u5b57\u6bb5\u5217\u8868\u6570\u636e\u5f02\u5e38";

    public ApiResponse<QueryBusinessDataVo> queryAppBusinessData(String formId, String appId, Map<String, Object> params) {
        SysForm form = (SysForm)HussarCacheUtil.get((String)TABLE_QUERY_FROM, (Object)formId, SysForm.class);
        if (HussarUtils.isEmpty((Object)form)) {
            form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
            HussarCacheUtil.put((String)TABLE_QUERY_FROM, (Object)formId, (Object)form, (long)3600L);
        }
        if (HussarUtils.isEmpty((Object)form) || !form.getAppId().toString().equals(appId)) {
            return ApiResponse.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8054\u52a8\u914d\u7f6e");
        }
        QueryBusinessDataVo result = new QueryBusinessDataVo();
        result.setFormName(form.getFormName());
        ApiResponse booleanApiResponse = this.applicationService.checkRolePermissions(Long.valueOf(formId));
        FormDesignResponse canvasResponse = this.canvasSchemaService.get(form);
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.businessDataCanvas(appId, (FormCanvasSchema)canvasResponse.getData());
        if (HussarUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        }
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            result.setWidgetList(formCanvasSchemaDTO.getWidgets());
            return ApiResponse.success((Object)result);
        }
        FormViewSchema formViewSchema = (FormViewSchema)this.viewSchemaService.get(form).getData();
        if (HussarUtils.isNotEmpty((Object)formViewSchema) && HussarUtils.isNotEmpty((Object)formViewSchema.getViews())) {
            ArrayList orders = new ArrayList();
            Optional value = JsonParser.value(params, (String)"orders", List.class);
            if (value.isPresent()) {
                ArrayList list = (ArrayList)value.get();
                orders.addAll(list);
            }
            if (HussarUtils.isEmpty(orders)) {
                List viewOrderBy = formViewSchema.fetchOrderBy();
                orders.addAll(viewOrderBy);
            }
            params.put("orders", orders);
            String viewId = HussarUtils.equals((Object)formCanvasSchemaDTO.getFormType(), (Object)"1") ? ViewIdEnum.SYS_FLOW_ALL_DATA.getId() : "";
            this.handleParamsForStrict(params);
            params.put(TABLE_QUERY_FROM, form);
            ResponseEntity apiResponseResponseEntity = this.formOperateExposedService.tableQuery(formId, viewId, params, appId);
            ApiResponse body = (ApiResponse)apiResponseResponseEntity.getBody();
            PageVo data = (PageVo)body.getData();
            List dataList = data.getData();
            SysForm finalForm = form;
            dataList.forEach(dataMap -> this.hussarAppFormService.suggestionShowSet(dataMap, finalForm, (FormCanvasSchema)canvasResponse.getData()));
            result.setBusinessData(body.getData());
            result.setWidgetList(formCanvasSchemaDTO.getWidgets());
        }
        return ApiResponse.success((Object)result);
    }

    public FormCanvasSchemaDTO businessDataCanvas(String appId, FormCanvasSchema canvas) {
        AppContextUtil.setAppId((String)appId);
        if (HussarUtils.isNotEmpty((Object)canvas)) {
            FormCanvasSchemaDTO canvasDto = new FormCanvasSchemaDTO();
            BeanUtils.copyProperties((Object)canvas, (Object)canvasDto);
            List widgets = canvas.widgetsWithSys();
            widgets.addAll(canvas.childTables());
            ArrayList widgetDTOS = new ArrayList();
            WidgetTool.ofWidgetDTO(widgetDTOS, (List)widgets, widget -> false);
            canvasDto.setWidgets(widgetDTOS);
            return canvasDto;
        }
        return new FormCanvasSchemaDTO();
    }

    private void handleParamsForStrict(Map<String, Object> params) {
        boolean haveQueryCondition;
        boolean bl = haveQueryCondition = params.containsKey("superQueryConditionDto") && HussarUtils.isNotEmpty((Object)params.get("superQueryConditionDto"));
        if (haveQueryCondition) {
            List queryConditions = JSON.parseArray((String)JSON.toJSONString((Object)params.get("superQueryConditionDto")), QueryConditionDto.class);
            ArrayList<QueryConditionDto> newQueryConditions = new ArrayList<QueryConditionDto>();
            ArrayList<String> strictFields = new ArrayList<String>();
            for (QueryConditionDto queryCondition : queryConditions) {
                boolean isValueEmpty;
                boolean bl2 = isValueEmpty = HussarUtils.isEmpty((Object)queryCondition.getVal()) || "[\"\"]".equals(queryCondition.getVal());
                if (HussarUtils.isNotEmpty((Object)queryCondition.getStrict()) && queryCondition.getStrict().booleanValue() && isValueEmpty) {
                    if (strictFields.contains(queryCondition.getField())) continue;
                    QueryConditionDto newQueryCondition = new QueryConditionDto();
                    newQueryCondition.setRule(OperatorType.NE.getValue().equals(queryCondition.getRule()) ? OperatorType.IS_NOT_NULL.getValue() : OperatorType.IS_NULL.getValue());
                    newQueryCondition.setMatch(queryCondition.getMatch());
                    newQueryCondition.setField(queryCondition.getField());
                    newQueryCondition.setVal(queryCondition.getVal());
                    newQueryCondition.setStrict(queryCondition.getStrict());
                    newQueryConditions.add(newQueryCondition);
                    strictFields.add(queryCondition.getField());
                    continue;
                }
                newQueryConditions.add(queryCondition);
            }
            params.put("superQueryConditionDto", newQueryConditions);
        }
    }

    public ApiResponse<QueryBusinessDataVo> querySetBusinessData(String dataSetId, Map<String, Object> params) {
        return ApiResponse.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u6570\u636e\u96c6\u67e5\u8be2");
    }

    public ApiResponse<QueryBusinessDataVo> queryApiBusinessData(String id, String appCode, String apiCode, String uri, Map<String, Object> params) {
        boolean open = this.eaiCrossServiceProperties.isOpen();
        QueryBusinessDataVo result = new QueryBusinessDataVo();
        if (open) {
            ApiDetailDto apiDetailDto = new ApiDetailDto();
            apiDetailDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
            apiDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
            apiDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            apiDetailDto.setAppCode(appCode);
            apiDetailDto.setApiCode(apiCode);
            ApiInfoSdkDto apiInfoSdkDetail = null;
            ApiResponse getApiDetailByCodeResult = null;
            try {
                logger.info("getApiDetailByCode\u7684\u53c2\u6570:" + JSON.toJSONString((Object)apiDetailDto));
                getApiDetailByCodeResult = this.eaiSyncApiSdkService.getApiDetailByCode(apiDetailDto);
                logger.info("getApiDetailByCode\u7684\u7ed3\u679c:" + JSON.toJSONString((Object)getApiDetailByCodeResult));
                apiInfoSdkDetail = (ApiInfoSdkDto)JSON.parseObject((String)JSON.toJSONString((Object)getApiDetailByCodeResult.getData()), ApiInfoSdkDto.class);
            }
            catch (Exception e) {
                logger.error("queryAPIBusinessData\u65b9\u6cd5\u83b7\u53d6\u67e5\u8be2\u5b57\u6bb5\u5217\u8868\u6570\u636e\u62a5\u9519", (Throwable)e);
                return ApiResponse.fail((String)QUERY_ERR);
            }
            List outParamsArray = apiInfoSdkDetail.getOutParams().getBody();
            List<Object> fieldsArray = new ArrayList<EaiApiParamsItem>();
            if (HussarUtils.isNotEmpty((Object)outParamsArray)) {
                Optional<EaiApiParamsItem> first;
                Optional<EaiApiParamsItem> data = outParamsArray.stream().filter(m -> HussarUtils.equals((Object)"data", (Object)m.getName())).findFirst();
                Optional<EaiApiParamsItem> items = data.get().getItems().stream().filter(i -> HussarUtils.equals((Object)"data", (Object)i.getName())).findFirst();
                if (!items.isPresent()) {
                    logger.error("\u63a5\u53e3\u51fa\u53c2\u683c\u5f0f\u914d\u7f6e\u9519\u8bef\uff1bdata\u9879\u7f3a\u5931");
                    fieldsArray.add(new EaiApiParamsItem());
                }
                if (!(first = ((EaiApiParamsItem)items.get()).getItems().stream().filter(i -> HussarUtils.equals((Object)"item", (Object)i.getName()) || HussarUtils.equals((Object)"items", (Object)i.getName())).findFirst()).isPresent()) {
                    logger.error("\u63a5\u53e3\u51fa\u53c2\u683c\u5f0f\u914d\u7f6e\u5f02\u5e38\uff1b\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a");
                    fieldsArray.add(new EaiApiParamsItem());
                }
                fieldsArray = first.get().getItems();
            } else {
                fieldsArray.add(new EaiApiParamsItem());
            }
            ArrayList<WidgetDTO> widgetDTOs = new ArrayList<WidgetDTO>();
            if (HussarUtils.isNotEmpty(fieldsArray)) {
                for (EaiApiParamsItem paramsItem : fieldsArray) {
                    WidgetDTO widgetDTO = new WidgetDTO();
                    String dataType = DataTypeConvert.convertApiDataType((Integer)paramsItem.getType());
                    widgetDTO.setName(paramsItem.getName());
                    widgetDTO.setTitle(paramsItem.getMark());
                    widgetDTO.setDataType(dataType);
                    widgetDTO.setType(DataTypeConvert.dataTypeConvertWidget((String)dataType));
                    widgetDTOs.add(widgetDTO);
                }
                result.setWidgetList(widgetDTOs);
            }
            EaiApiSdkInvokeParams eaiApiSdkInvokeParams = new EaiApiSdkInvokeParams();
            EaiApiParams inParams = apiInfoSdkDetail.getInParams();
            HashMap header = new HashMap();
            eaiApiSdkInvokeParams.setHeader(header);
            HashMap query = new HashMap();
            eaiApiSdkInvokeParams.setQuery(query);
            HashMap<String, Object> body = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty((Object)inParams.getBody())) {
                String current = (String)JsonParser.value(params, (String)"current", String.class).get();
                String size = (String)JsonParser.value(params, (String)"size", String.class).get();
                HashMap<String, Long> bodyParam = new HashMap<String, Long>();
                bodyParam.put("current", Long.valueOf(current));
                bodyParam.put("size", Long.valueOf(size));
                body.put("pageParams", bodyParam);
                List superQueryConditionDto = (List)JsonParser.value(params, (String)"superQueryConditionDto", List.class).get();
                body.put("superQueryConditionDto", superQueryConditionDto);
                Optional value = JsonParser.value(params, (String)"orders", List.class);
                if (value.isPresent()) {
                    List orders = (List)value.get();
                    body.put("orders", orders);
                }
            }
            eaiApiSdkInvokeParams.setBody(body);
            eaiApiSdkInvokeParams.setServerUrl(this.eaiClientSdkProperties.getEaiUrl());
            eaiApiSdkInvokeParams.setUri(uri);
            eaiApiSdkInvokeParams.setClientId(this.eaiClientSdkProperties.getClientId());
            eaiApiSdkInvokeParams.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            ApiResponse response = this.eaiApiSdkInvokService.getResponse(eaiApiSdkInvokeParams);
            Object object = this.iamIdToUserId(response.getData());
            result.setBusinessData(object);
        }
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<QueryBusinessDataVo> queryPacketData(String appId, String packetCode, String uri, Map<String, Object> params) {
        HussarException.throwByNull(params, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryBusinessDataVo result = new QueryBusinessDataVo();
        if (this.eaiCrossServiceProperties.isOpen()) {
            Object size;
            QueryDataPacketDetailDto queryDataPacketDetailDto = new QueryDataPacketDetailDto();
            queryDataPacketDetailDto.setPacketCode(packetCode);
            queryDataPacketDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
            queryDataPacketDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            ApiResponse response = this.eaiDataPacketSdkService.queryDataPacketDetail(queryDataPacketDetailDto);
            if (!response.isSuccess()) {
                return ApiResponse.fail((int)response.getCode(), (String)(BAD_GATEWAY_ERROR_CODE.equals(response.getCode()) ? BAD_GATEWAY_ERROR_MSG : response.getMsg()));
            }
            EaiDataPacketMarketInfo dataPacketMarketInfo = (EaiDataPacketMarketInfo)response.getData();
            if (dataPacketMarketInfo == null) {
                logger.error("\u6570\u636e\u5305\u4e0d\u5b58\u5728\uff0cpacketCode:{}", (Object)packetCode);
                return ApiResponse.fail((String)"\u6570\u636e\u5305\u4e0d\u5b58\u5728");
            }
            List tableFieldInfos = dataPacketMarketInfo.getTableFieldInfos();
            ArrayList<WidgetDTO> widgetDTOs = new ArrayList<WidgetDTO>();
            if (HussarUtils.isNotEmpty((Object)tableFieldInfos)) {
                for (EaiDataPacketField field : tableFieldInfos) {
                    WidgetDTO widgetDTO = new WidgetDTO();
                    widgetDTO.setName(field.getFieldName());
                    if (!HussarUtils.equals((Object)field.getComment(), (Object)"null")) {
                        widgetDTO.setTitle(field.getComment());
                    }
                    widgetDTO.setDbType(field.getFieldType());
                    String dataType = DataTypeConvert.convertPacketDataType((String)field.getFieldType());
                    widgetDTO.setDataType(dataType);
                    widgetDTO.setType(DataTypeConvert.dataTypeConvertWidget((String)dataType));
                    widgetDTOs.add(widgetDTO);
                }
                result.setWidgetList(widgetDTOs);
            }
            QueryPacketDataDto queryPacketDataDto = new QueryPacketDataDto();
            queryPacketDataDto.setConsumerCode(appId);
            queryPacketDataDto.setPacketCode(packetCode);
            queryPacketDataDto.setClientId(this.eaiClientSdkProperties.getClientId());
            queryPacketDataDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            PageQueryDto pageQueryDto = new PageQueryDto();
            Object current = params.get("current");
            if (HussarUtils.isNotEmpty((Object)current)) {
                pageQueryDto.setCurrent(Long.valueOf(String.valueOf(current)));
            }
            if (HussarUtils.isNotEmpty((Object)(size = params.get("size")))) {
                pageQueryDto.setSize(Long.valueOf(String.valueOf(size)));
            }
            queryPacketDataDto.setPageParams(pageQueryDto);
            Object superQueryConditionDto = params.get("superQueryConditionDto");
            List conditionList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)superQueryConditionDto)) {
                conditionList = (List)superQueryConditionDto;
            }
            queryPacketDataDto.setSuperQueryConditionDto(conditionList);
            Object orders = params.get("orders");
            List orderList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)orders)) {
                orderList = (List)orders;
            }
            queryPacketDataDto.setOrders(orderList);
            List fieldList = widgetDTOs.stream().map(WidgetDTO::getName).collect(Collectors.toList());
            queryPacketDataDto.setFields(fieldList);
            EaiQueryPacketData queryPacketData = null;
            try {
                logger.info("queryPacketData\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)queryPacketDataDto));
                ApiResponse packetDataResponse = this.eaiDataPacketSdkService.queryPacketData(queryPacketDataDto);
                logger.info("queryPacketData\u7684\u8fd4\u56de\u503c\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)packetDataResponse));
                if (!response.isSuccess()) {
                    return ApiResponse.fail((int)response.getCode(), (String)(BAD_GATEWAY_ERROR_CODE.equals(response.getCode()) ? BAD_GATEWAY_ERROR_MSG : response.getMsg()));
                }
                queryPacketData = (EaiQueryPacketData)packetDataResponse.getData();
            }
            catch (Exception e) {
                logger.error("queryPacketData\u65b9\u6cd5\u83b7\u53d6\u67e5\u8be2\u5b57\u6bb5\u5217\u8868\u6570\u636e\u62a5\u9519", (Throwable)e);
                return ApiResponse.fail((String)QUERY_ERR);
            }
            result.setBusinessData((Object)queryPacketData);
        }
        return ApiResponse.success((Object)result);
    }

    public ApiResponse<List<Map<String, Object>>> queryAppBusinessDataOnCascader(QueryDataOnCascaderDTO queryDataDto) {
        FormViewSchema formViewSchema;
        String appId = queryDataDto.getAppId();
        String formId = queryDataDto.getFormId();
        String supNodeField = queryDataDto.getSupNodeField();
        String supNodeId = queryDataDto.getSupNodeId();
        String showField = queryDataDto.getShowField();
        String defaultExpandLevel = queryDataDto.getDefaultExpandLevel();
        HashMap<String, Object> params = queryDataDto.getParams();
        List<Object> result = new ArrayList();
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form) || !form.getAppId().toString().equals(appId)) {
            return ApiResponse.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8054\u52a8\u914d\u7f6e");
        }
        ApiResponse booleanApiResponse = this.applicationService.checkRolePermissions(Long.valueOf(formId));
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            return ApiResponse.success(Collections.emptyList());
        }
        if (HussarUtils.isEmpty((Object)params)) {
            params = new HashMap<String, Object>();
        }
        if (HussarUtils.isNotEmpty((Object)(formViewSchema = (FormViewSchema)this.viewSchemaService.get(formId).getData())) && HussarUtils.isNotEmpty((Object)formViewSchema.getViews())) {
            List orders = JsonParser.value(params, (String)"orders", List.class).orElseGet(ArrayList::new);
            if (HussarUtils.isEmpty((Object)orders)) {
                List viewOrderBy = formViewSchema.fetchOrderBy();
                orders.addAll(viewOrderBy);
            }
            params.put("orders", orders);
            String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, TABLE_QUERY_ALL);
            List conditionList = JsonParser.value(params, (String)"superQueryConditionDto", List.class).orElseGet(ArrayList::new);
            FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.businessDataCanvas(formId, appId);
            if (HussarUtils.equals((Object)formCanvasSchemaDTO.getFormType(), (Object)"1")) {
                SuperQueryConditionDto filterFlow = new SuperQueryConditionDto();
                filterFlow.setRule(FLOW_RULE);
                filterFlow.setVal("");
                filterFlow.setField(FLOW_FIELD);
                filterFlow.setMatch(FLOW_MATCH);
                conditionList.add(filterFlow);
            }
            params.put("superQueryConditionDto", conditionList);
            SuperQueryConditionDto supNodeFieldCondition = new SuperQueryConditionDto();
            if (HussarUtils.isNotEmpty((Object)supNodeField)) {
                if (HussarUtils.isNotEmpty((Object)supNodeId)) {
                    supNodeFieldCondition.setField(String.format("%s_ref_id", supNodeField));
                    supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
                    supNodeFieldCondition.setRule(FilterConditionEnum.EQ.getSearchValue());
                    supNodeFieldCondition.setVal(supNodeId);
                    conditionList.add(supNodeFieldCondition);
                } else if (!HussarUtils.equals((Object)"all", (Object)defaultExpandLevel)) {
                    supNodeFieldCondition.setField(String.format("%s_ref_id", supNodeField));
                    supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
                    supNodeFieldCondition.setRule(FilterConditionEnum.IS_NULL.getSearchValue());
                    conditionList.add(supNodeFieldCondition);
                }
            }
            List<Map<String, Object>> dataList = this.tableQueryAll(businessId, params);
            List<Object> lastDataList = Lists.newArrayListWithCapacity((int)10);
            if (HussarUtils.isNotEmpty((Object)supNodeField) && !HussarUtils.equals((Object)"all", (Object)defaultExpandLevel)) {
                Integer level = 0;
                try {
                    level = Integer.valueOf(defaultExpandLevel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ArrayList supNodeIds = Lists.newArrayListWithCapacity((int)10);
                List<Object> childList = Lists.newArrayList(dataList);
                int index = 0;
                while (childList.size() > 0) {
                    supNodeIds.clear();
                    childList.forEach(dataMap -> supNodeIds.add((String)dataMap.get("RECORD_ID")));
                    supNodeFieldCondition.setRule(FilterConditionEnum.IN.getSearchValue());
                    supNodeFieldCondition.setVal(HussarUtils.join((Collection)supNodeIds, (String)","));
                    if (index == level) {
                        lastDataList = this.tableQueryCount(businessId, params, supNodeField);
                        break;
                    }
                    childList = this.tableQueryAll(businessId, params);
                    dataList.addAll(childList);
                    ++index;
                }
            }
            result = this.dataListConvertTree(dataList, supNodeField, showField, supNodeId, lastDataList);
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<List<Map<String, Object>>> searchDataOnCascader(SearchDataOnCascaderDTO searchDataDTO) {
        FormViewSchema formViewSchema;
        String appId = searchDataDTO.getAppId();
        String formId = searchDataDTO.getFormId();
        String supNodeField = searchDataDTO.getSupNodeField();
        String showField = searchDataDTO.getShowField();
        String fieldValue = searchDataDTO.getFieldValue();
        HashMap<String, Object> params = searchDataDTO.getParams();
        List<Object> result = new ArrayList();
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form) || !form.getAppId().toString().equals(appId)) {
            return ApiResponse.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8054\u52a8\u914d\u7f6e");
        }
        ApiResponse booleanApiResponse = this.applicationService.checkRolePermissions(Long.valueOf(formId));
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            return ApiResponse.success(Collections.emptyList());
        }
        if (HussarUtils.isEmpty((Object)params)) {
            params = new HashMap<String, Object>();
        }
        if (HussarUtils.isNotEmpty((Object)(formViewSchema = (FormViewSchema)this.viewSchemaService.get(formId).getData())) && HussarUtils.isNotEmpty((Object)formViewSchema.getViews())) {
            List orders = JsonParser.value(params, (String)"orders", List.class).orElseGet(ArrayList::new);
            if (HussarUtils.isEmpty((Object)orders)) {
                List viewOrderBy = formViewSchema.fetchOrderBy();
                orders.addAll(viewOrderBy);
            }
            params.put("orders", orders);
            String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, TABLE_QUERY_ALL);
            List conditionList = JsonParser.value(params, (String)"superQueryConditionDto", List.class).orElseGet(ArrayList::new);
            FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.businessDataCanvas(formId, appId);
            if (HussarUtils.equals((Object)formCanvasSchemaDTO.getFormType(), (Object)"1")) {
                SuperQueryConditionDto filterFlow = new SuperQueryConditionDto();
                filterFlow.setRule(FLOW_RULE);
                filterFlow.setVal("");
                filterFlow.setField(FLOW_FIELD);
                filterFlow.setMatch(FLOW_MATCH);
                conditionList.add(filterFlow);
            }
            params.put("superQueryConditionDto", conditionList);
            SuperQueryConditionDto supNodeFieldCondition = new SuperQueryConditionDto();
            conditionList.add(supNodeFieldCondition);
            supNodeFieldCondition.setField(showField);
            supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
            supNodeFieldCondition.setRule(FilterConditionEnum.LIKE.getSearchValue());
            supNodeFieldCondition.setVal(fieldValue);
            List<Map<String, Object>> dataList = this.tableQueryAll(businessId, params);
            List<Object> lastDataList = Lists.newArrayListWithCapacity((int)10);
            if (HussarUtils.isNotEmpty((Object)supNodeField) && HussarUtils.isNotEmpty(dataList)) {
                ArrayList supNodeIds = Lists.newArrayListWithCapacity((int)10);
                dataList.forEach(dataMap -> supNodeIds.add((String)dataMap.get("RECORD_ID")));
                supNodeFieldCondition.setField(String.format("%s_ref_id", supNodeField));
                supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
                supNodeFieldCondition.setRule(FilterConditionEnum.IN.getSearchValue());
                supNodeFieldCondition.setVal(HussarUtils.join((Collection)supNodeIds, (String)","));
                lastDataList = this.tableQueryCount(businessId, params, supNodeField);
                List<Object> supList = Lists.newArrayList(dataList);
                while (supList.size() > 0) {
                    supNodeIds.clear();
                    supList.forEach(dataMap -> supNodeIds.add((String)dataMap.get(String.format("%s_ref_id", supNodeField))));
                    supNodeFieldCondition.setField("RECORD_ID");
                    supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
                    supNodeFieldCondition.setRule(FilterConditionEnum.IN.getSearchValue());
                    supNodeFieldCondition.setVal(HussarUtils.join((Collection)supNodeIds, (String)","));
                    supList = this.tableQueryAll(businessId, params);
                    dataList.addAll(supList);
                }
            }
            result = this.dataListConvertTree(dataList, supNodeField, showField, null, lastDataList);
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<List<Map<String, Object>>> queryDataOnCascaderByIds(QueryDataOnCascaderByIdsDTO queryDataDto) {
        FormViewSchema formViewSchema;
        String appId = queryDataDto.getAppId();
        String formId = queryDataDto.getFormId();
        String supNodeField = queryDataDto.getSupNodeField();
        String supNodeIds = queryDataDto.getSupNodeIds();
        String showField = queryDataDto.getShowField();
        HashMap<String, Object> params = queryDataDto.getParams();
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        if (HussarUtils.isEmpty((Object)supNodeField) || HussarUtils.isEmpty((Object)supNodeIds)) {
            return ApiResponse.success(Collections.emptyList());
        }
        SysForm form = (SysForm)this.sysFormService.getById((Serializable)Long.valueOf(formId));
        if (HussarUtils.isEmpty((Object)form) || !form.getAppId().toString().equals(appId)) {
            return ApiResponse.fail((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u8054\u52a8\u914d\u7f6e");
        }
        ApiResponse booleanApiResponse = this.applicationService.checkRolePermissions(Long.valueOf(formId));
        if (!((Boolean)booleanApiResponse.getData()).booleanValue()) {
            return ApiResponse.success(Collections.emptyList());
        }
        if (HussarUtils.isEmpty((Object)params)) {
            params = new HashMap<String, Object>();
        }
        if (HussarUtils.isNotEmpty((Object)(formViewSchema = (FormViewSchema)this.viewSchemaService.get(formId).getData())) && HussarUtils.isNotEmpty((Object)formViewSchema.getViews())) {
            List orders = JsonParser.value(params, (String)"orders", List.class).orElseGet(ArrayList::new);
            if (HussarUtils.isEmpty((Object)orders)) {
                List viewOrderBy = formViewSchema.fetchOrderBy();
                orders.addAll(viewOrderBy);
            }
            params.put("orders", orders);
            String businessId = this.getBusinessId(HttpMethod.POST.name(), appId, formId, TABLE_QUERY_ALL);
            ArrayList dataList = Lists.newArrayListWithCapacity((int)10);
            if (HussarUtils.isNotEmpty((Object)supNodeField) && HussarUtils.isNotEmpty((Object)supNodeIds)) {
                List conditionList = JsonParser.value(params, (String)"superQueryConditionDto", List.class).orElseGet(ArrayList::new);
                FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.businessDataCanvas(formId, appId);
                if (HussarUtils.equals((Object)formCanvasSchemaDTO.getFormType(), (Object)"1")) {
                    SuperQueryConditionDto filterFlow = new SuperQueryConditionDto();
                    filterFlow.setRule(FLOW_RULE);
                    filterFlow.setVal("");
                    filterFlow.setField(FLOW_FIELD);
                    filterFlow.setMatch(FLOW_MATCH);
                    conditionList.add(filterFlow);
                }
                params.put("superQueryConditionDto", conditionList);
                SuperQueryConditionDto supNodeFieldCondition = new SuperQueryConditionDto();
                conditionList.add(supNodeFieldCondition);
                supNodeFieldCondition.setField(String.format("%s_ref_id", supNodeField));
                supNodeFieldCondition.setMatch(MatchTypeEnum.AND.getValue());
                supNodeFieldCondition.setRule(FilterConditionEnum.IN.getSearchValue());
                ArrayList supNodeList = Lists.newArrayListWithCapacity((int)10);
                supNodeList.addAll(Lists.newArrayList((Object[])supNodeIds.split(",")));
                while (supNodeList.size() > 0) {
                    supNodeFieldCondition.setVal(HussarUtils.join((Collection)supNodeList, (String)","));
                    List<Map<String, Object>> childList = this.tableQueryAll(businessId, params);
                    supNodeList.clear();
                    childList.forEach(dataMap -> supNodeList.add((String)dataMap.get("RECORD_ID")));
                    dataList.addAll(childList);
                }
            }
            if (HussarUtils.isNotEmpty((Object)dataList)) {
                Arrays.stream(supNodeIds.split(",")).forEach(supNodeId -> result.addAll(this.dataListConvertTree(dataList, supNodeField, showField, (String)supNodeId, Collections.emptyList())));
            }
        }
        return ApiResponse.success((Object)result);
    }

    private List<Map<String, Object>> tableQueryAll(String businessId, Map<String, Object> params) {
        ApiResponse body = (ApiResponse)this.engineApiService.invokeByReturnEntity(businessId, null, params).getBody();
        PageVo data = (PageVo)body.getData();
        if (HussarUtils.isNotEmpty((Object)data)) {
            List dataList = data.getData();
            return dataList;
        }
        return Lists.newArrayListWithCapacity((int)10);
    }

    private List<Map<String, Object>> tableQueryCount(String businessId, Map<String, Object> params, String supNodeField) {
        HashMap<String, Cloneable> aggregateParams = new HashMap<String, Cloneable>();
        HashMap<String, String> agg = new HashMap<String, String>();
        String refId = String.format("%s_ref_id", supNodeField);
        agg.put(String.format("COUNT(${%s})", refId), "total");
        aggregateParams.put("agg", agg);
        aggregateParams.put("group", Lists.newArrayList((Object[])new String[]{refId}));
        params.put("groupAggregation", aggregateParams);
        List<Map<String, Object>> result = this.tableQueryAll(businessId, params);
        params.remove("groupAggregation");
        return result;
    }

    private List<Map<String, Object>> dataListConvertTree(List<Map<String, Object>> dataList, String supNodeField, String showField, String supNodeId, List<Map<String, Object>> lastDataList) {
        String refIdField = String.format("%s_ref_id", supNodeField);
        HashMap dataListMap = Maps.newHashMapWithExpectedSize((int)16);
        dataList.stream().forEach(dataMap -> {
            String refIdValue = (String)dataMap.get(refIdField);
            List refIdList = (List)dataListMap.get(refIdValue);
            if (refIdList == null) {
                refIdList = Lists.newArrayListWithCapacity((int)16);
                dataListMap.put(refIdValue, refIdList);
            }
            refIdList.add(dataMap);
        });
        HashMap lastDataListMap = Maps.newHashMapWithExpectedSize((int)16);
        lastDataList.stream().forEach(dataMap -> {
            String refIdValue = (String)dataMap.get(refIdField);
            List refIdList = (List)lastDataListMap.get(refIdValue);
            if (refIdList == null) {
                refIdList = Lists.newArrayListWithCapacity((int)16);
                lastDataListMap.put(refIdValue, refIdList);
            }
            refIdList.add(dataMap);
        });
        return this.dataListFactorial(dataListMap, showField, supNodeId, lastDataListMap);
    }

    private List<Map<String, Object>> dataListFactorial(Map<String, List<Map<String, Object>>> dataListMap, String showField, String supNodeId, Map<String, List<Map<String, Object>>> lastDataListMap) {
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        List list = dataListMap.getOrDefault(supNodeId, Collections.emptyList());
        for (Map data : list) {
            String recordId = (String)data.get("RECORD_ID");
            List<Map<String, Object>> childList = this.dataListFactorial(dataListMap, showField, recordId, lastDataListMap);
            HashMap<String, Object> newNode = new HashMap<String, Object>();
            newNode.put("id", recordId);
            newNode.put("pid", supNodeId);
            newNode.put("value", recordId);
            newNode.put("label", data.get(showField));
            newNode.put("isLeaf", HussarUtils.isEmpty(childList) && !lastDataListMap.containsKey(recordId));
            if (HussarUtils.isNotEmpty(childList)) {
                newNode.put("children", childList);
            }
            result.add(newNode);
        }
        return result;
    }

    private String getBusinessId(String requestMethod, String appId, String formId, String invokeMethod) {
        if (HussarUtils.isNotEmpty((Object)appId)) {
            AppContextUtil.setAppId((String)appId);
        }
        String url = FileUtil.posixPath((String[])new String[]{appId, formId, invokeMethod});
        return String.format("%s /%s", requestMethod, url);
    }

    private Object iamIdToUserId(Object object) {
        if (HussarUtils.isEmpty((Object)object)) {
            return object;
        }
        JSONObject businessData = JSON.parseObject((String)JSON.toJSONString((Object)object));
        Object data = businessData.get((Object)"data");
        if (HussarUtils.isEmpty((Object)data)) {
            return object;
        }
        List array = JSON.parseArray((String)JSON.toJSONString((Object)data), JSONObject.class);
        if (HussarUtils.isEmpty((Object)array)) {
            return object;
        }
        Set keySet = ((JSONObject)array.get(0)).keySet();
        Object[] keys = new String[keySet.size()];
        int count = 0;
        for (String key : keySet) {
            keys[count] = key;
            ++count;
        }
        if (!HussarUtils.contains((Object[])keys, (Object)"USER_id")) {
            return object;
        }
        ArrayList<String> iamIds = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject json = (JSONObject)array.get(i);
            String userIds = json.getString("USER_id");
            if (!HussarUtils.isNotEmpty((Object)userIds)) continue;
            iamIds.addAll(Arrays.asList(userIds.split(",")));
        }
        Map<Object, Object> sysUsersMaps = new HashMap();
        Map<Object, Object> idConvertsMaps = new HashMap();
        if (HussarUtils.isNotEmpty(iamIds)) {
            List<SysIdConverts> idConverts = this.sysIdConvertsFrameMapper.selectSysIdConvertsByIamIds(iamIds);
            idConvertsMaps = idConverts.stream().collect(Collectors.toMap(SysIdConverts::getIamUser, SysIdConverts::getNumId, (key1, key2) -> key2));
        }
        if (!HussarUtils.isEmpty(idConvertsMaps)) {
            ArrayList employeeIds = new ArrayList();
            employeeIds.addAll(idConvertsMaps.values());
            List sysUsers = this.userBoService.getUsersByEmployeeIds(employeeIds);
            sysUsersMaps = sysUsers.stream().collect(Collectors.toMap(SysUsers::getEmployeeId, SysUsers::getId, (key1, key2) -> key2));
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        for (int i = 0; i < array.size(); ++i) {
            List userJsons;
            JSONObject json = (JSONObject)array.get(i);
            String userIds = json.getString("USER_id");
            String user = json.getString("USER");
            if (HussarUtils.isNotEmpty((Object)userIds)) {
                ArrayList<String> newUserIdList = new ArrayList<String>();
                List<String> userIdList = Arrays.asList(userIds.split(","));
                for (int j = 0; j < userIdList.size(); ++j) {
                    Long employeeId;
                    if (!HussarUtils.isNotEmpty((Object)userIdList.get(j)) || !HussarUtils.isNotEmpty((Object)(employeeId = (Long)idConvertsMaps.get(Long.parseLong(userIdList.get(j))))) || !HussarUtils.isNotEmpty((Object)sysUsersMaps.get(employeeId))) continue;
                    newUserIdList.add(Long.toString((Long)sysUsersMaps.get(employeeId)));
                }
                json.put("USER_id", (Object)newUserIdList.stream().collect(Collectors.joining(",")));
            }
            if (HussarUtils.isNotEmpty((Object)user) && HussarUtils.isNotEmpty((Object)(userJsons = JSON.parseArray((String)user, JSONObject.class)))) {
                for (int j = 0; j < userJsons.size(); ++j) {
                    Long iamId;
                    JSONObject userJson = (JSONObject)userJsons.get(j);
                    if (!HussarUtils.isNotEmpty((Object)userJson.getString("id")) || !HussarUtils.isNotEmpty((Object)(iamId = Long.valueOf(Long.parseLong(userJson.getString("id"))))) || !HussarUtils.isNotEmpty((Object)idConvertsMaps.get(iamId)) || !HussarUtils.isNotEmpty((Object)sysUsersMaps.get(idConvertsMaps.get(iamId)))) continue;
                    userJson.put("id", (Object)Long.toString((Long)sysUsersMaps.get(idConvertsMaps.get(iamId))));
                }
                json.put("USER", (Object)userJsons);
            }
            resultList.add(json);
        }
        businessData.put("data", resultList);
        return businessData;
    }

    public ApiResponse<QueryBusinessDataVo> queryApiBusinessDataFromMerge(String id, String appCode, String apiCode, String uri, Map<String, Object> params) {
        boolean open = this.eaiCrossServiceProperties.isOpen();
        QueryBusinessDataVo result = new QueryBusinessDataVo();
        if (open) {
            ApiDetailDto apiDetailDto = new ApiDetailDto();
            apiDetailDto.setUrl(this.eaiClientSdkProperties.getEaiUrl());
            apiDetailDto.setClientId(this.eaiClientSdkProperties.getClientId());
            apiDetailDto.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            apiDetailDto.setAppCode(appCode);
            apiDetailDto.setApiCode(apiCode);
            ApiInfoSdkDto apiInfoSdkDetail = null;
            ApiResponse getApiDetailByCodeResult = null;
            try {
                logger.info("getApiDetailByCode\u7684\u53c2\u6570:" + JSON.toJSONString((Object)apiDetailDto));
                getApiDetailByCodeResult = this.eaiSyncApiSdkService.getApiDetailByCode(apiDetailDto);
                logger.info("getApiDetailByCode\u7684\u7ed3\u679c:" + JSON.toJSONString((Object)getApiDetailByCodeResult));
                apiInfoSdkDetail = (ApiInfoSdkDto)JSON.parseObject((String)JSON.toJSONString((Object)getApiDetailByCodeResult.getData()), ApiInfoSdkDto.class);
            }
            catch (Exception e) {
                logger.error("queryAPIBusinessData\u65b9\u6cd5\u83b7\u53d6\u67e5\u8be2\u5b57\u6bb5\u5217\u8868\u6570\u636e\u62a5\u9519", (Throwable)e);
                return ApiResponse.fail((String)QUERY_ERR);
            }
            EaiApiSdkInvokeParams eaiApiSdkInvokeParams = new EaiApiSdkInvokeParams();
            EaiApiParams inParams = apiInfoSdkDetail.getInParams();
            HashMap header = new HashMap();
            eaiApiSdkInvokeParams.setHeader(header);
            HashMap query = new HashMap();
            eaiApiSdkInvokeParams.setQuery(query);
            HashMap<String, Object> body = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty((Object)inParams.getBody())) {
                String current = (String)JsonParser.value(params, (String)"current", String.class).get();
                String size = (String)JsonParser.value(params, (String)"size", String.class).get();
                HashMap<String, Long> bodyParam = new HashMap<String, Long>();
                bodyParam.put("current", Long.valueOf(current));
                bodyParam.put("size", Long.valueOf(size));
                body.put("pageParams", bodyParam);
                List superQueryConditionDto = (List)JsonParser.value(params, (String)"superQueryConditionDto", List.class).get();
                body.put("superQueryConditionDto", superQueryConditionDto);
                Optional value = JsonParser.value(params, (String)"orders", List.class);
                if (value.isPresent()) {
                    List orders = (List)value.get();
                    body.put("orders", orders);
                }
            }
            eaiApiSdkInvokeParams.setBody(body);
            eaiApiSdkInvokeParams.setServerUrl(this.eaiClientSdkProperties.getEaiUrl());
            eaiApiSdkInvokeParams.setUri(uri);
            eaiApiSdkInvokeParams.setClientId(this.eaiClientSdkProperties.getClientId());
            eaiApiSdkInvokeParams.setClientSecret(this.eaiClientSdkProperties.getClientSecret());
            ApiResponse response = this.eaiApiSdkInvokService.getResponse(eaiApiSdkInvokeParams);
            result.setBusinessData(response.getData());
        }
        return ApiResponse.success((Object)result);
    }
}

