/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.formdesign.app.frame.api.service.IFormPathService;
import com.jxdinfo.hussar.formdesign.application.properties.HussarNocodePublicProperties;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.openApi.common.ApiResponse;
import com.jxdinfo.hussar.openApi.dto.SysFormPathDTO;
import com.jxdinfo.hussar.openApi.service.IAiQAService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Service;

@Service
public class FormPathServiceImpl
implements IFormPathService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormPathServiceImpl.class);
    @Resource
    private IAiQAService aiQaService;
    @Resource
    private ServerProperties serverProperties;
    @Resource
    private HussarNocodePublicProperties hussarNocodePublicProperties;
    private static final String WEB_URL = "/hussarAppFrame/?appId={appId}#/form/{formId}";
    private static final String MOBILE_URL = "/hussarApp/#/container/list/?appId={appId}&formId={formId}";

    private SysFormPathDTO creatFormPath(FormCanvasSchema formCanvasSchema) {
        SysFormPathDTO sysFormPathDTO = new SysFormPathDTO();
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
            sysFormPathDTO.setAppId(Long.valueOf(formCanvasSchema.getAppId()));
            sysFormPathDTO.setFormId(formCanvasSchema.getId());
            sysFormPathDTO.setWebUrl(this.hussarNocodePublicProperties.getFrontIp() + WEB_URL);
            sysFormPathDTO.setMobileUrl(this.hussarNocodePublicProperties.getFrontIp() + MOBILE_URL);
        }
        return sysFormPathDTO;
    }

    public Void saveFormPathAsync(FormCanvasSchema formCanvasSchema) {
        LOGGER.info("=================\u5f00\u59cb\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)formCanvasSchema.getId());
        SysFormPathDTO sysFormPathDTO = this.creatFormPath(formCanvasSchema);
        ApiResponse booleanApiResponse = this.aiQaService.saveOrUpdateFormPath(sysFormPathDTO);
        LOGGER.info("=================\u8868\u5355\u8def\u5f84\u4fdd\u5b58{}=============", (Object)booleanApiResponse.getMsg());
        LOGGER.info("=================\u7ed3\u675f\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)formCanvasSchema.getId());
        return null;
    }

    public Void deleteFormPathAsync(String formId) {
        LOGGER.info("=================\u5f00\u59cb\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)formId);
        ApiResponse apiResponse = this.aiQaService.deleteFormPath(formId);
        LOGGER.info("=================\u8868\u5355\u8def\u5f84\u5220\u9664{}=============", (Object)apiResponse.getMsg());
        LOGGER.info("=================\u7ed3\u675f\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)formId);
        return null;
    }
}

