/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppAuthService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.configapi.service.ConfigApiService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.config.manager.vo.ConfigValueVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class HussarAppAuthServiceImpl
implements IHussarAppAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarAppAuthServiceImpl.class);
    @Autowired
    private ConfigApiService configApiService;
    @Resource
    private IHussarAppFormService appFormService;

    public ResponseEntity<ApiResponse<Object>> tableQueryAuth(String formId, String viewId, Map<String, Object> params, String appId, String clientId) {
        boolean authForm = this.authForm(formId, clientId);
        if (authForm) {
            return this.appFormService.tableQuery(formId, viewId, params, appId);
        }
        return ResponseEntity.of(Optional.of(ApiResponse.fail((String)"\u65e0\u6743\u9650")));
    }

    public ResponseEntity<ApiResponse<Object>> formQueryAuth(String formId, String id, String tabType, String appId, String clientId) {
        boolean authForm = this.authForm(formId, clientId);
        if (authForm) {
            return this.appFormService.formQuery(formId, id, tabType, appId);
        }
        return ResponseEntity.of(Optional.of(ApiResponse.fail((String)"\u65e0\u6743\u9650")));
    }

    private List<Long> getAuthFormIdList(String clientId) {
        try {
            List list = (List)this.configApiService.getConfigByGroupPath("hussar.client.accessForm").getData();
            if (HussarUtils.isNotEmpty((Object)list) && HussarUtils.isNotEmpty((Object)list)) {
                LOGGER.info("----------------------\u8868\u5355\u6388\u6743\u914d\u7f6elist:{}", (Object)JSON.toJSONString((Object)list));
                Optional<ConfigValueVo> first = list.stream().filter(e -> clientId.equals(e.getSimpleKey())).findFirst();
                if (first.isPresent()) {
                    ConfigValueVo configValueVo = first.get();
                    LOGGER.info("----------------------\u8868\u5355\u6388\u6743\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)configValueVo));
                    String configValue = configValueVo.getConfigValue();
                    if (HussarUtils.isNotEmpty((Object)configValue)) {
                        return Arrays.stream(configValue.split(",")).map(String::trim).map(Long::valueOf).collect(Collectors.toList());
                    }
                }
            }
        }
        catch (Exception e2) {
            LOGGER.error("----------------------\u8868\u5355\u6388\u6743\u914d\u7f6e\u5f02\u5e38:\u5ba2\u6237\u7aefid:{}", (Object)clientId);
            LOGGER.error("----------------------\u8868\u5355\u6388\u6743\u914d\u7f6e\u5f02\u5e38:", (Throwable)e2);
        }
        return new ArrayList<Long>();
    }

    private boolean authForm(String formId, String clientId) {
        List<Long> formIdList = this.getAuthFormIdList(clientId);
        if (HussarUtils.isEmpty(formIdList) || HussarUtils.isEmpty((Object)formId)) {
            LOGGER.info("----------------------\u8868\u5355:{}, \u5ba2\u6237\u7aef\uff1a{},\u672a\u6388\u6743", (Object)formId, (Object)clientId);
            return false;
        }
        if (formIdList.contains(Long.valueOf(formId))) {
            LOGGER.info("----------------------\u8868\u5355:{}, \u5ba2\u6237\u7aef{},\u5df2\u6388\u6743", (Object)formId, (Object)clientId);
            return true;
        }
        LOGGER.info("----------------------\u8868\u5355:{}, \u5ba2\u6237\u7aef\uff1a{},\u672a\u6388\u6743", (Object)formId, (Object)clientId);
        return false;
    }
}

