/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.ExcelImportErrorType;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.ImportProperties;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.ExcelFormatEnum;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.I18nUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportCellVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportErrorVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewMatchVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResultVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportRowVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.ExcelImportRowHookDto;
import com.jxdinfo.hussar.formdesign.extension.api.dto.form.ExcelVerifyHookDto;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.DataView;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.util.HookUtil;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.WidgetTool;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.client.utils.DateUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Component
public class ExcelImport {
    private static Logger logger = LoggerFactory.getLogger(ExcelImport.class);
    @Resource
    private IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    private IHussarBaseUserBoService sysUsersService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private I18nUtil i18nUtil;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private HookUtil hookUtil;
    private static final Long SECURITY_LEVEL_TYPE_ID = 1450742089372590091L;

    public boolean isFirstRowOfMergeCount(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row != firstRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstRowAndColOfMergeCount(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row != firstRow || column != firstColumn) continue;
            return true;
        }
        return false;
    }

    public CellRangeAddress isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return range;
        }
        return null;
    }

    public String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return this.getCellValue(fCell);
        }
        return null;
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            String cellValue = null;
            if (cell.getCellStyle().getDataFormat() == 0 || cell.getCellStyle().getDataFormat() == 3) {
                long longValue = Math.round(cell.getNumericCellValue());
                cellValue = Double.parseDouble(longValue + ".0") == cell.getNumericCellValue() ? String.valueOf(longValue) : String.valueOf(cell.getNumericCellValue());
            } else if (cell.getCellStyle().getDataFormat() == 176 || cell.getCellStyle().getDataFormat() == 177 || cell.getCellStyle().getDataFormat() == 178 || cell.getCellStyle().getDataFormat() == 14) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    if ("yyyy".equals(cell.getCellStyle().getDataFormatString())) {
                        Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                        cellValue = sdf.format(date);
                    } else if ("yyyy\\-mm\\-dd".equals(cell.getCellStyle().getDataFormatString())) {
                        Date date = DateUtil.getJavaDate((double)cell.getNumericCellValue());
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = sdf.format(date);
                    } else {
                        TimeZone zone;
                        double numericValue = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)numericValue, (TimeZone)(zone = TimeZone.getTimeZone("GMT")));
                        cellValue = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                        if (cellValue.endsWith(" 00:00:00")) {
                            cellValue = cellValue.replace(" 00:00:00", "");
                        }
                    }
                } else {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                }
            } else {
                TimeZone zone;
                double numericValue = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)numericValue, (TimeZone)(zone = TimeZone.getTimeZone("GMT")));
                cellValue = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                if (cellValue.endsWith(" 00:00:00")) {
                    cellValue = cellValue.replace(" 00:00:00", "");
                }
            }
            return cellValue;
        }
        return "";
    }

    public ExcelImportResultVo dealExcelData(ExcelImportPreviewVo excelImportPreviewVo, List<ExcelImportRowVo> rowsFromExcel, List<Widget> widgets, SysForm form, JSONObject sysData) {
        ArrayList<Integer> failRowNum = new ArrayList<Integer>();
        int failNum = 0;
        ArrayList<ExcelImportErrorVo> excelImportErrorVos = new ArrayList<ExcelImportErrorVo>();
        ArrayList excelImportOnlyErrorVos = new ArrayList();
        ExcelImportResultVo excelImportResultVo = new ExcelImportResultVo();
        Map<String, Widget> nameWidgetMap = widgets.stream().collect(Collectors.toMap(Widget::getName, Function.identity(), (key1, key2) -> key2));
        List matchs = excelImportPreviewVo.getMatches();
        int mainRowNum = 0;
        int excelRowNum = 0;
        for (ExcelImportRowVo excelImportRowVo : rowsFromExcel) {
            boolean isMainData = true;
            for (ExcelImportCellVo excelImportCellVo : excelImportRowVo.getCells()) {
                if (excelImportCellVo.getRowspan() == 1 || excelImportCellVo.isFirstMerge()) continue;
                isMainData = false;
                break;
            }
            if (isMainData) {
                ++mainRowNum;
            }
            if (mainRowNum - 1 != excelImportPreviewVo.getFirstRowIndex()) continue;
            excelRowNum = ((ExcelImportCellVo)excelImportRowVo.getCells().get(0)).getRow();
            break;
        }
        rowsFromExcel = rowsFromExcel.subList(excelRowNum, rowsFromExcel.size());
        ArrayList<Widget> bfsWidgets = new ArrayList<Widget>();
        bfsWidgets.addAll(widgets);
        LinkedList<Widget> buff = new LinkedList<Widget>();
        buff.addAll(widgets);
        Widget tmp = (Widget)buff.pollFirst();
        while (tmp != null) {
            if (CollUtil.isNotEmpty((Collection)tmp.getChildren())) {
                buff.addAll(tmp.getChildren());
                bfsWidgets.addAll(tmp.getChildren());
            }
            if (buff.isEmpty()) {
                tmp = null;
                continue;
            }
            tmp = (Widget)buff.pollFirst();
        }
        Function<Widget, String> toName = e -> HussarUtils.isEmpty((Object)e.getParentKey()) ? e.getName() : String.format("%s_%s", e.getParentKey(), e.getName());
        nameWidgetMap = bfsWidgets.stream().collect(Collectors.toMap(toName, e -> e));
        List bfsSorted = bfsWidgets.stream().map(toName).collect(Collectors.toList());
        matchs.sort(Comparator.comparingInt(e -> bfsSorted.indexOf(HussarUtils.isEmpty((Object)e.getChildField()) ? e.getFieldName() : String.format("%s_%s", e.getFieldName(), e.getChildField()))));
        HashMap<Long, JSONObject> mapMainData = new HashMap<Long, JSONObject>();
        int headersNum = ((ExcelImportCellVo)rowsFromExcel.get(0).getCells().get(0)).getRowspan();
        Long mainId = null;
        HashMap<String, Tuple2<Boolean, Boolean>> rowMerge = new HashMap<String, Tuple2<Boolean, Boolean>>();
        rowsFromExcel = this.excelImportHook(excelImportPreviewVo.getFormId(), form.getTableName(), excelImportPreviewVo.getAppId(), rowsFromExcel);
        for (int i = headersNum; i < rowsFromExcel.size(); ++i) {
            String err;
            List cells = rowsFromExcel.get(i).getCells();
            JSONObject jSONObject = new JSONObject();
            boolean isRowCkeck = true;
            if (HussarUtils.isNotEmpty((Object)matchs)) {
                ArrayList childCellAllEmpty = new ArrayList();
                ArrayList slaveFormSwitchColumns = Lists.newArrayListWithCapacity((int)5);
                for (int j = 0; j < matchs.size(); ++j) {
                    ExcelImportErrorVo excelImportErrorVo;
                    ExcelImportPreviewMatchVo excelImportPreviewMatchVo = (ExcelImportPreviewMatchVo)matchs.get(j);
                    ExcelImportCellVo excelImportCellVo = (ExcelImportCellVo)cells.get(excelImportPreviewMatchVo.getCol());
                    if (excelImportCellVo.getError()) {
                        int rowNum = i + 1;
                        if (!failRowNum.contains(rowNum)) {
                            failRowNum.add(rowNum);
                            ++failNum;
                        }
                        excelImportErrorVo = new ExcelImportErrorVo();
                        excelImportErrorVo.setRow(Integer.valueOf(excelImportCellVo.getRow()));
                        excelImportErrorVo.setCol(Integer.valueOf(excelImportCellVo.getCol()));
                        excelImportErrorVo.setType("0");
                        excelImportErrorVo.setFailMessage(excelImportCellVo.getErrorMes());
                        excelImportErrorVos.add(excelImportErrorVo);
                        continue;
                    }
                    Widget widget = nameWidgetMap.get(excelImportPreviewMatchVo.getFieldName());
                    if (HussarUtils.isNotEmpty((Object)excelImportPreviewMatchVo.getChildField())) {
                        String key = String.format("%s_%s", excelImportPreviewMatchVo.getFieldName(), excelImportPreviewMatchVo.getChildField());
                        widget = nameWidgetMap.get(key);
                        if (WidgetType.JXDNSwitch.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                            slaveFormSwitchColumns.add(key);
                        }
                        if (HussarUtils.isNotEmpty((Object)excelImportCellVo.getValue())) {
                            childCellAllEmpty.add(widget.getParentKey());
                        }
                    }
                    if (HussarUtils.isNotEmpty((Object)excelImportPreviewMatchVo.getChildField())) {
                        rowMerge.put(excelImportPreviewMatchVo.getFieldName(), (Tuple2<Boolean, Boolean>)Tuples.of((Object)excelImportCellVo.isMerge(), (Object)excelImportCellVo.isFirstMerge()));
                    } else {
                        rowMerge.put("", (Tuple2<Boolean, Boolean>)Tuples.of((Object)excelImportCellVo.isMerge(), (Object)excelImportCellVo.isFirstMerge()));
                    }
                    excelImportCellVo.setFieldType(widget.getType());
                    excelImportCellVo.setName(widget.getTitle());
                    excelImportCellVo.setFieldName(widget.getName());
                    excelImportErrorVo = this.checkCell(excelImportCellVo);
                    if (HussarUtils.isNotEmpty((Object)excelImportErrorVo)) {
                        ((ExcelImportCellVo)rowsFromExcel.get(i).getCells().get(excelImportErrorVo.getCol())).setError(true);
                        ((ExcelImportCellVo)rowsFromExcel.get(i).getCells().get(excelImportErrorVo.getCol())).setErrorMes(excelImportErrorVo.getFailMessage());
                        isRowCkeck = false;
                        logger.error("\u9a8c\u8bc1\u5931\u8d25\uff1a" + excelImportErrorVo.toString());
                        excelImportErrorVos.add(excelImportErrorVo);
                        continue;
                    }
                    try {
                        jSONObject = this.putCellValue(jSONObject, widget, excelImportCellVo.getValue(), sysData);
                        continue;
                    }
                    catch (Exception e2) {
                        isRowCkeck = false;
                        logger.error("\u6570\u636e\u5217\u201c" + widget.getTitle() + "\u201d\u53d6\u503c\u5931\u8d25;");
                        logger.error(e2.getMessage());
                        ExcelImportErrorVo excelImportError = new ExcelImportErrorVo();
                        excelImportError.setType(e2.getMessage());
                        excelImportError.setCol(Integer.valueOf(excelImportCellVo.getCol()));
                        excelImportError.setRow(Integer.valueOf(excelImportCellVo.getRow()));
                        excelImportError.setFailMessage(ExcelImportErrorType.getErrorMessageByType((String)e2.getMessage()));
                        excelImportErrorVos.add(excelImportError);
                        ((ExcelImportCellVo)rowsFromExcel.get(i).getCells().get(excelImportCellVo.getCol())).setError(true);
                        ((ExcelImportCellVo)rowsFromExcel.get(i).getCells().get(excelImportCellVo.getCol())).setErrorMes(ExcelImportErrorType.getErrorMessageByType((String)e2.getMessage()));
                    }
                }
                for (String slaveFormSwitchColumn : slaveFormSwitchColumns) {
                    boolean isEmpty = true;
                    Iterator widget = childCellAllEmpty.iterator();
                    while (widget.hasNext()) {
                        String s = (String)widget.next();
                        if (!slaveFormSwitchColumn.startsWith(s)) continue;
                        isEmpty = false;
                        break;
                    }
                    if (!isEmpty || !jSONObject.containsKey((Object)slaveFormSwitchColumn)) continue;
                    jSONObject.put(slaveFormSwitchColumn, null);
                }
                if (!isRowCkeck) {
                    int rowNum = i + 1;
                    failRowNum.add(rowNum);
                    if (!HussarUtils.isNotEmpty(rowMerge.get(""))) continue;
                    boolean isContainMerge = (Boolean)((Tuple2)rowMerge.get("")).getT1();
                    boolean isFirstMerge = (Boolean)((Tuple2)rowMerge.get("")).getT2();
                    if (isContainMerge && (!isContainMerge || !isFirstMerge)) continue;
                    ++failNum;
                    continue;
                }
            } else {
                for (Widget widget : widgets) {
                    if (!WidgetType.JXDNSwitch.getType().equals(widget.getType())) continue;
                    jSONObject.put(widget.getName(), (Object)0);
                }
            }
            jSONObject = this.putRowValue(jSONObject, form, matchs, nameWidgetMap, sysData);
            if (HussarUtils.isNotEmpty(rowMerge.get(""))) {
                boolean isContainMerge = (Boolean)((Tuple2)rowMerge.get("")).getT1();
                boolean isFirstMerge = (Boolean)((Tuple2)rowMerge.get("")).getT2();
                if (!isContainMerge || isContainMerge && isFirstMerge) {
                    mainId = System.currentTimeMillis() + (long)new Random().nextInt();
                    if (excelImportPreviewVo.getImportType() == 2) {
                        String recordId = jSONObject.get((Object)"RECORD_ID").toString();
                        HashMap params = new HashMap();
                        Filter idsFilter = new Filter();
                        ArrayList<Filter> filters = new ArrayList<Filter>();
                        idsFilter.setField("RECORD_ID");
                        idsFilter.setMatch("AND");
                        idsFilter.setRule("eq");
                        idsFilter.setVal(recordId);
                        filters.add(idsFilter);
                        Filter delFilter = new Filter();
                        delFilter.setField("DEL_FLAG");
                        delFilter.setMatch("AND");
                        delFilter.setRule("_ne");
                        delFilter.setVal("1");
                        filters.add(delFilter);
                        params.put("superQueryConditionDto", filters);
                        ResponseEntity apiResponse = this.formOperateExposedService.tableQueryByCondition(excelImportPreviewVo.getAppId(), excelImportPreviewVo.getFormId(), params);
                        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(apiResponse.getBody())).getData();
                        List dataTemp = pageData.getData();
                        if (!dataTemp.isEmpty()) {
                            mapMainData.put(mainId, jSONObject);
                        } else {
                            int rowNum = i;
                            if (!failRowNum.contains(rowNum)) {
                                failRowNum.add(rowNum);
                                ++failNum;
                            }
                            ExcelImportErrorVo excelImportErrorVo = new ExcelImportErrorVo();
                            excelImportErrorVo.setType(ExcelImportErrorType.DATANULL.getErrorType());
                            excelImportErrorVo.setFailMessage(ExcelImportErrorType.DATANULL.getErrorMessage());
                            excelImportErrorVo.setRow(Integer.valueOf(rowNum));
                            excelImportErrorVos.add(excelImportErrorVo);
                        }
                    } else {
                        mapMainData.put(mainId, new JSONObject());
                    }
                } else if (HussarUtils.isEmpty((Object)mainId)) {
                    continue;
                }
            } else {
                mainId = System.currentTimeMillis() + (long)new Random().nextInt();
                mapMainData.put(mainId, new JSONObject());
            }
            if (HussarUtils.isNull(mapMainData.get(mainId)) || (err = (String)this.createChildData(null, widgets, (JSONObject)mapMainData.get(mainId), jSONObject, rowMerge).orElse(null)) == null) continue;
            int rowNum = i + 1;
            if (!failRowNum.contains(rowNum)) {
                failRowNum.add(rowNum);
                ++failNum;
            }
            ExcelImportErrorVo excelImportError = new ExcelImportErrorVo();
            excelImportError.setType(err);
            excelImportError.setRow(Integer.valueOf(i + 1));
            excelImportError.setFailMessage(ExcelImportErrorType.getErrorMessageByType((String)err));
            excelImportErrorVos.add(excelImportError);
        }
        if (HussarUtils.isNotEmpty(failRowNum) || HussarUtils.isNotEmpty(excelImportErrorVos)) {
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5931\u8d25\u7684\u6570\u636e\u4e3a" + failRowNum);
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5931\u8d25\u7684\u63d0\u793a\u4fe1\u606f\uff08\u884c\u6570\u6309\u7167Excel\u7684\uff0c\u5373\u4ece0\u5f00\u59cb\uff09\u4e3a" + ((Object)excelImportErrorVos).toString());
        }
        ArrayList importList = new ArrayList(mapMainData.values());
        excelImportResultVo.setFailRowNums(failRowNum);
        excelImportResultVo.setDataList(importList);
        excelImportResultVo.setInsertNum(importList.size());
        excelImportResultVo.setFailNum(failNum);
        List<String> failMessage = this.dealExcelImportErrorVos(excelImportErrorVos);
        excelImportResultVo.setFailMessages(failMessage);
        excelImportResultVo.setExcelImportErrorVos(excelImportErrorVos);
        excelImportResultVo.setSheetIndex(excelImportPreviewVo.getSheetIndex());
        return excelImportResultVo;
    }

    private void deleteFileCopy(List<Integer> rowsToDelete, Sheet sheetCopy) {
        Collections.sort(rowsToDelete, Collections.reverseOrder());
        for (int rowIndex : rowsToDelete) {
            ExcelImport.removeRow(sheetCopy, rowIndex);
        }
    }

    private static void removeRow(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            sheet.removeRow(row);
        }
        if (rowIndex < sheet.getLastRowNum()) {
            sheet.shiftRows(rowIndex + 1, sheet.getLastRowNum(), -1);
        }
    }

    private List<ExcelImportErrorVo> getCopyErrorVos(int excelDeleteNumfirstError, List<ExcelImportErrorVo> excelImportErrorVos) {
        ArrayList errorVos = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isEmpty(excelImportErrorVos)) {
            return errorVos;
        }
        int errorNum = 0;
        TreeMap collectMap = excelImportErrorVos.stream().collect(Collectors.groupingBy(ExcelImportErrorVo::getRow, TreeMap::new, Collectors.toList()));
        boolean firstFlag = false;
        for (Map.Entry m : collectMap.entrySet()) {
            ExcelImportErrorVo voCopy;
            if (!firstFlag) {
                for (ExcelImportErrorVo e : (List)m.getValue()) {
                    voCopy = (ExcelImportErrorVo)JSON.parseObject((String)JSON.toJSONString((Object)e), ExcelImportErrorVo.class);
                    errorNum = voCopy.getRow() - excelDeleteNumfirstError;
                    voCopy.setRow(Integer.valueOf(errorNum));
                    errorVos.add(voCopy);
                }
                firstFlag = true;
                continue;
            }
            ++errorNum;
            for (ExcelImportErrorVo e : (List)m.getValue()) {
                voCopy = (ExcelImportErrorVo)JSON.parseObject((String)JSON.toJSONString((Object)e), ExcelImportErrorVo.class);
                voCopy.setRow(Integer.valueOf(errorNum));
                errorVos.add(voCopy);
            }
        }
        return errorVos;
    }

    public void dealLinkForm(Widget widget, JSONObject data, JSONObject row) {
        String fieldType = widget.getType();
        String field = widget.getName();
        String refId = String.format("%s_%s", field, "ref_id");
        String refChildId = String.format("%s_%s", field, "ref_child_id");
        switch (fieldType) {
            case "JXDNLinkForm": {
                String val = row.getString(ToolUtil.isEmpty((Object)widget.getParentKey()) ? widget.getName() : String.format("%s_%s", widget.getParentKey(), widget.getName()));
                if (!HussarUtils.isNotEmpty((Object)widget) || !HussarUtils.isNotEmpty((Object)val)) break;
                data.put(field, row.get((Object)field));
                JSONObject linkTableInfo = widget.getProps().getJSONObject("linkTableInfo");
                String linkFormName = linkTableInfo.getString("formName");
                String linkFormId = linkTableInfo.getString("formId");
                String linkAppId = linkTableInfo.getString("appId");
                String filedName = linkTableInfo.getJSONObject("linkFieldInfo").getString("name");
                String childTableName = linkTableInfo.getJSONObject("linkFieldInfo").getString("parent");
                HashMap newParam = new HashMap();
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put("rule", "_eq");
                filter.put("val", val);
                filter.put("match", "AND");
                filter.put("field", filedName);
                ArrayList<HashMap<String, String>> filters = new ArrayList<HashMap<String, String>>();
                filters.add(filter);
                newParam.put("superQueryConditionDto", filters);
                ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(linkAppId, linkFormId, newParam);
                PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
                List dataTemp = pageData.getData();
                Map maxMap = dataTemp.stream().max(Comparator.comparing(map -> Long.parseLong((String)map.get(linkFormName)))).orElse(null);
                if (maxMap != null) {
                    if (ToolUtil.isEmpty((Object)widget.getParentKey())) {
                        data.put(refId, maxMap.get("RECORD_ID"));
                        data.put(refChildId, null);
                        break;
                    }
                    data.put(refId, maxMap.get("RECORD_ID"));
                    data.put(refChildId, maxMap.get("RECORD_ID"));
                    break;
                }
                data.put(refId, null);
                data.put(refChildId, null);
                break;
            }
            case "JXDNLinkFormMulti": {
                ArrayList refIds = Lists.newArrayListWithCapacity((int)5);
                ArrayList refChildIds = Lists.newArrayListWithCapacity((int)5);
                String vals = row.getString(ToolUtil.isEmpty((Object)widget.getParentKey()) ? widget.getName() : String.format("%s_%s", widget.getParentKey(), widget.getName()));
                if (HussarUtils.isNotEmpty((Object)vals)) {
                    for (String valT : vals.split(",")) {
                        if (!HussarUtils.isNotEmpty((Object)widget) || !HussarUtils.isNotEmpty((Object)valT)) continue;
                        data.put(field, row.get((Object)field));
                        JSONObject linkTableInfo = widget.getProps().getJSONObject("linkTableInfo");
                        String linkFormName = linkTableInfo.getString("formName");
                        String linkFormId = linkTableInfo.getString("formId");
                        String linkAppId = linkTableInfo.getString("appId");
                        String filedName = linkTableInfo.getJSONObject("linkFieldInfo").getString("name");
                        String childTableName = linkTableInfo.getJSONObject("linkFieldInfo").getString("parent");
                        HashMap newParam = new HashMap();
                        HashMap<String, String> filter = new HashMap<String, String>();
                        filter.put("rule", "_eq");
                        filter.put("val", valT);
                        filter.put("match", "AND");
                        filter.put("field", filedName);
                        ArrayList<HashMap<String, String>> filters = new ArrayList<HashMap<String, String>>();
                        filters.add(filter);
                        newParam.put("superQueryConditionDto", filters);
                        ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(linkAppId, linkFormId, newParam);
                        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
                        List dataTemp = pageData.getData();
                        Map maxMap = dataTemp.stream().max(Comparator.comparing(map -> Long.parseLong((String)map.get(linkFormName)))).orElse(null);
                        if (maxMap == null) continue;
                        if (ToolUtil.isEmpty((Object)widget.getParentKey())) {
                            if (!HussarUtils.isNotEmpty(maxMap.get("RECORD_ID"))) continue;
                            refIds.add((String)maxMap.get("RECORD_ID"));
                            continue;
                        }
                        if (!HussarUtils.isNotEmpty(maxMap.get("RECORD_ID"))) continue;
                        refIds.add((String)maxMap.get("RECORD_ID"));
                        refChildIds.add((String)maxMap.get("RECORD_ID"));
                    }
                }
                if (HussarUtils.isNotEmpty((Object)refIds)) {
                    data.put(refId, (Object)refIds.stream().collect(Collectors.joining(",")));
                } else {
                    data.put(refId, null);
                }
                if (HussarUtils.isNotEmpty((Object)refChildIds)) {
                    data.put(refChildId, (Object)refChildIds.stream().collect(Collectors.joining(",")));
                    break;
                }
                data.put(refChildId, null);
                break;
            }
        }
    }

    public List<ExcelImportRowVo> excelImportHook(String formId, String tableName, String appId, List<ExcelImportRowVo> rowsFromExcel) {
        ExcelVerifyHookDto excelVerifyHookDto = new ExcelVerifyHookDto();
        excelVerifyHookDto.setFormId(formId);
        excelVerifyHookDto.setAppId(appId);
        List rowHookDtos = JsonUtil.parseArray((String)JsonUtil.toJson(rowsFromExcel), ExcelImportRowHookDto.class);
        excelVerifyHookDto.setRowHookDtos(rowHookDtos);
        this.hookUtil.excelImportDataVerifyHook(tableName, excelVerifyHookDto);
        return JsonUtil.parseArray((String)JsonUtil.toJson((Object)excelVerifyHookDto.getRowHookDtos()), ExcelImportRowVo.class);
    }

    public List<String> dealExcelImportErrorVos(List<ExcelImportErrorVo> excelImportErrorVos) {
        ArrayList<String> failMessge = new ArrayList<String>();
        Map<String, List<ExcelImportErrorVo>> mapTypeExcelImportErrorVo = excelImportErrorVos.stream().collect(Collectors.groupingBy(ExcelImportErrorVo::getType));
        for (Map.Entry<String, List<ExcelImportErrorVo>> entry : mapTypeExcelImportErrorVo.entrySet()) {
            String errorType = entry.getKey();
            List<ExcelImportErrorVo> vos = entry.getValue();
            ArrayList<String> rowSet = new ArrayList<String>();
            String rowString = "\u7b2c";
            for (int i = 0; i < vos.size(); ++i) {
                int newRow = vos.get(i).getRow() + 1;
                if (rowSet.contains(String.valueOf(newRow))) continue;
                rowSet.add(String.valueOf(newRow));
                if (i != 0) {
                    rowString = rowString + ",";
                }
                rowString = rowString + newRow;
            }
            rowString = rowString + "\u884c\u9519\u8bef\uff01";
            String error = ExcelImportErrorType.getErrorMessageByType((String)errorType) + ":" + rowString;
            failMessge.add(error);
        }
        return failMessge;
    }

    public JSONObject putRowValue(JSONObject jSONObject, SysForm form, List<ExcelImportPreviewMatchVo> matchs, Map<String, Widget> nameWidgetMap, JSONObject sysData) {
        HashMap<String, Widget> addressWidget = new HashMap<String, Widget>();
        for (ExcelImportPreviewMatchVo excelImportPreviewMatchVo : matchs) {
            String key;
            Widget widget = nameWidgetMap.get(excelImportPreviewMatchVo.getFieldName());
            if (excelImportPreviewMatchVo.getChildField() != null && (widget = nameWidgetMap.get(key = String.format("%s_%s", excelImportPreviewMatchVo.getFieldName(), excelImportPreviewMatchVo.getChildField()))) == null) {
                Map<String, Widget> map = this.flatByTableAndFieldName(nameWidgetMap.values());
                widget = map.get(key);
            }
            if (WidgetType.ADDRESS.getType().equals(widget.getType()) && widget.getIsInChild()) {
                String oldKey = String.format("%s_%s", widget.getParentKey(), widget.getOldName());
                addressWidget.put(oldKey, widget);
                continue;
            }
            if (!WidgetType.ADDRESS.getType().equals(widget.getType())) continue;
            addressWidget.put(widget.getOldName(), widget);
        }
        if (addressWidget.entrySet().size() > 0) {
            for (Map.Entry entry : addressWidget.entrySet()) {
                Map nameRegionVoMap;
                RegionVo regionVo;
                List regionVos;
                Long currentCode;
                String oldName = (String)entry.getKey();
                Widget widget = (Widget)entry.getValue();
                Map parentIdRegionVoMap = (Map)sysData.get((Object)"parentIdRegionVoMap");
                JSONObject props = widget.getProps();
                int addressLevel = props.getInteger("addressLevel") == null ? 1 : props.getInteger("addressLevel");
                String address = "";
                String province = jSONObject.get((Object)(oldName + "_province")) == null ? "" : jSONObject.get((Object)(oldName + "_province")).toString();
                String city = jSONObject.get((Object)(oldName + "_city")) == null ? "" : jSONObject.get((Object)(oldName + "_city")).toString();
                String town = jSONObject.get((Object)(oldName + "_town")) == null ? "" : jSONObject.get((Object)(oldName + "_town")).toString();
                String street = jSONObject.get((Object)(oldName + "_street")) == null ? "" : jSONObject.get((Object)(oldName + "_street")).toString();
                String code = null;
                Long parentId = null;
                if (addressLevel >= 1) {
                    parentId = 0L;
                    address = address + province;
                    currentCode = null;
                    if (parentId != null && (regionVos = (List)parentIdRegionVoMap.get(parentId)) != null && regionVos.size() > 0 && (regionVo = (RegionVo)(nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1))).get(province)) != null) {
                        currentCode = regionVo.getId();
                    }
                    if (currentCode != null) {
                        code = currentCode.toString();
                        parentId = currentCode;
                    } else {
                        code = "00";
                        parentId = null;
                    }
                }
                if (addressLevel >= 2) {
                    address = address + " / " + city;
                    currentCode = null;
                    if (parentId != null && (regionVos = (List)parentIdRegionVoMap.get(parentId)) != null && regionVos.size() > 0 && (regionVo = (RegionVo)(nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1))).get(city)) != null) {
                        currentCode = regionVo.getId();
                    }
                    if (currentCode != null) {
                        code = currentCode.toString();
                        parentId = currentCode;
                    } else {
                        code = code + "00";
                        parentId = null;
                    }
                }
                if (addressLevel >= 3) {
                    address = address + " / " + town;
                    currentCode = null;
                    if (parentId != null && (regionVos = (List)parentIdRegionVoMap.get(parentId)) != null && regionVos.size() > 0 && (regionVo = (RegionVo)(nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1))).get(town)) != null) {
                        currentCode = regionVo.getId();
                    }
                    if (currentCode != null) {
                        code = currentCode.toString();
                        parentId = currentCode;
                    } else {
                        code = code + "00";
                        parentId = null;
                    }
                }
                if (addressLevel >= 4) {
                    address = address + " / " + street;
                    currentCode = null;
                    if (HussarUtils.isNotEmpty((Object)parentId) && HussarUtils.isNotEmpty((Object)(regionVos = (List)parentIdRegionVoMap.get(parentId))) && (regionVo = (RegionVo)(nameRegionVoMap = regionVos.stream().collect(Collectors.toMap(RegionVo::getName, Function.identity(), (v1, v2) -> v1))).get(street)) != null) {
                        currentCode = regionVo.getId();
                    }
                    if (HussarUtils.isNotEmpty((Object)currentCode)) {
                        code = currentCode.toString();
                        parentId = currentCode;
                    } else {
                        code = code + "00";
                        parentId = null;
                    }
                }
                if (address.replace(" / ", "").trim().equals("")) continue;
                jSONObject.put(oldName + "_label", (Object)address);
                jSONObject.put(oldName + "_code", (Object)code);
            }
        }
        return jSONObject;
    }

    public JSONObject putCellValue(JSONObject jSONObject, Widget widget, String cellValue, JSONObject sysData) throws Exception {
        String fieldType = widget.getType();
        String fieldName = widget.getName();
        if (widget.getIsInChild()) {
            fieldName = String.format("%s_%s", widget.getParentKey(), fieldName);
        }
        if (HussarUtils.isEmpty((Object)(cellValue = cellValue.trim()))) {
            if (fieldType.equals(WidgetType.JXDNSwitch.getType())) {
                jSONObject.put(fieldName, (Object)0);
            } else {
                if (fieldType.equals(WidgetType.JXDNSecurityLevel.getType())) {
                    throw new Exception("10");
                }
                jSONObject.put(fieldName, (Object)cellValue);
            }
            return jSONObject;
        }
        if (fieldType.equals(WidgetType.DATE.getType())) {
            SimpleDateFormat dateFormat;
            String format2;
            Date date = null;
            try {
                if (cellValue.length() == 19) {
                    format2 = "yyyy-MM-dd HH:mm:ss";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format2) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty(date) && cellValue.length() == 16) {
                    format2 = "yyyy-MM-dd HH:mm";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format3) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty(date) && cellValue.length() == 13) {
                    format2 = "yyyy-MM-dd HH";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format4) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty(date) && cellValue.length() == 10) {
                    format2 = "yyyy-MM-dd";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format5) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty(date) && cellValue.length() == 7) {
                    format2 = "yyyy-MM";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format6) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty((Object)date) && cellValue.length() == 8) {
                    format2 = "yyyyMMdd";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format7) {
                // empty catch block
            }
            try {
                if (HussarUtils.isEmpty((Object)date) && cellValue.length() == 4) {
                    format2 = "yyyy";
                    dateFormat = new SimpleDateFormat(format2);
                    date = dateFormat.parse(cellValue);
                }
            }
            catch (Exception format8) {
                // empty catch block
            }
            if (HussarUtils.isNotEmpty((Object)date)) {
                jSONObject.put(fieldName, (Object)date);
                return jSONObject;
            }
            throw new Exception(ExcelImportErrorType.TIME.getErrorType());
        }
        if (fieldType.equals(WidgetType.RADIO_GROUP.getType()) || fieldType.equals(WidgetType.SELECT.getType())) {
            Map<String, String> labelValue = this.getLabelValue(widget);
            jSONObject.put(fieldName + "_label", (Object)cellValue);
            if (labelValue.get(cellValue) == null) {
                logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5355\u9009\u5339\u914d\u5931\u8d25\uff0c\u503c\u4e3a\uff1a{}", (Object)cellValue);
                jSONObject.put(fieldName, (Object)cellValue);
            } else {
                jSONObject.put(fieldName, (Object)labelValue.get(cellValue));
            }
        } else if (fieldType.equals(WidgetType.CHECK_BOX_GROUP.getType()) || fieldType.equals(WidgetType.SELECT_MUL.getType())) {
            String[] lables = cellValue.split(",");
            ArrayList<String> labelList = new ArrayList<String>();
            String value = "";
            Map<String, String> labelValue = this.getLabelValue(widget);
            boolean isTrue = true;
            for (int jj = 0; jj < lables.length; ++jj) {
                if (jj != 0) {
                    value = value + ",";
                }
                labelList.add(lables[jj]);
                String value1 = labelValue.get(lables[jj]);
                if (value1 == null) {
                    value1 = lables[jj];
                    isTrue = false;
                }
                value = value + value1;
            }
            if (!isTrue) {
                logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u590d\u9009\u5339\u914d\u5931\u8d25\u503c\u4e3a\uff1a{}", (Object)cellValue);
                jSONObject.put(fieldName, (Object)value);
                jSONObject.put(fieldName + "_label", (Object)JSON.toJSONString(labelList));
            } else {
                jSONObject.put(fieldName, (Object)value);
                jSONObject.put(fieldName + "_label", (Object)JSON.toJSONString(labelList));
            }
        } else if (fieldType.equals(WidgetType.JXDNSwitch.getType())) {
            List options = (List)widget.getProps().get((Object)"textEntry");
            boolean isTrue = false;
            for (int i = 0; i < options.size(); ++i) {
                if (!cellValue.equals(options.get(i))) continue;
                jSONObject.put(fieldName, (Object)i);
                isTrue = true;
                break;
            }
            if (!isTrue) {
                throw new Exception(ExcelImportErrorType.YES_OR_NO.getErrorType());
            }
        } else if (fieldType.equals(WidgetType.JXDNUser.getType())) {
            Map mapUserNameSysUsers;
            SysUsers sysUser;
            if (HussarUtils.isNotEmpty((Object)cellValue) && cellValue.contains("(") && cellValue.contains(")")) {
                cellValue = cellValue.substring(0, cellValue.indexOf("(")).trim();
            }
            List allUsers = new ArrayList();
            if (sysData.get((Object)"allUsers") != null) {
                allUsers = (List)sysData.get((Object)"allUsers");
            }
            if ((sysUser = (SysUsers)(mapUserNameSysUsers = allUsers.stream().filter(sysUsers -> "1".equals(sysUsers.getAccountStatus())).collect(Collectors.toMap(SysUsers::getUserName, Function.identity(), (key1, key2) -> key1))).get(cellValue)) == null) {
                throw new Exception(ExcelImportErrorType.USER.getErrorType());
            }
            ArrayList<JSONObject> user = new ArrayList<JSONObject>();
            JSONObject userObject = new JSONObject();
            userObject.put("label", (Object)sysUser.getUserName());
            userObject.put("id", (Object)String.valueOf(sysUser.getId()));
            user.add(userObject);
            jSONObject.put(fieldName, (Object)JSON.toJSONString(user));
            jSONObject.put(fieldName + "_label", (Object)sysUser.getUserName());
            jSONObject.put(fieldName + "_id", (Object)sysUser.getId());
        } else if (fieldType.equals(WidgetType.JXDNUserMulti.getType())) {
            if (HussarUtils.isNotEmpty((Object)cellValue)) {
                StringBuilder userLabelStringBuilder = new StringBuilder();
                String[] userLabels = cellValue.split(",");
                for (int i = 0; i < userLabels.length; ++i) {
                    if (userLabels[i].contains("(") && userLabels[i].contains(")")) {
                        userLabels[i] = userLabels[i].substring(0, userLabels[i].indexOf("(")).trim();
                    }
                    if (i != userLabels.length - 1) {
                        userLabelStringBuilder.append(userLabels[i]).append(",");
                        continue;
                    }
                    userLabelStringBuilder.append(userLabels[i]);
                }
                cellValue = userLabelStringBuilder.toString();
            }
            List allUsers = new ArrayList();
            if (sysData.get((Object)"allUsers") != null) {
                allUsers = (List)sysData.get((Object)"allUsers");
            }
            Map mapUserNameSysUsers = allUsers.stream().filter(sysUsers -> "1".equals(sysUsers.getAccountStatus())).collect(Collectors.toMap(SysUsers::getUserName, Function.identity(), (key1, key2) -> key1));
            String[] lables = cellValue.split(",");
            String userId = "";
            String userName = "";
            ArrayList<JSONObject> user = new ArrayList<JSONObject>();
            for (int i = 0; i < lables.length; ++i) {
                String label = lables[i];
                SysUsers sysUser = (SysUsers)mapUserNameSysUsers.get(label);
                if (sysUser == null) {
                    throw new Exception(ExcelImportErrorType.USER.getErrorType());
                }
                JSONObject json = new JSONObject();
                json.put("label", (Object)label);
                json.put("id", (Object)String.valueOf(sysUser.getId()));
                user.add(json);
                if (i != 0) {
                    userId = userId + ",";
                    userName = userName + ",";
                }
                userId = userId + sysUser.getId();
                userName = userName + label;
            }
            jSONObject.put(fieldName + "_label", (Object)userName);
            jSONObject.put(fieldName + "_id", (Object)userId);
            jSONObject.put(fieldName, (Object)JSON.toJSONString(user));
            if (fieldName.equals("createUserName")) {
                jSONObject.put("createUserName", (Object)userName);
                jSONObject.put("createUser_user", (Object)userName);
            }
            if (fieldName.equals("updateUserName")) {
                jSONObject.put("updateUserName", (Object)userName);
                jSONObject.put("updateUser_user", (Object)userName);
            }
        } else if (fieldType.equals(WidgetType.JXDNOrg.getType())) {
            Map mapOrganNameSysOrgans;
            OrganizationBo sysOrgan;
            if (HussarUtils.isNotEmpty((Object)cellValue) && (cellValue.contains("/") || cellValue.contains("-"))) {
                if (cellValue.contains("/")) {
                    cellValue = cellValue.split("/")[cellValue.split("/").length - 1].trim();
                } else if (cellValue.contains("-")) {
                    cellValue = cellValue.split("-")[cellValue.split("-").length - 1].trim();
                }
            }
            List allOrgans = new ArrayList();
            if (sysData.get((Object)"allOrgans") != null) {
                allOrgans = (List)sysData.get((Object)"allOrgans");
            }
            if ((sysOrgan = (OrganizationBo)(mapOrganNameSysOrgans = allOrgans.stream().collect(Collectors.toMap(OrganizationBo::getOrganName, Function.identity(), (key1, key2) -> key1))).get(cellValue)) == null) {
                throw new Exception(ExcelImportErrorType.ORGAN.getErrorType());
            }
            ArrayList<JSONObject> organ = new ArrayList<JSONObject>();
            JSONObject organObject = new JSONObject();
            organObject.put("label", (Object)sysOrgan.getOrganName());
            organObject.put("id", (Object)String.valueOf(sysOrgan.getId()));
            organ.add(organObject);
            jSONObject.put(fieldName, (Object)JSON.toJSONString(organ));
            jSONObject.put(fieldName + "_label", (Object)sysOrgan.getOrganName());
            jSONObject.put(fieldName + "_id", (Object)sysOrgan.getId());
        } else if (fieldType.equals(WidgetType.JXDNOrgMulti.getType())) {
            if (HussarUtils.isNotEmpty((Object)cellValue)) {
                StringBuilder orgLabelStringBuilder = new StringBuilder();
                String[] orgLabels = cellValue.split(",");
                for (int i = 0; i < orgLabels.length; ++i) {
                    String orgLabel = orgLabels[i];
                    if (orgLabel.contains("/")) {
                        orgLabel = orgLabel.split("/")[orgLabel.split("/").length - 1];
                    } else if (cellValue.contains("-")) {
                        orgLabel = orgLabel.split("-")[orgLabel.split("-").length - 1];
                    }
                    orgLabels[i] = orgLabel.trim();
                    if (i != orgLabels.length - 1) {
                        orgLabelStringBuilder.append(orgLabels[i]).append(",");
                        continue;
                    }
                    orgLabelStringBuilder.append(orgLabels[i]);
                }
                cellValue = orgLabelStringBuilder.toString();
            }
            List allOrgans = new ArrayList();
            if (sysData.get((Object)"allOrgans") != null) {
                allOrgans = (List)sysData.get((Object)"allOrgans");
            }
            Map mapOrganNameSysOrgans = allOrgans.stream().collect(Collectors.toMap(OrganizationBo::getOrganName, Function.identity(), (key1, key2) -> key1));
            String[] lables = cellValue.split(",");
            StringBuilder organId = new StringBuilder();
            StringBuilder organName = new StringBuilder();
            ArrayList<JSONObject> organList = new ArrayList<JSONObject>();
            for (int i = 0; i < lables.length; ++i) {
                String label = lables[i];
                OrganizationBo sysOrgan = (OrganizationBo)mapOrganNameSysOrgans.get(label);
                if (sysOrgan == null) {
                    throw new Exception(ExcelImportErrorType.ORGAN.getErrorType());
                }
                JSONObject json = new JSONObject();
                json.put("label", (Object)label);
                json.put("id", (Object)String.valueOf(sysOrgan.getId()));
                organList.add(json);
                if (i != 0) {
                    organId.append(",");
                    organName.append(",");
                }
                organId.append(sysOrgan.getId());
                organName.append(label);
            }
            jSONObject.put(fieldName + "_label", (Object)organName.toString());
            jSONObject.put(fieldName + "_id", (Object)organId.toString());
            jSONObject.put(fieldName, (Object)JSON.toJSONString(organList));
        } else if (fieldType.equals(WidgetType.NUMBER.getType())) {
            jSONObject.put(fieldName, (Object)cellValue);
        } else if (fieldType.equals(WidgetType.JXDN_CASCADER.getType())) {
            JSONObject labelObject = new JSONObject();
            labelObject.put("label", (Object)Lists.newArrayList((Object[])new String[]{cellValue}));
            jSONObject.put(fieldName + "_label", (Object)JSON.toJSONString((Object)labelObject));
            jSONObject.put(fieldName, (Object)cellValue);
        } else if (fieldType.equals(WidgetType.JXDN_CASCADER_MULTI.getType())) {
            String[] labels = cellValue.split(",");
            ArrayList<JSONObject> labelList = new ArrayList<JSONObject>();
            for (String label : labels) {
                JSONObject labelObject = new JSONObject();
                labelObject.put("label", (Object)Lists.newArrayList((Object[])new String[]{label}));
                labelList.add(labelObject);
            }
            jSONObject.put(fieldName + "_label", (Object)JSON.toJSONString(labelList));
            jSONObject.put(fieldName, (Object)cellValue);
        } else if (fieldType.equals(WidgetType.JXDNSecurityLevel.getType())) {
            int userSecurityLevel = (Integer)((UserDetails)TransmittableThreadLocalHolder.get((String)"loginUserDetails")).getExtendUserMap().get("securityLevel");
            List dicListByType = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
            boolean found = false;
            for (DicLevelTreeVo dicLevelTreeVo : dicListByType) {
                if (!dicLevelTreeVo.getLabel().equals(cellValue)) continue;
                if (userSecurityLevel < Integer.parseInt(dicLevelTreeVo.getValue())) {
                    throw new Exception("11");
                }
                jSONObject.put(fieldName + "_label", (Object)cellValue);
                jSONObject.put(fieldName, (Object)dicLevelTreeVo.getValue());
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("10");
            }
        } else {
            jSONObject.put(fieldName, (Object)cellValue);
        }
        return jSONObject;
    }

    private Map<String, String> getLabelValue(Widget widget) {
        HashMap<String, String> labelValue = new HashMap<String, String>();
        String optionType = widget.getProps().get((Object)"optionType").toString();
        if (HussarUtils.equals((Object)optionType, (Object)"dict")) {
            JSONObject dictParams = JSON.parseObject((String)JSON.toJSONString((Object)widget.getProps().get((Object)"dict")));
            String dictId = dictParams.get((Object)"dictId").toString();
            List levelDictByType = this.sysDicRefService.getLevelDictByType(Long.valueOf(dictId));
            for (DicLevelTreeVo dicLevelTreeVo : levelDictByType) {
                labelValue.put(dicLevelTreeVo.getLabel(), dicLevelTreeVo.getValue());
            }
        } else {
            List options = (List)widget.getProps().get((Object)"options");
            for (Map option : options) {
                labelValue.put(option.get("label").toString(), option.get("value").toString());
            }
        }
        return labelValue;
    }

    public Optional<String> createChildData(String pname, List<Widget> widgets, JSONObject data, JSONObject row, Map<String, Tuple2<Boolean, Boolean>> rowMerge) {
        if (HussarUtils.isNotEmpty((Object)row)) {
            List ws = WidgetTool.flatButNotChildrenWithSecurityLevel(new ArrayList(), widgets, (boolean)true);
            for (Widget widget : ws) {
                String key = widget.getName();
                this.dealLinkForm(widget, data, row);
                if (pname != null) {
                    key = String.format("%s_%s", widget.getParentKey(), key);
                }
                String oldkey = "";
                oldkey = pname != null ? String.format("%s_%s", pname, widget.getOldName()) : widget.getOldName();
                if (row.get((Object)(key + "_id")) != null) {
                    data.put(widget.getName() + "_id", row.get((Object)(key + "_id")));
                }
                if (row.get((Object)(key + "_label")) != null) {
                    data.put(widget.getName() + "_label", row.get((Object)(key + "_label")));
                }
                if (WidgetType.ADDRESS.getType().equals(widget.getType())) {
                    if (row.get((Object)(oldkey + "_code")) != null) {
                        data.put(widget.getOldName() + "_code", row.get((Object)(oldkey + "_code")));
                    }
                    if (row.get((Object)(oldkey + "_detailed")) != null) {
                        data.put(widget.getOldName() + "_detailed", row.get((Object)(oldkey + "_detailed")));
                    }
                    if (row.get((Object)(oldkey + "_label")) != null) {
                        data.put(widget.getOldName() + "_label", row.get((Object)(oldkey + "_label")));
                    }
                }
                if (HussarUtils.isNotEmpty((Object)row.get((Object)key))) {
                    data.put(widget.getName(), row.get((Object)key));
                }
                if (HussarUtils.isEmpty((Object)pname)) {
                    if (!HussarUtils.isNotEmpty((Object)row.get((Object)"RECORD_ID"))) continue;
                    data.put("RECORD_ID", row.get((Object)"RECORD_ID"));
                    continue;
                }
                if (!HussarUtils.isNotEmpty((Object)row.get((Object)(pname + "_RECORD_ID")))) continue;
                data.put("RECORD_ID", row.get((Object)(pname + "_RECORD_ID")));
            }
            List tables = WidgetTool.flatButChildren(new ArrayList(), widgets);
            for (Widget widget : tables) {
                ArrayList<JSONObject> list;
                Tuple2<Boolean, Boolean> merge = rowMerge.get(widget.getName());
                this.dealLinkForm(widget, data, row);
                if (merge == null) {
                    if (!HussarUtils.isNotEmpty((Object)widget.getChildren())) continue;
                    ArrayList<JSONObject> listJSON = new ArrayList<JSONObject>();
                    listJSON.add(new JSONObject());
                    data.put(widget.getName(), listJSON);
                    List list2 = (List)data.get((Object)widget.getName());
                    JSONObject cd = (JSONObject)list2.get(list2.size() - 1);
                    String err = this.createChildData(widget.getName(), widget.getChildren(), cd, row, rowMerge).orElse(null);
                    if (cd.isEmpty()) {
                        list2.remove(cd);
                    }
                    if (err == null) continue;
                    return Optional.of(err);
                }
                if (!((Boolean)merge.getT1()).booleanValue() || ((Boolean)merge.getT1()).booleanValue() && ((Boolean)merge.getT2()).booleanValue()) {
                    list = (ArrayList<JSONObject>)data.get((Object)widget.getName());
                    if (list == null) {
                        list = new ArrayList<JSONObject>();
                        data.put(widget.getName(), list);
                    }
                    list.add(new JSONObject());
                }
                if (CollUtil.isEmpty(list = (List)data.get((Object)widget.getName()))) {
                    return Optional.of(ExcelImportErrorType.NOT_CONNECT.getErrorType());
                }
                JSONObject cd = (JSONObject)list.get(list.size() - 1);
                String err = this.createChildData(widget.getName(), widget.getChildren(), cd, row, rowMerge).orElse(null);
                if (cd.isEmpty()) {
                    list.remove(cd);
                }
                if (err == null) continue;
                return Optional.of(err);
            }
        }
        return Optional.empty();
    }

    public ExcelImportErrorVo checkCell(ExcelImportCellVo excelImportCellVo) {
        if (excelImportCellVo.getFieldType() == null) {
            ExcelImportErrorVo excelImportErrorVo = new ExcelImportErrorVo();
            excelImportErrorVo.setRow(Integer.valueOf(excelImportCellVo.getRow()));
            excelImportErrorVo.setCol(Integer.valueOf(excelImportCellVo.getCol()));
            excelImportErrorVo.setType(ExcelImportErrorType.WIDGETNULL.getErrorType());
            excelImportErrorVo.setFailMessage(ExcelImportErrorType.WIDGETNULL.getErrorMessage());
            logger.error("\u6570\u636e\u5217\u201c" + excelImportCellVo.getName() + "\u201d\u7684\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u9a8c\u8bc1\u5931\u8d25;");
            return excelImportErrorVo;
        }
        if (excelImportCellVo.getValue() == null || "".equals(excelImportCellVo.getValue())) {
            return null;
        }
        if (excelImportCellVo.getFieldType().equals(WidgetType.NUMBER.getType())) {
            try {
                Double value = Double.valueOf(excelImportCellVo.getValue());
                return null;
            }
            catch (Exception e) {
                ExcelImportErrorVo excelImportErrorVo = new ExcelImportErrorVo();
                excelImportErrorVo.setRow(Integer.valueOf(excelImportCellVo.getRow()));
                excelImportErrorVo.setCol(Integer.valueOf(excelImportCellVo.getCol()));
                excelImportErrorVo.setType(ExcelImportErrorType.NUMBER.getErrorType());
                excelImportErrorVo.setFailMessage(ExcelImportErrorType.NUMBER.getErrorMessage());
                logger.error("\u6570\u636e\u5217\u201c" + excelImportCellVo.getName() + "\u201d\u89e3\u6790\u9519\u8bef\uff0c\u201c" + excelImportCellVo.getValue() + "\u201d\u4e0d\u662f\u6570\u5b57\u683c\u5f0f\uff0c\u9a8c\u8bc1\u5931\u8d25;");
                return excelImportErrorVo;
            }
        }
        if (excelImportCellVo.getFieldType().equals(WidgetType.DATE.getType())) {
            boolean isDataTime = false;
            try {
                String format = "yyyy-MM-dd HH:mm:ss";
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                dateFormat.parse(excelImportCellVo.getValue());
                isDataTime = true;
                return null;
            }
            catch (Exception format) {
                try {
                    String format2 = "yyyy-MM-dd HH:mm";
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format2);
                    dateFormat.parse(excelImportCellVo.getValue());
                    isDataTime = true;
                    return null;
                }
                catch (Exception format2) {
                    try {
                        String format3 = "yyyy-MM-dd HH";
                        SimpleDateFormat dateFormat = new SimpleDateFormat(format3);
                        dateFormat.parse(excelImportCellVo.getValue());
                        isDataTime = true;
                        return null;
                    }
                    catch (Exception format3) {
                        try {
                            String format4 = "yyyy-MM-dd";
                            SimpleDateFormat dateFormat = new SimpleDateFormat(format4);
                            dateFormat.parse(excelImportCellVo.getValue());
                            isDataTime = true;
                            return null;
                        }
                        catch (Exception format4) {
                            try {
                                String format5 = "yyyy-MM";
                                SimpleDateFormat dateFormat = new SimpleDateFormat(format5);
                                dateFormat.parse(excelImportCellVo.getValue());
                                isDataTime = true;
                                return null;
                            }
                            catch (Exception format5) {
                                try {
                                    String format6 = "yyyy";
                                    SimpleDateFormat dateFormat = new SimpleDateFormat(format6);
                                    dateFormat.parse(excelImportCellVo.getValue());
                                    isDataTime = true;
                                    return null;
                                }
                                catch (Exception format6) {
                                    if (!isDataTime) {
                                        ExcelImportErrorVo excelImportErrorVo = new ExcelImportErrorVo();
                                        excelImportErrorVo.setRow(Integer.valueOf(excelImportCellVo.getRow()));
                                        excelImportErrorVo.setCol(Integer.valueOf(excelImportCellVo.getCol()));
                                        excelImportErrorVo.setType(ExcelImportErrorType.TIME.getErrorType());
                                        excelImportErrorVo.setFailMessage(ExcelImportErrorType.TIME.getErrorMessage());
                                        logger.error("\u6570\u636e\u5217\u201c" + excelImportCellVo.getName() + "\u201d\u89e3\u6790\u9519\u8bef\uff0c\u201c" + excelImportCellVo.getValue() + "\u201d\u4e0d\u662f\u65f6\u95f4\u683c\u5f0f\uff0c\u9a8c\u8bc1\u5931\u8d25;");
                                        return excelImportErrorVo;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (excelImportCellVo.getFieldType().equals(WidgetType.RADIO_GROUP.getType()) && excelImportCellVo.getValue().length() > 200) {
            ExcelImportErrorVo excelImportErrorVo = new ExcelImportErrorVo();
            excelImportErrorVo.setRow(Integer.valueOf(excelImportCellVo.getRow()));
            excelImportErrorVo.setCol(Integer.valueOf(excelImportCellVo.getCol()));
            excelImportErrorVo.setType(ExcelImportErrorType.RADIO.getErrorType());
            excelImportErrorVo.setFailMessage(ExcelImportErrorType.RADIO.getErrorMessage());
            logger.error("\u6570\u636e\u5217\u201c" + excelImportCellVo.getName() + "\u201d\u7684\u6570\u503c\u957f\u5ea6\u8d85\u957f\uff0c\u9a8c\u8bc1\u5931\u8d25;");
            return excelImportErrorVo;
        }
        return null;
    }

    public List<Widget> dealWidgets(List<Widget> widgets, String langCode) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        for (Widget widget : widgets) {
            Widget widget1 = new Widget();
            BeanUtils.copyProperties((Object)widget, (Object)widget1);
            if (WidgetType.CHILDREN_TABLE.getType().equals(widget1.getType())) {
                widget1.setChildren(this.dealWidgets(widget1.getChildren(), langCode));
            }
            result.addAll(this.dealWidget(widget1, langCode));
        }
        return result;
    }

    public void addChildIdWidgetRecursion(List<Widget> widgets) {
        for (Widget widget : widgets) {
            if (!WidgetTool.isChildTableType((Widget)widget)) continue;
            Widget idw = WidgetTool.genIdWidget((String)widget.getName());
            ArrayList<Widget> children = widget.getChildren();
            if (children == null) {
                children = new ArrayList<Widget>();
                widget.setChildren(children);
            }
            children.add(0, idw);
            this.addChildIdWidgetRecursion(children);
        }
    }

    public List<Widget> dealWidgetsForTemp(List<Widget> widgets, String langCode, String formId, String appId, String viewId) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        for (Widget widget : widgets) {
            Widget widget1 = new Widget();
            BeanUtils.copyProperties((Object)widget, (Object)widget1);
            if (WidgetType.CHILDREN_TABLE.getType().equals(widget1.getType())) {
                ArrayList<Widget> resultChild = new ArrayList<Widget>();
                for (Widget widgetChild : widget1.getChildren()) {
                    if (WidgetType.CHILDREN_TABLE.getType().equals(widgetChild.getType())) {
                        ArrayList<Widget> resultGrand = new ArrayList<Widget>();
                        for (Widget widgetGrand : widgetChild.getChildren()) {
                            Widget newTidget = new Widget();
                            BeanUtils.copyProperties((Object)widgetGrand, (Object)newTidget);
                            resultGrand.addAll(this.dealWidgetForTemp(newTidget, langCode, formId, appId, viewId));
                        }
                        widgetChild.setChildren(resultGrand);
                    }
                    Widget newTidget = new Widget();
                    BeanUtils.copyProperties((Object)widgetChild, (Object)newTidget);
                    resultChild.addAll(this.dealWidgetForTemp(newTidget, langCode, formId, appId, viewId));
                }
                widget1.setChildren(resultChild);
            }
            result.addAll(this.dealWidgetForTemp(widget1, langCode, formId, appId, viewId));
        }
        return result;
    }

    private Map<String, Widget> flatByTableAndFieldName(Collection<Widget> mainChildren) {
        ArrayList<Widget> bfsWidgets = new ArrayList<Widget>();
        bfsWidgets.addAll(mainChildren);
        LinkedList<Widget> buff = new LinkedList<Widget>();
        buff.addAll(mainChildren);
        Widget tmp = (Widget)buff.pollFirst();
        while (tmp != null) {
            if (CollUtil.isNotEmpty((Collection)tmp.getChildren())) {
                buff.addAll(tmp.getChildren());
                bfsWidgets.addAll(tmp.getChildren());
            }
            if (buff.isEmpty()) {
                tmp = null;
                continue;
            }
            tmp = (Widget)buff.pollFirst();
        }
        Function<Widget, String> toName = e -> HussarUtils.isEmpty((Object)e.getParentKey()) ? e.getName() : String.format("%s_%s", e.getParentKey(), e.getName());
        return bfsWidgets.stream().collect(Collectors.toMap(toName, e -> e));
    }

    private List<Widget> dealWidget(Widget widget, String langCode) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        if (WidgetType.ADDRESS.getType().equals(widget.getType()) && HussarUtils.isEmpty((Object)widget.getOldName())) {
            Widget widget1;
            boolean fullAddress;
            if (widget.getProps() == null) {
                return result;
            }
            JSONObject props = JSON.parseObject((String)widget.getProps().toString());
            int addressLevel = props.getInteger("addressLevel") == null ? 1 : props.getInteger("addressLevel");
            boolean bl = fullAddress = props.getInteger("fullAddress") == null ? false : props.getBoolean("fullAddress");
            if (addressLevel >= 1) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Province/Autonomous Region/Municipality", "\uff08\u7701/\u81ea\u6cbb\u533a/\u76f4\u8f96\u5e02\uff09"));
                widget1.setName(widget.getName() + "_province");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 2) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-City", "\uff08\u5e02\uff09"));
                widget1.setName(widget.getName() + "_city");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 3) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-County/District", "\uff08\u53bf/\u533a\uff09"));
                widget1.setName(widget.getName() + "_town");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 4) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Street", "\uff08\u8857\u9053\uff09"));
                widget1.setName(widget.getName() + "_street");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (fullAddress) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Detailed address", "\uff08\u8be6\u7ec6\u5730\u5740\uff09"));
                widget1.setName(widget.getName() + "_detailed");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
        } else {
            result.add(widget);
        }
        return result;
    }

    private List<Widget> dealWidgetForTemp(Widget widget, String langCode, String formId, String appId, String viewId) {
        ArrayList<Widget> result = new ArrayList<Widget>();
        if (WidgetType.ADDRESS.getType().equals(widget.getType()) && HussarUtils.isEmpty((Object)widget.getOldName())) {
            Widget widget1;
            boolean fullAddress;
            String json = JsonUtil.toJson((Object)widget);
            WidgetDTO widgetDTO = (WidgetDTO)JsonUtil.parse((String)json, WidgetDTO.class);
            DataView view = this.i18nUtil.getView(viewId, appId, formId);
            String title = this.i18nUtil.getTitle(widgetDTO, langCode, view);
            widget.setTitle(title);
            if (widget.getProps() == null) {
                return result;
            }
            JSONObject props = JSON.parseObject((String)widget.getProps().toString());
            int addressLevel = props.getInteger("addressLevel") == null ? 1 : props.getInteger("addressLevel");
            boolean bl = fullAddress = props.getInteger("fullAddress") == null ? false : props.getBoolean("fullAddress");
            if (addressLevel >= 1) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Province/Autonomous Region/Municipality", "\uff08\u7701/\u81ea\u6cbb\u533a/\u76f4\u8f96\u5e02\uff09"));
                widget1.setName(widget.getName() + "_province");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 2) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-City", "\uff08\u5e02\uff09"));
                widget1.setName(widget.getName() + "_city");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 3) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-County/District", "\uff08\u53bf/\u533a\uff09"));
                widget1.setName(widget.getName() + "_town");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (addressLevel >= 4) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Street", "\uff08\u8857\u9053\uff09"));
                widget1.setName(widget.getName() + "_street");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
            if (fullAddress) {
                widget1 = new Widget();
                BeanUtils.copyProperties((Object)widget, (Object)widget1);
                widget1.setTitle(widget.getTitle() + this.i18nUtil.getCommonI18nByKey(langCode, "Header-Detailed address", "\uff08\u8be6\u7ec6\u5730\u5740\uff09"));
                widget1.setName(widget.getName() + "_detailed");
                widget1.setOldName(widget.getName());
                result.add(widget1);
            }
        } else {
            result.add(widget);
        }
        return result;
    }

    public JSONObject createExampleHeadersAndData(Map<String, Object> exampleDataMap, Map<String, Object> exampleTitleMap) {
        JSONObject result = new JSONObject();
        ArrayList exampleHeaderList = new ArrayList();
        ArrayList<ExcelImportCellVo> exampleHeader = new ArrayList<ExcelImportCellVo>();
        ArrayList<String> exampleData = new ArrayList<String>();
        ArrayList<ArrayList<String>> exampleDataList = new ArrayList<ArrayList<String>>();
        for (int i = 0; i < ImportProperties.allowFeildType.length; ++i) {
            String type = ImportProperties.allowFeildType[i];
            if (type.equals(WidgetType.CHILDREN_TABLE.getType())) continue;
            ExcelImportCellVo excelImportCellVo = new ExcelImportCellVo();
            if (exampleTitleMap.get(type) == null) continue;
            excelImportCellVo.setValue(exampleTitleMap.get(type).toString());
            excelImportCellVo.setRow(1);
            excelImportCellVo.setCol(i);
            excelImportCellVo.setRowspan(1);
            excelImportCellVo.setColspan(1);
            exampleHeader.add(excelImportCellVo);
            exampleData.add(exampleDataMap.get(type).toString());
        }
        exampleHeaderList.add(exampleHeader);
        exampleDataList.add(exampleData);
        result.put("exampleHeaderList", exampleHeaderList);
        result.put("exampleDataList", exampleDataList);
        return result;
    }

    public List<OrganizationBo> getAllOrgan() {
        return this.hussarBaseOrganizationBoService.getAllOrganInfo();
    }

    public List<SysUsers> getAllUser() {
        return this.sysUsersService.list();
    }

    private void assertDisabled(Long formId) {
        SysForm form = this.applicationService.getFormDetailById(formId);
        if (HussarUtils.isNotEmpty((Object)form) && Whether.NO.getValue().equals(form.getFormStatus())) {
            throw new BaseException("\u8868\u5355\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
    }

    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String formId, Map<String, Object> params) {
        this.assertDisabled(Long.parseLong(formId));
        return this.formOperateExposedService.flowFormSubmit(formId, params);
    }

    public ResponseEntity<ApiResponse<Object>> flowFormSubmits(String formId, Map<String, Object> params) {
        this.assertDisabled(Long.parseLong(formId));
        this.formOperateExposedService.setIdAndTableName(formId, params);
        return this.formOperateExposedService.flowFormSubmits(formId, params);
    }

    public ExcelImportSheetVo analysisExcelAndReturnPreviewData(int sheetIndex, InputStream stream, Integer rowNum, String excelName) throws IOException {
        ExcelImportSheetVo excelImportSheetVo = new ExcelImportSheetVo();
        Workbook workbook = ExcelFormatEnum.getWorkbook(excelName, stream);
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        excelImportSheetVo.setSheetIndex(sheetIndex);
        ArrayList<ExcelImportRowVo> rowList = new ArrayList<ExcelImportRowVo>();
        int lastCellNum = 0;
        int rowNumCount = 0;
        boolean mainFirstCellHaveRowFlag = true;
        int mainFirstCellHaveRow = 1;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            ++rowNumCount;
            ExcelImportRowVo excelImportRowVo = new ExcelImportRowVo();
            ArrayList<ExcelImportCellVo> cells = new ArrayList<ExcelImportCellVo>();
            Row row = sheet.getRow(i);
            if (ExcelImport.isRowEmpty(row)) continue;
            if (i == 0) {
                lastCellNum = row.getLastCellNum();
            }
            if (lastCellNum == 0) {
                throw new IOException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u83b7\u53d6\u7684\u5217\u6570\u91cf\u4e3a0\uff01");
            }
            for (int j = 0; j < lastCellNum; ++j) {
                ExcelImportCellVo excelImportCellVo = new ExcelImportCellVo();
                String cellValue = null;
                CellRangeAddress cellRangeAddress = this.isMergedRegion(sheet, i, j);
                if (HussarUtils.isNotEmpty((Object)cellRangeAddress)) {
                    excelImportCellVo.setMerge(true);
                    if (cellRangeAddress.getFirstRow() == i && cellRangeAddress.getFirstColumn() == j) {
                        excelImportCellVo.setFirstMerge(true);
                        cellValue = this.getCellValue(row.getCell(j));
                        excelImportCellVo.setRowspan(cellRangeAddress.getLastRow() - cellRangeAddress.getFirstRow() + 1);
                        excelImportCellVo.setColspan(cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn() + 1);
                        if (mainFirstCellHaveRowFlag) {
                            mainFirstCellHaveRowFlag = false;
                            mainFirstCellHaveRow = excelImportCellVo.getRowspan();
                        }
                    } else {
                        cellValue = "";
                        excelImportCellVo.setValueNull(true);
                    }
                } else {
                    cellValue = this.getCellValue(row.getCell(j));
                }
                excelImportCellVo.setRow(i);
                excelImportCellVo.setCol(j);
                excelImportCellVo.setValue(cellValue);
                cells.add(excelImportCellVo);
            }
            if (HussarUtils.isNotEmpty((Object)rowNum) && rowNumCount > rowNum + mainFirstCellHaveRow) break;
            excelImportRowVo.setCells(cells);
            rowList.add(excelImportRowVo);
        }
        excelImportSheetVo.setSheetName(sheet.getSheetName());
        excelImportSheetVo.setRows(rowList);
        return excelImportSheetVo;
    }

    public static boolean isRowEmpty(Row row) {
        if (row == null) {
            return true;
        }
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }
}

