/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationBo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.ExcelImportErrorType;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppRegionService;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.ExcelFormatEnum;
import com.jxdinfo.hussar.formdesign.app.frame.server.enmus.FormTypeEnum;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelExport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImportAsync;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExelTaskUtil;
import com.jxdinfo.hussar.formdesign.application.form.dto.SysFormDto;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.IFormWorkFlowDataAssembleService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportCellVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportErrorVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewMatchVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResultVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportRowVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormCreateByExcelVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.FormWorkFlowDataVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.application.util.SysNoCodeFileUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.DateUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class CreateForByExcelImport {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportAsync.class);
    @Resource
    private HussarFormDesignProperties hussarFormDesignFrameProperties;
    private static final String CACHE_NAME_NUM = "excel\u5bfc\u5165\u521b\u5efa\u8868\u5355\u4e2a\u6570";
    private static final String CACHE_EXCEL_IMPORT_PROCESS = "excel\u5bfc\u5165\u8fdb\u5ea6";
    private static final String XLSX_SUFFIX = ".xlsx";
    @Resource
    private OssService ossService;
    @Resource
    private HussarFormDesignProperties hussarFormDesignProperties;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ExcelExport excelExport;
    @Resource
    private ExcelImport excelImport;
    @Resource
    private ISysFormService sysFormService;
    @Autowired
    private ExelTaskUtil exelTaskUtil;
    @Resource
    private CanvasService canvasService;
    @Resource
    private IFormWorkFlowDataAssembleService assembleService;
    @Resource
    private WorkflowService workflowService;
    @Resource
    private ExcelImportAsync excelImportAsync;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private CreateForByExcelImport createForByExcelImport;
    @Autowired
    private IHussarAppRegionService hussarAppRegionService;
    private static Random random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void createFormAndImportData(FormCreateByExcelVo formCreateByExcelVo, Long taskId, UserDetails userDetails, String dataSourceKey) {
        logger.info("=======\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u5f00\u59cb=====", (Object)taskId, (Object)formCreateByExcelVo.getAppName());
        long taskStart = System.currentTimeMillis();
        EngineUserUtil.setUser((UserDetails)userDetails);
        String excelName = formCreateByExcelVo.getCacheKey();
        String filePath = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignFrameProperties.getWorkspace(), "import", excelName});
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStreamCurrent = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            long getworkBookStart = System.currentTimeMillis();
            Workbook workbook = ExcelFormatEnum.getWorkbook(excelName, fileInputStream);
            logger.info("\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011\uff0c\u83b7\u53d6excel\u5de5\u4f5c\u7c3fWorkbook\uff0c\u8017\u65f6{}ms", new Object[]{taskId, formCreateByExcelVo.getAppName(), System.currentTimeMillis() - getworkBookStart});
            String fileSuffix = null;
            if (excelName.endsWith(".xls")) {
                fileSuffix = ".xls";
            } else if (excelName.endsWith(XLSX_SUFFIX)) {
                fileSuffix = XLSX_SUFFIX;
            }
            List excelImports = formCreateByExcelVo.getExcelImports();
            JSONObject sysData = this.getinitData(excelImports);
            ArrayList importResultVos = Lists.newArrayListWithCapacity((int)5);
            int excuteSheetCount = 1;
            boolean createFormFlag = true;
            for (ExcelImportPreviewVo excelImportPreviewVo : excelImports) {
                logger.info("=======\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u83b7\u53d6\u7b2c{}\u4e2asheet\u521b\u5efa\u5f00\u59cb=========", new Object[]{taskId, formCreateByExcelVo.getAppName(), excelImportPreviewVo.getSheetIndex() + 1});
                try {
                    fileInputStreamCurrent = new FileInputStream(filePath);
                    Sheet currentSheet = workbook.getSheetAt(excelImportPreviewVo.getSheetIndex());
                    String sheetName = HussarUtils.isNotEmpty((Object)currentSheet.getSheetName().trim()) ? currentSheet.getSheetName() : "\u672a\u547d\u540d\u8868\u5355";
                    HussarCacheUtil.put((String)CACHE_EXCEL_IMPORT_PROCESS, (Object)taskId, (Object)("\u6b63\u5728\u5bfc\u5165\uff1a" + sheetName + "\u3002\u5f53\u524d\u8fdb\u5ea6(" + excuteSheetCount++ + "/" + excelImports.size() + ")"));
                    long addformStart = System.currentTimeMillis();
                    SysFormDto form = this.createForm(formCreateByExcelVo, excelImportPreviewVo, sheetName);
                    logger.info("\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u521b\u5efa\u8868\u5355\u3010{}\u3011\u53ca\u4e1a\u52a1\u8868\u3010{}\u3011\uff0c\u8017\u65f6{}ms", new Object[]{taskId, formCreateByExcelVo.getAppName(), form.getFormName(), form.getTableName(), System.currentTimeMillis() - addformStart});
                    excelImportPreviewVo.setAppId(formCreateByExcelVo.getAppId());
                    excelImportPreviewVo.setFormId(String.valueOf(form.getId()));
                    if (HussarUtils.isNotEmpty((Object)formCreateByExcelVo.getFormType()) && FormTypeEnum.FLOW_FORM.getFormType().equals(formCreateByExcelVo.getFormType())) {
                        FormDesignResponse formDesignResponse = this.canvasService.get(String.valueOf(form.getId()));
                        String processDefinitionKey = ((FormCanvasSchema)formDesignResponse.getData()).getIdentity();
                        excelImportPreviewVo.setProcessDefinitionKey(processDefinitionKey);
                    }
                    AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
                    List<Widget> widgets = new ArrayList<Widget>();
                    List widgetsIn = excelImportPreviewVo.getWidgets();
                    for (com.jxdinfo.hussar.formdesign.application.form.dto.Widget widgetT : widgetsIn) {
                        Widget widgetnew = new Widget();
                        BeanUtil.copy((Object)widgetT, (Object)widgetnew);
                        widgets.add(widgetnew);
                    }
                    widgets.add(this.excelExport.createDataIdWidget((SysForm)form));
                    widgets = this.excelImport.dealWidgets(widgets, null);
                    long analysisExcelStart = System.currentTimeMillis();
                    ExcelImportResultVo excelImportResultVo = this.dealExcelDataHandle(workbook, excelImportPreviewVo, widgets, (SysForm)form, sysData);
                    logger.info("\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u89e3\u6790sheet\u3010{}\u3011,\u89e3\u6790\u5230\u6570\u636e\u3010{}\u3011\u6761,\u8017\u65f6{}ms", new Object[]{taskId, formCreateByExcelVo.getAppName(), sheetName, excelImportResultVo.getDataList().size(), System.currentTimeMillis() - analysisExcelStart});
                    long importStart = System.currentTimeMillis();
                    CreateForByExcelImport createForByExcelImportProxy = (CreateForByExcelImport)AopContext.currentProxy();
                    createForByExcelImportProxy.excuteSaveData(excelImportPreviewVo, userDetails, widgets, (SysForm)form, excelImportResultVo);
                    logger.info("\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,sheet\u3010{}\u3011,\u5bfc\u5165\u4e1a\u52a1\u6570\u636e,\u8017\u65f6{}ms", new Object[]{taskId, formCreateByExcelVo.getAppName(), sheetName, System.currentTimeMillis() - importStart});
                    importResultVos.add(excelImportResultVo);
                    logger.info("======\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u83b7\u53d6\u7b2c{}sheet\u521b\u5efa\u7ed3\u675f========", new Object[]{taskId, formCreateByExcelVo.getAppName(), excelImportPreviewVo.getSheetIndex() + 1});
                }
                catch (Exception e) {
                    logger.error("======\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u7a0b\u5e8f\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a\u3010{}\u3011,\u7ec8\u6b62\u521b\u5efa", new Object[]{taskId, formCreateByExcelVo.getAppName(), e.getMessage()});
                    this.updateTaskException(taskId, "\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage() + ",\u4efb\u52a1\u7ec8\u6b62\uff01", dataSourceKey);
                    createFormFlag = false;
                    e.printStackTrace();
                    break;
                }
            }
            if (createFormFlag) {
                int insertNum = 0;
                int failNum = 0;
                for (ExcelImportResultVo resultVo : importResultVos) {
                    insertNum += resultVo.getInsertNum();
                    failNum += HussarUtils.isEmpty((Object)resultVo.getFailRowNums()) ? 0 : resultVo.getFailRowNums().size();
                }
                HussarCacheUtil.put((String)CACHE_NAME_NUM, (Object)taskId, (Object)excelImports.size());
                this.updateTaskFinish(taskId, insertNum, failNum, fileSuffix, dataSourceKey);
                if (failNum > 0) {
                    long startDownFile = System.currentTimeMillis();
                    this.downloadFile(taskId, formCreateByExcelVo, filePath, fileSuffix, importResultVos, failNum);
                    logger.info("\u4efb\u52a1\u3010{}\u3011,\u5b58\u5728\u4e0d\u89c4\u8303\u6570\u636e\u3010{}\u3011\u6761,\u4e0b\u8f7d\u6821\u9a8c\u7ed3\u679c\u6587\u4ef6\u8017\u65f6{}ms", new Object[]{taskId, failNum, System.currentTimeMillis() - startDownFile});
                }
            }
            logger.info("\u4efb\u52a1\u3010{}\u3011\u5904\u7406\u5b8c\u6210\uff0c\u603b\u8017\u65f6{}ms", (Object)taskId, (Object)(System.currentTimeMillis() - taskStart));
            logger.info("========\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u7ed3\u675f=========", (Object)taskId, (Object)formCreateByExcelVo.getAppName());
        }
        catch (IOException e) {
            logger.error("======\u4efb\u52a1\u3010{}\u3011,\u5e94\u7528\u540d\u79f0\u3010{}\u3011,\u89e3\u6790\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff1a\u3010{}\u3011", new Object[]{taskId, formCreateByExcelVo.getAppName(), e.getMessage()});
            this.updateTaskException(taskId, "\u89e3\u6790\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), dataSourceKey);
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error("========\u4efb\u52a1\u3010" + taskId + "\u3011,\u7a0b\u5e8f\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            this.updateTaskException(taskId, "\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage(), dataSourceKey);
            e.printStackTrace();
        }
        finally {
            if (null != fileInputStreamCurrent) {
                try {
                    if (fileInputStreamCurrent != null) {
                        fileInputStreamCurrent.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            if (null != fileInputStream) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
            SysNoCodeFileUtil.removeFileByPath((String)filePath);
            EngineUserUtil.remove();
        }
    }

    private JSONObject getinitData(List<ExcelImportPreviewVo> excelImports) {
        JSONObject sysData = new JSONObject();
        boolean containAddress = false;
        boolean containUser = false;
        boolean containOrg = false;
        for (ExcelImportPreviewVo excelImportPreviewVo : excelImports) {
            List matches = excelImportPreviewVo.getMatches();
            if (!HussarUtils.isNotEmpty((Object)matches)) continue;
            for (ExcelImportPreviewMatchVo excelImportPreviewMatchVo : matches) {
                if (WidgetType.ADDRESS.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containAddress = true;
                }
                if (WidgetType.JXDNUser.getType().equals(excelImportPreviewMatchVo.getFieldType()) || WidgetType.JXDNUserMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containUser = true;
                }
                if (!WidgetType.JXDNOrg.getType().equals(excelImportPreviewMatchVo.getFieldType()) && !WidgetType.JXDNOrgMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) continue;
                containOrg = true;
            }
        }
        if (containAddress) {
            List allRegionVos = this.hussarAppRegionService.getRegionInfo();
            Map<Long, List<RegionVo>> parentIdRegionVoMap = allRegionVos.stream().collect(Collectors.groupingBy(RegionVo::getParentId));
            sysData.put("allRegionVos", (Object)allRegionVos);
            sysData.put("parentIdRegionVoMap", parentIdRegionVoMap);
        }
        if (containUser) {
            List<SysUsers> allUsers = this.excelImport.getAllUser();
            sysData.put("allUsers", allUsers);
        }
        if (containOrg) {
            List<OrganizationBo> allOrgans = this.excelImport.getAllOrgan();
            sysData.put("allOrgans", allOrgans);
        }
        return sysData;
    }

    private void updateTaskFinish(Long taskId, int insertNum, int failNum, String fileSuffix, String dataSourceKey) {
        SysExcelTaskNoCode task = new SysExcelTaskNoCode();
        task.setId(taskId);
        task.setTaskStatus(Integer.valueOf(4));
        task.setDataSuccess(Integer.valueOf(insertNum));
        task.setDataError(Integer.valueOf(failNum));
        this.exelTaskUtil.updateExelTask(task, dataSourceKey);
    }

    private void updateTaskException(Long taskId, String errorMsg, String dataSourceKey) {
        SysExcelTaskNoCode task = new SysExcelTaskNoCode();
        task.setId(taskId);
        task.setTaskStatus(Integer.valueOf(-1));
        task.setErrorMsg(errorMsg);
        this.exelTaskUtil.updateExelTask(task, dataSourceKey);
    }

    private boolean downloadFile(Long taskId, FormCreateByExcelVo formCreateByExcelVo, String filePath, String fileSuffix, List<ExcelImportResultVo> importResultVos, int failNum) {
        String outputFilePath = FileUtil.posixPath((String[])new String[]{this.hussarFormDesignFrameProperties.getWorkspace(), "import", formCreateByExcelVo.getAppName() + "_\u6821\u9a8c\u7ed3\u679c_" + taskId + fileSuffix});
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean deleteFileFlag = true;
        try {
            fileInputStream = new FileInputStream(filePath);
            Workbook workbook = ExcelFormatEnum.getWorkbook(fileSuffix, fileInputStream);
            if (failNum > 0) {
                for (int i = 0; i < importResultVos.size(); ++i) {
                    List excelImportErrorVos = importResultVos.get(i).getExcelImportErrorVos();
                    if (!HussarUtils.isNotEmpty((Object)excelImportErrorVos)) continue;
                    for (ExcelImportErrorVo errorVo : excelImportErrorVos) {
                        if (!HussarUtils.isNotEmpty((Object)errorVo.getRow()) || !HussarUtils.isNotEmpty((Object)errorVo.getCol())) continue;
                        CreateForByExcelImport.setCell(workbook, workbook.getSheetAt(i), errorVo.getRow(), errorVo.getCol(), errorVo.getFailMessage());
                    }
                }
            }
            fileOutputStream = new FileOutputStream(outputFilePath);
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException e) {
            throw new BaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return deleteFileFlag;
    }

    private static void setCell(Workbook workbook, Sheet sheet, int rowIndex, int columnIndex, String errorMsg) {
        Cell cell;
        CellStyle style = workbook.createCellStyle();
        CreationHelper helper = workbook.getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(columnIndex);
        anchor.setRow1(rowIndex + 2);
        anchor.setCol2(columnIndex + 3);
        anchor.setRow2(rowIndex + 5);
        Comment comment = sheet.createDrawingPatriarch().createCellComment(anchor);
        comment.setString(helper.createRichTextString(errorMsg));
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(columnIndex, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK)).getCellStyle() != null) {
            style.cloneStyleFrom(cell.getCellStyle());
        }
        cell.setCellStyle(style);
        if (cell.getCellComment() == null) {
            cell.setCellComment(comment);
        }
        style.setFillForegroundColor(IndexedColors.RED.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    private FormWorkFlowDataVo getDefaultWorkFlowData(FormCreateByExcelVo formCreateByExcelVo, ExcelImportPreviewVo excelImportPreviewVo, SysFormDto form, String processDefinitionKey) {
        FormWorkFlowDataVo defaultWorkFlowData = new FormWorkFlowDataVo();
        defaultWorkFlowData.setAppId(formCreateByExcelVo.getAppId());
        defaultWorkFlowData.setFormName(form.getFormName());
        defaultWorkFlowData.setFormId(String.valueOf(form.getId()));
        defaultWorkFlowData.setTableName(form.getTableName());
        defaultWorkFlowData.setFieldNames(excelImportPreviewVo.getMatches().stream().map(ExcelImportPreviewMatchVo::getFieldName).collect(Collectors.toList()));
        defaultWorkFlowData.setProcessDefinitionKey(processDefinitionKey);
        return defaultWorkFlowData;
    }

    private SysFormDto createForm(FormCreateByExcelVo formCreateByExcelVo, ExcelImportPreviewVo excelImportPreviewVo, String sheetName) {
        SysFormDto form = new SysFormDto();
        form.setAppId(Long.valueOf(Long.parseLong(formCreateByExcelVo.getAppId())));
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
        if (HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)com.baomidou.mybatisplus.annotation.DbType.KINGBASE_ES.name().replace("_", ""), (Object)dbType)) {
            form.setTableName(CreateForByExcelImport.getTableName(formCreateByExcelVo.getAppName(), sheetName).toLowerCase());
        } else {
            form.setTableName(CreateForByExcelImport.getTableName(formCreateByExcelVo.getAppName(), sheetName));
        }
        form.setFormName(sheetName);
        form.setFormType(formCreateByExcelVo.getFormType());
        form.setFormIconType("1");
        form.setFormIconColor(FormTypeEnum.getTypeEnum(formCreateByExcelVo.getFormType()).getFormIconColor());
        form.setFormIcon(FormTypeEnum.getTypeEnum(formCreateByExcelVo.getFormType()).getFormIcon());
        form.setFormGroupId(HussarUtils.isNotEmpty((Object)formCreateByExcelVo.getFormgroupId()) ? Long.valueOf(Long.parseLong(formCreateByExcelVo.getFormgroupId())) : null);
        this.sysFormService.addForm(form, excelImportPreviewVo.getWidgets(), true);
        return form;
    }

    public static String getTableName(String appName, String sheetName) {
        return "EC_" + IdWorker.getId((Object)new SysForm());
    }

    public Long exportForImport(String sheetName, List<List<ExcelImportCellVo>> headers1, List<List<Object>> list1, List<List<ExcelImportCellVo>> headers2, List<List<Object>> list2, String fileName, String langCode, HttpServletResponse response) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        ArrayList<CellRangeAddress> ranges1 = new ArrayList<CellRangeAddress>();
        ArrayList<List<Object>> headerObjects1 = new ArrayList<List<Object>>();
        for (List<ExcelImportCellVo> row : headers1) {
            ArrayList headerObjectsRow = new ArrayList();
            for (ExcelImportCellVo excelImportCellVo : row) {
                if (excelImportCellVo.getRowspan() != 1 || excelImportCellVo.getColspan() != 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(excelImportCellVo.getRow(), excelImportCellVo.getRow() + excelImportCellVo.getRowspan() - 1, excelImportCellVo.getCol(), excelImportCellVo.getCol() + excelImportCellVo.getColspan() - 1);
                    ranges1.add(cellRangeAddress);
                }
                headerObjectsRow.add(excelImportCellVo.getValue());
            }
            headerObjects1.add(headerObjectsRow);
        }
        ArrayList<CellRangeAddress> ranges2 = new ArrayList<CellRangeAddress>();
        ArrayList<List<Object>> headerObjects2 = new ArrayList<List<Object>>();
        for (List list : headers2) {
            ArrayList<String> headerObjectsRow = new ArrayList<String>();
            for (ExcelImportCellVo excelImportCellVo : list) {
                if (excelImportCellVo.getRowspan() != 1 || excelImportCellVo.getColspan() != 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(excelImportCellVo.getRow(), excelImportCellVo.getRow() + excelImportCellVo.getRowspan() - 1, excelImportCellVo.getCol(), excelImportCellVo.getCol() + excelImportCellVo.getColspan() - 1);
                    ranges2.add(cellRangeAddress);
                }
                headerObjectsRow.add(excelImportCellVo.getValue());
            }
            headerObjects2.add(headerObjectsRow);
        }
        this.excelExport.createSheet2(this.excelExport.getSaticName(langCode, sheetName), headerObjects1, null, list1, workbook, ranges1, false, null);
        this.excelExport.createSheet2(this.excelExport.getSaticName(langCode, "\u793a\u4f8b\u6570\u636e"), headerObjects2, null, list2, workbook, ranges2, true, null);
        if (HussarUtils.isNotEmpty((Object)response)) {
            response.reset();
            response.setContentType("application/octet-stream; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        }
        Long fileId = 0L;
        String string = this.hussarFormDesignProperties.getWorkspace() + File.separator + "excelDownloadTemplateWhite" + File.separator;
        fileId = Long.parseLong(this.gene16Num());
        String outputFilePath = string + File.separator + fileId + XLSX_SUFFIX;
        try (ServletOutputStream servletOutputStream = response != null ? response.getOutputStream() : null;
             OutputStream outputStream = response == null ? Files.newOutputStream(Paths.get(outputFilePath, new String[0]), new OpenOption[0]) : null;
             FileInputStream fileInputStream = response == null ? new FileInputStream(outputFilePath) : null;){
            if (HussarUtils.isNotEmpty((Object)response)) {
                workbook.write((OutputStream)servletOutputStream);
            } else {
                File file = new File(string);
                if (!file.exists()) {
                    boolean mkdirFlag = file.mkdirs();
                    logger.info("\u6587\u4ef6\u521b\u5efa{}", (Object)(mkdirFlag ? "\u6210\u529f" : "\u5931\u8d25"));
                }
                workbook.write(outputStream);
                int length = fileInputStream.available();
                byte[] fileBytes = new byte[length];
                int bytesRead = fileInputStream.read(fileBytes);
                logger.info("-------bytesRead\u957f\u5ea6{}", (Object)bytesRead);
                MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, XLSX_SUFFIX, fileBytes);
                ApiResponse upload = this.ossService.backgroundUpload((MultipartFile)multipartFile);
                fileId = (Long)upload.getData();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new IOException(e);
        }
        workbook.dispose();
        return fileId;
    }

    public String gene16Num() {
        int firstDigit = 1 + random.nextInt(9);
        StringBuilder remainingDigits = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            remainingDigits.append(random.nextInt(10));
        }
        return firstDigit + remainingDigits.toString();
    }

    @OperateLogTypeCache(mode=7)
    public void excuteSaveData(ExcelImportPreviewVo excelImportPreviewVo, UserDetails userDetails, List<Widget> widgets, SysForm form, ExcelImportResultVo excelImportResultVo) {
        List importList = excelImportResultVo.getDataList();
        if (importList.size() > 0) {
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("importList", importList);
            if (excelImportPreviewVo.getTriggerProcess() == 2) {
                HashMap<String, Object> flowFormSubmitsParams = new HashMap<String, Object>();
                ArrayList dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", false);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
            } else if (excelImportPreviewVo.getTriggerProcess() == 3) {
                HashMap<String, Object> flowFormSubmitsParams = new HashMap<String, Object>();
                ArrayList dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", true);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
            } else {
                boolean targetFormChild;
                FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
                List canvasWidgets = formCanvasSchemaDTO.getWidgets();
                String json = JsonUtil.toJson((Object)canvasWidgets);
                List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
                boolean bl = targetFormChild = widgetDTOS.stream().anyMatch(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) || widgets.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).anyMatch(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()));
                if (targetFormChild) {
                    HashMap<String, List> map = new HashMap<String, List>();
                    map.put(form.getTableName(), importList);
                    HashMap<String, HashMap<String, List>> typeMap = new HashMap<String, HashMap<String, List>>();
                    typeMap.put("saveAndUpdate", map);
                    this.formOperateExposedService.formIncrementSave(excelImportPreviewVo.getFormId(), typeMap, excelImportPreviewVo.getAppId());
                } else {
                    logger.info("===========\u8868\u5355\u3010{}\u3011\uff0csaveBatchMore\u4fdd\u5b58\u6570\u636e\u3010{}\u3011\u6761\u5f00\u59cb=====", (Object)form.getId(), (Object)importList.size());
                    this.formOperateExposedService.saveBatchMore(excelImportPreviewVo.getAppId(), excelImportPreviewVo.getFormId(), params);
                    logger.info("===========\u8868\u5355\u3010{}\u3011\uff0csaveBatchMore\u4fdd\u5b58\u6570\u636e\u3010{}\u3011\u6761\u7ed3\u675f=====", (Object)form.getId(), (Object)importList.size());
                }
            }
        }
    }

    public ExcelImportSheetVo analysisExcelAndReturnPreviewData(int sheetIndex, InputStream stream, Integer rowNum, String excelName) throws IOException {
        ExcelImportSheetVo excelImportSheetVo = new ExcelImportSheetVo();
        Workbook workbook = ExcelFormatEnum.getWorkbook(excelName, stream);
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        excelImportSheetVo.setSheetIndex(sheetIndex);
        List<ExcelImportRowVo> rowList = new ArrayList<ExcelImportRowVo>();
        boolean lastCellNum = false;
        int rowNumCount = 0;
        boolean mainFirstCellHaveRowFlag = true;
        int mainFirstCellHaveRow = 1;
        short firstNotEmptyRowNotEmptyCellEndIndex = 0;
        boolean getfirstNotEmptyRowNotEmptyCellEndIndexFlag = false;
        short firstNotEmptyRowNotEmptyCellStartIndex = 0;
        boolean getfirstNotEmptyRowNotEmptyCellStartIndexFlag = false;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            ++rowNumCount;
            ExcelImportRowVo excelImportRowVo = new ExcelImportRowVo();
            ArrayList<ExcelImportCellVo> cells = new ArrayList<ExcelImportCellVo>();
            Row row = sheet.getRow(i);
            if (!getfirstNotEmptyRowNotEmptyCellEndIndexFlag) {
                block1: for (Row rowT : sheet) {
                    boolean emptyRowFlag = this.isRowEmpty(rowT);
                    if (emptyRowFlag) continue;
                    getfirstNotEmptyRowNotEmptyCellEndIndexFlag = true;
                    firstNotEmptyRowNotEmptyCellEndIndex = rowT.getLastCellNum();
                    for (Cell cell : rowT) {
                        if (null == cell || cell.getCellType() == CellType.BLANK || !HussarUtils.isNotEmpty((Object)this.createForByExcelImport.getCellValue(cell).trim())) continue;
                        firstNotEmptyRowNotEmptyCellStartIndex = cell.getColumnIndex();
                        break block1;
                    }
                }
            }
            for (short j = firstNotEmptyRowNotEmptyCellStartIndex; j < firstNotEmptyRowNotEmptyCellEndIndex; ++j) {
                ExcelImportCellVo excelImportCellVo = new ExcelImportCellVo();
                String cellValue = HussarUtils.isNotEmpty((Object)row) ? this.getCellValue(row.getCell((int)j)) : "";
                excelImportCellVo.setRow(i);
                excelImportCellVo.setCol((int)j);
                excelImportCellVo.setValue(cellValue);
                cells.add(excelImportCellVo);
            }
            if (HussarUtils.isNotEmpty((Object)rowNum) && rowNumCount > rowNum + mainFirstCellHaveRow) break;
            excelImportRowVo.setCells(cells);
            rowList.add(excelImportRowVo);
        }
        excelImportSheetVo.setSheetName(HussarUtils.isNotEmpty((Object)sheet.getSheetName().trim()) ? sheet.getSheetName() : "\u672a\u547d\u540d\u8868\u5355");
        rowList = this.getEffectiveRow(rowList);
        excelImportSheetVo.setRows(rowList);
        return excelImportSheetVo;
    }

    public List<ExcelImportRowVo> getEffectiveRow(List<ExcelImportRowVo> rowList) {
        if (CollectionUtil.isNotEmpty(rowList)) {
            int firstNotEmptyRow = 0;
            block0: for (int i = 0; i < rowList.size(); ++i) {
                List importCellVos = rowList.get(i).getCells();
                for (ExcelImportCellVo cell : importCellVos) {
                    if (!HussarUtils.isNotEmpty((Object)cell.getValue())) continue;
                    firstNotEmptyRow = i;
                    break block0;
                }
            }
            int endNotEmptyRow = 0;
            block2: for (int i = rowList.size() - 1; i >= 0; --i) {
                List importCellVos = rowList.get(i).getCells();
                for (ExcelImportCellVo cell : importCellVos) {
                    if (!HussarUtils.isNotEmpty((Object)cell.getValue())) continue;
                    endNotEmptyRow = i;
                    break block2;
                }
            }
            rowList = rowList.subList(firstNotEmptyRow, endNotEmptyRow + 1);
        }
        return rowList;
    }

    public CellRangeAddress isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return range;
        }
        return null;
    }

    public boolean isRowEmpty(Row row) {
        boolean checkRowEmptyFlag = true;
        if (HussarUtils.isEmpty((Object)row)) {
            return checkRowEmptyFlag;
        }
        for (Cell cell : row) {
            if (null == cell || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return checkRowEmptyFlag;
    }

    public String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return cell.getCellFormula();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            String cellValue = null;
            if (cell.getCellStyle().getDataFormat() == 0) {
                if (HussarUtils.isNotEmpty((Object)cell.getNumericCellValue()) && CreateForByExcelImport.isScientificNotation(String.valueOf(cell.getNumericCellValue()))) {
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(cell.getNumericCellValue()));
                    cellValue = bigDecimal.toPlainString();
                } else {
                    long longValue = Math.round(cell.getNumericCellValue());
                    cellValue = Double.parseDouble(longValue + ".0") == cell.getNumericCellValue() ? String.valueOf(longValue) : String.valueOf(cell.getNumericCellValue());
                }
            } else if (cell.getCellStyle().getDataFormat() == 49 || cell.getCellStyle().getDataFormat() == 176 || cell.getCellStyle().getDataFormat() == 177 || cell.getCellStyle().getDataFormat() == 178) {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(cell.getNumericCellValue()));
                cellValue = bigDecimal.toPlainString();
            } else {
                TimeZone zone;
                double numericValue = cell.getNumericCellValue();
                Date date = DateUtil.getJavaDate((double)numericValue, (TimeZone)(zone = TimeZone.getTimeZone("GMT")));
                cellValue = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                if (cellValue.endsWith(" 00:00:00")) {
                    cellValue = cellValue.replace(" 00:00:00", "");
                }
            }
            return cellValue;
        }
        return "";
    }

    public static boolean isScientificNotation(String number) {
        try {
            if (number.contains(".") && number.contains("E")) {
                return true;
            }
            new BigDecimal(number);
            return false;
        }
        catch (NumberFormatException e) {
            String[] parts = number.split("E|e");
            if (parts.length != 2) {
                return false;
            }
            try {
                Integer.parseInt(parts[1]);
                return true;
            }
            catch (NumberFormatException e1) {
                return false;
            }
        }
    }

    public ExcelImportResultVo dealExcelDataHandle(Workbook workbook, ExcelImportPreviewVo excelImportPreviewVo, List<Widget> widgets, SysForm form, JSONObject sysData) {
        Row rowT;
        int sheetIndex = excelImportPreviewVo.getSheetIndex();
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        List matchsT = excelImportPreviewVo.getMatches();
        Set setList = matchsT.stream().map(ExcelImportPreviewMatchVo::getCol).collect(Collectors.toSet());
        int minCellNum = (Integer)Collections.min(setList);
        int maxCellNum = (Integer)Collections.max(setList);
        ArrayList<Integer> failRowNum = new ArrayList<Integer>();
        int failNum = 0;
        ArrayList<ExcelImportErrorVo> excelImportErrorVos = new ArrayList<ExcelImportErrorVo>();
        ExcelImportResultVo excelImportResultVo = new ExcelImportResultVo();
        Map<String, Widget> nameWidgetMap = widgets.stream().collect(Collectors.toMap(Widget::getName, Function.identity(), (key1, key2) -> key2));
        List matchs = excelImportPreviewVo.getMatches();
        HashMap<Long, JSONObject> mapMainData = new HashMap<Long, JSONObject>();
        Long mainId = null;
        for (int i = excelImportPreviewVo.getFirstRowIndex() + 1; i <= sheet.getLastRowNum() && !this.createForByExcelImport.isRowEmpty(rowT = sheet.getRow(i)); ++i) {
            ArrayList<ExcelImportCellVo> cells = new ArrayList<ExcelImportCellVo>();
            for (int c = minCellNum; c <= maxCellNum; ++c) {
                ExcelImportCellVo excelImportCellVo = new ExcelImportCellVo();
                String cellValue = HussarUtils.isNotEmpty((Object)rowT) ? this.getCellValue(rowT.getCell(c)) : "";
                excelImportCellVo.setRow(i);
                excelImportCellVo.setCol(c);
                excelImportCellVo.setValue(cellValue);
                cells.add(excelImportCellVo);
            }
            JSONObject jSONObject = new JSONObject();
            boolean isRowCkeck = true;
            boolean isContainMerge = false;
            boolean isFirstMerge = false;
            if (HussarUtils.isNotEmpty((Object)matchs)) {
                boolean childHaveSwitchType = false;
                boolean childCellAllEmpty = true;
                ArrayList slaveFormSwitchColumns = Lists.newArrayListWithCapacity((int)5);
                Map colExcelCellMap = cells.stream().collect(Collectors.toMap(ExcelImportCellVo::getCol, Function.identity()));
                for (int j = 0; j < matchs.size(); ++j) {
                    ExcelImportPreviewMatchVo excelImportPreviewMatchVo = (ExcelImportPreviewMatchVo)matchs.get(j);
                    ExcelImportCellVo excelImportCellVo = (ExcelImportCellVo)colExcelCellMap.get(excelImportPreviewMatchVo.getCol());
                    Widget widget = nameWidgetMap.get(excelImportPreviewMatchVo.getFieldName());
                    if (HussarUtils.isNotEmpty((Object)excelImportPreviewMatchVo.getChildField())) {
                        String key = String.format("%s_%s", excelImportPreviewMatchVo.getFieldName(), excelImportPreviewMatchVo.getChildField());
                        if (!nameWidgetMap.containsKey(excelImportPreviewMatchVo.getChildField()) || "RECORD_ID".equals(excelImportPreviewMatchVo.getChildField())) {
                            widget = (Widget)nameWidgetMap.get(excelImportPreviewMatchVo.getFieldName()).getChildren().stream().collect(Collectors.toMap(Widget::getName, Function.identity(), (key1, key2) -> key2)).get(excelImportPreviewMatchVo.getChildField());
                            nameWidgetMap.put(key, widget);
                        } else {
                            widget = nameWidgetMap.get(excelImportPreviewMatchVo.getChildField());
                        }
                        if (WidgetType.JXDNSwitch.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                            childHaveSwitchType = true;
                            slaveFormSwitchColumns.add(key);
                        }
                        if (HussarUtils.isNotEmpty((Object)excelImportCellVo.getValue())) {
                            childCellAllEmpty = false;
                        }
                    }
                    if (excelImportCellVo.isMerge()) {
                        isContainMerge = true;
                    }
                    if (excelImportCellVo.isFirstMerge()) {
                        isFirstMerge = true;
                    }
                    excelImportCellVo.setFieldType(widget.getType());
                    excelImportCellVo.setName(widget.getTitle());
                    excelImportCellVo.setFieldName(widget.getName());
                    ExcelImportErrorVo excelImportErrorVo = this.excelImport.checkCell(excelImportCellVo);
                    if (HussarUtils.isNotEmpty((Object)excelImportErrorVo)) {
                        isRowCkeck = false;
                        logger.error("\u9a8c\u8bc1\u5931\u8d25\uff1a" + excelImportErrorVo.toString());
                        excelImportErrorVos.add(excelImportErrorVo);
                        break;
                    }
                    try {
                        jSONObject = this.excelImport.putCellValue(jSONObject, widget, excelImportCellVo.getValue(), sysData);
                        continue;
                    }
                    catch (Exception e) {
                        isRowCkeck = false;
                        logger.error("\u6570\u636e\u5217\u201c" + widget.getTitle() + "\u201d\u53d6\u503c\u5931\u8d25;");
                        logger.error(e.getMessage());
                        ExcelImportErrorVo excelImportError = new ExcelImportErrorVo();
                        excelImportError.setType(e.getMessage());
                        excelImportError.setCol(Integer.valueOf(excelImportCellVo.getCol()));
                        excelImportError.setRow(Integer.valueOf(excelImportCellVo.getRow()));
                        excelImportError.setFailMessage(ExcelImportErrorType.getErrorMessageByType((String)e.getMessage()));
                        excelImportErrorVos.add(excelImportError);
                    }
                }
                if (childHaveSwitchType && childCellAllEmpty) {
                    for (String slaveFormSwitchColumn : slaveFormSwitchColumns) {
                        if (!jSONObject.containsKey((Object)slaveFormSwitchColumn)) continue;
                        jSONObject.put(slaveFormSwitchColumn, null);
                    }
                }
                if (!isRowCkeck) {
                    int rowNum = i + 1;
                    failRowNum.add(rowNum);
                    if (isContainMerge && (!isContainMerge || !isFirstMerge)) continue;
                    ++failNum;
                    continue;
                }
            } else {
                for (Widget widget : widgets) {
                    if (!WidgetType.JXDNSwitch.getType().equals(widget.getType())) continue;
                    jSONObject.put(widget.getName(), (Object)0);
                }
            }
            jSONObject = this.excelImport.putRowValue(jSONObject, form, matchs, nameWidgetMap, sysData);
            mainId = System.currentTimeMillis() + (long)random.nextInt();
            mapMainData.put(mainId, jSONObject);
        }
        ArrayList importList = new ArrayList(mapMainData.values());
        excelImportResultVo.setFailRowNums(failRowNum);
        excelImportResultVo.setDataList(importList);
        excelImportResultVo.setInsertNum(importList.size());
        excelImportResultVo.setFailNum(failNum);
        List<String> failMessage = this.excelImport.dealExcelImportErrorVos(excelImportErrorVos);
        excelImportResultVo.setFailMessages(failMessage);
        excelImportResultVo.setExcelImportErrorVos(excelImportErrorVos);
        excelImportResultVo.setSheetIndex(excelImportPreviewVo.getSheetIndex());
        return excelImportResultVo;
    }

    static {
        try {
            random = new SecureRandom();
        }
        catch (Exception e) {
            logger.info("Exception:", (Throwable)e);
        }
    }
}

