/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IAiFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFrameService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldControlVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.FieldTypeToAi;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.FieldControl;
import com.jxdinfo.hussar.formdesign.no.code.business.service.DictDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.openApi.common.ApiResponse;
import com.jxdinfo.hussar.openApi.dto.AIFormFieldDTO;
import com.jxdinfo.hussar.openApi.dto.FormDetailDTO;
import com.jxdinfo.hussar.openApi.service.IAiQAService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AiFormServiceImpl
implements IAiFormService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiFormServiceImpl.class);
    @Resource
    private IAiQAService aiQaService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private DictDataSourceService dictDataSourceService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private IHussarAppFrameService appFrameService;
    private static final int SIZE = 20;
    public static final String OPTION_TYPE = "optionType";
    public static final String OPTIONS = "options";
    public static final String FORM_ID = "formId";
    public static final String APP_ID = "appId";
    public static final String FIELD_NAME = "fieldName";

    private FormDetailDTO modelToAiModel(FormCanvasSchema formCanvasSchema) {
        List widgets;
        FormDetailDTO formDetail = new FormDetailDTO();
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema)) {
            formDetail.setFormCode(formCanvasSchema.getId());
            formDetail.setFormName(formCanvasSchema.getTitle());
            if (HussarUtils.isNotEmpty((Object)formCanvasSchema.getProps())) {
                Map props = formCanvasSchema.getProps();
                if (HussarUtils.isNotEmpty(props.get("description"))) {
                    formDetail.setFormDesc(props.get("description").toString());
                } else {
                    formDetail.setFormDesc(formDetail.getFormName());
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(widgets = formCanvasSchema.widgetsContainChildren()))) {
            String processKey = formCanvasSchema.getIdentity();
            formDetail.setFields(this.modelToAiModelField(widgets, Long.valueOf(formDetail.getFormCode()), processKey, formCanvasSchema.getAppId()));
        }
        return formDetail;
    }

    public Void saveAiFormAsync(FormCanvasSchema newCanvas) {
        LOGGER.info("=================\u5f00\u59cb\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)newCanvas.getId());
        FormDetailDTO formDetail = this.modelToAiModel(newCanvas);
        ApiResponse mapApiResponse = this.aiQaService.saveOrUpdateAiForm(formDetail);
        LOGGER.info("=================ai\u8868\u5355\u4fdd\u5b58{}=============", (Object)mapApiResponse.getMsg());
        LOGGER.info("=================\u7ed3\u675f\u8c03\u7528ai\u63a5\u53e3\uff1a\u8868\u5355ID-[{}]=============", (Object)newCanvas.getId());
        return null;
    }

    public Void deleteAiFormAsync(List<String> ids) {
        ApiResponse apiResponse = this.aiQaService.deleteAiForm(ids);
        LOGGER.info("=================ai\u8868\u5355\u5220\u9664{}=============", (Object)apiResponse.getMsg());
        return null;
    }

    public List<AIFormFieldDTO> modelToAiModelField(List<Widget> widgets, Long formId, String processKey, String appId) {
        List fieldControls;
        ArrayList<AIFormFieldDTO> aiFormFields = new ArrayList<AIFormFieldDTO>();
        HashMap<String, Boolean> optional = new HashMap<String, Boolean>();
        HashMap<String, Boolean> required = new HashMap<String, Boolean>();
        try {
            FieldControlVo fieldControlVo;
            if (HussarUtils.isNotEmpty((Object)processKey)) {
                fieldControlVo = this.appFormService.getFieldControl(String.valueOf(formId), null, "2", processKey, appId);
                fieldControls = fieldControlVo.getBpmControl();
            } else {
                fieldControlVo = this.appFormService.getFieldControl(String.valueOf(formId), null, null, processKey, appId);
                fieldControls = fieldControlVo.getFieldControlSchema().getFieldControl().getAdd();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (FieldControl fieldControl : fieldControls) {
            required.put(fieldControl.getField(), fieldControl.isRequired());
            optional.put(fieldControl.getField(), !fieldControl.isRequired() && fieldControl.isVisible() && fieldControl.isWitable() && !fieldControl.isAuto());
        }
        for (Widget widget : widgets) {
            Map extPropsMap;
            String extProps;
            AIFormFieldDTO aiFormField = new AIFormFieldDTO();
            aiFormField.setFormId(formId);
            aiFormField.setFieldCode(widget.getName());
            aiFormField.setFieldLabel(widget.getTitle());
            aiFormField.setSort(Integer.valueOf(widget.getSeq()));
            aiFormField.setFieldDesc(widget.getUsage());
            String widgetType = widget.getType();
            if ("JXDNExtWidget".equals(widget.getType()) && HussarUtils.isNotEmpty((Object)(extProps = (String)widget.getProps().get((Object)"extProps"))) && HussarUtils.isNotEmpty((extPropsMap = (Map)JSON.parseObject((String)extProps, Map.class)).get("AIWidgetType"))) {
                widgetType = extPropsMap.get("AIWidgetType").toString();
            }
            aiFormField.setFieldType(FieldTypeToAi.convertWidgetType(widgetType));
            JSONObject props = widget.getProps();
            props.put("required", required.get(widget.getName()));
            props.put("optional", optional.get(widget.getName()));
            aiFormField.setFieldConfig((JSONObject)this.getOptions((Map<String, Object>)props));
            if (HussarUtils.isNotEmpty((Object)widget.getParentKey())) {
                aiFormField.setParentId(Long.valueOf(widget.getParentKey()));
            }
            if (HussarUtils.isNotEmpty((Object)widget.getChildren())) {
                aiFormField.setChildren(this.modelToAiModelField(widget.getChildren(), formId, processKey, appId));
            }
            aiFormFields.add(aiFormField);
        }
        return aiFormFields;
    }

    private Map<String, Object> getOptions(Map<String, Object> props) {
        List<Object> options = new ArrayList();
        if (props.containsKey(OPTION_TYPE)) {
            if ("dict".equals(props.get(OPTION_TYPE))) {
                Map dict = (Map)props.get("dict");
                List dicLevelTreeVos = this.dictDataSourceService.queryDictOptions(Long.valueOf((String)dict.get("dictId")));
                if (HussarUtils.isNotEmpty((Object)dicLevelTreeVos)) {
                    for (DicLevelTreeVo dicLevelTreeVo : dicLevelTreeVos) {
                        HashMap<String, String> option = new HashMap<String, String>();
                        option.put("label", dicLevelTreeVo.getLabel());
                        option.put("value", dicLevelTreeVo.getValue());
                        options.add(option);
                    }
                    props.put(OPTIONS, options);
                }
            } else if ("async".equals(props.get(OPTION_TYPE))) {
                Map async = (Map)props.get("async");
                if ("nocode".equals(async.get("appType"))) {
                    options = this.getFormData(async);
                    props.put(OPTIONS, options);
                } else {
                    props.remove(OPTIONS);
                }
            } else if ("dataLinkage".equals(props.get(OPTION_TYPE))) {
                props.remove(OPTIONS);
            }
        } else if (props.containsKey("linkTableInfo")) {
            Map async = (Map)props.get("linkTableInfo");
            if ("nocode".equals(async.get("appType"))) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put(FORM_ID, (String)async.get(FORM_ID));
                param.put(APP_ID, (String)async.get(APP_ID));
                String fieldName = (String)((Map)async.get("linkFieldInfo")).get("name");
                param.put(FIELD_NAME, fieldName);
                options = this.getFormData(param);
                props.put(OPTIONS, options);
            } else {
                props.remove(OPTIONS);
            }
        }
        if (HussarUtils.isEmpty((Object)props.get(OPTIONS))) {
            props.remove(OPTIONS);
        }
        return props;
    }

    private List<Map<String, String>> getFormData(Map<String, String> async) {
        ArrayList<Map<String, String>> options = new ArrayList<Map<String, String>>();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("current", Integer.valueOf(1));
        params.put("size", Integer.valueOf(20));
        ArrayList superQueryConditionDto = new ArrayList();
        HashMap<String, String> rule = new HashMap<String, String>();
        rule.put("field", async.get(FIELD_NAME));
        rule.put("match", "AND");
        rule.put("rule", "_isNotNull");
        rule.put("val", "");
        superQueryConditionDto.add(rule);
        params.put("superQueryConditionDto", superQueryConditionDto);
        QueryBusinessDataVo data = (QueryBusinessDataVo)this.hussarAppDataSourceService.queryAppBusinessData(async.get(FORM_ID), async.get(APP_ID), params).getData();
        PageVo business = (PageVo)data.getBusinessData();
        List businessDatas = business.getData();
        if (HussarUtils.isEmpty((Object)businessDatas)) {
            return options;
        }
        for (Map businessData : businessDatas) {
            HashMap option = new HashMap();
            option.put("label", businessData.get(async.get(FIELD_NAME)));
            option.put("value", businessData.get(async.get(FIELD_NAME)));
            options.add(option);
        }
        return options;
    }
}

