/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigBoService;
import com.jxdinfo.hussar.eai.sysapi.api.dto.ApiInfoSdkDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AttachListDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.BatchDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderByIdsDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.QueryDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.SearchDataOnCascaderDTO;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DataType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormAttachmentService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormOutLinkService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHandwrittenSignatureService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppDataSourceService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldControlVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FieldOperateControlVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormFieldsVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FormViewVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.QueryBusinessDataVo;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.data.service.BatchDownLodService;
import com.jxdinfo.hussar.formdesign.application.data.service.PushDataService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormCheckConfigService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormCheckConfigVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.SysFormVo;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkOpenDto;
import com.jxdinfo.hussar.formdesign.application.formLink.dto.SysFormLinkSingleDto;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkOpenService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleService;
import com.jxdinfo.hussar.formdesign.application.formLink.service.ISysFormLinkSingleStatusService;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkOpenVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkSingleStatusVo;
import com.jxdinfo.hussar.formdesign.application.formLink.vo.SysFormLinkVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OpControllerAnno;
import com.jxdinfo.hussar.formdesign.application.panel.dto.QueryChartDataDto;
import com.jxdinfo.hussar.formdesign.application.property.service.IWidgetExpService;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeFileUtil;
import com.jxdinfo.hussar.formdesign.application.util.NoCodeSecurityUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.HideRuleSchema;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.setting.SubmitSchema;
import com.jxdinfo.hussar.formdesign.no.code.business.service.DictDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.FieldDataSourceService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.InvokeService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.lang.model.SysMultiLangMgt;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionBoService;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.theme.config.model.vo.ThemeVO;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/public_release"})
public class FormOutLinkController {
    @Resource
    private InvokeService invokeService;
    @Resource
    private FormAttachmentService formAttachmentService;
    @Resource
    private BatchDownLodService batchDownLodService;
    @Resource
    private FormOutLinkService formOutLinkService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private IHussarBaseRegionBoService regionService;
    @Resource
    private IWidgetExpService widgetExpService;
    @Resource
    private IHussarAppDataSourceService hussarAppDataSourceService;
    @Resource
    private ISysFormLinkService formLinkService;
    @Resource
    private ISysFormLinkSingleService sysFormLinkSingleService;
    @Resource
    private ISysFormLinkSingleStatusService sysFormLinkSingleStatusService;
    @Resource
    private ISysFormLinkOpenService sysFormLinkOpenService;
    @Resource
    private OssService ossService;
    @Resource
    private ISysBaseConfigBoService sysBaseConfigService;
    @Resource
    private IHandwrittenSignatureService handwrittenSignatureService;
    @Resource
    private ISysFormCheckConfigService formCheckConfigService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private ISysMultiLangMgtBoService sysMultiLangMgtService;
    @Autowired
    private ISysDicRefService sysDicRefService;
    @Resource
    private IHussarThemeConfigService hussarThemeConfigService;
    @Resource
    private DictDataSourceService dictDataSourceService;
    @Resource
    private FieldDataSourceService fieldDataSourceService;
    @Resource
    private PushDataService pushDataService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FormOutLinkController.class);

    @PostMapping(value={"/testOut"})
    public ApiResponse<Object> testOut(@RequestBody Object params) {
        this.pushDataService.test((HashMap)params, 1);
        return ApiResponse.success((Object)"\u6210\u529f", (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/hussarApp/formInfo/formQueryExt"})
    public Object formQueryExt(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType, @RequestParam(required=false) String appId) {
        ApiResponse body = (ApiResponse)this.invokeService.formQuery(appId, formId, id, true, null).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @GetMapping(value={"/app_list_out"})
    public FormDesignResponse<List<ApiInfoSdkDto>> appListOut(@RequestParam String type) {
        return this.fieldDataSourceService.appListOut(type);
    }

    @GetMapping(value={"/dicFront/getDictByCode"})
    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178", notes="\u83b7\u53d6\u5b57\u5178")
    public ApiResponse<List<DicVo>> getDictByCode(@ApiParam(value="\u7c7b\u522b\u540d") @RequestParam(value="code") String code) {
        List list = this.sysDicRefService.getDicListByType(code);
        return ApiResponse.success((Object)list);
    }

    @PostMapping(value={"/exportLang"})
    public Map<String, String> exportLang() {
        List list = this.sysMultiLangMgtService.listByTypeAndLangCode("system", "zh-CN");
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysMultiLangMgt sysMultiLangMgt : list) {
            String langKey = sysMultiLangMgt.getLangKey();
            String langText = sysMultiLangMgt.getLangText();
            map.put(langKey, langText);
        }
        return map;
    }

    @PostMapping(value={"/exportLangEn"})
    public Map<String, String> exportLangEn() {
        List list = this.sysMultiLangMgtService.listByTypeAndLangCode("system", "en-US");
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysMultiLangMgt sysMultiLangMgt : list) {
            String langKey = sysMultiLangMgt.getLangKey();
            String langText = sysMultiLangMgt.getLangText();
            map.put(langKey, langText);
        }
        return map;
    }

    @ApiOperation(value="\u9009\u62e9\u7ec4\u4ef6\u6570\u636e\u67e5\u8be2", notes="\u9009\u62e9\u7ec4\u4ef6\u6570\u636e\u67e5\u8be2")
    @PostMapping(value={"/hussarApp/formInfo/formDataBySelect"})
    public ApiResponse<Object> formDataBySelect(@RequestBody QueryChartDataDto selectQueryDto) {
        return this.appFormService.formDataBySelect(selectQueryDto);
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u8868\u5355\u8bbe\u8ba1\u5668\u753b\u5e03")
    @GetMapping(value={"/hussarApp/formInfo/getCanvas"})
    public ApiResponse<FormFieldsVo> getCanvas(@RequestParam(required=false) String appId, @RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getCanvas(formId, appId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u8868\u5355\u89c6\u56fe")
    @GetMapping(value={"/hussarApp/formInfo/getView"})
    public ApiResponse<FormViewVo> getView(@RequestParam(required=false) String appId, @RequestParam String formId) throws Exception {
        return ApiResponse.success((Object)this.appFormService.getViewForFormOutLink(formId, appId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u914d\u7f6e")
    @GetMapping(value={"/hussarApp/formInfo/getSubmit"})
    public ApiResponse<SubmitSchema> getSubmit(@RequestParam(required=false) String appId, @RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getSubmit(formId, appId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u67e5\u8be2\u663e\u9690\u89c4\u5219")
    @GetMapping(value={"/hussarApp/formInfo/getHideRule"})
    public ApiResponse<HideRuleSchema> getHideRule(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getHideRule(formId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u5b57\u6bb5\u6743\u9650")
    @GetMapping(value={"/hussarApp/formInfo/getFieldControl"})
    public ApiResponse<FieldControlVo> getFieldControl(@RequestParam(required=false) String appId, @RequestParam String formId, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmFormType, @RequestParam(required=false) String processKey) throws IOException {
        return ApiResponse.success((Object)this.appFormService.getFieldControl(formId, taskId, bpmFormType, processKey, appId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u6458\u8981")
    @GetMapping(value={"/hussarApp/formInfo/getSummary"})
    public ApiResponse<List<String>> getSummary(@RequestParam String formId) {
        return ApiResponse.success((Object)this.appFormService.getSummary(formId));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u5730\u5740\u7ec4\u4ef6\u6570\u636e")
    @GetMapping(value={"/formdesign/region/getRegionInfoByLevel"})
    public ApiResponse<List<RegionVo>> getRegionInfoByLevel(@RequestParam String level) {
        return ApiResponse.success((Object)this.regionService.getRegionInfoByLevel(level));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u6839\u636e\u5730\u533aid\u96c6\u5408\u67e5\u5730\u533a\u4fe1\u606f")
    @GetMapping(value={"/formdesign/region/getRegionInfoByIds"})
    public ApiResponse<List<RegionVo>> getRegionInfoByIds(@ApiParam(value="\u5730\u533aid\u96c6\u5408") @RequestParam List<Long> ids) {
        return ApiResponse.success((Object)this.regionService.getRegionInfoByIds(ids));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u5730\u5740\u7ec4\u4ef6\u83b7\u53d6\u5b50\u7ea7\u5730\u5740")
    @GetMapping(value={"/formdesign/region/getChildrenRegionInfoById"})
    public ApiResponse<List<RegionVo>> getChildrenRegionInfoById(@RequestParam long id) {
        return ApiResponse.success((Object)this.regionService.getChildrenRegionInfoById(Long.valueOf(id)));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u62d3\u5c55\u7ec4\u4ef6\u6570\u636e")
    @GetMapping(value={"/hussarNoCode/property/widget/fileContent"})
    public String getWidgetFileContent(@RequestParam String widgetName, @RequestParam String fileName) throws IOException {
        return this.widgetExpService.getWidgetFileContent(widgetName, fileName);
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u5173\u8054\u8868\u5355\u6570\u636e")
    @PostMapping(value={"/hussarApp/formInfo/queryData"})
    public ApiResponse<QueryBusinessDataVo> queryData(@RequestBody QueryDataDTO queryDataDTO) throws IOException, LcdpException {
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.FORM.getType())) {
            return this.hussarAppDataSourceService.queryAppBusinessData(queryDataDTO.getFormId(), queryDataDTO.getAppId(), queryDataDTO.getParams());
        }
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.DATASET.getType())) {
            return this.hussarAppDataSourceService.querySetBusinessData(queryDataDTO.getFormId(), queryDataDTO.getParams());
        }
        if (HussarUtils.equals((Object)queryDataDTO.getType(), (Object)DataType.EXTERNALAPI.getType())) {
            return this.hussarAppDataSourceService.queryApiBusinessData(queryDataDTO.getFormId(), queryDataDTO.getAppCode(), queryDataDTO.getApiCode(), queryDataDTO.getUri(), queryDataDTO.getParams());
        }
        return ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
    }

    @PostMapping(value={"/hussarApp/formInfo/queryDataOnCascader"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> queryDataOnCascader(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody QueryDataOnCascaderDTO queryDataDto) {
        if (HussarUtils.equals((Object)queryDataDto.getType(), (Object)DataType.FORM.getType())) {
            return this.hussarAppDataSourceService.queryAppBusinessDataOnCascader(queryDataDto);
        }
        return ApiResponse.fail((String)"\u6570\u636e\u6e90\u7c7b\u578b\u65e0\u6548");
    }

    @PostMapping(value={"/hussarApp/formInfo/searchDataOnCascader"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> searchDataOnCascader(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody SearchDataOnCascaderDTO searchDataDTO) {
        return this.hussarAppDataSourceService.searchDataOnCascader(searchDataDTO);
    }

    @PostMapping(value={"/hussarApp/formInfo/queryDataOnCascaderByIds"})
    @ApiOperation(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e", notes="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6 \u8be2\u6307\u5b9a\u6570\u636e\u6e90\u4e0b\u7684\u5217\u8868\u6570\u636e")
    public ApiResponse<List<Map<String, Object>>> queryDataOnCascaderByIds(@ApiParam(value="\u7ea7\u8054\u9009\u62e9\u7ec4\u4ef6\u67e5\u8be2\u6570\u636e\u7684dto") @RequestBody QueryDataOnCascaderByIdsDTO queryDataDto) {
        return this.hussarAppDataSourceService.queryDataOnCascaderByIds(queryDataDto);
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u5173\u8054\u8868\u5355\u72b6\u6001")
    @GetMapping(value={"/hussarApp/formInfo/getFormState"})
    public ApiResponse<Integer> getFormState(@RequestParam String appId, @RequestParam String formId) {
        return this.formOutLinkService.getFormState(appId, formId);
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u83b7\u53d6\u64cd\u4f5c\u6743\u9650")
    @GetMapping(value={"/hussarApp/formInfo/getOperateControl"})
    public ApiResponse<FieldOperateControlVo> getOperateControl(@RequestParam String formId, @RequestParam(required=false) String taskId, @RequestParam(required=false) String bpmformType, @RequestParam(required=false) String processKey) {
        return ApiResponse.success((Object)this.appFormService.getOperateControl(formId, taskId, bpmformType, processKey));
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u5355\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/attachment/uploadfilewithdrag"})
    public ApiResponse<AttachmentManagerModelVo> uploadfileWithDrag(@RequestParam(required=false, value="token") String token, MultipartFile file) {
        try {
            NoCodeSecurityUtil.setLoginInfo((String)token, null);
            ApiResponse ossResponse = this.ossService.backgroundUpload(file);
            if (ossResponse.isSuccess()) {
                Long fileId = (Long)ossResponse.getData();
                AttachmentManagerModelVo attachmentManagerModelVo = this.ossService.getByFileId(fileId);
                return ApiResponse.success((Object)attachmentManagerModelVo);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e0a\u4f20\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a", (Throwable)e);
        }
        return ApiResponse.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/attachment/showPicture"})
    public void showImage(HttpServletResponse response, @ApiParam(value="\u56fe\u7247id") Long image) {
        try {
            ApiResponse ossResponse = this.ossService.backgroundDownload(image);
            if (ossResponse.isSuccess()) {
                byte[] data = (byte[])ossResponse.getData();
                NoCodeFileUtil.showPicture((byte[])data, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u670d\u52a1\u5668\u51fa\u9519\u4e86");
        }
    }

    @ApiOperation(value="\u8868\u5355\u6e32\u67d3\uff0c\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/sysBaseConfigFront/showPicture"})
    @Inner
    public void showImage(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long id, HttpServletResponse response) {
        this.sysBaseConfigService.showImage(id, response);
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u83b7\u53d6\u94fe\u63a5\u5f00\u542f\u72b6\u6001")
    @GetMapping(value={"/hussarNoCode/formLink/formFill/getLinkOpenStatus"})
    public ApiResponse<Boolean> getLinkOpenStatus(@RequestParam String formId, @RequestParam String shortLink) {
        return this.formLinkService.getLinkOpenStatus(formId, shortLink);
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u83b7\u53d6\u5bc6\u7801\u5f00\u542f\u72b6\u6001")
    @GetMapping(value={"/hussarNoCode/formLink/formFill/getPwdStatus"})
    public ApiResponse<Boolean> getPwdStatus(@RequestParam String formId) {
        return this.formLinkService.getPwdStatus(formId);
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u5bc6\u7801\u9a8c\u8bc1")
    @PostMapping(value={"/hussarNoCode/formLink/formFill/verifyPassword"})
    public ApiResponse<Void> verifyPassword(@RequestParam String formId, @RequestBody String password) {
        return this.formLinkService.verifyPassword(formId, password);
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u83b7\u53d6\u914d\u7f6e\u8be6\u60c5")
    @GetMapping(value={"/hussarNoCode/formLink/detail"})
    public ApiResponse<SysFormLinkVo> getFormLinkDetail(@RequestParam Long formId, HttpServletRequest request) {
        return this.formLinkService.getFormLinkDetail(formId, request);
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9")
    @PostMapping(value={"/bpm/publicProcess/queryNextUserNode"})
    public BpmResponseResult queryNextUserNode(@RequestParam(value="processDefinitionKey") String processDefinitionKey, @RequestParam(value="taskId") String taskId, @RequestBody Map<String, Object> lineCondition, @RequestParam(value="isGetRevokeNode") boolean isGetRevokeNode) {
        return TaskEngineService.queryNextUserTask((String)processDefinitionKey, (String)taskId, (boolean)isGetRevokeNode, (boolean)true, lineCondition);
    }

    @ApiOperation(value="\u8868\u5355\u63d0\u4ea4\uff0c\u63d0\u4ea4\u666e\u901a\u8868\u5355")
    @PostMapping(value={"/hussarApp/formInfo/formSave"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> formSave(@RequestParam(required=false) String appId, @RequestParam String formId, @RequestParam String dataId, @RequestBody Map<String, Object> params, HttpServletRequest request) {
        return this.formOutLinkService.verifyFingerprintCountAndSave(appId, formId, dataId, params, request);
    }

    @PostMapping(value={"/hussarApp/formInfo/formSaveExt"})
    public Object formSaveExt(@RequestParam(required=false) String appId, @RequestParam String formId, @RequestBody Map<String, Object> params) {
        ApiResponse body = (ApiResponse)this.invokeService.formSave(appId, formId, params).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @PostMapping(value={"/hussarApp/formInfo/deleteBatchExt"})
    public Object deleteBatchExt(@RequestParam String formId, @RequestParam String ids, @RequestParam(required=false) String appId) {
        ApiResponse body = (ApiResponse)this.invokeService.deleteBatch(appId, formId, ids).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @PostMapping(value={"/hussarApp/formInfo/tableQueryAllExt"})
    public Object tableQueryAllExt(@RequestParam String formId, @RequestParam String appId) {
        ApiResponse body = (ApiResponse)this.invokeService.tableQueryAll(appId, formId).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @PostMapping(value={"/hussarApp/formInfo/tableSaveExt"})
    public Object tableSaveExt(@RequestParam String formId, @RequestParam String appId, @RequestBody Map<String, Object> params) {
        this.invokeService.tableSave(appId, formId, params);
        return true;
    }

    @ApiOperation(value="\u8868\u5355\u586b\u5199\u94fe\u63a5\uff0c\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355")
    @PostMapping(value={"/hussarApp/formInfo/flowFormSubmit"})
    @OpControllerAnno
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(@RequestParam String formId, @RequestParam String dataId, @RequestBody Map<String, Object> params, HttpServletRequest request) {
        return this.formOutLinkService.verifyFingerprintCountAndSaveFlow(formId, dataId, params, request);
    }

    @PostMapping(value={"/hussarApp/formInfo/flowFormSubmitExt"})
    public Object flowFormSubmitExt(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        Long appId = ((SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData()).getAppId();
        ApiResponse body = (ApiResponse)this.invokeService.flowFormSubmit(String.valueOf(appId), formId, params).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @PostMapping(value={"/hussarApp/formInfo/prevNodeRejectExt"})
    public Object prevNodeRejectExt(@RequestParam String formId, @RequestBody Map<String, Object> params) {
        Long appId = ((SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData()).getAppId();
        ApiResponse body = (ApiResponse)this.invokeService.prevNodeReject(String.valueOf(appId), formId, params).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @PostMapping(value={"/hussarNoCode/formLinkSingle/verifyStatus"})
    @ApiOperation(value="\u5355\u6761\u6570\u636e\u5206\u4eab\uff0c\u83b7\u53d6\u94fe\u63a5\u5f00\u542f\u72b6\u6001")
    public ApiResponse<Boolean> verifyStatus(@ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u6570\u636eId") @RequestParam Long dataId, @ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u77ed\u7801") @RequestParam String shortLink, @ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u8868\u5355Id") @RequestParam Long formId) {
        return this.sysFormLinkSingleService.verifyStatus(dataId, shortLink, formId);
    }

    @ApiOperation(value="\u5355\u6761\u6570\u636e\u5206\u4eab\uff0c\u83b7\u53d6\u5bc6\u7801\u5f00\u542f\u72b6\u6001")
    @PostMapping(value={"/hussarNoCode/formLinkSingle/isLinkPass"})
    public ApiResponse<Boolean> isLinkPass(@ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u6570\u636eId") @RequestParam Long dataId, @ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u8868\u5355Id") @RequestParam Long formId) {
        return this.sysFormLinkSingleService.isLinkPass(dataId, formId);
    }

    @ApiOperation(value="\u5355\u6761\u6570\u636e\u5206\u4eab\uff0c\u5bc6\u7801\u9a8c\u8bc1")
    @PostMapping(value={"/hussarNoCode/formLinkSingle/verifyLinkPass"})
    public ApiResponse<Boolean> verifyLinkPass(@ApiParam(value="\u5355\u6761\u6570\u636e\u5916\u94fe\u5b9e\u4f53") @RequestBody SysFormLinkSingleDto sysFormLinkSingleDto) {
        return this.sysFormLinkSingleService.verifyLinkPass(sysFormLinkSingleDto);
    }

    @ApiOperation(value="\u5355\u6761\u6570\u636e\u5206\u4eab\uff0c\u67e5\u8be2\u8868\u5355\u6570\u636e")
    @GetMapping(value={"/hussarApp/formInfo/formQuery"})
    public ResponseEntity<ApiResponse<Object>> formQuery(@RequestParam String formId, @RequestParam String id, @RequestParam(required=false) String tabType, @RequestParam(required=false) String appId) {
        return this.appFormService.formQueryPublic(formId, id, tabType, appId);
    }

    @ApiOperation(value="\u5355\u6761\u6570\u636e\u5206\u4eab\uff0c\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/hussarNoCode/formLinkSingleStatus/detail"})
    public ApiResponse<SysFormLinkSingleStatusVo> getSysFormLinkSingleStatusByFormId(@ApiParam(value="\u8868\u5355id") @RequestParam Long formId, @ApiParam(value="\u6570\u636eid") @RequestParam Long dataId, HttpServletRequest request) {
        return this.sysFormLinkSingleStatusService.getSysFormLinkSingleStatusByFormIdOut(formId, dataId, request);
    }

    @PostMapping(value={"/hussarNoCode/formLinkOpen/verifyStatus"})
    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\uff0c\u83b7\u53d6\u94fe\u63a5\u5f00\u542f\u72b6\u6001")
    public ApiResponse<Boolean> verifyOpenLinkStatus(@ApiParam(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u8868\u5355Id") @RequestParam Long formId, @ApiParam(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u8868\u5355Id") @RequestParam String shortLink) {
        return this.sysFormLinkOpenService.verifyStatus(formId, shortLink);
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\uff0c\u83b7\u53d6\u5bc6\u7801\u5f00\u542f\u72b6\u6001")
    @PostMapping(value={"/hussarNoCode/formLinkOpen/isLinkPass"})
    public ApiResponse<Boolean> isOpenLinkPass(@ApiParam(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u8868\u5355Id") @RequestParam Long formId) {
        return this.sysFormLinkOpenService.isLinkPass(formId);
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\uff0c\u5bc6\u7801\u9a8c\u8bc1")
    @PostMapping(value={"/hussarNoCode/formLinkOpen/verifyLinkPass"})
    public ApiResponse<Boolean> verifyOpenLinkPass(@ApiParam(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u5b9e\u4f53") @RequestBody SysFormLinkOpenDto sysFormLinkOpenDto) {
        return this.sysFormLinkOpenService.verifyLinkPass(sysFormLinkOpenDto);
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\uff0c\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/hussarNoCode/formLinkOpen/detail"})
    public ApiResponse<SysFormLinkOpenVo> detail(@ApiParam(value="\u516c\u5f00\u67e5\u8be2\u5916\u94fe\u8868\u5355Id") @RequestParam Long formId, HttpServletRequest request) {
        return this.sysFormLinkOpenService.getFormLinkOpenDetail(formId, request);
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\uff0c\u83b7\u53d6\u67e5\u8be2\u7ed3\u679c")
    @PostMapping(value={"/hussarApp/formInfo/tableQuery"})
    public ResponseEntity<ApiResponse<Object>> tableQuery(@RequestParam(required=false) String appId, @RequestParam String formId, @RequestBody Map<String, Object> params, HttpServletRequest request) {
        return this.formOutLinkService.tableQuery(appId, formId, params, request);
    }

    @PostMapping(value={"/hussarApp/formInfo/tableQueryExt"})
    public Object tableQueryExt(@RequestParam(required=false) String appId, @RequestParam String formId, @RequestParam String viewId, @RequestBody Map<String, Object> params, HttpServletRequest request) {
        ApiResponse body = (ApiResponse)this.invokeService.tableQuery(appId, formId, viewId, params).getBody();
        if (HussarUtils.isNotEmpty((Object)body) && HussarUtils.isNotEmpty((Object)body.getData())) {
            return body.getData();
        }
        return null;
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u5f53\u524d\u5e94\u7528\u4e3b\u9898")
    @GetMapping(value={"/themeConfig/getCurrentApplicationTheme"})
    public ApiResponse<ThemeVO> getCurrentApplicationTheme() {
        return this.hussarThemeConfigService.getCurrentApplicationTheme();
    }

    @ApiOperation(value="\u516c\u5f00\u67e5\u8be2\u4e3b\u9898\u6837\u5f0f")
    @GetMapping(value={"/themeConfig/getThemeConfigCss.css"})
    public void getThemeConfigCss(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendRedirect("/hussartheme/api/themeConfig/getCurrentApplicationTheme");
    }

    @GetMapping(value={"/hussarNoCode/formCheckConfig/getFormCheckConfig"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u6821\u9a8c\u914d\u7f6e\u8be6\u60c5", notes="\u83b7\u53d6\u8868\u5355\u63d0\u4ea4\u6821\u9a8c\u914d\u7f6e\u8be6\u60c5")
    public ApiResponse<SysFormCheckConfigVo> getFormCheckConfig(@ApiParam(value="\u8868\u5355Id") @RequestParam Long formId) {
        return this.formCheckConfigService.getFormCheckConfig(formId);
    }

    @PostMapping(value={"/hussarApp/attachment/batchDownload"})
    @CheckPermission(value={"attachment:fileDownload"})
    public ApiResponse<SysBatchDownloadTask> batchDownload(@RequestBody BatchDownloadDto batchDownloadDto, HttpServletResponse response) throws Exception {
        return this.formAttachmentService.batchDownload(batchDownloadDto, response);
    }

    @GetMapping(value={"/hussarApp/attachment/batchDownload/taskDetail"})
    @ApiOperation(value="\u83b7\u53d6\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\u8be6\u60c5", notes="\u83b7\u53d6\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\u8be6\u60c5")
    public ApiResponse<SysBatchDownloadTask> taskDetail(@ApiParam(value="\u4efb\u52a1id") @RequestParam Long taskId) {
        return this.batchDownLodService.getTaskDetail(taskId);
    }

    @ApiOperation(value="\u5217\u8868\u6279\u91cf\u4e0b\u8f7d")
    @PostMapping(value={"/hussarApp/attachment/batchDownload/list"})
    @CheckPermission(value={"attachment:fileDownload"})
    public ApiResponse<SysBatchDownloadTask> downloadAttachmentsInList(@RequestBody AttachListDownloadDto attachListDownloadDto, HttpServletResponse response) throws Exception {
        return this.formAttachmentService.downloadAttachmentsInList(attachListDownloadDto, response);
    }

    @GetMapping(value={"/hussarApp/formInfo/requestSignature"})
    public ResponseEntity<ApiResponse<String>> requestSignature(@RequestParam(value="appId") String appId, @RequestParam(value="formId") String formId) {
        return this.handwrittenSignatureService.requestSignature(appId, formId);
    }

    @GetMapping(value={"/hussarApp/formInfo/scanSignature"})
    public ResponseEntity<ApiResponse<Boolean>> scanSignature(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.scanSignature(randomCode);
    }

    @PostMapping(value={"/hussarApp/formInfo/saveSignatureToRedis"})
    public ResponseEntity<ApiResponse<Boolean>> saveSignatureToRedis(@RequestBody JSONObject param) {
        return this.handwrittenSignatureService.saveSignatureToRedis(param);
    }

    @GetMapping(value={"/hussarApp/formInfo/getSignatureFromRedis"})
    public ResponseEntity<ApiResponse<String>> getSignatureFromRedis(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.getSignatureFromRedis(randomCode);
    }

    @GetMapping(value={"/hussarApp/formInfo/delSignatureFromRedis"})
    public ResponseEntity<ApiResponse<Boolean>> delSignatureFromRedis(@RequestParam(value="randomCode") String randomCode) {
        return this.handwrittenSignatureService.delSignatureFromRedis(randomCode);
    }

    @GetMapping(value={"/hussarNoCode/form/getDetailById"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355Id\u83b7\u53d6\u8868\u5355\u8be6\u60c5", notes="\u6839\u636e\u8868\u5355Id\u83b7\u53d6\u8868\u5355\u8be6\u60c5")
    public ApiResponse<SysFormVo> getDetailById(@ApiParam(value="\u8868\u5355Id") @RequestParam Long formId) {
        try {
            return this.sysFormService.getFormDetailById(formId);
        }
        catch (Exception e) {
            return ApiResponse.success((String)"\u83b7\u53d6\u8868\u5355\u8be6\u60c5\u5931\u8d25\uff01");
        }
    }

    @GetMapping(value={"/checkToken"})
    public ApiResponse<Boolean> checkToken(@RequestParam String token) {
        return this.formOutLinkService.checkToken(token);
    }

    @GetMapping(value={"/dict/get_by_typeId"})
    public FormDesignResponse<List<DicLevelTreeVo>> queryOption(@RequestParam(value="dictTypeId") Long dictTypeId) {
        List dicLevelTreeVos = this.dictDataSourceService.queryDictOptions(dictTypeId);
        return FormDesignResponse.success((Object)dicLevelTreeVos);
    }
}

