/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.controller;

import com.jxdinfo.hussar.formdesign.application.util.NoCodeFileUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public_release"})
public class FormFileController {
    @Resource
    private OssService ossService;

    @ApiOperation(value="\u56fe\u6587\u5c55\u793a\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/file/attachment/fileDownload"})
    public void fileDownload(HttpServletResponse response, Long fileId) {
        try {
            ApiResponse ossResponse = this.ossService.backgroundDownload(fileId);
            AttachmentManagerModelVo managerModelVo = this.ossService.getByFileId(fileId);
            if (ossResponse.isSuccess() && HussarUtils.isNotEmpty((Object)managerModelVo)) {
                byte[] data = (byte[])ossResponse.getData();
                String fileName = managerModelVo.getFileName();
                NoCodeFileUtil.returnByteArray((byte[])data, (String)fileName, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u670d\u52a1\u5668\u51fa\u9519\u4e86");
        }
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/file/attachment/showPicture"})
    public void showImage(HttpServletResponse response, @ApiParam(value="\u56fe\u7247id") Long image) {
        try {
            ApiResponse ossResponse = this.ossService.backgroundDownload(image);
            if (ossResponse.isSuccess()) {
                byte[] data = (byte[])ossResponse.getData();
                NoCodeFileUtil.showPicture((byte[])data, (HttpServletResponse)response);
            }
        }
        catch (IOException e) {
            throw new HussarException("\u670d\u52a1\u5668\u51fa\u9519\u4e86");
        }
    }

    @ApiOperation(value="\u5224\u65ad\u6587\u4ef6\u72b6\u6001")
    @GetMapping(value={"/file/attachment/getFileState"})
    public ApiResponse<String> getFileState(@RequestParam Long fileId) {
        if (HussarUtils.isNotEmpty((Object)this.ossService.getByFileId(fileId))) {
            return ApiResponse.success((String)"\u6587\u4ef6\u5b58\u5728");
        }
        return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548");
    }
}

