/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.FlowRejectBatchDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FlowBatchDealService;
import com.jxdinfo.hussar.formdesign.app.frame.api.vo.FlowBatchStatusVo;
import com.jxdinfo.hussar.formdesign.app.frame.server.impl.HussarAppFormServiceImpl;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.app.frame.server.impl.FlowBatchDealServiceImpl")
public class FlowBatchDealServiceImpl
implements FlowBatchDealService {
    private static Logger logger = LoggerFactory.getLogger(FlowBatchDealServiceImpl.class);
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private HussarAppFormServiceImpl hussarAppFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    private static final String JXD_N_TAB_S = "JXDNTabs";

    @HussarDs(value="#dataSourceKey")
    public void flowRejectBatch(FlowRejectBatchDto flowRejectBatchDto, String cacheName, String cachekey, String dataSourceKey) {
        String formId = flowRejectBatchDto.getFormId();
        String ids = flowRejectBatchDto.getIds();
        String comment = flowRejectBatchDto.getComment();
        String submitToRejectNode = flowRejectBatchDto.getSubmitToRejectNode();
        String rejectNode = flowRejectBatchDto.getRejectNode();
        String type = flowRejectBatchDto.getType();
        String taskIds = flowRejectBatchDto.getTaskIds();
        Map extendFields = flowRejectBatchDto.getExtendFields();
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new HussarException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] idArray = ids.split(",");
        String[] taskArray = taskIds.split(",");
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        HashMap params = new HashMap();
        int num = 1;
        ArrayList errorDataList = new ArrayList();
        for (int i = 0; i < idArray.length; ++i) {
            FlowBatchStatusVo flowBatchStatusVo = new FlowBatchStatusVo();
            flowBatchStatusVo.setCurrent(String.valueOf(i + 1));
            flowBatchStatusVo.setTotal(String.valueOf(idArray.length));
            flowBatchStatusVo.setFinishFlag(false);
            flowBatchStatusVo.setErrorFlag(false);
            flowBatchStatusVo.setMsg("\u9a73\u56de\u4e2d");
            HussarCacheUtil.put((String)cacheName, (Object)cachekey, (Object)flowBatchStatusVo, (long)1800L);
            ArrayList dataList = new ArrayList();
            String id = idArray[i];
            String taskId = taskArray[i];
            HashMap dataMap = new HashMap();
            Map formData = new HashMap();
            HashMap<String, Object> flowData = new HashMap<String, Object>();
            ResponseEntity apiResponseResponseEntity = this.formOperateExposedService.formQuery(formId, id, "2", form.getAppId().toString(), false);
            ApiResponse body = (ApiResponse)apiResponseResponseEntity.getBody();
            Object data = body.getData();
            if (HussarUtils.isEmpty((Object)data)) {
                HashMap<String, String> errorMap = new HashMap<String, String>();
                errorMap.put("id", taskId);
                errorMap.put("errorReason", "\u4efb\u52a1\u4e0d\u5b58\u5728");
                errorDataList.add(errorMap);
                continue;
            }
            String json = JsonUtil.toJson((Object)data);
            formData = JsonUtil.toMap((String)json);
            dataMap.put("formData", formData);
            flowData.put("taskId", taskId);
            flowData.put("comment", comment);
            flowData.put("rejectNode", rejectNode);
            flowData.put("submitToRejectNode", submitToRejectNode);
            flowData.put("isSubmit", true);
            flowData.put("type", type);
            flowData.put("extendFields", extendFields);
            dataMap.put("flowData", flowData);
            dataList.add(dataMap);
            params.put("dataList", dataList);
            String title = formData.get("title").toString();
            ResponseEntity flowFormRejectBatchResult = new ResponseEntity(HttpStatus.OK);
            try {
                flowFormRejectBatchResult = this.formOperateExposedService.flowFormRejectBatch(formId, params);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u9a73\u56de\u53d1\u751f\u5f02\u5e38:" + e);
            }
            ApiResponse resultBody = (ApiResponse)flowFormRejectBatchResult.getBody();
            Object reuleData = resultBody.getData();
            String resultJson = JsonUtil.toJson((Object)reuleData);
            Map resultMap = JsonUtil.toMap((String)resultJson);
            Object errorListObj = resultMap.get("errorList");
            String errorListStr = JsonUtil.toJson(errorListObj);
            List errorList = (List)JSON.parseObject((String)errorListStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            if (!HussarUtils.isNotEmpty((Object)errorList)) continue;
            Map errorData = (Map)errorList.get(0);
            String errorTaskId = errorData.get("data").toString();
            Map errMsgMap = (Map)errorData.get("errMsg");
            List reasonList = (List)errMsgMap.get("reason");
            String reason = "";
            if (HussarUtils.isNotEmpty((Object)reasonList)) {
                reason = (String)reasonList.get(0);
            }
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("num", num);
            errorMap.put("id", taskId);
            errorMap.put("title", title);
            errorMap.put("errorReason", reason);
            errorDataList.add(errorMap);
            ++num;
        }
        FlowBatchStatusVo flowBatchStatusVo = new FlowBatchStatusVo();
        flowBatchStatusVo.setCurrent(String.valueOf(idArray.length));
        flowBatchStatusVo.setTotal(String.valueOf(idArray.length));
        flowBatchStatusVo.setFinishFlag(true);
        flowBatchStatusVo.setErrorFlag(false);
        flowBatchStatusVo.setMsg("\u9a73\u56de\u5b8c\u6210");
        flowBatchStatusVo.setData(errorDataList);
        HussarCacheUtil.put((String)cacheName, (Object)cachekey, (Object)flowBatchStatusVo, (long)1800L);
    }

    @HussarDs(value="#dataSourceKey")
    public void flowSubmitBatchWithDataAuthAndRule(String formId, String taskIds, String ids, String comment, Map<String, Object> extendFields, Map<String, Object> formData, String cacheName, String cachekey, String dataSourceKey) {
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new HussarException("\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] idArray = ids.split(",");
        String[] taskIdArray = taskIds.split(",");
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(formId)));
        String appId = String.valueOf(form.getAppId());
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList errorDataList = new ArrayList();
        int num = 1;
        for (int i = 0; i < idArray.length; ++i) {
            Object successListObj;
            String successListStr;
            List successList;
            FlowBatchStatusVo flowBatchStatusVo = new FlowBatchStatusVo();
            flowBatchStatusVo.setCurrent(String.valueOf(i + 1));
            flowBatchStatusVo.setTotal(String.valueOf(idArray.length));
            flowBatchStatusVo.setFinishFlag(false);
            flowBatchStatusVo.setErrorFlag(false);
            flowBatchStatusVo.setMsg("\u5ba1\u6279\u4e2d");
            HussarCacheUtil.put((String)cacheName, (Object)cachekey, (Object)flowBatchStatusVo, (long)1800L);
            ArrayList dataList = new ArrayList();
            String id = idArray[i];
            String taskId = taskIdArray[i];
            Map<String, Object> allDataMap = new HashMap();
            HashMap<String, Object> flowData = new HashMap<String, Object>();
            HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
            Map<String, Object> newDataMap = this.addChildRecord(formData, formId);
            ResponseEntity apiResponseResponseEntity = this.formOperateExposedService.formQuery(formId, id, "2", form.getAppId().toString(), false);
            ApiResponse body = (ApiResponse)apiResponseResponseEntity.getBody();
            Object data = body.getData();
            if (HussarUtils.isEmpty((Object)data)) {
                HashMap<String, String> errorMap = new HashMap<String, String>();
                errorMap.put("id", taskId);
                errorMap.put("errorReason", "\u4efb\u52a1\u4e0d\u5b58\u5728");
                errorDataList.add(errorMap);
                continue;
            }
            String json = JsonUtil.toJson((Object)data);
            allDataMap = JsonUtil.toMap((String)json);
            for (Map.Entry<String, Object> entry : newDataMap.entrySet()) {
                String key = entry.getKey();
                if (!allDataMap.containsKey(key)) continue;
                allDataMap.put(key, entry.getValue());
            }
            dataMap.put("formData", allDataMap);
            String processDefinitionKey = allDataMap.get("PROCESS_KEY").toString();
            flowData.put("taskId", taskId);
            flowData.put("comment", comment);
            flowData.put("extendFields", extendFields);
            flowData.put("processDefinitionKey", processDefinitionKey);
            dataMap.put("flowData", flowData);
            dataList.add(dataMap);
            String title = allDataMap.get("title").toString();
            String allDataMapStr = JsonUtil.toJson(allDataMap);
            Map ruleParam = (Map)JSON.parseObject((String)allDataMapStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            params.put("dataList", dataList);
            ResponseEntity<ApiResponse<Object>> flowFormRejectBatchResult = new ResponseEntity<ApiResponse<Object>>(HttpStatus.OK);
            try {
                logger.info("\u6279\u91cf\u63d0\u4ea4\u4f20\u9012\u7ed9\u89e3\u6790\u5f15\u64ce\u7684\u4e1a\u52a1\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(params));
                flowFormRejectBatchResult = this.hussarAppFormService.flowFormSubmitBatch(formId, params);
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u63d0\u4ea4\u53d1\u751f\u5f02\u5e38\uff1a" + e);
            }
            ApiResponse flowFormRejectBatchResultBody = (ApiResponse)flowFormRejectBatchResult.getBody();
            Object flowFormRejectBatchResultBodyData = flowFormRejectBatchResultBody.getData();
            String flowFormRejectBatchResultJson = JsonUtil.toJson((Object)flowFormRejectBatchResultBodyData);
            Map resultMap = JsonUtil.toMap((String)flowFormRejectBatchResultJson);
            Object errorListObj = resultMap.get("errorList");
            String errorListStr = JsonUtil.toJson(errorListObj);
            List errorList = (List)JSON.parseObject((String)errorListStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            if (HussarUtils.isNotEmpty((Object)errorList)) {
                Map errorData = (Map)errorList.get(0);
                String errorTaskId = errorData.get("data").toString();
                Map errMsgMap = (Map)errorData.get("errMsg");
                List reasonList = (List)errMsgMap.get("reason");
                String reason = "";
                if (HussarUtils.isNotEmpty((Object)reasonList)) {
                    reason = (String)reasonList.get(0);
                }
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("num", num);
                errorMap.put("id", taskId);
                errorMap.put("title", title);
                errorMap.put("errorReason", reason);
                errorDataList.add(errorMap);
                ++num;
            }
            if (!HussarUtils.isNotEmpty((Object)(successList = (List)JSON.parseObject((String)(successListStr = JsonUtil.toJson(successListObj = resultMap.get("successList"))), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0])))) continue;
            Map map = (Map)successList.get(0);
            String successId = map.get("code").toString();
            allDataMap.put("taskId", taskId);
            Map<String, Object> flowDataInfo = this.hussarAppFormService.queryAllTableInfo(formId, appId, successId);
            this.hussarAppFormService.ruleForFlowFormSubmit(appId, formId, ruleParam, flowDataInfo, new ArrayList<String>());
            this.hussarAppFormService.pushDataForFlowFormSubmit(appId, formId, ruleParam, flowDataInfo);
        }
        FlowBatchStatusVo flowBatchStatusVo = new FlowBatchStatusVo();
        flowBatchStatusVo.setCurrent(String.valueOf(idArray.length));
        flowBatchStatusVo.setTotal(String.valueOf(idArray.length));
        flowBatchStatusVo.setFinishFlag(true);
        flowBatchStatusVo.setErrorFlag(false);
        flowBatchStatusVo.setMsg("\u5ba1\u6279\u5b8c\u6210");
        flowBatchStatusVo.setData(errorDataList);
        HussarCacheUtil.put((String)cacheName, (Object)cachekey, (Object)flowBatchStatusVo, (long)1800L);
    }

    private Map<String, Object> addChildRecord(Map<String, Object> dataMap, String formId) {
        String jsonString = JsonUtil.toJson(dataMap);
        Map newDataMap = (Map)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        FormCanvasSchema targetCanvas = (FormCanvasSchema)this.canvasSchemaService.get(formId).getData();
        List widgets = targetCanvas.getWidgets();
        ArrayList tableName = new ArrayList();
        widgets.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).forEach(widget -> tableName.add(widget.getName()));
        widgets.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> tableName.add(child.getName()));
        widgets.stream().filter(widget -> JXD_N_TAB_S.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> tableName.add(child.getName()));
        Iterator iterator = newDataMap.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            Map.Entry data = iterator.next();
            String dataKey = (String)data.getKey();
            Object dataValue = data.getValue();
            String json = JsonUtil.toJson(dataValue);
            for (String childName : tableName) {
                if (!childName.equals(dataKey)) continue;
                List childList = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                if (!childList.isEmpty()) {
                    for (Map map : childList) {
                        map.put("RECORD_ID", EngineUtil.getId());
                    }
                    data.setValue(childList);
                    continue block0;
                }
                iterator.remove();
                continue block0;
            }
        }
        return newDataMap;
    }
}

