/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFrameService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class UserAndOrgHandle {
    @Resource
    private IHussarAppFrameService appFrameService;
    @Resource
    private IHussarBaseOrganizationBoService baseOrganizationBoService;
    private static final Logger LOGGER = LogManager.getLogger(UserAndOrgHandle.class);
    private final Map<String, String> methodMap = new HashMap<String, String>(){
        {
            this.put("address", "getAddress");
            this.put("birthday", "getBirthday");
            this.put("graduateDate", "getGraduateDate");
            this.put("graduateSchool", "getGraduateSchool");
            this.put("organs", "getOrgans");
            this.put("posts", "getPosts");
            this.put("sex", "getSex");
            this.put("userAccount", "getUserAccount");
            this.put("userName", "getUserName");
            this.put("workDate", "getWorkDate");
            this.put("workId", "getWorkId");
            this.put("idcard", "getIdcard");
            this.put("mobile", "getMobile");
            this.put("telephone", "getTelephone");
        }
    };

    public void userHandle(String widgetName, List<Widget> widgets, Map<Long, UserStaffVo> userStaffVoMap, Map<String, String> userWidgetAndLabels) {
        for (Widget widget : widgets) {
            block19: {
                String name = widget.getName();
                if (!name.equals(widgetName)) break block19;
                JSONObject props = widget.getProps();
                if (!HussarUtils.isNotEmpty((Object)props) || !HussarUtils.isNotEmpty((Object)props.get((Object)"additionalField"))) continue;
                String value = String.valueOf(props.get((Object)"additionalField"));
                for (String userId : userWidgetAndLabels.keySet()) {
                    String userLabel = userWidgetAndLabels.get(userId);
                    StringBuilder userLabelBuilder = new StringBuilder(userLabel);
                    UserStaffVo userStaffVo = userStaffVoMap.get(Long.valueOf(userId));
                    try {
                        block21: {
                            block20: {
                                Object invoke = userStaffVo.getClass().getMethod(this.methodMap.get(value), new Class[0]).invoke((Object)userStaffVo, new Object[0]);
                                if (!HussarUtils.isNotEmpty((Object)invoke)) break block20;
                                switch (value) {
                                    case "sex": {
                                        String sex = String.valueOf(invoke);
                                        userLabelBuilder.append("(").append(sex.equals("1") ? "\u7537" : "\u5973").append(")");
                                        break;
                                    }
                                    case "organs": {
                                        List userOrganVos = (List)invoke;
                                        ArrayList<UserOrganPostVo> removeList = new ArrayList<UserOrganPostVo>();
                                        if (HussarUtils.isNotEmpty((Object)userOrganVos)) {
                                            String organName;
                                            block14: for (UserOrganPostVo userOrganVo : userOrganVos) {
                                                organName = userOrganVo.getOrganName();
                                                for (int i = 0; i < userOrganVos.size(); ++i) {
                                                    UserOrganPostVo userOrganPostVo;
                                                    String organFname;
                                                    if (i == userOrganVos.indexOf(userOrganVo) || !(organFname = (userOrganPostVo = (UserOrganPostVo)userOrganVos.get(i)).getOrganFname()).contains(organName)) continue;
                                                    removeList.add(userOrganVo);
                                                    continue block14;
                                                }
                                            }
                                            userOrganVos.removeAll(removeList);
                                            for (UserOrganPostVo userOrganVo : userOrganVos) {
                                                organName = userOrganVo.getOrganName();
                                                if (!HussarUtils.isNotEmpty((Object)organName)) continue;
                                                userLabelBuilder.append("(").append(organName).append(")");
                                            }
                                        }
                                        break block21;
                                    }
                                    case "posts": {
                                        List userPostVos = (List)invoke;
                                        for (UserOrganPostVo userPostVo : userPostVos) {
                                            String postName = userPostVo.getPostName();
                                            if (!HussarUtils.isNotEmpty((Object)postName)) continue;
                                            userLabelBuilder.append("(").append(postName).append(")");
                                        }
                                        break block21;
                                    }
                                    default: {
                                        userLabelBuilder.append("(").append(invoke).append(")");
                                    }
                                }
                                break block21;
                            }
                            userLabelBuilder.append("(").append("-").append(")");
                        }
                        userLabel = userLabelBuilder.toString();
                        userWidgetAndLabels.put(userId, userLabel);
                    }
                    catch (Exception e) {
                        LOGGER.error("{}\u5bf9\u5e94\u7684get\u65b9\u6cd5\u4e0d\u5b58\u5728\u3002\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)value, (Object)e);
                    }
                }
                break;
            }
            if (!widget.getIsContainer()) continue;
            List children = widget.getChildren();
            this.userHandle(widgetName, children, userStaffVoMap, userWidgetAndLabels);
        }
    }

    public void orgHandle(String widgetName, List<Widget> widgets, Map<Long, String> orgVoMap, Map<String, String> orgWidgetAndLabels) {
        for (Widget widget : widgets) {
            String name = widget.getName();
            if (name.equals(widgetName)) {
                boolean showAllLevels;
                JSONObject props = widget.getProps();
                if (!HussarUtils.isNotEmpty((Object)props) || !HussarUtils.isNotEmpty((Object)props.get((Object)"showAllLevels")) || !(showAllLevels = ((Boolean)props.get((Object)"showAllLevels")).booleanValue())) continue;
                Object object = props.get((Object)"separator");
                String separator = "";
                separator = HussarUtils.isEmpty((Object)object) ? "/" : String.valueOf(object);
                for (String orgId : orgWidgetAndLabels.keySet()) {
                    String organFname = orgVoMap.get(Long.valueOf(orgId));
                    if (HussarUtils.isNotEmpty((Object)organFname)) {
                        organFname = organFname.substring(1);
                        if (!separator.equals("/")) {
                            organFname = organFname.replace("/", separator);
                        }
                    }
                    orgWidgetAndLabels.put(orgId, organFname);
                }
                break;
            }
            if (!widget.getIsContainer()) continue;
            List children = widget.getChildren();
            this.orgHandle(widgetName, children, orgVoMap, orgWidgetAndLabels);
        }
    }

    private void userHandleBatch(Map<String, Map<String, String>> userIdAndLabelMap, List<Widget> widgets, Set<Long> userIds) {
        if (HussarUtils.isNotEmpty(userIdAndLabelMap)) {
            HashMap<Long, UserStaffVo> userStaffVos = new HashMap<Long, UserStaffVo>();
            List userStaffVoList = this.appFrameService.getUserAndStaffInfoList(new ArrayList<Long>(userIds));
            for (UserStaffVo userStaffVo : userStaffVoList) {
                userStaffVos.put(userStaffVo.getUserId(), userStaffVo);
            }
            for (String widgetName : userIdAndLabelMap.keySet()) {
                Map<String, String> userWidgetAndLabels = userIdAndLabelMap.get(widgetName);
                this.userHandle(widgetName, widgets, userStaffVos, userWidgetAndLabels);
            }
        }
    }

    private void orgHandleBatch(Map<String, Map<String, String>> orgIdAndLabelMap, List<Widget> widgets, Set<Long> orgIds) {
        if (HussarUtils.isNotEmpty(orgIdAndLabelMap)) {
            HashMap<Long, String> orgVoMap = new HashMap<Long, String>();
            List simpleOrganByIds = this.baseOrganizationBoService.getSimpleOrganByIds(new ArrayList<Long>(orgIds));
            for (OrganVo organVo : simpleOrganByIds) {
                orgVoMap.put(Long.valueOf(organVo.getId()), organVo.getOrganFname());
            }
            for (String widgetName : orgIdAndLabelMap.keySet()) {
                Map<String, String> orgWidgetAndLabels = orgIdAndLabelMap.get(widgetName);
                this.orgHandle(widgetName, widgets, orgVoMap, orgWidgetAndLabels);
            }
        }
    }

    public void userAndOrgChanged(List<EngineResultEntity> entities, List<Widget> widgets) {
        if (HussarUtils.isNotEmpty(widgets)) {
            try {
                List<Widget> collectWidgets = widgets.stream().filter(widget -> widget.getType().equals(WidgetType.JXDNUser.getType()) || widget.getType().equals(WidgetType.JXDNUserMulti.getType()) || widget.getType().equals(WidgetType.JXDNOrg.getType()) || widget.getType().equals(WidgetType.JXDNOrgMulti.getType()) || widget.getIsContainer()).collect(Collectors.toList());
                HashMap<String, Map<String, String>> userIdAndLabelMap = new HashMap<String, Map<String, String>>();
                HashMap<String, Map<String, String>> orgIdAndLabelMap = new HashMap<String, Map<String, String>>();
                HashSet<Long> userSet = new HashSet<Long>();
                HashSet<Long> orgSet = new HashSet<Long>();
                long time1 = System.currentTimeMillis();
                this.widgetsHandle(collectWidgets, entities, userIdAndLabelMap, userSet, orgIdAndLabelMap, orgSet);
                long time2 = System.currentTimeMillis();
                LOGGER.info("widgetsHandle\u6279\u5904\u7406\u65f6\u95f4\uff1a{}", (Object)(time2 - time1));
                this.userHandleBatch(userIdAndLabelMap, collectWidgets, userSet);
                this.orgHandleBatch(orgIdAndLabelMap, collectWidgets, orgSet);
                long time3 = System.currentTimeMillis();
                LOGGER.info("userHandleBatch,orgHandleBatch\u6279\u5904\u7406\u65f6\u95f4\uff1a{}", (Object)(time3 - time2));
                this.replaceEntity(collectWidgets, entities, userIdAndLabelMap, orgIdAndLabelMap);
                long time4 = System.currentTimeMillis();
                LOGGER.info("replaceEntity\u6279\u5904\u7406\u65f6\u95f4\uff1a{}", (Object)(time4 - time3));
            }
            catch (Exception e) {
                LOGGER.error("\u7528\u6237\u7ec4\u7ec7\u4fe1\u606f\u66ff\u6362\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
            }
        }
    }

    private void replaceEntity(List<Widget> widgets, List<EngineResultEntity> entities, Map<String, Map<String, String>> userIdAndLabelMap, Map<String, Map<String, String>> orgIdAndLabelMap) {
        for (EngineResultEntity entity : entities) {
            block1: for (String key : entity.keySet()) {
                for (Widget widget : widgets) {
                    String userLabel;
                    String userId;
                    String name = widget.getName();
                    String type = widget.getType();
                    if (name.equals(key) && type.equals(WidgetType.JXDNUser.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        userId = String.valueOf(entity.get((Object)(key + "_id")));
                        Map<String, String> userWidgetAndLabels = userIdAndLabelMap.get(key);
                        userLabel = userWidgetAndLabels.get(userId);
                        entity.put((Object)(key + "_label"), (Object)userLabel);
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNUserMulti.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        Map<String, String> userWidgetAndLabels = userIdAndLabelMap.get(key);
                        StringBuilder userLabelStringBuilder = new StringBuilder();
                        String userIds = String.valueOf(entity.get((Object)(key + "_id")));
                        String[] userIdSplits = userIds.split(",");
                        List<String> userIdList = Arrays.asList(userIdSplits);
                        for (String userId2 : userIdList) {
                            String userLabel2 = userWidgetAndLabels.get(userId2);
                            if (userIdList.indexOf(userId2) != userIdList.size() - 1) {
                                userLabelStringBuilder.append(userLabel2).append(",");
                                continue;
                            }
                            userLabelStringBuilder.append(userLabel2);
                        }
                        entity.put((Object)(key + "_label"), (Object)userLabelStringBuilder.toString());
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNOrg.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        userId = String.valueOf(entity.get((Object)(key + "_id")));
                        Map<String, String> orgWidgetAndLabels = orgIdAndLabelMap.get(key);
                        userLabel = orgWidgetAndLabels.get(userId);
                        entity.put((Object)(key + "_label"), (Object)userLabel);
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNOrgMulti.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        Map<String, String> orgWidgetAndLabels = orgIdAndLabelMap.get(key);
                        StringBuilder orgLabelStringBuilder = new StringBuilder();
                        String orgIds = String.valueOf(entity.get((Object)(key + "_id")));
                        String[] orgIdSplits = orgIds.split(",");
                        List<String> orgIdList = Arrays.asList(orgIdSplits);
                        for (String orgId : orgIdList) {
                            String orgLabel = orgWidgetAndLabels.get(orgId);
                            if (orgIdList.indexOf(orgId) != orgIdList.size() - 1) {
                                orgLabelStringBuilder.append(orgLabel).append(",");
                                continue;
                            }
                            orgLabelStringBuilder.append(orgLabel);
                        }
                        entity.put((Object)(key + "_label"), (Object)orgLabelStringBuilder.toString());
                        continue block1;
                    }
                    if (!name.equals(key) || !type.equals(WidgetType.CHILDREN_TABLE.getType()) && !type.equals(WidgetType.JXDNChildrenTableAgg.getType()) || !HussarUtils.isNotEmpty((Object)entity.get((Object)key))) continue;
                    List childrenWidgets = widget.getChildren();
                    List childEntities = (List)entity.get((Object)key);
                    this.replaceEntity(childrenWidgets, childEntities, userIdAndLabelMap, orgIdAndLabelMap);
                }
            }
        }
    }

    private void widgetsHandle(List<Widget> widgets, List<EngineResultEntity> entities, Map<String, Map<String, String>> userIdAndLabelMap, Set<Long> userSet, Map<String, Map<String, String>> orgIdAndLabelMap, Set<Long> orgSet) {
        for (EngineResultEntity entity : entities) {
            block1: for (String key : entity.keySet()) {
                for (Widget widget : widgets) {
                    Map<Object, Object> orgWidgetAndLabels;
                    int i;
                    String[] userLabelSplits;
                    String[] userIdSplits;
                    String userLabels;
                    String userIds;
                    Map<Object, Object> userWidgetAndLabels;
                    String name = widget.getName();
                    String type = widget.getType();
                    if (name.equals(key) && type.equals(WidgetType.JXDNUser.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        userWidgetAndLabels = HussarUtils.isNotEmpty(userIdAndLabelMap.get(key)) ? userIdAndLabelMap.get(key) : new HashMap();
                        userWidgetAndLabels.put(String.valueOf(entity.get((Object)(key + "_id"))), String.valueOf(entity.get((Object)(key + "_label"))));
                        userSet.add(Long.valueOf(String.valueOf(entity.get((Object)(key + "_id")))));
                        userIdAndLabelMap.put(key, userWidgetAndLabels);
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNUserMulti.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        userWidgetAndLabels = HussarUtils.isNotEmpty(userIdAndLabelMap.get(key)) ? userIdAndLabelMap.get(key) : new HashMap();
                        userIds = String.valueOf(entity.get((Object)(key + "_id")));
                        userLabels = String.valueOf(entity.get((Object)(key + "_label")));
                        userIdSplits = userIds.split(",");
                        userLabelSplits = userLabels.split(",");
                        for (i = 0; i < userIdSplits.length; ++i) {
                            userWidgetAndLabels.put(userIdSplits[i], userLabelSplits[i]);
                            userSet.add(Long.valueOf(userIdSplits[i]));
                        }
                        userIdAndLabelMap.put(key, userWidgetAndLabels);
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNOrg.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        orgWidgetAndLabels = HussarUtils.isNotEmpty(orgIdAndLabelMap.get(key)) ? orgIdAndLabelMap.get(key) : new HashMap();
                        orgWidgetAndLabels.put(String.valueOf(entity.get((Object)(key + "_id"))), String.valueOf(entity.get((Object)(key + "_label"))));
                        orgSet.add(Long.valueOf(String.valueOf(entity.get((Object)(key + "_id")))));
                        orgIdAndLabelMap.put(key, orgWidgetAndLabels);
                        continue block1;
                    }
                    if (name.equals(key) && type.equals(WidgetType.JXDNOrgMulti.getType()) && HussarUtils.isNotEmpty((Object)entity.get((Object)key)) && HussarUtils.isNotEmpty((Object)entity.get((Object)(key + "_id")))) {
                        orgWidgetAndLabels = HussarUtils.isNotEmpty(orgIdAndLabelMap.get(key)) ? orgIdAndLabelMap.get(key) : new HashMap();
                        userIds = String.valueOf(entity.get((Object)(key + "_id")));
                        userLabels = String.valueOf(entity.get((Object)(key + "_label")));
                        userIdSplits = userIds.split(",");
                        userLabelSplits = userLabels.split(",");
                        for (i = 0; i < userIdSplits.length; ++i) {
                            orgWidgetAndLabels.put(userIdSplits[i], userLabelSplits[i]);
                            orgSet.add(Long.valueOf(userIdSplits[i]));
                        }
                        orgIdAndLabelMap.put(key, orgWidgetAndLabels);
                        continue block1;
                    }
                    if (!name.equals(key) || !type.equals(WidgetType.CHILDREN_TABLE.getType()) && !type.equals(WidgetType.JXDNChildrenTableAgg.getType()) || !HussarUtils.isNotEmpty((Object)entity.get((Object)key))) continue;
                    List childrenWidgets = widget.getChildren();
                    List childEntities = (List)entity.get((Object)key);
                    this.widgetsHandle(childrenWidgets, childEntities, userIdAndLabelMap, userSet, orgIdAndLabelMap, orgSet);
                }
            }
        }
    }

    private void widgetsHandleSingle(String key, EngineResultEntity entity, Map<String, Map<String, String>> idAndLabelMap, Set<Long> idSet) {
        Map<Object, Object> widgetAndLabels = HussarUtils.isNotEmpty(idAndLabelMap.get(key)) ? idAndLabelMap.get(key) : new HashMap();
        widgetAndLabels.put(String.valueOf(entity.get((Object)(key + "_id"))), String.valueOf(entity.get((Object)(key + "_label"))));
        idSet.add(Long.valueOf(String.valueOf(entity.get((Object)(key + "_id")))));
        idAndLabelMap.put(key, widgetAndLabels);
    }

    private void widgetsHandleMulti(String key, EngineResultEntity entity, Map<String, Map<String, String>> idAndLabelMap, Set<Long> idSet) {
        Map<Object, Object> widgetAndLabels = HussarUtils.isNotEmpty(idAndLabelMap.get(key)) ? idAndLabelMap.get(key) : new HashMap();
        String ids = String.valueOf(entity.get((Object)(key + "_id")));
        String labels = String.valueOf(entity.get((Object)(key + "_label")));
        String[] idSplits = ids.split(",");
        String[] labelSplits = labels.split(",");
        for (int i = 0; i < idSplits.length; ++i) {
            widgetAndLabels.put(idSplits[i], labelSplits[i]);
            idSet.add(Long.valueOf(idSplits[i]));
        }
        idAndLabelMap.put(key, widgetAndLabels);
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return Collections.emptyList();
    }
}

